/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1877;

import com.aspose.pdf.internal.l188I.I2l;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.ms.System.I04;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class I7
extends ECDHBasicAgreement {
    private final String lif;
    private final DerivationFunction ll;
    private ECPrivateKeyParameters lI;

    public void init(CipherParameters parameters) {
        super.init(parameters);
        if (I4.ll((Object)parameters, ParametersWithRandom.class)) {
            parameters = ((ParametersWithRandom)parameters).getParameters();
        }
        this.lI = (ECPrivateKeyParameters)parameters;
    }

    public I7(String string, DerivationFunction derivationFunction) {
        if (string == null) {
            throw new I04("algorithm");
        }
        if (derivationFunction == null) {
            throw new I04("kdf");
        }
        this.lif = string;
        this.ll = derivationFunction;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        BigInteger bigInteger = super.calculateAgreement(pubKey);
        int n = I2l.lIF(this.lif);
        DHKDFParameters dHKDFParameters = new DHKDFParameters(new ASN1ObjectIdentifier(this.lif), n, this.lif(bigInteger));
        this.ll.init((DerivationParameters)dHKDFParameters);
        byte[] byArray = new byte[n / 8];
        this.ll.generateBytes(byArray, 0, byArray.length);
        return new BigInteger(1, byArray);
    }

    private byte[] lif(BigInteger bigInteger) {
        int n = new X9IntegerConverter().getByteLength(this.lI.getParameters().getG().getX());
        return new X9IntegerConverter().integerToBytes(bigInteger, n);
    }
}

