/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.l1871;

import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.ms.System.I177;
import com.aspose.pdf.internal.ms.System.I1I;
import com.aspose.pdf.internal.ms.System.I254;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class I01
implements BlockCipher {
    private byte[] lif;
    private byte[] ll;
    private byte[] lI;
    private final int l1;
    private final BlockCipher lIF;

    public I01(BlockCipher blockCipher, int n) {
        this.lIF = blockCipher;
        this.l1 = n / 8;
        this.lif = new byte[blockCipher.getBlockSize()];
        this.ll = new byte[blockCipher.getBlockSize()];
        this.lI = new byte[blockCipher.getBlockSize()];
    }

    public BlockCipher lif() {
        return this.lIF;
    }

    public void init(boolean forEncryption, CipherParameters parameters) {
        if (I4.ll((Object)parameters, ParametersWithIV.class)) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)parameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.lif.length) {
                I1I.ll(I1I.lI((Object)byArray), 0, I1I.lI((Object)this.lif), this.lif.length - byArray.length, byArray.length);
                for (int i = 0; i < this.lif.length - byArray.length; ++i) {
                    this.lif[i] = 0;
                }
            } else {
                I1I.ll(I1I.lI((Object)byArray), 0, I1I.lI((Object)this.lif), 0, this.lif.length);
            }
            parameters = parametersWithIV.getParameters();
        }
        this.reset();
        this.lIF.init(true, parameters);
    }

    public String getAlgorithmName() {
        return I254.lif(new String[]{this.lIF.getAlgorithmName(), "/OFB", I177.ll(this.l1 * 8)});
    }

    public boolean ll() {
        return true;
    }

    public int getBlockSize() {
        return this.l1;
    }

    public int processBlock(byte[] input, int inOff, byte[] output, int outOff) {
        if (inOff + this.l1 > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + this.l1 > output.length) {
            throw new DataLengthException("output buffer too short");
        }
        this.lIF.processBlock(this.ll, 0, this.lI, 0);
        for (int i = 0; i < this.l1; ++i) {
            output[outOff + i] = I4.ll((Object)(I4.lIF((Object)this.lI[i], 6) ^ I4.lIF((Object)input[inOff + i], 6)), 9);
        }
        I1I.ll(I1I.lI((Object)this.ll), this.l1, I1I.lI((Object)this.ll), 0, this.ll.length - this.l1);
        I1I.ll(I1I.lI((Object)this.lI), 0, I1I.lI((Object)this.ll), this.ll.length - this.l1, this.l1);
        return this.l1;
    }

    public void reset() {
        I1I.ll(I1I.lI((Object)this.lif), 0, I1I.lI((Object)this.ll), 0, this.lif.length);
        this.lIF.reset();
    }
}

