/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.AssemblyConstants;
import com.aspose.pdf.Document;
import com.aspose.pdf.DocumentInfo;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.exceptions.InvalidPasswordException;
import com.aspose.pdf.facades.DocumentPrivilege;
import com.aspose.pdf.facades.PdfXmpMetadata;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l151.I3l;
import com.aspose.pdf.internal.l15l.I6l;
import com.aspose.pdf.internal.l1637.I17;
import com.aspose.pdf.internal.l16l.Il;
import com.aspose.pdf.internal.l27l.I1;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I1I;
import com.aspose.pdf.internal.ms.System.I131;
import com.aspose.pdf.internal.ms.System.I201;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I9l;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileInfo
extends SaveableFacade {
    private static final Logger lif = Logger.getLogger(PdfFileInfo.class.getName());
    private String ll;
    private InputStream lI;
    private boolean l1;
    private String lIF = null;
    private Map<String, String> llf;
    private boolean liF = false;
    private static final String lIf = "xmp";
    private static final String lf = "http://ns.adobe.com/xap/1.0/";

    @Override
    protected void lif(Stream stream, String string) {
        try {
            super.lif(stream, string);
            this.lif();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            lif.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.lIF = invalidPasswordException.getMessage();
            this.liF = true;
            this.l1 = true;
        }
        catch (RuntimeException runtimeException) {
            lif.log(Level.INFO, "Exception occur", runtimeException);
            this.lIF = runtimeException.getMessage();
            this.l1 = false;
        }
    }

    @Override
    public void bindPdf(String srcFile, String password) {
        try {
            super.bindPdf(srcFile, password);
            this.lif();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            lif.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.lIF = invalidPasswordException.getMessage();
            this.liF = true;
        }
        catch (RuntimeException runtimeException) {
            lif.log(Level.INFO, "Exception occur", runtimeException);
            this.lIF = runtimeException.getMessage();
            this.l1 = false;
        }
    }

    public void bindPdf(Document srcDoc) {
        super.bindPdf(srcDoc);
        this.l1 = true;
    }

    private void lif() {
        this.l1();
        this.l1 = true;
        this.llf = new HashMap<String, String>();
        for (I1I i1I : this.getDocument().getInfo()) {
            if (DocumentInfo.isPredefinedKey((String)i1I.lif())) continue;
            this.llf.put((String)i1I.lif(), (String)i1I.ll());
        }
        this.getDocument().getPages().get_Item(1);
    }

    @Override
    protected void l1() {
        if (this.l0l == null) {
            String string = "PdfFileInfo is not initialized. Use constructors with parameters or properties for initialization.";
            if (this.ll != null) {
                string = I254.lif(string, I254.lif(new String[]{" (File: ", this.ll, ")"}));
            }
            if (this.lIF != null) {
                string = I254.lif(string, I254.lif(new String[]{" (Reason: ", this.lIF, ")"}));
            }
            throw new I201(string);
        }
    }

    public String getAuthor() {
        this.l1();
        return this.l0l.getInfo().getAuthor();
    }

    public void setAuthor(String value) {
        this.l1();
        this.getDocument().getInfo().setAuthor(value);
    }

    public boolean isEncrypted() {
        if (this.liF) {
            return true;
        }
        this.l1();
        return this.getDocument().isEncrypted();
    }

    public boolean isPdfFile() {
        return this.l1;
    }

    public String getCreationDate() {
        this.l1();
        if (this.getDocument().getInfo().containsKey("CreationDate")) {
            return this.getDocument().getInfo().get_Item("CreationDate");
        }
        return null;
    }

    public void setCreationDate(String value) {
        this.l1();
        this.getDocument().getInfo().setCreationDate(I9l.l1(Il.lif(new I6l(this.getDocument().getEngineDoc().ll(), value)).lif().l2iF()));
    }

    public String getCreator() {
        this.l1();
        return this.getDocument().getInfo().getCreator();
    }

    public void setCreator(String value) {
        this.l1();
        InternalHelper.lif(this.getDocument().getInfo(), value);
    }

    public boolean hasCollection() {
        this.l1();
        return this.getDocument().getCollection() != null;
    }

    public Map<String, String> getHeader() {
        return this.llf;
    }

    public void setHeader(Map<String, String> value) {
        this.llf = value;
    }

    @Deprecated
    public String getInputFile() {
        return this.ll;
    }

    @Deprecated
    public void setInputFile(String value) {
        this.ll = value;
        this.bindPdf(value, null);
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.lI;
    }

    @Deprecated
    public void setInputStream(InputStream value) {
        this.lI = value;
        this.bindPdf(value, null);
    }

    public String getKeywords() {
        this.l1();
        return this.l0l.getInfo().getKeywords();
    }

    public void setKeywords(String value) {
        this.l1();
        this.getDocument().getInfo().setKeywords(value);
    }

    public String getModDate() {
        this.l1();
        if (this.getDocument().getInfo().containsKey("ModDate")) {
            return this.getDocument().getInfo().get_Item("ModDate");
        }
        return null;
    }

    public void setModDate(String value) {
        this.l1();
        this.getDocument().getInfo().setModDate(I9l.l1(Il.lif(new I6l(this.getDocument().getEngineDoc().ll(), value)).lif().l2iF()));
    }

    public int getNumberOfPages() {
        this.l1();
        return this.getDocument().getPages().size();
    }

    public String getProducer() {
        this.l1();
        return this.getDocument().getInfo().getProducer();
    }

    public String getSubject() {
        this.l1();
        return this.getDocument().getInfo().getSubject();
    }

    public void setSubject(String value) {
        this.l1();
        this.getDocument().getInfo().setSubject(value);
    }

    public String getTitle() {
        this.l1();
        return this.getDocument().getInfo().getTitle();
    }

    public void setTitle(String value) {
        this.l1();
        this.getDocument().getInfo().setTitle(value);
    }

    public PdfFileInfo() {
    }

    public PdfFileInfo(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfFileInfo(InputStream inputStream, String password) {
        this.lI = inputStream;
        this.bindPdf(inputStream, password);
    }

    public PdfFileInfo(String inputFile) {
        this(inputFile, null);
    }

    public PdfFileInfo(String inputFile, String password) {
        this.ll = inputFile;
        this.bindPdf(inputFile, password);
    }

    public void clearInfo() {
        this.l1();
        this.getDocument().getInfo().clear();
        this.llf.clear();
    }

    public DocumentPrivilege getDocumentPrivilege() {
        this.l1();
        return new DocumentPrivilege(this.getDocument().getPermissions());
    }

    public String getMetaInfo(String name) {
        this.l1();
        if (!DocumentInfo.isPredefinedKey(name) && this.llf.containsKey(name)) {
            return this.llf.get(name);
        }
        return I254.lif;
    }

    public float getPageHeight(int pageNum) {
        this.l1();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getHeight();
    }

    public int getPageRotation(int pageNum) {
        this.l1();
        switch (this.getDocument().getPages().get_Item(pageNum).getRotate()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public float getPageWidth(int pageNum) {
        this.l1();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getWidth();
    }

    public float getPageXOffset(int pageNum) {
        this.l1();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLX();
    }

    public float getPageYOffset(int pageNum) {
        this.l1();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLY();
    }

    public String getPdfVersion() {
        this.l1();
        return this.getDocument().getVersion();
    }

    @Deprecated
    public boolean saveNewInfo(OutputStream outputStream) {
        this.l1();
        try {
            this.save(outputStream);
            return true;
        }
        catch (I131 i131) {
            lif.log(Level.INFO, "Exception occur", i131);
            return false;
        }
    }

    public boolean saveNewInfo(String outputFile) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.saveNewInfo(fileOutputStream);
        }
        catch (Exception exception) {
            lif.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lif.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream destStream) {
        I5l i5l = new I5l();
        this.lif(i5l);
        try {
            if (((Stream)i5l).canSeek()) {
                ((Stream)i5l).seek(0L, 0);
            }
            byte[] byArray = new byte[i5l.toInputStream().available()];
            i5l.toInputStream().read(byArray);
            destStream.write(byArray);
        }
        catch (IOException iOException) {
            lif.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (i5l != null) {
                i5l.close();
            }
        }
    }

    @Override
    void lif(Stream stream) {
        this.ll();
        InternalHelper.lif(this.getDocument(), stream);
    }

    private void ll() {
        this.l1();
        this.getDocument().getInfo().clearCustomData();
        for (Map.Entry<String, String> entry : this.llf.entrySet()) {
            this.getDocument().getInfo().addItem(entry.getKey(), entry.getValue());
        }
    }

    public void setMetaInfo(String name, String value) {
        this.l1();
        if (this.llf.containsKey(name)) {
            this.llf.remove(name);
        }
        this.llf.put(name, value);
    }

    public boolean saveNewInfoWithXmp(String outputFileName) {
        PdfXmpMetadata pdfXmpMetadata = new PdfXmpMetadata();
        pdfXmpMetadata.bindPdf(this.ll);
        IDocument iDocument = pdfXmpMetadata.getDocument();
        this.getDocument().getMetadata().registerNamespaceUri(lIf, lf);
        if (this.getAuthor() != null) {
            iDocument.getInfo().setAuthor(this.getAuthor());
            pdfXmpMetadata.set_Item("dc:creator", new I3l(new I3l[]{new I3l(this.getAuthor())}));
        }
        if (this.getCreator() != null) {
            InternalHelper.lif(iDocument.getInfo(), this.getCreator());
            pdfXmpMetadata.set_Item("xmp:CreatorTool", new I3l(this.getCreator()));
        }
        if (this.getKeywords() != null) {
            iDocument.getInfo().setKeywords(this.getKeywords());
            pdfXmpMetadata.set_Item("pdf:Keywords", new I3l(this.getKeywords()));
        }
        if (this.getSubject() != null) {
            iDocument.getInfo().setSubject(this.getSubject());
            pdfXmpMetadata.set_Item("dc:description", new I3l(new I3l[]{new I3l(this.getSubject())}));
        }
        if (this.getTitle() != null) {
            iDocument.getInfo().setTitle(this.getTitle());
            pdfXmpMetadata.set_Item("dc:title", new I3l(new I3l[]{new I3l(this.getTitle())}));
        }
        pdfXmpMetadata.set_Item("pdf:Producer", new I3l(AssemblyConstants.Producer));
        if (this.getCreationDate() != null) {
            iDocument.getInfo().setCreationDate(this.getDocument().getInfo().getCreationDate());
            pdfXmpMetadata.set_Item("xmp:CreateDate", new I3l(PdfFileInfo.lif(I9l.lif(this.l0l.getInfo().getCreationDate()))));
        }
        if (this.getModDate() != null) {
            iDocument.getInfo().setModDate(this.getDocument().getInfo().getModDate());
            pdfXmpMetadata.set_Item("xmp:ModifyDate", new I3l(PdfFileInfo.lif(I9l.lif(this.l0l.getInfo().getModDate()))));
        }
        for (Map.Entry<String, String> object : this.llf.entrySet()) {
            pdfXmpMetadata.registerNamespaceURI("pdfx", "http://ns.adobe.com/pdfx/1.3/");
            pdfXmpMetadata.addItem(I254.lif(new String[]{"pdfx:", object.getKey().toString()}), new I3l(object.getValue().toString()));
        }
        for (String string : this.llf.keySet()) {
            iDocument.getInfo().removeItemByKey(string);
        }
        for (Map.Entry entry : this.llf.entrySet()) {
            iDocument.getInfo().addItem((String)entry.getKey(), (String)entry.getValue());
        }
        iDocument.save(outputFileName);
        return true;
    }

    public PdfFileInfo(IDocument document) {
        super(document);
    }

    private static String lif(I9l i9l) {
        String string = i9l.ll("yyyy-MM-ddTHH\\:mm\\:ss\\.fff");
        string = I254.lif(string, I9l.lif(i9l, "zzz", I17.l1If()));
        return string;
    }

    public int getPasswordType() {
        if (this.liF) {
            return 3;
        }
        if (this.isEncrypted() && this.getDocument() != null) {
            I1 i1 = this.getDocument().getEngineDoc().ll().l81();
            if (i1.lif(i1.lIF())) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean hasOpenPassword() {
        I1 i1 = this.getDocument() != null ? this.getDocument().getEngineDoc().ll().l81() : null;
        switch (this.getPasswordType()) {
            case 3: {
                return true;
            }
            case 1: {
                return !I254.lIF(i1.lIF(), I254.lif);
            }
            case 2: {
                return !i1.lif(I254.lif);
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public boolean hasEditPassword() {
        switch (this.getPasswordType()) {
            case 1: {
                I1 i1 = this.getDocument().getEngineDoc().ll().l81();
                return !i1.ll(i1.lIF());
            }
            case 3: {
                throw new InvalidPasswordException("Document must be opened with valid password in order to read this property.");
            }
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        this.lI = null;
        this.ll = null;
        this.llf = null;
        this.l1 = false;
        this.liF = false;
        this.lIF = null;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lif.setUseParentHandlers(false);
    }
}

