/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.SaveOptions;
import com.aspose.pdf.internal.ms.System.I131;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public interface IPdfFileEditor {
    public String getConversionLog();

    public boolean getMergeDuplicateLayers();

    public void setMergeDuplicateLayers(boolean var1);

    public boolean getMergeDuplicateOutlines();

    public void setMergeDuplicateOutlines(boolean var1);

    public boolean getPreserveUserRights();

    public void setPreserveUserRights(boolean var1);

    public boolean getIncrementalUpdates();

    public void setIncrementalUpdates(boolean var1);

    public int getCorruptedFileAction();

    public void setCorruptedFileAction(int var1);

    public String getOwnerPassword();

    public void setOwnerPassword(String var1);

    public boolean getAllowConcatenateExceptions();

    public void setAllowConcatenateExceptions(boolean var1);

    public void setConvertTo(int var1);

    public boolean getCloseConcatenatedStreams();

    public void setCloseConcatenatedStreams(boolean var1);

    public String getUniqueSuffix();

    public void setUniqueSuffix(String var1);

    public boolean getKeepFieldsUnique();

    public void setKeepFieldsUnique(boolean var1);

    public boolean concatenate(String var1, String var2, String var3);

    public boolean concatenate(InputStream var1, InputStream var2, OutputStream var3);

    public boolean concatenate(IDocument[] var1, IDocument var2);

    public boolean concatenate(String[] var1, String var2);

    public boolean concatenate(InputStream[] var1, OutputStream var2);

    public boolean concatenate(String var1, String var2, String var3, String var4);

    public boolean concatenate(InputStream var1, InputStream var2, InputStream var3, OutputStream var4);

    public boolean append(InputStream var1, InputStream[] var2, int var3, int var4, OutputStream var5);

    public boolean append(String var1, String[] var2, int var3, int var4, String var5);

    public boolean append(String var1, String var2, int var3, int var4, String var5);

    public boolean append(InputStream var1, InputStream var2, int var3, int var4, OutputStream var5);

    public boolean insert(String var1, int var2, String var3, int var4, int var5, String var6);

    public boolean insert(InputStream var1, int var2, InputStream var3, int var4, int var5, OutputStream var6);

    public boolean insert(String var1, int var2, String var3, int[] var4, String var5);

    public boolean insert(InputStream var1, int var2, InputStream var3, int[] var4, OutputStream var5);

    public boolean delete(String var1, int[] var2, String var3);

    public boolean delete(InputStream var1, int[] var2, OutputStream var3);

    public boolean extract(String var1, int var2, int var3, String var4);

    public boolean extract(String var1, int[] var2, String var3);

    public boolean extract(InputStream var1, int var2, int var3, OutputStream var4);

    public boolean extract(InputStream var1, int[] var2, OutputStream var3);

    public boolean splitFromFirst(String var1, int var2, String var3);

    public boolean splitFromFirst(InputStream var1, int var2, OutputStream var3);

    public boolean splitToEnd(String var1, int var2, String var3);

    public boolean splitToEnd(InputStream var1, int var2, OutputStream var3);

    public boolean makeBooklet(String var1, String var2);

    public boolean makeBooklet(InputStream var1, OutputStream var2);

    public boolean makeBooklet(String var1, String var2, PageSize var3);

    public boolean makeBooklet(InputStream var1, OutputStream var2, PageSize var3);

    public boolean makeBooklet(String var1, String var2, int[] var3, int[] var4);

    public boolean makeBooklet(InputStream var1, OutputStream var2, int[] var3, int[] var4);

    public boolean makeBooklet(String var1, String var2, PageSize var3, int[] var4, int[] var5);

    public boolean makeBooklet(InputStream var1, OutputStream var2, PageSize var3, int[] var4, int[] var5);

    public boolean makeNUp(String var1, String var2, int var3, int var4);

    public boolean makeNUp(InputStream var1, OutputStream var2, int var3, int var4);

    public boolean makeNUp(InputStream var1, OutputStream var2, int var3, int var4, PageSize var5);

    public boolean makeNUp(String var1, String var2, String var3);

    public boolean makeNUp(InputStream var1, InputStream var2, OutputStream var3);

    public boolean makeNUp(String[] var1, String var2, boolean var3);

    public boolean makeNUp(InputStream[] var1, OutputStream var2, boolean var3);

    public boolean makeNUp(String var1, String var2, int var3, int var4, PageSize var5);

    public ByteArrayInputStream[] splitToPages(String var1);

    public void splitToPages(String var1, String var2);

    public void splitToPages(InputStream var1, String var2);

    public ByteArrayInputStream[] splitToPages(InputStream var1);

    public ByteArrayInputStream[] splitToBulks(String var1, int[][] var2);

    public ByteArrayInputStream[] splitToBulks(InputStream var1, int[][] var2);

    public Exception getLastException();

    public boolean resizeContents(InputStream var1, OutputStream var2, int[] var3, double var4, double var6);

    public boolean resizeContentsPct(InputStream var1, OutputStream var2, int[] var3, double var4, double var6);

    public boolean addMargins(InputStream var1, OutputStream var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean addMarginsPct(InputStream var1, OutputStream var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean resizeContents(String var1, String var2, int[] var3, double var4, double var6);

    public boolean resizeContentsPct(String var1, String var2, int[] var3, double var4, double var6);

    public boolean addMargins(String var1, String var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean addMarginsPct(String var1, String var2, int[] var3, double var4, double var6, double var8, double var10);

    public int getContentDisposition();

    public void setContentDisposition(int var1);

    public SaveOptions getSaveOptions();

    public void setSaveOptions(SaveOptions var1);

    public String getAttachmentName();

    public void setAttachmentName(String var1);

    public static class ContentsResizeParameters {
        private ContentsResizeValue lif = ContentsResizeValue.auto();
        private ContentsResizeValue ll = ContentsResizeValue.auto();
        private ContentsResizeValue lI = ContentsResizeValue.auto();
        private ContentsResizeValue l1 = ContentsResizeValue.auto();
        private ContentsResizeValue lIF = ContentsResizeValue.auto();
        private ContentsResizeValue llf = ContentsResizeValue.auto();

        public ContentsResizeValue getLeftMargin() {
            return this.lif;
        }

        public void setLeftMargin(ContentsResizeValue value) {
            this.lif = value;
        }

        public ContentsResizeValue getRightMargin() {
            return this.lI;
        }

        public void setRightMargin(ContentsResizeValue value) {
            this.lI = value;
        }

        public ContentsResizeValue getTopMargin() {
            return this.l1;
        }

        public void setTopMargin(ContentsResizeValue value) {
            this.l1 = value;
        }

        public ContentsResizeValue getBottomMargin() {
            return this.llf;
        }

        public void setBottomMargin(ContentsResizeValue value) {
            this.llf = value;
        }

        public ContentsResizeValue getContentsWidth() {
            return this.ll;
        }

        public void setContentsWidth(ContentsResizeValue value) {
            this.ll = value;
        }

        public ContentsResizeValue getContentsHeight() {
            return this.lIF;
        }

        public void setContentsHeight(ContentsResizeValue value) {
            this.lIF = value;
        }

        public ContentsResizeParameters() {
        }

        public ContentsResizeParameters(ContentsResizeValue leftMargin, ContentsResizeValue contentsWidth, ContentsResizeValue rightMargin, ContentsResizeValue topMargin, ContentsResizeValue contentsHeight, ContentsResizeValue bottomMargin) {
            this.setLeftMargin(leftMargin);
            this.setRightMargin(rightMargin);
            this.setContentsWidth(contentsWidth);
            this.setTopMargin(topMargin);
            this.setContentsHeight(contentsHeight);
            this.setBottomMargin(bottomMargin);
        }

        public static ContentsResizeParameters margins(double left, double right, double top, double bottom) {
            return new ContentsResizeParameters(ContentsResizeValue.units(left), ContentsResizeValue.auto(), ContentsResizeValue.units(right), ContentsResizeValue.units(top), ContentsResizeValue.auto(), ContentsResizeValue.units(bottom));
        }

        public static ContentsResizeParameters marginsPercent(double left, double right, double top, double bottom) {
            return new ContentsResizeParameters(ContentsResizeValue.percents(left), ContentsResizeValue.auto(), ContentsResizeValue.percents(right), ContentsResizeValue.percents(top), ContentsResizeValue.auto(), ContentsResizeValue.percents(bottom));
        }

        public static ContentsResizeParameters contentSize(double width, double height) {
            return new ContentsResizeParameters(ContentsResizeValue.auto(), ContentsResizeValue.units(width), ContentsResizeValue.auto(), ContentsResizeValue.auto(), ContentsResizeValue.units(height), ContentsResizeValue.auto());
        }

        public static ContentsResizeParameters contentSizePercent(double width, double height) {
            return new ContentsResizeParameters(ContentsResizeValue.auto(), ContentsResizeValue.percents(width), ContentsResizeValue.auto(), ContentsResizeValue.auto(), ContentsResizeValue.percents(height), ContentsResizeValue.auto());
        }

        public static ContentsResizeParameters pageResize(double width, double height) {
            return new ContentsResizeParameters(ContentsResizeValue.units(0.0), ContentsResizeValue.units(width), ContentsResizeValue.units(0.0), ContentsResizeValue.units(0.0), ContentsResizeValue.units(height), ContentsResizeValue.units(0.0));
        }

        public static ContentsResizeParameters pageResizePct(double widthPct, double heightPct) {
            return new ContentsResizeParameters(ContentsResizeValue.units(0.0), ContentsResizeValue.percents(widthPct), ContentsResizeValue.units(0.0), ContentsResizeValue.units(0.0), ContentsResizeValue.percents(heightPct), ContentsResizeValue.units(0.0));
        }

        private double[] lif(ContentsResizeValue[] contentsResizeValueArray, double d) {
            int n;
            double d2 = 0.0;
            int n2 = 0;
            double[] dArray = new double[contentsResizeValueArray.length];
            for (n = 0; n < contentsResizeValueArray.length; ++n) {
                if (contentsResizeValueArray[n] != null) {
                    dArray[n] = contentsResizeValueArray[n].isPercent() ? d * contentsResizeValueArray[n].getValue() / 100.0 : contentsResizeValueArray[n].getValue();
                    d2 += dArray[n];
                    continue;
                }
                ++n2;
            }
            if (n2 > 0) {
                for (n = 0; n < contentsResizeValueArray.length; ++n) {
                    if (contentsResizeValueArray[n] != null) continue;
                    dArray[n] = (d - d2) / (double)n2;
                }
            }
            if (dArray[1] <= 0.0) {
                throw new I131("Margin sizes are larger then page size");
            }
            return dArray;
        }

        double[][] lif(double d, double d2) {
            double[] dArray = this.lif(new ContentsResizeValue[]{this.getLeftMargin(), this.getContentsWidth(), this.getRightMargin()}, d);
            double[] dArray2 = this.lif(new ContentsResizeValue[]{this.getBottomMargin(), this.getContentsHeight(), this.getTopMargin()}, d2);
            return new double[][]{dArray, dArray2};
        }
    }

    public static class ContentsResizeValue {
        private double lif;
        private boolean ll = false;

        public void setPercentValue(double value) {
            this.ll = true;
            this.lif = value;
        }

        public void setUnitValue(double value) {
            this.ll = false;
            this.lif = value;
        }

        public double getValue() {
            return this.lif;
        }

        public boolean isPercent() {
            return this.ll;
        }

        private ContentsResizeValue() {
        }

        public static ContentsResizeValue percents(double value) {
            ContentsResizeValue contentsResizeValue = new ContentsResizeValue();
            contentsResizeValue.setPercentValue(value);
            return contentsResizeValue;
        }

        public static ContentsResizeValue units(double value) {
            ContentsResizeValue contentsResizeValue = new ContentsResizeValue();
            contentsResizeValue.setUnitValue(value);
            return contentsResizeValue;
        }

        public static ContentsResizeValue auto() {
            return null;
        }
    }
}

