/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextFragment;
import com.aspose.pdf.TextFragmentAbsorber;
import com.aspose.pdf.TextFragmentCollection;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.l15l.I11;
import com.aspose.pdf.internal.l15l.I27;
import com.aspose.pdf.internal.l15l.I3I;
import com.aspose.pdf.internal.l15l.I4;
import com.aspose.pdf.internal.l15l.I44;
import com.aspose.pdf.internal.l1687.I5l;
import com.aspose.pdf.internal.l1697.I118I;
import com.aspose.pdf.internal.l1697.I804;
import com.aspose.pdf.internal.ms.System.I11I;
import com.aspose.pdf.internal.ms.System.I12l;
import com.aspose.pdf.internal.ms.System.I16l;
import com.aspose.pdf.internal.ms.System.I1I;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;
import java.util.ArrayList;
import java.util.List;

public abstract class TextMarkupAnnotation
extends MarkupAnnotation {
    TextMarkupAnnotation(I11 annotation, IDocument document) {
        super(annotation, document);
    }

    protected TextMarkupAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        I3I i3I = new I3I(page.EnginePage);
        i3I.lif((I27)new I44(this.getRect().getLLX()));
        i3I.lif((I27)new I44(this.getRect().getURY()));
        i3I.lif((I27)new I44(this.getRect().getURX()));
        i3I.lif((I27)new I44(this.getRect().getURY()));
        i3I.lif((I27)new I44(this.getRect().getLLX()));
        i3I.lif((I27)new I44(this.getRect().getLLY()));
        i3I.lif((I27)new I44(this.getRect().getURX()));
        i3I.lif((I27)new I44(this.getRect().getLLY()));
        this.getEngineDict().ll("QuadPoints", (I27)i3I);
    }

    @Override
    protected void ll(I118I i118I) {
        StringBuilder stringBuilder;
        super.ll(i118I);
        if (this.getEngineDict().l1("QuadPoints")) {
            stringBuilder = new StringBuilder();
            for (Point point : this.getQuadPoints()) {
                stringBuilder.append(I254.lif(this.ll, "{0},{1},", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        i118I.lI("coords", stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length()).toString());
    }

    @Override
    protected void ll(I804 i804) {
        Point[] pointArray;
        super.ll(i804);
        if (i804.l1("coords")) {
            String[] stringArray = I254.llf(i804.lI("coords"), ',');
            int n = stringArray.length / 2;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                double d = I11I.lif(stringArray[2 * i], (I16l)this.ll);
                double d2 = I11I.lif(stringArray[2 * i + 1], (I16l)this.ll);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setQuadPoints(pointArray);
    }

    @Override
    void lif(I804 i804) {
        this.ll(i804);
        super.lif(XfdfReader.lif(i804));
    }

    public Point[] getQuadPoints() {
        if (this.getEngineDict().l1("QuadPoints")) {
            I4 i4 = this.getEngineDict().lI("QuadPoints").l7I();
            int n = i4.l0l() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(i4.lif(2 * i).l7If().liF(), i4.lif(2 * i + 1).l7If().liF());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoints(Point[] value) {
        I3I i3I = new I3I(this.getEngineDict());
        for (Point point : value) {
            i3I.lif((I27)new I44(point.getX()));
            i3I.lif((I27)new I44(point.getY()));
        }
        this.getEngineDict().lif("QuadPoints", (I27)i3I);
        this.updateAppearances();
    }

    public String getMarkedText() {
        double d = 0.13;
        I5l i5l = new I5l();
        TextFragmentCollection textFragmentCollection = this.getMarkedTextFragments();
        if (textFragmentCollection.size() == 0) {
            return I254.lif;
        }
        TextFragment textFragment = textFragmentCollection.get_Item(1);
        i5l.lif(textFragment.getText());
        for (int i = 2; i <= textFragmentCollection.size(); ++i) {
            TextFragment textFragment2 = textFragmentCollection.get_Item(i);
            if (I331.lif(textFragment.getRectangle().getLLY() - textFragment2.getRectangle().getLLY()) > (double)(textFragment.getTextState().getFontSize() / 2.0f)) {
                i5l.lif(I12l.lIf());
            } else if (I331.lif(textFragment2.getRectangle().getLLX() - textFragment.getRectangle().getURX()) > d * (double)textFragment.getTextState().getFontSize()) {
                i5l.lif(' ');
            }
            i5l.lif(textFragment2.getText());
            textFragment = textFragment2;
        }
        return i5l.toString();
    }

    public TextFragmentCollection getMarkedTextFragments() {
        TextFragmentCollection textFragmentCollection = new TextFragmentCollection();
        List<TextFragmentAbsorber> list = this.l1if();
        for (TextFragmentAbsorber textFragmentAbsorber : list) {
            for (TextFragment textFragment : textFragmentAbsorber.getTextFragments()) {
                textFragmentCollection.add(textFragment);
            }
        }
        return textFragmentCollection;
    }

    private List<TextFragmentAbsorber> l1if() {
        ArrayList<TextFragmentAbsorber> arrayList = new ArrayList<TextFragmentAbsorber>();
        if (this.getQuadPoints() != null) {
            Point[] pointArray = new Point[4];
            for (int i = 0; i < this.getQuadPoints().length; i += 4) {
                I1I.ll(I1I.lI(this.getQuadPoints()), i, I1I.lI(pointArray), 0, 4);
                Rectangle rectangle = new Rectangle(pointArray[0].getX(), pointArray[0].getY(), pointArray[3].getX(), pointArray[3].getY());
                if (!this.getRect().lif(rectangle, 0.0)) continue;
                TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber();
                textFragmentAbsorber.setTextSearchOptions(new TextSearchOptions(false));
                textFragmentAbsorber.getTextSearchOptions().setLimitToPageBounds(true);
                textFragmentAbsorber.getTextSearchOptions().setRectangle(rectangle);
                textFragmentAbsorber.visit(this.lI.getPages().get_Item(this.getPageIndex()));
                arrayList.add(textFragmentAbsorber);
            }
        } else {
            TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber();
            textFragmentAbsorber.setTextSearchOptions(new TextSearchOptions(false));
            textFragmentAbsorber.getTextSearchOptions().setLimitToPageBounds(true);
            textFragmentAbsorber.getTextSearchOptions().setRectangle(this.getRect());
            arrayList.add(textFragmentAbsorber);
        }
        return arrayList;
    }
}

