/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Color;
import com.aspose.pdf.Document;
import com.aspose.pdf.Font;
import com.aspose.pdf.FontRepository;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Redaction;
import com.aspose.pdf.XForm;
import com.aspose.pdf.internal.l15l.I01;
import com.aspose.pdf.internal.l15l.I11;
import com.aspose.pdf.internal.l15l.I27;
import com.aspose.pdf.internal.l15l.I31;
import com.aspose.pdf.internal.l15l.I37;
import com.aspose.pdf.internal.l15l.I3I;
import com.aspose.pdf.internal.l15l.I44;
import com.aspose.pdf.internal.l15l.I4I;
import com.aspose.pdf.internal.l15l.I6l;
import com.aspose.pdf.internal.l1614.I07;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.operators.BT;
import com.aspose.pdf.operators.ClosePathFillStroke;
import com.aspose.pdf.operators.ClosePathStroke;
import com.aspose.pdf.operators.ET;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GSave;
import com.aspose.pdf.operators.MoveTextPosition;
import com.aspose.pdf.operators.Re;
import com.aspose.pdf.operators.SelectFont;
import com.aspose.pdf.operators.SetLineWidth;
import com.aspose.pdf.operators.SetRGBColor;
import com.aspose.pdf.operators.SetRGBColorStroke;
import com.aspose.pdf.operators.ShowText;
import java.util.List;

public final class RedactionAnnotation
extends Annotation {
    RedactionAnnotation(I11 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public RedactionAnnotation(IDocument document) {
        super(document);
        this.getEngineDict().ll("Subtype", (I27)new I4I("Redact"));
    }

    public Point[] getQuadPoint() {
        if (this.getEngineDict().l1("QuadPoints")) {
            com.aspose.pdf.internal.l15l.I4 i4 = this.getEngineDict().lI("QuadPoints").l7I();
            int n = i4.l0l() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(i4.lif(2 * i).l7If().liF(), i4.lif(2 * i + 1).l7If().liF());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoint(Point[] value) {
        I3I i3I = new I3I(this.getEngineDict());
        for (Point point : value) {
            i3I.lif((I27)new I44(point.getX()));
            i3I.lif((I27)new I44(point.getY()));
        }
        this.getEngineDict().lif("QuadPoints", (I27)i3I);
        this.updateAppearances();
    }

    public RedactionAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        this.getEngineDict().ll("Subtype", (I27)new I4I("Redact"));
        this.updateAppearances();
    }

    public Color getFillColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().l1("IC")) {
            I27 i27 = this.getEngineDict().ll("IC");
            if (i27.l7I() == null) {
                return color;
            }
            if (i27.l7I().l0l() < 3) {
                return color;
            }
            color = new Color(new double[]{i27.l7I().lif(0).l7If().liF(), i27.l7I().lif(1).l7If().liF(), i27.l7I().lif(2).l7If().liF()});
        }
        return color;
    }

    public void setFillColor(Color value) {
        this.getEngineDict().lif("IC", (I27)new I3I((I37)((Object)I4.lif(this.getEngineDict(), I37.class)), new I44[]{new I44(I4.l0if(value.ll().l0IF(), 6) / 255.0), new I44(I4.l0if(value.ll().l0lf(), 6) / 255.0), new I44(I4.l0if(value.ll().l0iF(), 6) / 255.0)}));
    }

    public Color getBorderColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().l1("OC")) {
            I27 i27 = this.getEngineDict().ll("OC");
            if (i27.l7I() == null) {
                return color;
            }
            if (i27.l7I().l0l() < 3) {
                return color;
            }
            color = new Color(new double[]{i27.l7I().lif(0).l7If().liF() / 255.0, i27.l7I().lif(1).l7If().liF() / 255.0, i27.l7I().lif(2).l7If().liF() / 255.0});
        }
        return color;
    }

    public void setBorderColor(Color value) {
        this.getEngineDict().lif("OC", (I27)new I3I((I37)((Object)I4.lif(this.getEngineDict(), I37.class)), new I44[]{new I44(I4.l0if(value.ll().l0IF(), 6)), new I44(I4.l0if(value.ll().l0lf(), 6)), new I44(I4.l0if(value.ll().l0iF(), 6))}));
    }

    public String getOverlayText() {
        I27 i27;
        if (this.getEngineDict().l1("OverlayText") && (i27 = this.getEngineDict().ll("OverlayText")).l6f() != null) {
            return i27.l6f().liF();
        }
        return null;
    }

    public void setOverlayText(String value) {
        I6l i6l = new I6l((I37)((Object)I4.lif(this.getEngineDict(), I37.class)), value);
        this.getEngineDict().lif("OverlayText", (I27)i6l);
        this.updateAppearances();
    }

    public boolean isRepeat() {
        if (this.getEngineDict().l1("Repeat") && this.getEngineDict().ll("Repeat").l7IF() != null) {
            return this.getEngineDict().ll("Repeat").l7IF().ll();
        }
        return false;
    }

    public void setRepeat(boolean value) {
        this.getEngineDict().lif("Repeat", (I27)new I31(value));
        this.updateAppearances();
    }

    public int getTextAlignment() {
        int n = 1;
        if (this.getEngineDict().l1("Q") && this.getEngineDict().ll("Q").l7If() != null) {
            switch (this.getEngineDict().ll("Q").l7If().ll()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
            }
        }
        return n;
    }

    public void setTextAlignment(int value) {
        int n = 0;
        switch (value) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
        }
        this.getEngineDict().lif("Q", (I27)new I44(n));
    }

    @Override
    boolean liF() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void lif(Annotation annotation) {
        if (this._disableUpdateAppearance) {
            return;
        }
        XForm xForm = this.lif("N", annotation);
        XForm xForm2 = this.lif("R", annotation);
        xForm2.getResources().getFonts().add("Helv", "Helvetica");
        Document.startOperation();
        try {
            xForm.getContents().add(this.lI(new Annotation.I7("N"), annotation));
            xForm2.getContents().add(this.lI(new Annotation.I7("R"), annotation));
        }
        finally {
            Document.endOperation();
        }
    }

    com.aspose.pdf.internal.ms.System.Collections.Generic.I27<Operator> lI(Annotation.I7 i7, Annotation annotation) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.I27<Operator> i27 = new com.aspose.pdf.internal.ms.System.Collections.Generic.I27<Operator>();
        i27.addItem(new GSave());
        if ("R".equals(i7.lif)) {
            i27.addItem(new SetRGBColor(this.getFillColor().toRgb()));
            i27.addItem(new SetRGBColorStroke(this.getFillColor().toRgb()));
            i27.addItem(new Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            i27.addItem(new ClosePathFillStroke());
            if (this.getOverlayText() != null) {
                i27.addItem(new BT());
                i27.addItem(new SetRGBColor(this.getColor().toRgb()));
                i27.addItem(new SetRGBColorStroke(this.getColor().toRgb()));
                double d = 10.0;
                double d2 = this.getRect().getHeight();
                double d3 = 0.0;
                Font font = FontRepository.findFont("Helvetica");
                switch (this.getTextAlignment()) {
                    case 1: {
                        d3 = 0.0;
                        break;
                    }
                    case 2: {
                        d3 = (this.getWidth() - font.ll().lif(this.getOverlayText(), d)) / 2.0;
                        break;
                    }
                    case 3: {
                        d3 = this.getWidth() - font.ll().lif(this.getOverlayText(), d);
                        break;
                    }
                }
                i27.addItem(new SelectFont("Helv", d));
                i27.addItem(new MoveTextPosition(d3, d2));
                do {
                    i27.addItem(new MoveTextPosition(0.0, -d));
                    i27.addItem(new ShowText(this.getOverlayText()));
                } while (this.isRepeat() && (d2 -= d) > 0.0);
                i27.addItem(new ET());
            }
        } else if ("N".equals(i7.lif)) {
            i27.addItem(new SetRGBColor(this.getBorderColor().toRgb()));
            i27.addItem(new SetRGBColorStroke(this.getBorderColor().toRgb()));
            i27.addItem(new SetLineWidth(5.0));
            i27.addItem(new Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            i27.addItem(new ClosePathStroke());
        }
        i27.addItem(new GRestore());
        return i27;
    }

    @Override
    public void flatten() {
        I01 i01 = this.getEngineDict().ll("AP").l7l();
        i01.lif("N", i01.ll("R"));
        super.flatten();
    }

    public void redact() {
        Redaction.redactText(this.lIf(), this.getRect());
        Redaction.lif(this.lIf(), this.getRect(), I07.l1iF().l16IF(), false);
        Redaction.redactAnnotations(this.lIf(), this.getRect());
        this.flatten();
    }

    public void redactExact() {
        Redaction.redactText(this.lIf(), this.getRect());
        Redaction.lif(this.lIf(), this.getRect(), this.getFillColor().ll().l16IF(), true);
        this.flatten();
    }

    @Override
    public int getAnnotationType() {
        return 23;
    }

    /* synthetic */ List ll(Annotation.I7 i7, Annotation annotation) {
        return this.lI(i7, annotation);
    }
}

