/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.internal.l15l.I27;
import com.aspose.pdf.internal.l15l.I37;
import com.aspose.pdf.internal.l15l.I3I;
import com.aspose.pdf.internal.l15l.I44;
import com.aspose.pdf.internal.l1614.I34I;
import com.aspose.pdf.internal.l1614.I34l;
import com.aspose.pdf.internal.l1637.I01;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.l224.I14;
import com.aspose.pdf.internal.ms.System.I11I;
import com.aspose.pdf.internal.ms.System.I131;
import com.aspose.pdf.internal.ms.System.I16l;
import com.aspose.pdf.internal.ms.System.I17;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Rectangle
implements Cloneable,
Comparable<Object> {
    private static final Logger ll = Logger.getLogger(Rectangle.class.getName());
    private double lI;
    private double l1;
    private double lIF;
    private double llf;
    private boolean liF;
    @Deprecated
    static Rectangle lif;

    public double getWidth() {
        return I331.lif(this.getURX() - this.getLLX());
    }

    public double getHeight() {
        return I331.lif(this.getURY() - this.getLLY());
    }

    public double getLLX() {
        return this.lI;
    }

    public void setLLX(double value) {
        this.lI = value;
    }

    public double getLLY() {
        return this.l1;
    }

    public void setLLY(double value) {
        this.l1 = value;
    }

    public double getURX() {
        return this.lIF;
    }

    public void setURX(double value) {
        this.lIF = value;
    }

    public double getURY() {
        return this.llf;
    }

    public void setURY(double value) {
        this.llf = value;
    }

    public Rectangle(double llx, double lly, double urx, double ury) {
        this(llx, lly, urx, ury, false);
    }

    private Rectangle(double llx, double lly, double urx, double ury, boolean isEmpty) {
        this.lI = llx;
        this.l1 = lly;
        this.lIF = urx;
        this.llf = ury;
        this.liF = isEmpty;
        this.lI();
    }

    private void lI() {
        double d = I331.l1(this.lI, this.lIF);
        double d2 = I331.l1(this.l1, this.llf);
        double d3 = I331.lI(this.lI, this.lIF);
        double d4 = I331.lI(this.l1, this.llf);
        this.lI = d;
        this.l1 = d2;
        this.lIF = d3;
        this.llf = d4;
    }

    I34l lif() {
        return new I34l((int)this.getLLX(), (int)this.getLLY(), (int)this.getWidth(), (int)this.getHeight());
    }

    I34I ll() {
        I34I i34I = new I34I(I4.lf(this.getLLX(), 14), I4.lf(this.getLLY(), 14), I4.lf(this.getWidth(), 14), I4.lf(this.getHeight(), 14));
        return i34I;
    }

    public java.awt.Rectangle toRect() {
        return this.lif().lif();
    }

    static Rectangle lif(I34l i34l) {
        return new Rectangle(i34l.lIF(), i34l.lf(), i34l.lIF() + i34l.l0if(), i34l.lf() + i34l.lI());
    }

    public static Rectangle fromRect(java.awt.Rectangle src) {
        return Rectangle.lif(I34l.lif(src));
    }

    public I3I toArray(I37 trailerable) {
        return new I3I(trailerable, new I27[]{new I44(this.lI), new I44(this.l1), new I44(this.lIF), new I44(this.llf)});
    }

    public String toString() {
        return I254.lif(I01.l1(), "{0},{1},{2},{3}", this.lI, this.l1, this.lIF, this.llf);
    }

    public static Rectangle parse(String value) {
        I01 i01 = I01.l1();
        try {
            String[] stringArray = I254.llf(value, ',');
            double d = I11I.lif(stringArray[0], (I16l)i01);
            double d2 = I11I.lif(stringArray[1], (I16l)i01);
            double d3 = I11I.lif(stringArray[2], (I16l)i01);
            double d4 = I11I.lif(stringArray[3], (I16l)i01);
            return new Rectangle(d, d2, d3, d4);
        }
        catch (I131 i131) {
            ll.log(Level.INFO, "Exception occur", i131);
            throw new IllegalStateException("Wrong input string.");
        }
    }

    public static Rectangle getEmpty() {
        if (lif == null) {
            lif = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
        }
        return lif;
    }

    public static Rectangle getTrivial() {
        return new Rectangle(0.0, 0.0, 0.0, 0.0);
    }

    public boolean isTrivial() {
        return Double.doubleToRawLongBits(this.getLLX()) == 0L && Double.doubleToRawLongBits(this.getLLY()) == 0L && Double.doubleToRawLongBits(this.getURX()) == 0L && Double.doubleToRawLongBits(this.getURY()) == 0L;
    }

    public boolean isEmpty() {
        return this.liF;
    }

    public boolean isPoint() {
        return Double.compare(this.lI, this.lIF) == 0 && Double.compare(this.l1, this.llf) == 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        return Double.compare(this.getLLX(), ((Rectangle)other).getLLX()) == 0 && Double.compare(this.getLLY(), ((Rectangle)other).getLLY()) == 0 && Double.compare(this.getURX(), ((Rectangle)other).getURX()) == 0 && Double.compare(this.getURY(), ((Rectangle)other).getURY()) == 0;
    }

    public boolean nearEquals(Rectangle other, double delta) {
        if (other == null) {
            return false;
        }
        return I331.lif(this.getLLX() - other.getLLX()) < delta && I331.lif(this.getLLY() - other.getLLY()) < delta && I331.lif(this.getURX() - other.getURX()) < delta && I331.lif(this.getURY() - other.getURY()) < delta;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private double[] lif(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = I331.lI(d, d3);
        if (d6 > (d5 = I331.l1(d2, d4))) {
            return null;
        }
        return new double[]{d6, d5};
    }

    public Rectangle intersect(Rectangle otherRect) {
        double[] dArray = this.lif(this.getLLX(), this.getURX(), otherRect.getLLX(), otherRect.getURX());
        double[] dArray2 = this.lif(this.getLLY(), this.getURY(), otherRect.getLLY(), otherRect.getURY());
        if (dArray != null && dArray2 != null) {
            return new Rectangle(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        }
        return null;
    }

    public Rectangle join(Rectangle otherRect) {
        if (otherRect == null) {
            return this;
        }
        otherRect.lI();
        double d = I331.l1(this.getLLX(), otherRect.getLLX());
        double d2 = I331.lI(this.getURX(), otherRect.getURX());
        double d3 = I331.l1(this.getLLY(), otherRect.getLLY());
        double d4 = I331.lI(this.getURY(), otherRect.getURY());
        return new Rectangle(d, d3, d2, d4);
    }

    @Deprecated
    public void _Intersect(Rectangle otherRect) {
        this.lI = Math.max(this.getLLX(), otherRect.getLLX());
        this.lIF = Math.min(this.getURX(), otherRect.getURX());
        this.l1 = Math.max(this.getLLY(), otherRect.getLLY());
        this.llf = Math.min(this.getURY(), otherRect.getURY());
        this.lI();
    }

    public boolean isIntersect(Rectangle otherRect) {
        if (this.getLLX() > otherRect.getURX() || this.getURX() < otherRect.getLLX()) {
            return false;
        }
        return !(this.getLLY() > otherRect.getURY()) && !(this.getURY() < otherRect.getLLY());
    }

    public boolean contains(Point point) {
        return point.getX() > this.getLLX() && point.getX() < this.getURX() && point.getY() > this.getLLY() && point.getY() < this.getURY();
    }

    public Point center() {
        return new Point((this.getLLX() + this.getURX()) / 2.0, (this.getLLY() + this.getURY()) / 2.0);
    }

    boolean lif(Rectangle rectangle, double d) {
        this.lI();
        if (I14.lif(d, 0.0, 1.0E-4)) {
            double d2;
            if (!this.lif(rectangle.getLLX(), rectangle.getLLY())) {
                return false;
            }
            double d3 = rectangle.getLLX();
            double d4 = rectangle.getLLY();
            double d5 = d3 + rectangle.getWidth() * I331.lIf(d) - rectangle.getHeight() * I331.liF(d);
            if (!this.lif(d5, d2 = d4 + rectangle.getWidth() * I331.liF(d) + rectangle.getHeight() * I331.lIf(d))) {
                return false;
            }
            d5 = d3 + rectangle.getWidth() * I331.lIf(d);
            if (!this.lif(d5, d2 = d4 + rectangle.getWidth() * I331.liF(d))) {
                return false;
            }
            d5 = d3 - rectangle.getHeight() * I331.liF(d);
            return this.lif(d5, d2 = d4 + rectangle.getHeight() * I331.lIf(d));
        }
        return this.lif(rectangle);
    }

    private boolean lif(Rectangle rectangle) {
        return this.lif(rectangle.getURX(), rectangle.getURY()) && this.lif(rectangle.getURX(), rectangle.getLLY()) && this.lif(rectangle.getLLX(), rectangle.getURY()) && this.lif(rectangle.getLLX(), rectangle.getLLY());
    }

    private boolean lif(double d, double d2) {
        return d >= this.getLLX() && d < this.getURX() && d2 >= this.getLLY() && d2 < this.getURY();
    }

    public void rotate(int angle) {
        switch (angle) {
            case 1: 
            case 3: {
                double d = this.lI;
                this.lI = this.l1;
                this.l1 = d;
                d = this.lIF;
                this.lIF = this.llf;
                this.llf = d;
                break;
            }
        }
    }

    public void rotateAngle(int angle) {
        if (angle < 0 || angle > 360) {
            throw new I17("angle", "Must be between 0 and 360");
        }
        double d = (double)angle * Math.PI / 180.0;
        double d2 = I331.lif((this.lI + this.lIF) / 2.0, 2);
        double d3 = I331.lif((this.l1 + this.llf) / 2.0, 2);
        double d4 = this.getHeight();
        double d5 = this.getWidth();
        this.lI = I331.lif(d2 + d5 / 2.0 * I331.lIf(d) + d4 / 2.0 * I331.liF(d), 2);
        this.l1 = I331.lif(d3 - d4 / 2.0 * I331.lIf(d) + d5 / 2.0 * I331.liF(d), 2);
        this.lIF = I331.lif(d2 - d5 / 2.0 * I331.lIf(d) - d4 / 2.0 * I331.liF(d), 2);
        this.llf = I331.lif(d3 + d4 / 2.0 * I331.lIf(d) - d5 / 2.0 * I331.liF(d), 2);
    }

    @Override
    public int compareTo(Object arg0) {
        if (((Rectangle)arg0).getLLX() > this.getLLX()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLX() < this.getLLX()) {
            return -1;
        }
        if (((Rectangle)arg0).getLLY() > this.getLLY()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLY() < this.getLLY()) {
            return -1;
        }
        if (((Rectangle)arg0).getURX() > this.getURX()) {
            return 1;
        }
        if (((Rectangle)arg0).getURX() < this.getURX()) {
            return -1;
        }
        if (((Rectangle)arg0).getURY() > this.getURY()) {
            return 1;
        }
        if (((Rectangle)arg0).getURY() < this.getURY()) {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    public Object deepClone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    static {
        ll.setUseParentHandlers(false);
        lif = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
    }
}

