/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.internal.l1687.I2I;
import com.aspose.pdf.internal.l1687.I5l;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.ms.System.I01;
import com.aspose.pdf.internal.ms.System.I04;
import com.aspose.pdf.internal.ms.System.I114;
import com.aspose.pdf.internal.ms.System.I14l;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.I331;
import com.aspose.pdf.internal.ms.System.I51;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class Pdf417Encoder {
    private static final Logger lif = Logger.getLogger(Pdf417Encoder.class.getName());
    private byte[] ll = new byte[]{8, 1, 1, 1, 1, 1, 1, 3};
    private byte[] lI = new byte[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private byte[][] l1;
    private byte[][] lIF;
    private byte[][] llf;
    private boolean liF = false;
    private int lIf;
    private I2I lf;
    private boolean l0if = false;
    private static final int l0l = 929;
    private static final int[] l0I;
    private static final int[] l01;
    private static final int[] l0IF;
    private static final int[] l0lf;
    private static final int[] l0iF;
    private static final int[] l0If;
    private static final int[] l0f;
    private static final int[] l1if;
    private static final int[] l1l;
    private int[][] l1I = new int[][]{l0I, l01, l0IF, l0lf, l0iF, l0If, l0f, l1if, l1l};

    Pdf417Encoder() {
    }

    private int[] lif(int n) {
        return this.l1I[n];
    }

    public String lif(int[] nArray, String string) {
        char[] cArray = this.ll(nArray, string);
        I5l i5l = new I5l();
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] == '\u0000') {
                i5l.lIF(0);
                continue;
            }
            i5l.lif((char)(929 - cArray[i]));
        }
        return i5l.toString();
    }

    private char[] ll(int[] nArray, String string) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = (c + cArray[cArray.length - 1]) % 929;
            for (int j = cArray.length - 1; j >= 1; --j) {
                cArray[j] = (char)((cArray[j - 1] + (929 - n * nArray[j] % 929)) % 929);
            }
            cArray[0] = (char)((929 - n * nArray[0] % 929) % 929);
        }
        return cArray;
    }

    private static int lif(int n, int n2, int n3, int n4) {
        return n3 * n4 - n2 - n - 1;
    }

    private static int lif(int n, int n2, int n3) {
        int n4 = (n + 1 + n2) / n3 + 1;
        if (n3 * n4 >= n + 1 + n2 + n3) {
            --n4;
        }
        return n4;
    }

    private int lif(float f, int n, int n2, float f2, float f3) {
        return I4.lIF((Object)(((double)(-(73.0f * f - 4.0f)) + I331.l1if(I331.llf(73.0f * f - 4.0f, 2.0) + (double)(4.0f * (17.0f * f * (float)(n + 1 + n2) * f3 / f2)))) / (double)(34.0f * f)), 14);
    }

    public BarcodeRow[] lif(String string, float f, float f2, float f3, int n) {
        int[] nArray = this.lif(n);
        int n2 = nArray.length;
        String string2 = HighLevelEncoder.encodeHighLevel(string, this.lIf, this.lf);
        int n3 = string2.length();
        int n4 = I4.lIF((Object)Float.valueOf((f / f3 - 73.0f) / 17.0f), 13);
        int n5 = I331.ll(Pdf417Encoder.lif(n3, n2, n4), I4.lIF((Object)Float.valueOf(f2 / (f3 * 20.0f)), 13));
        I5l i5l = new I5l();
        int n6 = Pdf417Encoder.lif(n3, n2, n4, n5);
        i5l.lif((char)(n3 + n6 + 1));
        i5l.lif(string2);
        for (int i = 0; i < n6; ++i) {
            i5l.lif('\u0384');
        }
        i5l.lif(this.lif(nArray, i5l.toString()));
        if (n5 > 0) {
            this.ll();
        }
        String string3 = i5l.toString();
        BarcodeRow[] barcodeRowArray = new BarcodeRow[n5];
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            byte[][] byArray;
            int n8;
            int n9;
            BarcodeRow barcodeRow;
            barcodeRowArray[i] = barcodeRow = new BarcodeRow((n4 + 4) * 17 + 1);
            BarcodeRow barcodeRow2 = barcodeRowArray[i];
            barcodeRow2.addSequence(this.ll);
            switch (i % 3) {
                case 0: {
                    n9 = 30 * (i / 3) + (n5 - 1) / 3;
                    n8 = 30 * (i / 3) + (n4 - 1);
                    byArray = this.l1;
                    break;
                }
                case 1: {
                    n9 = 30 * (i / 3) + n * 3 + (n5 - 1) % 3;
                    n8 = 30 * (i / 3) + (n5 - 1) / 3;
                    byArray = this.lIF;
                    break;
                }
                default: {
                    n9 = 30 * (i / 3) + (n4 - 1);
                    n8 = 30 * (i / 3) + n * 3 + (n5 - 1) % 3;
                    byArray = this.llf;
                }
            }
            barcodeRow2.addSequence(byArray[n9]);
            for (int j = 0; j < n4; ++j) {
                barcodeRow2.addSequence(byArray[string3.charAt(n7++)]);
            }
            if (!this.l0if) {
                barcodeRow2.addSequence(byArray[n8]);
            }
            barcodeRow2.addSequence(this.lI);
        }
        return barcodeRowArray;
    }

    private void ll() {
        if (!this.liF) {
            this.lI();
            this.l1();
            this.lIF();
            this.liF = true;
        }
    }

    /*
     * Opcode count of 34379 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void lI() {
        this.l1 = new byte[][]{{3, 1, 1, 1, 1, 1, 3, 6}, {4, 1, 1, 1, 1, 1, 4, 4}, {5, 1, 1, 1, 1, 1, 5, 2}, {3, 1, 1, 1, 1, 2, 3, 5}, {4, 1, 1, 1, 1, 2, 4, 3}, {5, 1, 1, 1, 1, 2, 5, 1}, {2, 1, 1, 1, 1, 3, 2, 6}, {3, 1, 1, 1, 1, 3, 3, 4}, {2, 1, 1, 1, 1, 4, 2, 5}, {1, 1, 1, 1, 1, 5, 1, 6}, {2, 1, 1, 1, 1, 5, 2, 4}, {1, 1, 1, 1, 1, 6, 1, 5}, {2, 1, 1, 1, 2, 1, 3, 6}, {3, 1, 1, 1, 2, 1, 4, 4}, {4, 1, 1, 1, 2, 1, 5, 2}, {2, 1, 1, 1, 2, 2, 3, 5}, {3, 1, 1, 1, 2, 2, 4, 3}, {4, 1, 1, 1, 2, 2, 5, 1}, {1, 1, 1, 1, 2, 3, 2, 6}, {2, 1, 1, 1, 2, 3, 3, 4}, {1, 1, 1, 1, 2, 4, 2, 5}, {1, 1, 1, 1, 3, 1, 3, 6}, {2, 1, 1, 1, 3, 1, 4, 4}, {3, 1, 1, 1, 3, 1, 5, 2}, {1, 1, 1, 1, 3, 2, 3, 5}, {2, 1, 1, 1, 3, 2, 4, 3}, {3, 1, 1, 1, 3, 2, 5, 1}, {1, 1, 1, 1, 3, 3, 3, 4}, {2, 1, 1, 1, 3, 3, 4, 2}, {1, 1, 1, 1, 4, 1, 4, 4}, {2, 1, 1, 1, 4, 1, 5, 2}, {1, 1, 1, 1, 4, 2, 4, 3}, {2, 1, 1, 1, 4, 2, 5, 1}, {1, 1, 1, 1, 5, 1, 5, 2}, {5, 1, 1, 1, 6, 1, 1, 1}, {3, 1, 1, 2, 1, 1, 3, 5}, {4, 1, 1, 2, 1, 1, 4, 3}, {5, 1, 1, 2, 1, 1, 5, 1}, {2, 1, 1, 2, 1, 2, 2, 6}, {3, 1, 1, 2, 1, 2, 3, 4}, {4, 1, 1, 2, 1, 2, 4, 2}, {2, 1, 1, 2, 1, 3, 2, 5}, {3, 1, 1, 2, 1, 3, 3, 3}, {1, 1, 1, 2, 1, 4, 1, 6}, {2, 1, 1, 2, 1, 4, 2, 4}, {3, 1, 1, 2, 1, 4, 3, 2}, {1, 1, 1, 2, 1, 5, 1, 5}, {2, 1, 1, 2, 1, 5, 2, 3}, {1, 1, 1, 2, 1, 6, 1, 4}, {2, 1, 1, 2, 2, 1, 3, 5}, {3, 1, 1, 2, 2, 1, 4, 3}, {4, 1, 1, 2, 2, 1, 5, 1}, {1, 1, 1, 2, 2, 2, 2, 6}, {2, 1, 1, 2, 2, 2, 3, 4}, {3, 1, 1, 2, 2, 2, 4, 2}, {1, 1, 1, 2, 2, 3, 2, 5}, {2, 1, 1, 2, 2, 3, 3, 3}, {3, 1, 1, 2, 2, 3, 4, 1}, {1, 1, 1, 2, 2, 4, 2, 4}, {2, 1, 1, 2, 2, 4, 3, 2}, {1, 1, 1, 2, 3, 1, 3, 5}, {2, 1, 1, 2, 3, 1, 4, 3}, {3, 1, 1, 2, 3, 1, 5, 1}, {1, 1, 1, 2, 3, 2, 3, 4}, {2, 1, 1, 2, 3, 2, 4, 2}, {1, 1, 1, 2, 3, 3, 3, 3}, {2, 1, 1, 2, 3, 3, 4, 1}, {1, 1, 1, 2, 4, 1, 4, 3}, {2, 1, 1, 2, 4, 1, 5, 1}, {1, 1, 1, 2, 4, 2, 4, 2}, {1, 1, 1, 2, 4, 3, 4, 1}, {2, 1, 1, 3, 1, 1, 2, 6}, {3, 1, 1, 3, 1, 1, 3, 4}, {4, 1, 1, 3, 1, 1, 4, 2}, {2, 1, 1, 3, 1, 2, 2, 5}, {3, 1, 1, 3, 1, 2, 3, 3}, {4, 1, 1, 3, 1, 2, 4, 1}, {1, 1, 1, 3, 1, 3, 1, 6}, {2, 1, 1, 3, 1, 3, 2, 4}, {3, 1, 1, 3, 1, 3, 3, 2}, {1, 1, 1, 3, 1, 4, 1, 5}, {2, 1, 1, 3, 1, 4, 2, 3}, {1, 1, 1, 3, 1, 5, 1, 4}, {1, 1, 1, 3, 1, 6, 1, 3}, {1, 1, 1, 3, 2, 1, 2, 6}, {2, 1, 1, 3, 2, 1, 3, 4}, {3, 1, 1, 3, 2, 1, 4, 2}, {1, 1, 1, 3, 2, 2, 2, 5}, {2, 1, 1, 3, 2, 2, 3, 3}, {3, 1, 1, 3, 2, 2, 4, 1}, {1, 1, 1, 3, 2, 3, 2, 4}, {2, 1, 1, 3, 2, 3, 3, 2}, {1, 1, 1, 3, 2, 4, 2, 3}, {1, 1, 1, 3, 2, 5, 2, 2}, {1, 1, 1, 3, 3, 1, 3, 4}, {2, 1, 1, 3, 3, 1, 4, 2}, {1, 1, 1, 3, 3, 2, 3, 3}, {2, 1, 1, 3, 3, 2, 4, 1}, {1, 1, 1, 3, 3, 3, 3, 2}, {1, 1, 1, 3, 4, 1, 4, 2}, {2, 1, 1, 4, 1, 1, 2, 5}, {3, 1, 1, 4, 1, 1, 3, 3}, {4, 1, 1, 4, 1, 1, 4, 1}, {1, 1, 1, 4, 1, 2, 1, 6}, {2, 1, 1, 4, 1, 2, 2, 4}, {3, 1, 1, 4, 1, 2, 3, 2}, {1, 1, 1, 4, 1, 3, 1, 5}, {2, 1, 1, 4, 1, 3, 2, 3}, {3, 1, 1, 4, 1, 3, 3, 1}, {1, 1, 1, 4, 1, 4, 1, 4}, {2, 1, 1, 4, 1, 4, 2, 2}, {1, 1, 1, 4, 1, 5, 1, 3}, {2, 1, 1, 4, 1, 5, 2, 1}, {1, 1, 1, 4, 2, 1, 2, 5}, {2, 1, 1, 4, 2, 1, 3, 3}, {3, 1, 1, 4, 2, 1, 4, 1}, {1, 1, 1, 4, 2, 2, 2, 4}, {2, 1, 1, 4, 2, 2, 3, 2}, {1, 1, 1, 4, 2, 3, 2, 3}, {2, 1, 1, 4, 2, 3, 3, 1}, {1, 1, 1, 4, 2, 4, 2, 2}, {1, 1, 1, 4, 2, 5, 2, 1}, {2, 1, 1, 4, 3, 1, 4, 1}, {1, 1, 1, 4, 3, 3, 3, 1}, {1, 1, 1, 5, 1, 1, 1, 6}, {2, 1, 1, 5, 1, 1, 2, 4}, {3, 1, 1, 5, 1, 1, 3, 2}, {1, 1, 1, 5, 1, 2, 1, 5}, {2, 1, 1, 5, 1, 2, 2, 3}, {3, 1, 1, 5, 1, 2, 3, 1}, {1, 1, 1, 5, 1, 3, 1, 4}, {2, 1, 1, 5, 1, 3, 2, 2}, {1, 1, 1, 5, 1, 4, 1, 3}, {2, 1, 1, 5, 1, 4, 2, 1}, {1, 1, 1, 5, 1, 5, 1, 2}, {1, 1, 1, 5, 2, 1, 2, 4}, {1, 1, 1, 5, 2, 2, 2, 3}, {1, 1, 1, 5, 2, 3, 2, 2}, {1, 1, 1, 6, 1, 1, 1, 5}, {3, 1, 1, 6, 1, 1, 3, 1}, {2, 1, 1, 6, 1, 2, 2, 2}, {2, 1, 1, 6, 1, 3, 2, 1}, {1, 1, 1, 6, 1, 5, 1, 1}, {3, 2, 1, 1, 1, 1, 3, 5}, {4, 2, 1, 1, 1, 1, 4, 3}, {5, 2, 1, 1, 1, 1, 5, 1}, {2, 2, 1, 1, 1, 2, 2, 6}, {3, 2, 1, 1, 1, 2, 3, 4}, {4, 2, 1, 1, 1, 2, 4, 2}, {2, 2, 1, 1, 1, 3, 2, 5}, {3, 2, 1, 1, 1, 3, 3, 3}, {4, 2, 1, 1, 1, 3, 4, 1}, {1, 2, 1, 1, 1, 4, 1, 6}, {2, 2, 1, 1, 1, 4, 2, 4}, {1, 2, 1, 1, 1, 5, 1, 5}, {2, 2, 1, 1, 2, 1, 3, 5}, {3, 2, 1, 1, 2, 1, 4, 3}, {4, 2, 1, 1, 2, 1, 5, 1}, {1, 2, 1, 1, 2, 2, 2, 6}, {2, 2, 1, 1, 2, 2, 3, 4}, {3, 2, 1, 1, 2, 2, 4, 2}, {1, 2, 1, 1, 2, 3, 2, 5}, {2, 2, 1, 1, 2, 3, 3, 3}, {1, 2, 1, 1, 2, 4, 2, 4}, {1, 2, 1, 1, 2, 5, 2, 3}, {1, 2, 1, 1, 3, 1, 3, 5}, {2, 2, 1, 1, 3, 1, 4, 3}, {3, 2, 1, 1, 3, 1, 5, 1}, {1, 2, 1, 1, 3, 2, 3, 4}, {2, 2, 1, 1, 3, 2, 4, 2}, {1, 2, 1, 1, 3, 3, 3, 3}, {1, 2, 1, 1, 3, 4, 3, 2}, {1, 2, 1, 1, 4, 1, 4, 3}, {2, 2, 1, 1, 4, 1, 5, 1}, {1, 2, 1, 1, 4, 2, 4, 2}, {1, 2, 1, 1, 5, 1, 5, 1}, {3, 1, 2, 1, 1, 1, 2, 6}, {4, 1, 2, 1, 1, 1, 3, 4}, {5, 1, 2, 1, 1, 1, 4, 2}, {3, 1, 2, 1, 1, 2, 2, 5}, {4, 1, 2, 1, 1, 2, 3, 3}, {5, 1, 2, 1, 1, 2, 4, 1}, {2, 1, 2, 1, 1, 3, 1, 6}, {3, 1, 2, 1, 1, 3, 2, 4}, {4, 1, 2, 1, 1, 3, 3, 2}, {2, 1, 2, 1, 1, 4, 1, 5}, {3, 1, 2, 1, 1, 4, 2, 3}, {4, 1, 2, 1, 1, 4, 3, 1}, {2, 1, 2, 1, 1, 5, 1, 4}, {3, 1, 2, 1, 1, 5, 2, 2}, {2, 2, 1, 2, 1, 1, 2, 6}, {3, 2, 1, 2, 1, 1, 3, 4}, {4, 2, 1, 2, 1, 1, 4, 2}, {2, 1, 2, 1, 2, 1, 2, 6}, {2, 2, 1, 2, 1, 2, 2, 5}, {3, 2, 1, 2, 1, 2, 3, 3}, {4, 2, 1, 2, 1, 2, 4, 1}, {2, 1, 2, 1, 2, 2, 2, 5}, {3, 1, 2, 1, 2, 2, 3, 3}, {4, 1, 2, 1, 2, 2, 4, 1}, {1, 1, 2, 1, 2, 3, 1, 6}, {1, 2, 1, 2, 1, 4, 1, 5}, {2, 2, 1, 2, 1, 4, 2, 3}, {3, 2, 1, 2, 1, 4, 3, 1}, {1, 1, 2, 1, 2, 4, 1, 5}, {2, 1, 2, 1, 2, 4, 2, 3}, {1, 1, 2, 1, 2, 5, 1, 4}, {1, 2, 1, 2, 2, 1, 2, 6}, {2, 2, 1, 2, 2, 1, 3, 4}, {3, 2, 1, 2, 2, 1, 4, 2}, {1, 1, 2, 1, 3, 1, 2, 6}, {1, 2, 1, 2, 2, 2, 2, 5}, {2, 2, 1, 2, 2, 2, 3, 3}, {3, 2, 1, 2, 2, 2, 4, 1}, {1, 1, 2, 1, 3, 2, 2, 5}, {2, 1, 2, 1, 3, 2, 3, 3}, {3, 1, 2, 1, 3, 2, 4, 1}, {1, 1, 2, 1, 3, 3, 2, 4}, {1, 2, 1, 2, 2, 4, 2, 3}, {1, 1, 2, 1, 3, 4, 2, 3}, {1, 2, 1, 2, 3, 1, 3, 4}, {2, 2, 1, 2, 3, 1, 4, 2}, {1, 1, 2, 1, 4, 1, 3, 4}, {1, 2, 1, 2, 3, 2, 3, 3}, {2, 2, 1, 2, 3, 2, 4, 1}, {1, 1, 2, 1, 4, 2, 3, 3}, {2, 1, 2, 1, 4, 2, 4, 1}, {1, 1, 2, 1, 4, 3, 3, 2}, {1, 2, 1, 2, 4, 1, 4, 2}, {1, 1, 2, 1, 5, 1, 4, 2}, {1, 2, 1, 2, 4, 2, 4, 1}, {1, 1, 2, 1, 5, 2, 4, 1}, {3, 1, 2, 2, 1, 1, 2, 5}, {4, 1, 2, 2, 1, 1, 3, 3}, {5, 1, 2, 2, 1, 1, 4, 1}, {2, 1, 2, 2, 1, 2, 1, 6}, {3, 1, 2, 2, 1, 2, 2, 4}, {4, 1, 2, 2, 1, 2, 3, 2}, {2, 1, 2, 2, 1, 3, 1, 5}, {3, 1, 2, 2, 1, 3, 2, 3}, {4, 1, 2, 2, 1, 3, 3, 1}, {2, 1, 2, 2, 1, 4, 1, 4}, {3, 1, 2, 2, 1, 4, 2, 2}, {2, 1, 2, 2, 1, 5, 1, 3}, {2, 1, 2, 2, 1, 6, 1, 2}, {2, 2, 1, 3, 1, 1, 2, 5}, {3, 2, 1, 3, 1, 1, 3, 3}, {4, 2, 1, 3, 1, 1, 4, 1}, {2, 1, 2, 2, 2, 1, 2, 5}, {2, 2, 1, 3, 1, 2, 2, 4}, {3, 2, 1, 3, 1, 2, 3, 2}, {1, 1, 2, 2, 2, 2, 1, 6}, {1, 2, 1, 3, 1, 3, 1, 5}, {3, 1, 2, 2, 2, 2, 3, 2}, {3, 2, 1, 3, 1, 3, 3, 1}, {1, 1, 2, 2, 2, 3, 1, 5}, {1, 2, 1, 3, 1, 4, 1, 4}, {2, 2, 1, 3, 1, 4, 2, 2}, {1, 1, 2, 2, 2, 4, 1, 4}, {2, 1, 2, 2, 2, 4, 2, 2}, {2, 2, 1, 3, 1, 5, 2, 1}, {1, 2, 1, 3, 1, 6, 1, 2}, {1, 2, 1, 3, 2, 1, 2, 5}, {2, 2, 1, 3, 2, 1, 3, 3}, {3, 2, 1, 3, 2, 1, 4, 1}, {1, 1, 2, 2, 3, 1, 2, 5}, {1, 2, 1, 3, 2, 2, 2, 4}, {2, 2, 1, 3, 2, 2, 3, 2}, {1, 1, 2, 2, 3, 2, 2, 4}, {2, 1, 2, 2, 3, 2, 3, 2}, {2, 2, 1, 3, 2, 3, 3, 1}, {1, 1, 2, 2, 3, 3, 2, 3}, {1, 2, 1, 3, 2, 4, 2, 2}, {1, 2, 1, 3, 2, 5, 2, 1}, {1, 2, 1, 3, 3, 1, 3, 3}, {2, 2, 1, 3, 3, 1, 4, 1}, {1, 1, 2, 2, 4, 1, 3, 3}, {1, 2, 1, 3, 3, 2, 3, 2}, {1, 1, 2, 2, 4, 2, 3, 2}, {1, 2, 1, 3, 3, 3, 3, 1}, {1, 1, 2, 2, 4, 3, 3, 1}, {1, 1, 2, 2, 5, 1, 4, 1}, {2, 1, 2, 3, 1, 1, 1, 6}, {3, 1, 2, 3, 1, 1, 2, 4}, {4, 1, 2, 3, 1, 1, 3, 2}, {2, 1, 2, 3, 1, 2, 1, 5}, {3, 1, 2, 3, 1, 2, 2, 3}, {4, 1, 2, 3, 1, 2, 3, 1}, {2, 1, 2, 3, 1, 3, 1, 4}, {3, 1, 2, 3, 1, 3, 2, 2}, {2, 1, 2, 3, 1, 4, 1, 3}, {3, 1, 2, 3, 1, 4, 2, 1}, {2, 1, 2, 3, 1, 5, 1, 2}, {2, 1, 2, 3, 1, 6, 1, 1}, {1, 2, 1, 4, 1, 1, 1, 6}, {2, 2, 1, 4, 1, 1, 2, 4}, {3, 2, 1, 4, 1, 1, 3, 2}, {1, 1, 2, 3, 2, 1, 1, 6}, {1, 2, 1, 4, 1, 2, 1, 5}, {2, 2, 1, 4, 1, 2, 2, 3}, {3, 2, 1, 4, 1, 2, 3, 1}, {1, 1, 2, 3, 2, 2, 1, 5}, {2, 1, 2, 3, 2, 2, 2, 3}, {3, 1, 2, 3, 2, 2, 3, 1}, {1, 1, 2, 3, 2, 3, 1, 4}, {1, 2, 1, 4, 1, 4, 1, 3}, {2, 2, 1, 4, 1, 4, 2, 1}, {1, 1, 2, 3, 2, 4, 1, 3}, {2, 1, 2, 3, 2, 4, 2, 1}, {1, 1, 2, 3, 2, 5, 1, 2}, {1, 2, 1, 4, 2, 1, 2, 4}, {2, 2, 1, 4, 2, 1, 3, 2}, {1, 1, 2, 3, 3, 1, 2, 4}, {1, 2, 1, 4, 2, 2, 2, 3}, {2, 2, 1, 4, 2, 2, 3, 1}, {1, 1, 2, 3, 3, 2, 2, 3}, {2, 1, 2, 3, 3, 2, 3, 1}, {1, 1, 2, 3, 3, 3, 2, 2}, {1, 2, 1, 4, 2, 4, 2, 1}, {1, 1, 2, 3, 3, 4, 2, 1}, {1, 1, 2, 3, 4, 1, 3, 2}, {1, 1, 2, 3, 4, 2, 3, 1}, {2, 1, 2, 4, 1, 1, 1, 5}, {3, 1, 2, 4, 1, 1, 2, 3}, {4, 1, 2, 4, 1, 1, 3, 1}, {2, 1, 2, 4, 1, 2, 1, 4}, {3, 1, 2, 4, 1, 2, 2, 2}, {2, 1, 2, 4, 1, 3, 1, 3}, {3, 1, 2, 4, 1, 3, 2, 1}, {2, 1, 2, 4, 1, 4, 1, 2}, {2, 1, 2, 4, 1, 5, 1, 1}, {1, 2, 1, 5, 1, 1, 1, 5}, {2, 2, 1, 5, 1, 1, 2, 3}, {3, 2, 1, 5, 1, 1, 3, 1}, {1, 1, 2, 4, 2, 1, 1, 5}, {1, 2, 1, 5, 1, 2, 1, 4}, {2, 2, 1, 5, 1, 2, 2, 2}, {1, 1, 2, 4, 2, 2, 1, 4}, {2, 1, 2, 4, 2, 2, 2, 2}, {2, 2, 1, 5, 1, 3, 2, 1}, {1, 1, 2, 4, 2, 3, 1, 3}, {1, 2, 1, 5, 1, 4, 1, 2}, {1, 1, 2, 4, 2, 4, 1, 2}, {1, 2, 1, 5, 1, 5, 1, 1}, {1, 2, 1, 5, 2, 1, 2, 3}, {1, 1, 2, 4, 3, 1, 2, 3}, {1, 1, 2, 4, 3, 2, 2, 2}, {1, 1, 2, 4, 3, 3, 2, 1}, {3, 1, 2, 5, 1, 1, 2, 2}, {3, 1, 2, 5, 1, 2, 2, 1}, {2, 1, 2, 5, 1, 4, 1, 1}, {2, 2, 1, 6, 1, 1, 2, 2}, {1, 2, 1, 6, 1, 2, 1, 3}, {1, 1, 2, 5, 2, 2, 1, 3}, {1, 1, 2, 5, 2, 3, 1, 2}, {1, 1, 2, 5, 2, 4, 1, 1}, {2, 3, 1, 1, 1, 1, 2, 6}, {3, 3, 1, 1, 1, 1, 3, 4}, {4, 3, 1, 1, 1, 1, 4, 2}, {2, 3, 1, 1, 1, 2, 2, 5}, {3, 3, 1, 1, 1, 2, 3, 3}, {1, 3, 1, 1, 1, 3, 1, 6}, {2, 3, 1, 1, 1, 3, 2, 4}, {3, 3, 1, 1, 1, 3, 3, 2}, {1, 3, 1, 1, 1, 4, 1, 5}, {2, 3, 1, 1, 1, 4, 2, 3}, {1, 3, 1, 1, 1, 5, 1, 4}, {1, 3, 1, 1, 1, 6, 1, 3}, {1, 3, 1, 1, 2, 1, 2, 6}, {2, 3, 1, 1, 2, 1, 3, 4}, {3, 3, 1, 1, 2, 1, 4, 2}, {1, 3, 1, 1, 2, 2, 2, 5}, {2, 3, 1, 1, 2, 2, 3, 3}, {3, 3, 1, 1, 2, 2, 4, 1}, {1, 3, 1, 1, 2, 3, 2, 4}, {2, 3, 1, 1, 2, 3, 3, 2}, {1, 3, 1, 1, 2, 4, 2, 3}, {1, 3, 1, 1, 2, 5, 2, 2}, {1, 3, 1, 1, 3, 1, 3, 4}, {2, 3, 1, 1, 3, 1, 4, 2}, {1, 3, 1, 1, 3, 2, 3, 3}, {2, 3, 1, 1, 3, 2, 4, 1}, {1, 3, 1, 1, 3, 3, 3, 2}, {1, 3, 1, 1, 4, 1, 4, 2}, {1, 3, 1, 1, 4, 2, 4, 1}, {3, 2, 2, 1, 1, 1, 2, 5}, {4, 2, 2, 1, 1, 1, 3, 3}, {5, 2, 2, 1, 1, 1, 4, 1}, {2, 2, 2, 1, 1, 2, 1, 6}, {3, 2, 2, 1, 1, 2, 2, 4}, {4, 2, 2, 1, 1, 2, 3, 2}, {2, 2, 2, 1, 1, 3, 1, 5}, {3, 2, 2, 1, 1, 3, 2, 3}, {4, 2, 2, 1, 1, 3, 3, 1}, {2, 2, 2, 1, 1, 4, 1, 4}, {3, 2, 2, 1, 1, 4, 2, 2}, {2, 2, 2, 1, 1, 5, 1, 3}, {3, 2, 2, 1, 1, 5, 2, 1}, {2, 3, 1, 2, 1, 1, 2, 5}, {3, 3, 1, 2, 1, 1, 3, 3}, {4, 3, 1, 2, 1, 1, 4, 1}, {2, 2, 2, 1, 2, 1, 2, 5}, {2, 3, 1, 2, 1, 2, 2, 4}, {3, 3, 1, 2, 1, 2, 3, 2}, {1, 2, 2, 1, 2, 2, 1, 6}, {1, 3, 1, 2, 1, 3, 1, 5}, {3, 2, 2, 1, 2, 2, 3, 2}, {3, 3, 1, 2, 1, 3, 3, 1}, {1, 2, 2, 1, 2, 3, 1, 5}, {2, 2, 2, 1, 2, 3, 2, 3}, {2, 3, 1, 2, 1, 4, 2, 2}, {1, 2, 2, 1, 2, 4, 1, 4}, {1, 3, 1, 2, 1, 5, 1, 3}, {1, 2, 2, 1, 2, 5, 1, 3}, {1, 3, 1, 2, 2, 1, 2, 5}, {2, 3, 1, 2, 2, 1, 3, 3}, {3, 3, 1, 2, 2, 1, 4, 1}, {1, 2, 2, 1, 3, 1, 2, 5}, {1, 3, 1, 2, 2, 2, 2, 4}, {3, 2, 2, 1, 3, 1, 4, 1}, {1, 2, 2, 1, 3, 2, 2, 4}, {2, 2, 2, 1, 3, 2, 3, 2}, {2, 3, 1, 2, 2, 3, 3, 1}, {1, 2, 2, 1, 3, 3, 2, 3}, {1, 3, 1, 2, 2, 4, 2, 2}, {1, 2, 2, 1, 3, 4, 2, 2}, {1, 3, 1, 2, 3, 1, 3, 3}, {2, 3, 1, 2, 3, 1, 4, 1}, {1, 2, 2, 1, 4, 1, 3, 3}, {1, 3, 1, 2, 3, 2, 3, 2}, {1, 2, 2, 1, 4, 2, 3, 2}, {1, 3, 1, 2, 3, 3, 3, 1}, {1, 3, 1, 2, 4, 1, 4, 1}, {1, 2, 2, 1, 5, 1, 4, 1}, {3, 1, 3, 1, 1, 1, 1, 6}, {4, 1, 3, 1, 1, 1, 2, 4}, {5, 1, 3, 1, 1, 1, 3, 2}, {3, 1, 3, 1, 1, 2, 1, 5}, {4, 1, 3, 1, 1, 2, 2, 3}, {5, 1, 3, 1, 1, 2, 3, 1}, {3, 1, 3, 1, 1, 3, 1, 4}, {4, 1, 3, 1, 1, 3, 2, 2}, {3, 1, 3, 1, 1, 4, 1, 3}, {4, 1, 3, 1, 1, 4, 2, 1}, {3, 1, 3, 1, 1, 5, 1, 2}, {2, 2, 2, 2, 1, 1, 1, 6}, {3, 2, 2, 2, 1, 1, 2, 4}, {4, 2, 2, 2, 1, 1, 3, 2}, {2, 1, 3, 1, 2, 1, 1, 6}, {2, 2, 2, 2, 1, 2, 1, 5}, {4, 1, 3, 1, 2, 1, 3, 2}, {4, 2, 2, 2, 1, 2, 3, 1}, {2, 1, 3, 1, 2, 2, 1, 5}, {3, 1, 3, 1, 2, 2, 2, 3}, {4, 1, 3, 1, 2, 2, 3, 1}, {2, 1, 3, 1, 2, 3, 1, 4}, {2, 2, 2, 2, 1, 4, 1, 3}, {3, 2, 2, 2, 1, 4, 2, 1}, {2, 1, 3, 1, 2, 4, 1, 3}, {3, 1, 3, 1, 2, 4, 2, 1}, {2, 2, 2, 2, 1, 6, 1, 1}, {1, 3, 1, 3, 1, 1, 1, 6}, {2, 3, 1, 3, 1, 1, 2, 4}, {3, 3, 1, 3, 1, 1, 3, 2}, {1, 2, 2, 2, 2, 1, 1, 6}, {1, 3, 1, 3, 1, 2, 1, 5}, {2, 3, 1, 3, 1, 2, 2, 3}, {3, 3, 1, 3, 1, 2, 3, 1}, {1, 1, 3, 1, 3, 1, 1, 6}, {1, 2, 2, 2, 2, 2, 1, 5}, {2, 2, 2, 2, 2, 2, 2, 3}, {3, 2, 2, 2, 2, 2, 3, 1}, {1, 1, 3, 1, 3, 2, 1, 5}, {2, 1, 3, 1, 3, 2, 2, 3}, {3, 1, 3, 1, 3, 2, 3, 1}, {2, 3, 1, 3, 1, 4, 2, 1}, {1, 1, 3, 1, 3, 3, 1, 4}, {1, 2, 2, 2, 2, 4, 1, 3}, {2, 2, 2, 2, 2, 4, 2, 1}, {1, 1, 3, 1, 3, 4, 1, 3}, {1, 3, 1, 3, 1, 6, 1, 1}, {1, 3, 1, 3, 2, 1, 2, 4}, {2, 3, 1, 3, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1, 2, 4}, {1, 3, 1, 3, 2, 2, 2, 3}, {2, 3, 1, 3, 2, 2, 3, 1}, {1, 1, 3, 1, 4, 1, 2, 4}, {1, 2, 2, 2, 3, 2, 2, 3}, {2, 2, 2, 2, 3, 2, 3, 1}, {1, 1, 3, 1, 4, 2, 2, 3}, {2, 1, 3, 1, 4, 2, 3, 1}, {1, 3, 1, 3, 2, 4, 2, 1}, {1, 2, 2, 2, 3, 4, 2, 1}, {1, 3, 1, 3, 3, 1, 3, 2}, {1, 2, 2, 2, 4, 1, 3, 2}, {1, 3, 1, 3, 3, 2, 3, 1}, {1, 1, 3, 1, 5, 1, 3, 2}, {1, 2, 2, 2, 4, 2, 3, 1}, {3, 1, 3, 2, 1, 1, 1, 5}, {4, 1, 3, 2, 1, 1, 2, 3}, {5, 1, 3, 2, 1, 1, 3, 1}, {3, 1, 3, 2, 1, 2, 1, 4}, {4, 1, 3, 2, 1, 2, 2, 2}, {3, 1, 3, 2, 1, 3, 1, 3}, {4, 1, 3, 2, 1, 3, 2, 1}, {3, 1, 3, 2, 1, 4, 1, 2}, {3, 1, 3, 2, 1, 5, 1, 1}, {2, 2, 2, 3, 1, 1, 1, 5}, {3, 2, 2, 3, 1, 1, 2, 3}, {4, 2, 2, 3, 1, 1, 3, 1}, {2, 1, 3, 2, 2, 1, 1, 5}, {2, 2, 2, 3, 1, 2, 1, 4}, {4, 1, 3, 2, 2, 1, 3, 1}, {2, 1, 3, 2, 2, 2, 1, 4}, {3, 1, 3, 2, 2, 2, 2, 2}, {3, 2, 2, 3, 1, 3, 2, 1}, {2, 1, 3, 2, 2, 3, 1, 3}, {2, 2, 2, 3, 1, 4, 1, 2}, {2, 1, 3, 2, 2, 4, 1, 2}, {2, 2, 2, 3, 1, 5, 1, 1}, {2, 1, 3, 2, 2, 5, 1, 1}, {1, 3, 1, 4, 1, 1, 1, 5}, {2, 3, 1, 4, 1, 1, 2, 3}, {3, 3, 1, 4, 1, 1, 3, 1}, {1, 2, 2, 3, 2, 1, 1, 5}, {1, 3, 1, 4, 1, 2, 1, 4}, {2, 3, 1, 4, 1, 2, 2, 2}, {1, 1, 3, 2, 3, 1, 1, 5}, {1, 2, 2, 3, 2, 2, 1, 4}, {2, 2, 2, 3, 2, 2, 2, 2}, {2, 3, 1, 4, 1, 3, 2, 1}, {1, 1, 3, 2, 3, 2, 1, 4}, {2, 1, 3, 2, 3, 2, 2, 2}, {1, 3, 1, 4, 1, 4, 1, 2}, {1, 1, 3, 2, 3, 3, 1, 3}, {1, 2, 2, 3, 2, 4, 1, 2}, {1, 3, 1, 4, 1, 5, 1, 1}, {1, 2, 2, 3, 2, 5, 1, 1}, {1, 3, 1, 4, 2, 1, 2, 3}, {2, 3, 1, 4, 2, 1, 3, 1}, {1, 2, 2, 3, 3, 1, 2, 3}, {1, 3, 1, 4, 2, 2, 2, 2}, {1, 1, 3, 2, 4, 1, 2, 3}, {1, 2, 2, 3, 3, 2, 2, 2}, {1, 3, 1, 4, 2, 3, 2, 1}, {1, 1, 3, 2, 4, 2, 2, 2}, {1, 2, 2, 3, 3, 3, 2, 1}, {1, 3, 1, 4, 3, 1, 3, 1}, {1, 1, 3, 2, 5, 1, 3, 1}, {3, 1, 3, 3, 1, 1, 1, 4}, {4, 1, 3, 3, 1, 1, 2, 2}, {3, 1, 3, 3, 1, 2, 1, 3}, {4, 1, 3, 3, 1, 2, 2, 1}, {3, 1, 3, 3, 1, 3, 1, 2}, {3, 1, 3, 3, 1, 4, 1, 1}, {2, 2, 2, 4, 1, 1, 1, 4}, {3, 2, 2, 4, 1, 1, 2, 2}, {2, 1, 3, 3, 2, 1, 1, 4}, {2, 2, 2, 4, 1, 2, 1, 3}, {3, 2, 2, 4, 1, 2, 2, 1}, {2, 1, 3, 3, 2, 2, 1, 3}, {3, 1, 3, 3, 2, 2, 2, 1}, {2, 1, 3, 3, 2, 3, 1, 2}, {2, 2, 2, 4, 1, 4, 1, 1}, {2, 1, 3, 3, 2, 4, 1, 1}, {1, 3, 1, 5, 1, 1, 1, 4}, {2, 3, 1, 5, 1, 1, 2, 2}, {1, 2, 2, 4, 2, 1, 1, 4}, {1, 3, 1, 5, 1, 2, 1, 3}, {2, 3, 1, 5, 1, 2, 2, 1}, {1, 1, 3, 3, 3, 1, 1, 4}, {1, 2, 2, 4, 2, 2, 1, 3}, {2, 2, 2, 4, 2, 2, 2, 1}, {1, 1, 3, 3, 3, 2, 1, 3}, {2, 1, 3, 3, 3, 2, 2, 1}, {1, 3, 1, 5, 1, 4, 1, 1}, {1, 1, 3, 3, 3, 3, 1, 2}, {1, 2, 2, 4, 2, 4, 1, 1}, {1, 1, 3, 3, 3, 4, 1, 1}, {1, 2, 2, 4, 3, 1, 2, 2}, {1, 1, 3, 3, 4, 1, 2, 2}, {1, 1, 3, 3, 4, 2, 2, 1}, {4, 1, 3, 4, 1, 1, 2, 1}, {3, 1, 3, 4, 1, 3, 1, 1}, {3, 2, 2, 5, 1, 1, 2, 1}, {2, 2, 2, 5, 1, 2, 1, 2}, {2, 2, 2, 5, 1, 3, 1, 1}, {1, 3, 1, 6, 1, 1, 1, 3}, {1, 2, 2, 5, 2, 1, 1, 3}, {1, 1, 3, 4, 3, 1, 1, 3}, {1, 3, 1, 6, 1, 3, 1, 1}, {1, 2, 2, 5, 2, 3, 1, 1}, {2, 4, 1, 1, 1, 1, 2, 5}, {1, 4, 1, 1, 1, 2, 1, 6}, {2, 4, 1, 1, 1, 2, 2, 4}, {1, 4, 1, 1, 1, 3, 1, 5}, {2, 4, 1, 1, 1, 3, 2, 3}, {3, 4, 1, 1, 1, 3, 3, 1}, {1, 4, 1, 1, 1, 4, 1, 4}, {2, 4, 1, 1, 1, 4, 2, 2}, {1, 4, 1, 1, 1, 5, 1, 3}, {2, 4, 1, 1, 1, 5, 2, 1}, {1, 4, 1, 1, 2, 1, 2, 5}, {2, 4, 1, 1, 2, 1, 3, 3}, {3, 4, 1, 1, 2, 1, 4, 1}, {1, 4, 1, 1, 2, 2, 2, 4}, {2, 4, 1, 1, 2, 2, 3, 2}, {1, 4, 1, 1, 2, 3, 2, 3}, {2, 4, 1, 1, 2, 3, 3, 1}, {1, 4, 1, 1, 2, 4, 2, 2}, {1, 4, 1, 1, 2, 5, 2, 1}, {1, 4, 1, 1, 3, 1, 3, 3}, {2, 4, 1, 1, 3, 1, 4, 1}, {1, 4, 1, 1, 3, 2, 3, 2}, {1, 4, 1, 1, 3, 3, 3, 1}, {1, 4, 1, 1, 4, 1, 4, 1}, {2, 3, 2, 1, 1, 1, 1, 6}, {3, 3, 2, 1, 1, 1, 2, 4}, {4, 3, 2, 1, 1, 1, 3, 2}, {2, 3, 2, 1, 1, 2, 1, 5}, {3, 3, 2, 1, 1, 2, 2, 3}, {2, 3, 2, 1, 1, 3, 1, 4}, {3, 3, 2, 1, 1, 3, 2, 2}, {2, 3, 2, 1, 1, 4, 1, 3}, {3, 3, 2, 1, 1, 4, 2, 1}, {2, 3, 2, 1, 1, 5, 1, 2}, {1, 4, 1, 2, 1, 1, 1, 6}, {2, 4, 1, 2, 1, 1, 2, 4}, {3, 4, 1, 2, 1, 1, 3, 2}, {1, 3, 2, 1, 2, 1, 1, 6}, {1, 4, 1, 2, 1, 2, 1, 5}, {3, 3, 2, 1, 2, 1, 3, 2}, {3, 4, 1, 2, 1, 2, 3, 1}, {1, 3, 2, 1, 2, 2, 1, 5}, {2, 3, 2, 1, 2, 2, 2, 3}, {3, 3, 2, 1, 2, 2, 3, 1}, {1, 3, 2, 1, 2, 3, 1, 4}, {1, 4, 1, 2, 1, 4, 1, 3}, {2, 4, 1, 2, 1, 4, 2, 1}, {1, 3, 2, 1, 2, 4, 1, 3}, {2, 3, 2, 1, 2, 4, 2, 1}, {1, 4, 1, 2, 1, 6, 1, 1}, {1, 4, 1, 2, 2, 1, 2, 4}, {2, 4, 1, 2, 2, 1, 3, 2}, {1, 3, 2, 1, 3, 1, 2, 4}, {1, 4, 1, 2, 2, 2, 2, 3}, {2, 4, 1, 2, 2, 2, 3, 1}, {1, 3, 2, 1, 3, 2, 2, 3}, {2, 3, 2, 1, 3, 2, 3, 1}, {1, 3, 2, 1, 3, 3, 2, 2}, {1, 4, 1, 2, 2, 4, 2, 1}, {1, 4, 1, 2, 3, 1, 3, 2}, {1, 3, 2, 1, 4, 1, 3, 2}, {1, 4, 1, 2, 3, 2, 3, 1}, {1, 3, 2, 1, 4, 2, 3, 1}, {3, 2, 3, 1, 1, 1, 1, 5}, {4, 2, 3, 1, 1, 1, 2, 3}, {5, 2, 3, 1, 1, 1, 3, 1}, {3, 2, 3, 1, 1, 2, 1, 4}, {4, 2, 3, 1, 1, 2, 2, 2}, {3, 2, 3, 1, 1, 3, 1, 3}, {4, 2, 3, 1, 1, 3, 2, 1}, {3, 2, 3, 1, 1, 4, 1, 2}, {3, 2, 3, 1, 1, 5, 1, 1}, {2, 3, 2, 2, 1, 1, 1, 5}, {3, 3, 2, 2, 1, 1, 2, 3}, {2, 2, 3, 1, 2, 1, 1, 5}, {2, 3, 2, 2, 1, 2, 1, 4}, {3, 3, 2, 2, 1, 2, 2, 2}, {2, 2, 3, 1, 2, 2, 1, 4}, {3, 2, 3, 1, 2, 2, 2, 2}, {3, 3, 2, 2, 1, 3, 2, 1}, {2, 2, 3, 1, 2, 3, 1, 3}, {2, 3, 2, 2, 1, 4, 1, 2}, {2, 2, 3, 1, 2, 4, 1, 2}, {2, 3, 2, 2, 1, 5, 1, 1}, {2, 2, 3, 1, 2, 5, 1, 1}, {1, 4, 1, 3, 1, 1, 1, 5}, {2, 4, 1, 3, 1, 1, 2, 3}, {1, 3, 2, 2, 2, 1, 1, 5}, {1, 4, 1, 3, 1, 2, 1, 4}, {3, 3, 2, 2, 2, 1, 3, 1}, {1, 2, 3, 1, 3, 1, 1, 5}, {1, 3, 2, 2, 2, 2, 1, 4}, {2, 3, 2, 2, 2, 2, 2, 2}, {2, 4, 1, 3, 1, 3, 2, 1}, {1, 2, 3, 1, 3, 2, 1, 4}, {2, 2, 3, 1, 3, 2, 2, 2}, {1, 4, 1, 3, 1, 4, 1, 2}, {1, 2, 3, 1, 3, 3, 1, 3}, {1, 3, 2, 2, 2, 4, 1, 2}, {1, 4, 1, 3, 1, 5, 1, 1}, {1, 3, 2, 2, 2, 5, 1, 1}, {1, 4, 1, 3, 2, 1, 2, 3}, {2, 4, 1, 3, 2, 1, 3, 1}, {1, 3, 2, 2, 3, 1, 2, 3}, {1, 4, 1, 3, 2, 2, 2, 2}, {1, 2, 3, 1, 4, 1, 2, 3}, {1, 3, 2, 2, 3, 2, 2, 2}, {1, 4, 1, 3, 2, 3, 2, 1}, {1, 2, 3, 1, 4, 2, 2, 2}, {1, 3, 2, 2, 3, 3, 2, 1}, {1, 4, 1, 3, 3, 1, 3, 1}, {1, 3, 2, 2, 4, 1, 3, 1}, {1, 2, 3, 1, 5, 1, 3, 1}, {4, 1, 4, 1, 1, 1, 1, 4}, {5, 1, 4, 1, 1, 1, 2, 2}, {4, 1, 4, 1, 1, 2, 1, 3}, {5, 1, 4, 1, 1, 2, 2, 1}, {4, 1, 4, 1, 1, 3, 1, 2}, {4, 1, 4, 1, 1, 4, 1, 1}, {3, 2, 3, 2, 1, 1, 1, 4}, {4, 2, 3, 2, 1, 1, 2, 2}, {3, 1, 4, 1, 2, 1, 1, 4}, {4, 1, 4, 1, 2, 1, 2, 2}, {4, 2, 3, 2, 1, 2, 2, 1}, {3, 1, 4, 1, 2, 2, 1, 3}, {4, 1, 4, 1, 2, 2, 2, 1}, {3, 1, 4, 1, 2, 3, 1, 2}, {3, 2, 3, 2, 1, 4, 1, 1}, {3, 1, 4, 1, 2, 4, 1, 1}, {2, 3, 2, 3, 1, 1, 1, 4}, {3, 3, 2, 3, 1, 1, 2, 2}, {2, 2, 3, 2, 2, 1, 1, 4}, {2, 3, 2, 3, 1, 2, 1, 3}, {3, 3, 2, 3, 1, 2, 2, 1}, {2, 1, 4, 1, 3, 1, 1, 4}, {2, 2, 3, 2, 2, 2, 1, 3}, {3, 2, 3, 2, 2, 2, 2, 1}, {2, 1, 4, 1, 3, 2, 1, 3}, {3, 1, 4, 1, 3, 2, 2, 1}, {2, 3, 2, 3, 1, 4, 1, 1}, {2, 1, 4, 1, 3, 3, 1, 2}, {2, 2, 3, 2, 2, 4, 1, 1}, {2, 1, 4, 1, 3, 4, 1, 1}, {1, 4, 1, 4, 1, 1, 1, 4}, {2, 4, 1, 4, 1, 1, 2, 2}, {1, 3, 2, 3, 2, 1, 1, 4}, {1, 4, 1, 4, 1, 2, 1, 3}, {2, 4, 1, 4, 1, 2, 2, 1}, {1, 2, 3, 2, 3, 1, 1, 4}, {1, 3, 2, 3, 2, 2, 1, 3}, {2, 3, 2, 3, 2, 2, 2, 1}, {1, 1, 4, 1, 4, 1, 1, 4}, {1, 2, 3, 2, 3, 2, 1, 3}, {2, 2, 3, 2, 3, 2, 2, 1}, {1, 4, 1, 4, 1, 4, 1, 1}, {1, 1, 4, 1, 4, 2, 1, 3}, {2, 1, 4, 1, 4, 2, 2, 1}, {1, 3, 2, 3, 2, 4, 1, 1}, {1, 1, 4, 1, 4, 3, 1, 2}, {1, 4, 1, 4, 2, 1, 2, 2}, {1, 3, 2, 3, 3, 1, 2, 2}, {1, 4, 1, 4, 2, 2, 2, 1}, {1, 2, 3, 2, 4, 1, 2, 2}, {1, 3, 2, 3, 3, 2, 2, 1}, {1, 1, 4, 1, 5, 1, 2, 2}, {1, 2, 3, 2, 4, 2, 2, 1}, {1, 1, 4, 1, 5, 2, 2, 1}, {4, 1, 4, 2, 1, 1, 1, 3}, {5, 1, 4, 2, 1, 1, 2, 1}, {4, 1, 4, 2, 1, 2, 1, 2}, {4, 1, 4, 2, 1, 3, 1, 1}, {3, 2, 3, 3, 1, 1, 1, 3}, {4, 2, 3, 3, 1, 1, 2, 1}, {3, 1, 4, 2, 2, 1, 1, 3}, {4, 1, 4, 2, 2, 1, 2, 1}, {3, 1, 4, 2, 2, 2, 1, 2}, {3, 2, 3, 3, 1, 3, 1, 1}, {3, 1, 4, 2, 2, 3, 1, 1}, {2, 3, 2, 4, 1, 1, 1, 3}, {3, 3, 2, 4, 1, 1, 2, 1}, {2, 2, 3, 3, 2, 1, 1, 3}, {2, 3, 2, 4, 1, 2, 1, 2}, {2, 1, 4, 2, 3, 1, 1, 3}, {2, 2, 3, 3, 2, 2, 1, 2}, {2, 3, 2, 4, 1, 3, 1, 1}, {2, 1, 4, 2, 3, 2, 1, 2}, {2, 2, 3, 3, 2, 3, 1, 1}, {2, 1, 4, 2, 3, 3, 1, 1}, {1, 4, 1, 5, 1, 1, 1, 3}, {2, 4, 1, 5, 1, 1, 2, 1}, {1, 3, 2, 4, 2, 1, 1, 3}, {2, 3, 2, 4, 2, 1, 2, 1}, {1, 2, 3, 3, 3, 1, 1, 3}, {1, 3, 2, 4, 2, 2, 1, 2}, {1, 4, 1, 5, 1, 3, 1, 1}, {1, 1, 4, 2, 4, 1, 1, 3}, {1, 2, 3, 3, 3, 2, 1, 2}, {1, 3, 2, 4, 2, 3, 1, 1}, {1, 1, 4, 2, 4, 2, 1, 2}, {1, 2, 3, 3, 3, 3, 1, 1}, {1, 1, 4, 2, 4, 3, 1, 1}, {1, 3, 2, 4, 3, 1, 2, 1}, {1, 1, 4, 2, 5, 1, 2, 1}, {4, 1, 4, 3, 1, 2, 1, 1}, {3, 1, 4, 3, 2, 1, 1, 2}, {3, 1, 4, 3, 2, 2, 1, 1}, {2, 2, 3, 4, 2, 1, 1, 2}, {2, 1, 4, 3, 3, 1, 1, 2}, {2, 1, 4, 3, 3, 2, 1, 1}, {1, 3, 2, 5, 2, 1, 1, 2}, {1, 2, 3, 4, 3, 1, 1, 2}, {1, 1, 4, 3, 4, 1, 1, 2}, {1, 1, 4, 3, 4, 2, 1, 1}, {1, 5, 1, 1, 1, 1, 1, 6}, {1, 5, 1, 1, 1, 2, 1, 5}, {2, 5, 1, 1, 1, 2, 2, 3}, {1, 5, 1, 1, 1, 3, 1, 4}, {1, 5, 1, 1, 1, 4, 1, 3}, {1, 5, 1, 1, 1, 5, 1, 2}, {1, 5, 1, 1, 2, 1, 2, 4}, {1, 5, 1, 1, 2, 2, 2, 3}, {1, 5, 1, 1, 2, 3, 2, 2}, {1, 5, 1, 1, 2, 4, 2, 1}, {1, 5, 1, 1, 3, 1, 3, 2}, {1, 5, 1, 1, 3, 2, 3, 1}, {2, 4, 2, 1, 1, 1, 1, 5}, {2, 4, 2, 1, 1, 2, 1, 4}, {3, 4, 2, 1, 1, 2, 2, 2}, {2, 4, 2, 1, 1, 3, 1, 3}, {3, 4, 2, 1, 1, 3, 2, 1}, {2, 4, 2, 1, 1, 4, 1, 2}, {2, 4, 2, 1, 1, 5, 1, 1}, {1, 5, 1, 2, 1, 1, 1, 5}, {2, 5, 1, 2, 1, 1, 2, 3}, {1, 4, 2, 1, 2, 1, 1, 5}, {2, 4, 2, 1, 2, 1, 2, 3}, {2, 5, 1, 2, 1, 2, 2, 2}, {1, 4, 2, 1, 2, 2, 1, 4}, {2, 4, 2, 1, 2, 2, 2, 2}, {1, 4, 2, 1, 2, 3, 1, 3}, {2, 4, 2, 1, 2, 3, 2, 1}, {1, 4, 2, 1, 2, 4, 1, 2}, {1, 5, 1, 2, 1, 5, 1, 1}, {1, 4, 2, 1, 2, 5, 1, 1}, {1, 5, 1, 2, 2, 1, 2, 3}, {2, 5, 1, 2, 2, 1, 3, 1}, {1, 4, 2, 1, 3, 1, 2, 3}, {2, 4, 2, 1, 3, 1, 3, 1}, {1, 4, 2, 1, 3, 2, 2, 2}, {1, 5, 1, 2, 2, 3, 2, 1}, {1, 4, 2, 1, 3, 3, 2, 1}, {1, 5, 1, 2, 3, 1, 3, 1}, {1, 4, 2, 1, 4, 1, 3, 1}, {3, 3, 3, 1, 1, 1, 1, 4}, {3, 3, 3, 1, 1, 2, 1, 3}, {3, 3, 3, 1, 1, 3, 1, 2}, {3, 3, 3, 1, 1, 4, 1, 1}, {2, 4, 2, 2, 1, 1, 1, 4}, {2, 3, 3, 1, 2, 1, 1, 4}, {3, 3, 3, 1, 2, 1, 2, 2}, {3, 4, 2, 2, 1, 2, 2, 1}, {2, 3, 3, 1, 2, 2, 1, 3}, {3, 3, 3, 1, 2, 2, 2, 1}, {2, 3, 3, 1, 2, 3, 1, 2}, {2, 4, 2, 2, 1, 4, 1, 1}, {2, 3, 3, 1, 2, 4, 1, 1}, {1, 5, 1, 3, 1, 1, 1, 4}, {1, 4, 2, 2, 2, 1, 1, 4}, {1, 5, 1, 3, 1, 2, 1, 3}, {2, 5, 1, 3, 1, 2, 2, 1}, {1, 3, 3, 1, 3, 1, 1, 4}, {1, 4, 2, 2, 2, 2, 1, 3}, {1, 5, 1, 3, 1, 3, 1, 2}, {1, 3, 3, 1, 3, 2, 1, 3}, {1, 4, 2, 2, 2, 3, 1, 2}, {1, 5, 1, 3, 1, 4, 1, 1}, {1, 3, 3, 1, 3, 3, 1, 2}, {1, 4, 2, 2, 2, 4, 1, 1}, {1, 5, 1, 3, 2, 1, 2, 2}, {1, 4, 2, 2, 3, 1, 2, 2}, {1, 5, 1, 3, 2, 2, 2, 1}, {1, 3, 3, 1, 4, 1, 2, 2}, {1, 4, 2, 2, 3, 2, 2, 1}, {1, 3, 3, 1, 4, 2, 2, 1}, {4, 2, 4, 1, 1, 1, 1, 3}, {4, 2, 4, 1, 1, 2, 1, 2}, {4, 2, 4, 1, 1, 3, 1, 1}, {3, 3, 3, 2, 1, 1, 1, 3}, {3, 2, 4, 1, 2, 1, 1, 3}, {4, 2, 4, 1, 2, 1, 2, 1}, {3, 2, 4, 1, 2, 2, 1, 2}, {3, 3, 3, 2, 1, 3, 1, 1}, {3, 2, 4, 1, 2, 3, 1, 1}, {2, 4, 2, 3, 1, 1, 1, 3}, {3, 4, 2, 3, 1, 1, 2, 1}, {2, 3, 3, 2, 2, 1, 1, 3}, {3, 3, 3, 2, 2, 1, 2, 1}, {2, 2, 4, 1, 3, 1, 1, 3}, {2, 3, 3, 2, 2, 2, 1, 2}, {2, 4, 2, 3, 1, 3, 1, 1}, {2, 2, 4, 1, 3, 2, 1, 2}, {2, 3, 3, 2, 2, 3, 1, 1}, {2, 2, 4, 1, 3, 3, 1, 1}, {1, 5, 1, 4, 1, 1, 1, 3}, {2, 5, 1, 4, 1, 1, 2, 1}, {1, 4, 2, 3, 2, 1, 1, 3}, {2, 4, 2, 3, 2, 1, 2, 1}, {1, 3, 3, 2, 3, 1, 1, 3}, {1, 4, 2, 3, 2, 2, 1, 2}, {1, 5, 1, 4, 1, 3, 1, 1}, {1, 2, 4, 1, 4, 1, 1, 3}, {1, 3, 3, 2, 3, 2, 1, 2}, {1, 4, 2, 3, 2, 3, 1, 1}, {1, 2, 4, 1, 4, 2, 1, 2}, {1, 3, 3, 2, 3, 3, 1, 1}, {1, 5, 1, 4, 2, 1, 2, 1}, {1, 4, 2, 3, 3, 1, 2, 1}, {1, 3, 3, 2, 4, 1, 2, 1}, {1, 2, 4, 1, 5, 1, 2, 1}, {5, 1, 5, 1, 1, 1, 1, 2}, {5, 1, 5, 1, 1, 2, 1, 1}, {4, 2, 4, 2, 1, 1, 1, 2}, {4, 1, 5, 1, 2, 1, 1, 2}, {4, 2, 4, 2, 1, 2, 1, 1}, {4, 1, 5, 1, 2, 2, 1, 1}, {3, 3, 3, 3, 1, 1, 1, 2}, {3, 2, 4, 2, 2, 1, 1, 2}, {3, 3, 3, 3, 1, 2, 1, 1}, {3, 1, 5, 1, 3, 1, 1, 2}, {3, 2, 4, 2, 2, 2, 1, 1}, {3, 1, 5, 1, 3, 2, 1, 1}, {2, 4, 2, 4, 1, 1, 1, 2}, {2, 3, 3, 3, 2, 1, 1, 2}, {2, 4, 2, 4, 1, 2, 1, 1}, {2, 2, 4, 2, 3, 1, 1, 2}, {2, 3, 3, 3, 2, 2, 1, 1}, {2, 1, 5, 1, 4, 1, 1, 2}};
    }

    /*
     * Opcode count of 34379 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void l1() {
        this.lIF = new byte[][]{{5, 1, 1, 1, 1, 1, 2, 5}, {6, 1, 1, 1, 1, 1, 3, 3}, {4, 1, 1, 1, 1, 2, 1, 6}, {5, 1, 1, 1, 1, 2, 2, 4}, {6, 1, 1, 1, 1, 2, 3, 2}, {4, 1, 1, 1, 1, 3, 1, 5}, {5, 1, 1, 1, 1, 3, 2, 3}, {6, 1, 1, 1, 1, 3, 3, 1}, {4, 1, 1, 1, 1, 4, 1, 4}, {5, 1, 1, 1, 1, 4, 2, 2}, {4, 1, 1, 1, 1, 5, 1, 3}, {5, 1, 1, 1, 1, 5, 2, 1}, {4, 1, 1, 1, 1, 6, 1, 2}, {4, 1, 1, 1, 2, 1, 2, 5}, {5, 1, 1, 1, 2, 1, 3, 3}, {6, 1, 1, 1, 2, 1, 4, 1}, {3, 1, 1, 1, 2, 2, 1, 6}, {4, 1, 1, 1, 2, 2, 2, 4}, {5, 1, 1, 1, 2, 2, 3, 2}, {3, 1, 1, 1, 2, 3, 1, 5}, {4, 1, 1, 1, 2, 3, 2, 3}, {5, 1, 1, 1, 2, 3, 3, 1}, {3, 1, 1, 1, 2, 4, 1, 4}, {4, 1, 1, 1, 2, 4, 2, 2}, {3, 1, 1, 1, 2, 5, 1, 3}, {4, 1, 1, 1, 2, 5, 2, 1}, {3, 1, 1, 1, 2, 6, 1, 2}, {3, 1, 1, 1, 3, 1, 2, 5}, {4, 1, 1, 1, 3, 1, 3, 3}, {5, 1, 1, 1, 3, 1, 4, 1}, {2, 1, 1, 1, 3, 2, 1, 6}, {3, 1, 1, 1, 3, 2, 2, 4}, {4, 1, 1, 1, 3, 2, 3, 2}, {2, 1, 1, 1, 3, 3, 1, 5}, {3, 1, 1, 1, 3, 3, 2, 3}, {4, 1, 1, 1, 3, 3, 3, 1}, {2, 1, 1, 1, 3, 4, 1, 4}, {3, 1, 1, 1, 3, 4, 2, 2}, {2, 1, 1, 1, 3, 5, 1, 3}, {3, 1, 1, 1, 3, 5, 2, 1}, {2, 1, 1, 1, 3, 6, 1, 2}, {2, 1, 1, 1, 4, 1, 2, 5}, {3, 1, 1, 1, 4, 1, 3, 3}, {4, 1, 1, 1, 4, 1, 4, 1}, {1, 1, 1, 1, 4, 2, 1, 6}, {2, 1, 1, 1, 4, 2, 2, 4}, {3, 1, 1, 1, 4, 2, 3, 2}, {1, 1, 1, 1, 4, 3, 1, 5}, {2, 1, 1, 1, 4, 3, 2, 3}, {3, 1, 1, 1, 4, 3, 3, 1}, {1, 1, 1, 1, 4, 4, 1, 4}, {2, 1, 1, 1, 4, 4, 2, 2}, {1, 1, 1, 1, 4, 5, 1, 3}, {2, 1, 1, 1, 4, 5, 2, 1}, {1, 1, 1, 1, 5, 1, 2, 5}, {2, 1, 1, 1, 5, 1, 3, 3}, {3, 1, 1, 1, 5, 1, 4, 1}, {1, 1, 1, 1, 5, 2, 2, 4}, {2, 1, 1, 1, 5, 2, 3, 2}, {1, 1, 1, 1, 5, 3, 2, 3}, {2, 1, 1, 1, 5, 3, 3, 1}, {1, 1, 1, 1, 5, 4, 2, 2}, {1, 1, 1, 1, 6, 1, 3, 3}, {2, 1, 1, 1, 6, 1, 4, 1}, {1, 1, 1, 1, 6, 2, 3, 2}, {1, 1, 1, 1, 6, 3, 3, 1}, {4, 1, 1, 2, 1, 1, 1, 6}, {5, 1, 1, 2, 1, 1, 2, 4}, {6, 1, 1, 2, 1, 1, 3, 2}, {4, 1, 1, 2, 1, 2, 1, 5}, {5, 1, 1, 2, 1, 2, 2, 3}, {6, 1, 1, 2, 1, 2, 3, 1}, {4, 1, 1, 2, 1, 3, 1, 4}, {5, 1, 1, 2, 1, 3, 2, 2}, {4, 1, 1, 2, 1, 4, 1, 3}, {5, 1, 1, 2, 1, 4, 2, 1}, {4, 1, 1, 2, 1, 5, 1, 2}, {4, 1, 1, 2, 1, 6, 1, 1}, {3, 1, 1, 2, 2, 1, 1, 6}, {4, 1, 1, 2, 2, 1, 2, 4}, {5, 1, 1, 2, 2, 1, 3, 2}, {3, 1, 1, 2, 2, 2, 1, 5}, {4, 1, 1, 2, 2, 2, 2, 3}, {5, 1, 1, 2, 2, 2, 3, 1}, {3, 1, 1, 2, 2, 3, 1, 4}, {4, 1, 1, 2, 2, 3, 2, 2}, {3, 1, 1, 2, 2, 4, 1, 3}, {4, 1, 1, 2, 2, 4, 2, 1}, {3, 1, 1, 2, 2, 5, 1, 2}, {3, 1, 1, 2, 2, 6, 1, 1}, {2, 1, 1, 2, 3, 1, 1, 6}, {3, 1, 1, 2, 3, 1, 2, 4}, {4, 1, 1, 2, 3, 1, 3, 2}, {2, 1, 1, 2, 3, 2, 1, 5}, {3, 1, 1, 2, 3, 2, 2, 3}, {4, 1, 1, 2, 3, 2, 3, 1}, {2, 1, 1, 2, 3, 3, 1, 4}, {3, 1, 1, 2, 3, 3, 2, 2}, {2, 1, 1, 2, 3, 4, 1, 3}, {3, 1, 1, 2, 3, 4, 2, 1}, {2, 1, 1, 2, 3, 5, 1, 2}, {2, 1, 1, 2, 3, 6, 1, 1}, {1, 1, 1, 2, 4, 1, 1, 6}, {2, 1, 1, 2, 4, 1, 2, 4}, {3, 1, 1, 2, 4, 1, 3, 2}, {1, 1, 1, 2, 4, 2, 1, 5}, {2, 1, 1, 2, 4, 2, 2, 3}, {3, 1, 1, 2, 4, 2, 3, 1}, {1, 1, 1, 2, 4, 3, 1, 4}, {2, 1, 1, 2, 4, 3, 2, 2}, {1, 1, 1, 2, 4, 4, 1, 3}, {2, 1, 1, 2, 4, 4, 2, 1}, {1, 1, 1, 2, 4, 5, 1, 2}, {1, 1, 1, 2, 5, 1, 2, 4}, {2, 1, 1, 2, 5, 1, 3, 2}, {1, 1, 1, 2, 5, 2, 2, 3}, {2, 1, 1, 2, 5, 2, 3, 1}, {1, 1, 1, 2, 5, 3, 2, 2}, {1, 1, 1, 2, 5, 4, 2, 1}, {1, 1, 1, 2, 6, 1, 3, 2}, {1, 1, 1, 2, 6, 2, 3, 1}, {4, 1, 1, 3, 1, 1, 1, 5}, {5, 1, 1, 3, 1, 1, 2, 3}, {6, 1, 1, 3, 1, 1, 3, 1}, {4, 1, 1, 3, 1, 2, 1, 4}, {5, 1, 1, 3, 1, 2, 2, 2}, {4, 1, 1, 3, 1, 3, 1, 3}, {5, 1, 1, 3, 1, 3, 2, 1}, {4, 1, 1, 3, 1, 4, 1, 2}, {4, 1, 1, 3, 1, 5, 1, 1}, {3, 1, 1, 3, 2, 1, 1, 5}, {4, 1, 1, 3, 2, 1, 2, 3}, {5, 1, 1, 3, 2, 1, 3, 1}, {3, 1, 1, 3, 2, 2, 1, 4}, {4, 1, 1, 3, 2, 2, 2, 2}, {3, 1, 1, 3, 2, 3, 1, 3}, {4, 1, 1, 3, 2, 3, 2, 1}, {3, 1, 1, 3, 2, 4, 1, 2}, {3, 1, 1, 3, 2, 5, 1, 1}, {2, 1, 1, 3, 3, 1, 1, 5}, {3, 1, 1, 3, 3, 1, 2, 3}, {4, 1, 1, 3, 3, 1, 3, 1}, {2, 1, 1, 3, 3, 2, 1, 4}, {3, 1, 1, 3, 3, 2, 2, 2}, {2, 1, 1, 3, 3, 3, 1, 3}, {3, 1, 1, 3, 3, 3, 2, 1}, {2, 1, 1, 3, 3, 4, 1, 2}, {2, 1, 1, 3, 3, 5, 1, 1}, {1, 1, 1, 3, 4, 1, 1, 5}, {2, 1, 1, 3, 4, 1, 2, 3}, {3, 1, 1, 3, 4, 1, 3, 1}, {1, 1, 1, 3, 4, 2, 1, 4}, {2, 1, 1, 3, 4, 2, 2, 2}, {1, 1, 1, 3, 4, 3, 1, 3}, {2, 1, 1, 3, 4, 3, 2, 1}, {1, 1, 1, 3, 4, 4, 1, 2}, {1, 1, 1, 3, 4, 5, 1, 1}, {1, 1, 1, 3, 5, 1, 2, 3}, {2, 1, 1, 3, 5, 1, 3, 1}, {1, 1, 1, 3, 5, 2, 2, 2}, {1, 1, 1, 3, 5, 3, 2, 1}, {1, 1, 1, 3, 6, 1, 3, 1}, {4, 1, 1, 4, 1, 1, 1, 4}, {5, 1, 1, 4, 1, 1, 2, 2}, {4, 1, 1, 4, 1, 2, 1, 3}, {5, 1, 1, 4, 1, 2, 2, 1}, {4, 1, 1, 4, 1, 3, 1, 2}, {4, 1, 1, 4, 1, 4, 1, 1}, {3, 1, 1, 4, 2, 1, 1, 4}, {4, 1, 1, 4, 2, 1, 2, 2}, {3, 1, 1, 4, 2, 2, 1, 3}, {4, 1, 1, 4, 2, 2, 2, 1}, {3, 1, 1, 4, 2, 3, 1, 2}, {3, 1, 1, 4, 2, 4, 1, 1}, {2, 1, 1, 4, 3, 1, 1, 4}, {3, 1, 1, 4, 3, 1, 2, 2}, {2, 1, 1, 4, 3, 2, 1, 3}, {3, 1, 1, 4, 3, 2, 2, 1}, {2, 1, 1, 4, 3, 3, 1, 2}, {2, 1, 1, 4, 3, 4, 1, 1}, {1, 1, 1, 4, 4, 1, 1, 4}, {2, 1, 1, 4, 4, 1, 2, 2}, {1, 1, 1, 4, 4, 2, 1, 3}, {2, 1, 1, 4, 4, 2, 2, 1}, {1, 1, 1, 4, 4, 3, 1, 2}, {1, 1, 1, 4, 4, 4, 1, 1}, {1, 1, 1, 4, 5, 1, 2, 2}, {1, 1, 1, 4, 5, 2, 2, 1}, {4, 1, 1, 5, 1, 1, 1, 3}, {5, 1, 1, 5, 1, 1, 2, 1}, {4, 1, 1, 5, 1, 2, 1, 2}, {4, 1, 1, 5, 1, 3, 1, 1}, {3, 1, 1, 5, 2, 1, 1, 3}, {4, 1, 1, 5, 2, 1, 2, 1}, {3, 1, 1, 5, 2, 2, 1, 2}, {3, 1, 1, 5, 2, 3, 1, 1}, {2, 1, 1, 5, 3, 1, 1, 3}, {3, 1, 1, 5, 3, 1, 2, 1}, {2, 1, 1, 5, 3, 2, 1, 2}, {2, 1, 1, 5, 3, 3, 1, 1}, {1, 1, 1, 5, 4, 1, 1, 3}, {2, 1, 1, 5, 4, 1, 2, 1}, {1, 1, 1, 5, 4, 2, 1, 2}, {1, 1, 1, 5, 4, 3, 1, 1}, {4, 1, 1, 6, 1, 1, 1, 2}, {4, 1, 1, 6, 1, 2, 1, 1}, {3, 1, 1, 6, 2, 1, 1, 2}, {3, 1, 1, 6, 2, 2, 1, 1}, {2, 1, 1, 6, 3, 1, 1, 2}, {2, 1, 1, 6, 3, 2, 1, 1}, {4, 2, 1, 1, 1, 1, 1, 6}, {5, 2, 1, 1, 1, 1, 2, 4}, {6, 2, 1, 1, 1, 1, 3, 2}, {4, 2, 1, 1, 1, 2, 1, 5}, {5, 2, 1, 1, 1, 2, 2, 3}, {6, 2, 1, 1, 1, 2, 3, 1}, {4, 2, 1, 1, 1, 3, 1, 4}, {5, 2, 1, 1, 1, 3, 2, 2}, {4, 2, 1, 1, 1, 4, 1, 3}, {5, 2, 1, 1, 1, 4, 2, 1}, {4, 2, 1, 1, 1, 5, 1, 2}, {4, 2, 1, 1, 1, 6, 1, 1}, {3, 2, 1, 1, 2, 1, 1, 6}, {4, 2, 1, 1, 2, 1, 2, 4}, {5, 2, 1, 1, 2, 1, 3, 2}, {3, 2, 1, 1, 2, 2, 1, 5}, {4, 2, 1, 1, 2, 2, 2, 3}, {5, 2, 1, 1, 2, 2, 3, 1}, {3, 2, 1, 1, 2, 3, 1, 4}, {4, 2, 1, 1, 2, 3, 2, 2}, {3, 2, 1, 1, 2, 4, 1, 3}, {4, 2, 1, 1, 2, 4, 2, 1}, {3, 2, 1, 1, 2, 5, 1, 2}, {3, 2, 1, 1, 2, 6, 1, 1}, {2, 2, 1, 1, 3, 1, 1, 6}, {3, 2, 1, 1, 3, 1, 2, 4}, {4, 2, 1, 1, 3, 1, 3, 2}, {2, 2, 1, 1, 3, 2, 1, 5}, {3, 2, 1, 1, 3, 2, 2, 3}, {4, 2, 1, 1, 3, 2, 3, 1}, {2, 2, 1, 1, 3, 3, 1, 4}, {3, 2, 1, 1, 3, 3, 2, 2}, {2, 2, 1, 1, 3, 4, 1, 3}, {3, 2, 1, 1, 3, 4, 2, 1}, {2, 2, 1, 1, 3, 5, 1, 2}, {2, 2, 1, 1, 3, 6, 1, 1}, {1, 2, 1, 1, 4, 1, 1, 6}, {2, 2, 1, 1, 4, 1, 2, 4}, {3, 2, 1, 1, 4, 1, 3, 2}, {1, 2, 1, 1, 4, 2, 1, 5}, {2, 2, 1, 1, 4, 2, 2, 3}, {3, 2, 1, 1, 4, 2, 3, 1}, {1, 2, 1, 1, 4, 3, 1, 4}, {2, 2, 1, 1, 4, 3, 2, 2}, {1, 2, 1, 1, 4, 4, 1, 3}, {2, 2, 1, 1, 4, 4, 2, 1}, {1, 2, 1, 1, 4, 5, 1, 2}, {1, 2, 1, 1, 5, 1, 2, 4}, {2, 2, 1, 1, 5, 1, 3, 2}, {1, 2, 1, 1, 5, 2, 2, 3}, {2, 2, 1, 1, 5, 2, 3, 1}, {1, 2, 1, 1, 5, 3, 2, 2}, {1, 2, 1, 1, 5, 4, 2, 1}, {1, 2, 1, 1, 6, 1, 3, 2}, {1, 2, 1, 1, 6, 2, 3, 1}, {5, 1, 2, 1, 1, 1, 1, 5}, {6, 1, 2, 1, 1, 1, 2, 3}, {1, 1, 2, 1, 1, 1, 6, 4}, {5, 1, 2, 1, 1, 2, 1, 4}, {6, 1, 2, 1, 1, 2, 2, 2}, {1, 1, 2, 1, 1, 2, 6, 3}, {5, 1, 2, 1, 1, 3, 1, 3}, {6, 1, 2, 1, 1, 3, 2, 1}, {1, 1, 2, 1, 1, 3, 6, 2}, {5, 1, 2, 1, 1, 4, 1, 2}, {5, 1, 2, 1, 1, 5, 1, 1}, {4, 2, 1, 2, 1, 1, 1, 5}, {5, 2, 1, 2, 1, 1, 2, 3}, {6, 2, 1, 2, 1, 1, 3, 1}, {4, 1, 2, 1, 2, 1, 1, 5}, {4, 2, 1, 2, 1, 2, 1, 4}, {6, 1, 2, 1, 2, 1, 3, 1}, {4, 1, 2, 1, 2, 2, 1, 4}, {5, 1, 2, 1, 2, 2, 2, 2}, {5, 2, 1, 2, 1, 3, 2, 1}, {4, 1, 2, 1, 2, 3, 1, 3}, {4, 2, 1, 2, 1, 4, 1, 2}, {4, 1, 2, 1, 2, 4, 1, 2}, {4, 2, 1, 2, 1, 5, 1, 1}, {4, 1, 2, 1, 2, 5, 1, 1}, {3, 2, 1, 2, 2, 1, 1, 5}, {4, 2, 1, 2, 2, 1, 2, 3}, {5, 2, 1, 2, 2, 1, 3, 1}, {3, 1, 2, 1, 3, 1, 1, 5}, {3, 2, 1, 2, 2, 2, 1, 4}, {4, 2, 1, 2, 2, 2, 2, 2}, {3, 1, 2, 1, 3, 2, 1, 4}, {4, 1, 2, 1, 3, 2, 2, 2}, {4, 2, 1, 2, 2, 3, 2, 1}, {3, 1, 2, 1, 3, 3, 1, 3}, {3, 2, 1, 2, 2, 4, 1, 2}, {3, 1, 2, 1, 3, 4, 1, 2}, {3, 2, 1, 2, 2, 5, 1, 1}, {3, 1, 2, 1, 3, 5, 1, 1}, {2, 2, 1, 2, 3, 1, 1, 5}, {3, 2, 1, 2, 3, 1, 2, 3}, {4, 2, 1, 2, 3, 1, 3, 1}, {2, 1, 2, 1, 4, 1, 1, 5}, {2, 2, 1, 2, 3, 2, 1, 4}, {3, 2, 1, 2, 3, 2, 2, 2}, {2, 1, 2, 1, 4, 2, 1, 4}, {3, 1, 2, 1, 4, 2, 2, 2}, {3, 2, 1, 2, 3, 3, 2, 1}, {2, 1, 2, 1, 4, 3, 1, 3}, {2, 2, 1, 2, 3, 4, 1, 2}, {2, 1, 2, 1, 4, 4, 1, 2}, {2, 2, 1, 2, 3, 5, 1, 1}, {2, 1, 2, 1, 4, 5, 1, 1}, {1, 2, 1, 2, 4, 1, 1, 5}, {2, 2, 1, 2, 4, 1, 2, 3}, {3, 2, 1, 2, 4, 1, 3, 1}, {1, 1, 2, 1, 5, 1, 1, 5}, {1, 2, 1, 2, 4, 2, 1, 4}, {2, 2, 1, 2, 4, 2, 2, 2}, {1, 1, 2, 1, 5, 2, 1, 4}, {2, 1, 2, 1, 5, 2, 2, 2}, {2, 2, 1, 2, 4, 3, 2, 1}, {1, 1, 2, 1, 5, 3, 1, 3}, {1, 2, 1, 2, 4, 4, 1, 2}, {1, 1, 2, 1, 5, 4, 1, 2}, {1, 2, 1, 2, 4, 5, 1, 1}, {1, 2, 1, 2, 5, 1, 2, 3}, {2, 2, 1, 2, 5, 1, 3, 1}, {1, 1, 2, 1, 6, 1, 2, 3}, {1, 2, 1, 2, 5, 2, 2, 2}, {1, 1, 2, 1, 6, 2, 2, 2}, {1, 2, 1, 2, 5, 3, 2, 1}, {1, 1, 2, 1, 6, 3, 2, 1}, {1, 2, 1, 2, 6, 1, 3, 1}, {5, 1, 2, 2, 1, 1, 1, 4}, {6, 1, 2, 2, 1, 1, 2, 2}, {1, 1, 2, 2, 1, 1, 6, 3}, {5, 1, 2, 2, 1, 2, 1, 3}, {6, 1, 2, 2, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 2, 6, 2}, {5, 1, 2, 2, 1, 3, 1, 2}, {1, 1, 2, 2, 1, 3, 6, 1}, {5, 1, 2, 2, 1, 4, 1, 1}, {4, 2, 1, 3, 1, 1, 1, 4}, {5, 2, 1, 3, 1, 1, 2, 2}, {4, 1, 2, 2, 2, 1, 1, 4}, {4, 2, 1, 3, 1, 2, 1, 3}, {5, 2, 1, 3, 1, 2, 2, 1}, {4, 1, 2, 2, 2, 2, 1, 3}, {5, 1, 2, 2, 2, 2, 2, 1}, {4, 1, 2, 2, 2, 3, 1, 2}, {4, 2, 1, 3, 1, 4, 1, 1}, {4, 1, 2, 2, 2, 4, 1, 1}, {3, 2, 1, 3, 2, 1, 1, 4}, {4, 2, 1, 3, 2, 1, 2, 2}, {3, 1, 2, 2, 3, 1, 1, 4}, {3, 2, 1, 3, 2, 2, 1, 3}, {4, 2, 1, 3, 2, 2, 2, 1}, {3, 1, 2, 2, 3, 2, 1, 3}, {4, 1, 2, 2, 3, 2, 2, 1}, {3, 1, 2, 2, 3, 3, 1, 2}, {3, 2, 1, 3, 2, 4, 1, 1}, {3, 1, 2, 2, 3, 4, 1, 1}, {2, 2, 1, 3, 3, 1, 1, 4}, {3, 2, 1, 3, 3, 1, 2, 2}, {2, 1, 2, 2, 4, 1, 1, 4}, {2, 2, 1, 3, 3, 2, 1, 3}, {3, 2, 1, 3, 3, 2, 2, 1}, {2, 1, 2, 2, 4, 2, 1, 3}, {3, 1, 2, 2, 4, 2, 2, 1}, {2, 1, 2, 2, 4, 3, 1, 2}, {2, 2, 1, 3, 3, 4, 1, 1}, {2, 1, 2, 2, 4, 4, 1, 1}, {1, 2, 1, 3, 4, 1, 1, 4}, {2, 2, 1, 3, 4, 1, 2, 2}, {1, 1, 2, 2, 5, 1, 1, 4}, {1, 2, 1, 3, 4, 2, 1, 3}, {2, 2, 1, 3, 4, 2, 2, 1}, {1, 1, 2, 2, 5, 2, 1, 3}, {2, 1, 2, 2, 5, 2, 2, 1}, {1, 1, 2, 2, 5, 3, 1, 2}, {1, 2, 1, 3, 4, 4, 1, 1}, {1, 1, 2, 2, 5, 4, 1, 1}, {1, 2, 1, 3, 5, 1, 2, 2}, {1, 1, 2, 2, 6, 1, 2, 2}, {1, 2, 1, 3, 5, 2, 2, 1}, {1, 1, 2, 2, 6, 2, 2, 1}, {5, 1, 2, 3, 1, 1, 1, 3}, {6, 1, 2, 3, 1, 1, 2, 1}, {1, 1, 2, 3, 1, 1, 6, 2}, {5, 1, 2, 3, 1, 2, 1, 2}, {1, 1, 2, 3, 1, 2, 6, 1}, {5, 1, 2, 3, 1, 3, 1, 1}, {4, 2, 1, 4, 1, 1, 1, 3}, {5, 2, 1, 4, 1, 1, 2, 1}, {4, 1, 2, 3, 2, 1, 1, 3}, {5, 1, 2, 3, 2, 1, 2, 1}, {4, 1, 2, 3, 2, 2, 1, 2}, {4, 2, 1, 4, 1, 3, 1, 1}, {4, 1, 2, 3, 2, 3, 1, 1}, {3, 2, 1, 4, 2, 1, 1, 3}, {4, 2, 1, 4, 2, 1, 2, 1}, {3, 1, 2, 3, 3, 1, 1, 3}, {3, 2, 1, 4, 2, 2, 1, 2}, {3, 1, 2, 3, 3, 2, 1, 2}, {3, 2, 1, 4, 2, 3, 1, 1}, {3, 1, 2, 3, 3, 3, 1, 1}, {2, 2, 1, 4, 3, 1, 1, 3}, {3, 2, 1, 4, 3, 1, 2, 1}, {2, 1, 2, 3, 4, 1, 1, 3}, {3, 1, 2, 3, 4, 1, 2, 1}, {2, 1, 2, 3, 4, 2, 1, 2}, {2, 2, 1, 4, 3, 3, 1, 1}, {2, 1, 2, 3, 4, 3, 1, 1}, {1, 2, 1, 4, 4, 1, 1, 3}, {2, 2, 1, 4, 4, 1, 2, 1}, {1, 1, 2, 3, 5, 1, 1, 3}, {1, 2, 1, 4, 4, 2, 1, 2}, {1, 1, 2, 3, 5, 2, 1, 2}, {1, 2, 1, 4, 4, 3, 1, 1}, {1, 1, 2, 3, 5, 3, 1, 1}, {1, 2, 1, 4, 5, 1, 2, 1}, {1, 1, 2, 3, 6, 1, 2, 1}, {5, 1, 2, 4, 1, 1, 1, 2}, {1, 1, 2, 4, 1, 1, 6, 1}, {5, 1, 2, 4, 1, 2, 1, 1}, {4, 2, 1, 5, 1, 1, 1, 2}, {4, 1, 2, 4, 2, 1, 1, 2}, {4, 2, 1, 5, 1, 2, 1, 1}, {4, 1, 2, 4, 2, 2, 1, 1}, {3, 2, 1, 5, 2, 1, 1, 2}, {3, 1, 2, 4, 3, 1, 1, 2}, {3, 2, 1, 5, 2, 2, 1, 1}, {3, 1, 2, 4, 3, 2, 1, 1}, {2, 2, 1, 5, 3, 1, 1, 2}, {2, 1, 2, 4, 4, 1, 1, 2}, {2, 2, 1, 5, 3, 2, 1, 1}, {2, 1, 2, 4, 4, 2, 1, 1}, {1, 2, 1, 5, 4, 1, 1, 2}, {1, 1, 2, 4, 5, 1, 1, 2}, {1, 2, 1, 5, 4, 2, 1, 1}, {1, 1, 2, 4, 5, 2, 1, 1}, {5, 1, 2, 5, 1, 1, 1, 1}, {4, 2, 1, 6, 1, 1, 1, 1}, {4, 1, 2, 5, 2, 1, 1, 1}, {3, 2, 1, 6, 2, 1, 1, 1}, {3, 1, 2, 5, 3, 1, 1, 1}, {2, 2, 1, 6, 3, 1, 1, 1}, {2, 1, 2, 5, 4, 1, 1, 1}, {4, 3, 1, 1, 1, 1, 1, 5}, {5, 3, 1, 1, 1, 1, 2, 3}, {6, 3, 1, 1, 1, 1, 3, 1}, {4, 3, 1, 1, 1, 2, 1, 4}, {5, 3, 1, 1, 1, 2, 2, 2}, {4, 3, 1, 1, 1, 3, 1, 3}, {5, 3, 1, 1, 1, 3, 2, 1}, {4, 3, 1, 1, 1, 4, 1, 2}, {4, 3, 1, 1, 1, 5, 1, 1}, {3, 3, 1, 1, 2, 1, 1, 5}, {4, 3, 1, 1, 2, 1, 2, 3}, {5, 3, 1, 1, 2, 1, 3, 1}, {3, 3, 1, 1, 2, 2, 1, 4}, {4, 3, 1, 1, 2, 2, 2, 2}, {3, 3, 1, 1, 2, 3, 1, 3}, {4, 3, 1, 1, 2, 3, 2, 1}, {3, 3, 1, 1, 2, 4, 1, 2}, {3, 3, 1, 1, 2, 5, 1, 1}, {2, 3, 1, 1, 3, 1, 1, 5}, {3, 3, 1, 1, 3, 1, 2, 3}, {4, 3, 1, 1, 3, 1, 3, 1}, {2, 3, 1, 1, 3, 2, 1, 4}, {3, 3, 1, 1, 3, 2, 2, 2}, {2, 3, 1, 1, 3, 3, 1, 3}, {3, 3, 1, 1, 3, 3, 2, 1}, {2, 3, 1, 1, 3, 4, 1, 2}, {2, 3, 1, 1, 3, 5, 1, 1}, {1, 3, 1, 1, 4, 1, 1, 5}, {2, 3, 1, 1, 4, 1, 2, 3}, {3, 3, 1, 1, 4, 1, 3, 1}, {1, 3, 1, 1, 4, 2, 1, 4}, {2, 3, 1, 1, 4, 2, 2, 2}, {1, 3, 1, 1, 4, 3, 1, 3}, {2, 3, 1, 1, 4, 3, 2, 1}, {1, 3, 1, 1, 4, 4, 1, 2}, {1, 3, 1, 1, 4, 5, 1, 1}, {1, 3, 1, 1, 5, 1, 2, 3}, {2, 3, 1, 1, 5, 1, 3, 1}, {1, 3, 1, 1, 5, 2, 2, 2}, {1, 3, 1, 1, 5, 3, 2, 1}, {1, 3, 1, 1, 6, 1, 3, 1}, {5, 2, 2, 1, 1, 1, 1, 4}, {6, 2, 2, 1, 1, 1, 2, 2}, {1, 2, 2, 1, 1, 1, 6, 3}, {5, 2, 2, 1, 1, 2, 1, 3}, {6, 2, 2, 1, 1, 2, 2, 1}, {1, 2, 2, 1, 1, 2, 6, 2}, {5, 2, 2, 1, 1, 3, 1, 2}, {1, 2, 2, 1, 1, 3, 6, 1}, {5, 2, 2, 1, 1, 4, 1, 1}, {4, 3, 1, 2, 1, 1, 1, 4}, {5, 3, 1, 2, 1, 1, 2, 2}, {4, 2, 2, 1, 2, 1, 1, 4}, {4, 3, 1, 2, 1, 2, 1, 3}, {5, 3, 1, 2, 1, 2, 2, 1}, {4, 2, 2, 1, 2, 2, 1, 3}, {5, 2, 2, 1, 2, 2, 2, 1}, {4, 2, 2, 1, 2, 3, 1, 2}, {4, 3, 1, 2, 1, 4, 1, 1}, {4, 2, 2, 1, 2, 4, 1, 1}, {3, 3, 1, 2, 2, 1, 1, 4}, {4, 3, 1, 2, 2, 1, 2, 2}, {3, 2, 2, 1, 3, 1, 1, 4}, {3, 3, 1, 2, 2, 2, 1, 3}, {4, 3, 1, 2, 2, 2, 2, 1}, {3, 2, 2, 1, 3, 2, 1, 3}, {4, 2, 2, 1, 3, 2, 2, 1}, {3, 2, 2, 1, 3, 3, 1, 2}, {3, 3, 1, 2, 2, 4, 1, 1}, {3, 2, 2, 1, 3, 4, 1, 1}, {2, 3, 1, 2, 3, 1, 1, 4}, {3, 3, 1, 2, 3, 1, 2, 2}, {2, 2, 2, 1, 4, 1, 1, 4}, {2, 3, 1, 2, 3, 2, 1, 3}, {3, 3, 1, 2, 3, 2, 2, 1}, {2, 2, 2, 1, 4, 2, 1, 3}, {3, 2, 2, 1, 4, 2, 2, 1}, {2, 2, 2, 1, 4, 3, 1, 2}, {2, 3, 1, 2, 3, 4, 1, 1}, {2, 2, 2, 1, 4, 4, 1, 1}, {1, 3, 1, 2, 4, 1, 1, 4}, {2, 3, 1, 2, 4, 1, 2, 2}, {1, 2, 2, 1, 5, 1, 1, 4}, {1, 3, 1, 2, 4, 2, 1, 3}, {2, 3, 1, 2, 4, 2, 2, 1}, {1, 2, 2, 1, 5, 2, 1, 3}, {2, 2, 2, 1, 5, 2, 2, 1}, {1, 2, 2, 1, 5, 3, 1, 2}, {1, 3, 1, 2, 4, 4, 1, 1}, {1, 2, 2, 1, 5, 4, 1, 1}, {1, 3, 1, 2, 5, 1, 2, 2}, {1, 2, 2, 1, 6, 1, 2, 2}, {1, 3, 1, 2, 5, 2, 2, 1}, {1, 2, 2, 1, 6, 2, 2, 1}, {6, 1, 3, 1, 1, 1, 1, 3}, {1, 1, 3, 1, 1, 1, 5, 4}, {2, 1, 3, 1, 1, 1, 6, 2}, {6, 1, 3, 1, 1, 2, 1, 2}, {1, 1, 3, 1, 1, 2, 5, 3}, {2, 1, 3, 1, 1, 2, 6, 1}, {6, 1, 3, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 1, 3, 5, 2}, {1, 1, 3, 1, 1, 4, 5, 1}, {5, 2, 2, 2, 1, 1, 1, 3}, {6, 2, 2, 2, 1, 1, 2, 1}, {1, 2, 2, 2, 1, 1, 6, 2}, {5, 1, 3, 1, 2, 1, 1, 3}, {6, 1, 3, 1, 2, 1, 2, 1}, {1, 1, 3, 1, 2, 1, 6, 2}, {1, 2, 2, 2, 1, 2, 6, 1}, {5, 1, 3, 1, 2, 2, 1, 2}, {5, 2, 2, 2, 1, 3, 1, 1}, {1, 1, 3, 1, 2, 2, 6, 1}, {5, 1, 3, 1, 2, 3, 1, 1}, {4, 3, 1, 3, 1, 1, 1, 3}, {5, 3, 1, 3, 1, 1, 2, 1}, {4, 2, 2, 2, 2, 1, 1, 3}, {4, 3, 1, 3, 1, 2, 1, 2}, {4, 1, 3, 1, 3, 1, 1, 3}, {5, 1, 3, 1, 3, 1, 2, 1}, {4, 3, 1, 3, 1, 3, 1, 1}, {4, 1, 3, 1, 3, 2, 1, 2}, {4, 2, 2, 2, 2, 3, 1, 1}, {4, 1, 3, 1, 3, 3, 1, 1}, {3, 3, 1, 3, 2, 1, 1, 3}, {4, 3, 1, 3, 2, 1, 2, 1}, {3, 2, 2, 2, 3, 1, 1, 3}, {3, 3, 1, 3, 2, 2, 1, 2}, {3, 1, 3, 1, 4, 1, 1, 3}, {3, 2, 2, 2, 3, 2, 1, 2}, {3, 3, 1, 3, 2, 3, 1, 1}, {3, 1, 3, 1, 4, 2, 1, 2}, {3, 2, 2, 2, 3, 3, 1, 1}, {3, 1, 3, 1, 4, 3, 1, 1}, {2, 3, 1, 3, 3, 1, 1, 3}, {3, 3, 1, 3, 3, 1, 2, 1}, {2, 2, 2, 2, 4, 1, 1, 3}, {2, 3, 1, 3, 3, 2, 1, 2}, {2, 1, 3, 1, 5, 1, 1, 3}, {2, 2, 2, 2, 4, 2, 1, 2}, {2, 3, 1, 3, 3, 3, 1, 1}, {2, 1, 3, 1, 5, 2, 1, 2}, {2, 2, 2, 2, 4, 3, 1, 1}, {2, 1, 3, 1, 5, 3, 1, 1}, {1, 3, 1, 3, 4, 1, 1, 3}, {2, 3, 1, 3, 4, 1, 2, 1}, {1, 2, 2, 2, 5, 1, 1, 3}, {1, 3, 1, 3, 4, 2, 1, 2}, {1, 1, 3, 1, 6, 1, 1, 3}, {1, 2, 2, 2, 5, 2, 1, 2}, {1, 3, 1, 3, 4, 3, 1, 1}, {1, 1, 3, 1, 6, 2, 1, 2}, {1, 2, 2, 2, 5, 3, 1, 1}, {1, 1, 3, 1, 6, 3, 1, 1}, {1, 3, 1, 3, 5, 1, 2, 1}, {1, 2, 2, 2, 6, 1, 2, 1}, {6, 1, 3, 2, 1, 1, 1, 2}, {1, 1, 3, 2, 1, 1, 5, 3}, {2, 1, 3, 2, 1, 1, 6, 1}, {6, 1, 3, 2, 1, 2, 1, 1}, {1, 1, 3, 2, 1, 2, 5, 2}, {1, 1, 3, 2, 1, 3, 5, 1}, {5, 2, 2, 3, 1, 1, 1, 2}, {1, 2, 2, 3, 1, 1, 6, 1}, {5, 1, 3, 2, 2, 1, 1, 2}, {5, 2, 2, 3, 1, 2, 1, 1}, {1, 1, 3, 2, 2, 1, 6, 1}, {5, 1, 3, 2, 2, 2, 1, 1}, {4, 3, 1, 4, 1, 1, 1, 2}, {4, 2, 2, 3, 2, 1, 1, 2}, {4, 3, 1, 4, 1, 2, 1, 1}, {4, 1, 3, 2, 3, 1, 1, 2}, {4, 2, 2, 3, 2, 2, 1, 1}, {4, 1, 3, 2, 3, 2, 1, 1}, {3, 3, 1, 4, 2, 1, 1, 2}, {3, 2, 2, 3, 3, 1, 1, 2}, {3, 3, 1, 4, 2, 2, 1, 1}, {3, 1, 3, 2, 4, 1, 1, 2}, {3, 2, 2, 3, 3, 2, 1, 1}, {3, 1, 3, 2, 4, 2, 1, 1}, {2, 3, 1, 4, 3, 1, 1, 2}, {2, 2, 2, 3, 4, 1, 1, 2}, {2, 3, 1, 4, 3, 2, 1, 1}, {2, 1, 3, 2, 5, 1, 1, 2}, {2, 2, 2, 3, 4, 2, 1, 1}, {2, 1, 3, 2, 5, 2, 1, 1}, {1, 3, 1, 4, 4, 1, 1, 2}, {1, 2, 2, 3, 5, 1, 1, 2}, {1, 3, 1, 4, 4, 2, 1, 1}, {1, 1, 3, 2, 6, 1, 1, 2}, {1, 2, 2, 3, 5, 2, 1, 1}, {1, 1, 3, 2, 6, 2, 1, 1}, {6, 1, 3, 3, 1, 1, 1, 1}, {1, 1, 3, 3, 1, 1, 5, 2}, {1, 1, 3, 3, 1, 2, 5, 1}, {5, 2, 2, 4, 1, 1, 1, 1}, {5, 1, 3, 3, 2, 1, 1, 1}, {4, 3, 1, 5, 1, 1, 1, 1}, {4, 2, 2, 4, 2, 1, 1, 1}, {4, 1, 3, 3, 3, 1, 1, 1}, {3, 3, 1, 5, 2, 1, 1, 1}, {3, 2, 2, 4, 3, 1, 1, 1}, {3, 1, 3, 3, 4, 1, 1, 1}, {2, 3, 1, 5, 3, 1, 1, 1}, {2, 2, 2, 4, 4, 1, 1, 1}, {2, 1, 3, 3, 5, 1, 1, 1}, {1, 3, 1, 5, 4, 1, 1, 1}, {1, 2, 2, 4, 5, 1, 1, 1}, {1, 1, 3, 3, 6, 1, 1, 1}, {1, 1, 3, 4, 1, 1, 5, 1}, {4, 4, 1, 1, 1, 1, 1, 4}, {5, 4, 1, 1, 1, 1, 2, 2}, {4, 4, 1, 1, 1, 2, 1, 3}, {5, 4, 1, 1, 1, 2, 2, 1}, {4, 4, 1, 1, 1, 3, 1, 2}, {4, 4, 1, 1, 1, 4, 1, 1}, {3, 4, 1, 1, 2, 1, 1, 4}, {4, 4, 1, 1, 2, 1, 2, 2}, {3, 4, 1, 1, 2, 2, 1, 3}, {4, 4, 1, 1, 2, 2, 2, 1}, {3, 4, 1, 1, 2, 3, 1, 2}, {3, 4, 1, 1, 2, 4, 1, 1}, {2, 4, 1, 1, 3, 1, 1, 4}, {3, 4, 1, 1, 3, 1, 2, 2}, {2, 4, 1, 1, 3, 2, 1, 3}, {3, 4, 1, 1, 3, 2, 2, 1}, {2, 4, 1, 1, 3, 3, 1, 2}, {2, 4, 1, 1, 3, 4, 1, 1}, {1, 4, 1, 1, 4, 1, 1, 4}, {2, 4, 1, 1, 4, 1, 2, 2}, {1, 4, 1, 1, 4, 2, 1, 3}, {2, 4, 1, 1, 4, 2, 2, 1}, {1, 4, 1, 1, 4, 3, 1, 2}, {1, 4, 1, 1, 4, 4, 1, 1}, {1, 4, 1, 1, 5, 1, 2, 2}, {1, 4, 1, 1, 5, 2, 2, 1}, {5, 3, 2, 1, 1, 1, 1, 3}, {6, 3, 2, 1, 1, 1, 2, 1}, {1, 3, 2, 1, 1, 1, 6, 2}, {5, 3, 2, 1, 1, 2, 1, 2}, {1, 3, 2, 1, 1, 2, 6, 1}, {5, 3, 2, 1, 1, 3, 1, 1}, {4, 4, 1, 2, 1, 1, 1, 3}, {5, 4, 1, 2, 1, 1, 2, 1}, {4, 3, 2, 1, 2, 1, 1, 3}, {4, 4, 1, 2, 1, 2, 1, 2}, {4, 3, 2, 1, 2, 2, 1, 2}, {4, 4, 1, 2, 1, 3, 1, 1}, {4, 3, 2, 1, 2, 3, 1, 1}, {3, 4, 1, 2, 2, 1, 1, 3}, {4, 4, 1, 2, 2, 1, 2, 1}, {3, 3, 2, 1, 3, 1, 1, 3}, {3, 4, 1, 2, 2, 2, 1, 2}, {3, 3, 2, 1, 3, 2, 1, 2}, {3, 4, 1, 2, 2, 3, 1, 1}, {3, 3, 2, 1, 3, 3, 1, 1}, {2, 4, 1, 2, 3, 1, 1, 3}, {3, 4, 1, 2, 3, 1, 2, 1}, {2, 3, 2, 1, 4, 1, 1, 3}, {2, 4, 1, 2, 3, 2, 1, 2}, {2, 3, 2, 1, 4, 2, 1, 2}, {2, 4, 1, 2, 3, 3, 1, 1}, {2, 3, 2, 1, 4, 3, 1, 1}, {1, 4, 1, 2, 4, 1, 1, 3}, {2, 4, 1, 2, 4, 1, 2, 1}, {1, 3, 2, 1, 5, 1, 1, 3}, {1, 4, 1, 2, 4, 2, 1, 2}, {1, 3, 2, 1, 5, 2, 1, 2}, {1, 4, 1, 2, 4, 3, 1, 1}, {1, 3, 2, 1, 5, 3, 1, 1}, {1, 4, 1, 2, 5, 1, 2, 1}, {1, 3, 2, 1, 6, 1, 2, 1}, {6, 2, 3, 1, 1, 1, 1, 2}, {1, 2, 3, 1, 1, 1, 5, 3}, {2, 2, 3, 1, 1, 1, 6, 1}, {6, 2, 3, 1, 1, 2, 1, 1}, {1, 2, 3, 1, 1, 2, 5, 2}, {1, 2, 3, 1, 1, 3, 5, 1}, {5, 3, 2, 2, 1, 1, 1, 2}, {1, 3, 2, 2, 1, 1, 6, 1}, {5, 2, 3, 1, 2, 1, 1, 2}, {5, 3, 2, 2, 1, 2, 1, 1}, {1, 2, 3, 1, 2, 1, 6, 1}, {5, 2, 3, 1, 2, 2, 1, 1}, {4, 4, 1, 3, 1, 1, 1, 2}, {4, 3, 2, 2, 2, 1, 1, 2}, {4, 4, 1, 3, 1, 2, 1, 1}, {4, 2, 3, 1, 3, 1, 1, 2}, {4, 3, 2, 2, 2, 2, 1, 1}, {4, 2, 3, 1, 3, 2, 1, 1}, {3, 4, 1, 3, 2, 1, 1, 2}, {3, 3, 2, 2, 3, 1, 1, 2}, {3, 4, 1, 3, 2, 2, 1, 1}, {3, 2, 3, 1, 4, 1, 1, 2}, {3, 3, 2, 2, 3, 2, 1, 1}, {3, 2, 3, 1, 4, 2, 1, 1}, {2, 4, 1, 3, 3, 1, 1, 2}, {2, 3, 2, 2, 4, 1, 1, 2}, {2, 4, 1, 3, 3, 2, 1, 1}, {2, 2, 3, 1, 5, 1, 1, 2}, {2, 3, 2, 2, 4, 2, 1, 1}, {2, 2, 3, 1, 5, 2, 1, 1}, {1, 4, 1, 3, 4, 1, 1, 2}, {1, 3, 2, 2, 5, 1, 1, 2}, {1, 4, 1, 3, 4, 2, 1, 1}, {1, 2, 3, 1, 6, 1, 1, 2}, {1, 3, 2, 2, 5, 2, 1, 1}, {1, 2, 3, 1, 6, 2, 1, 1}, {1, 1, 4, 1, 1, 1, 4, 4}, {2, 1, 4, 1, 1, 1, 5, 2}, {1, 1, 4, 1, 1, 2, 4, 3}, {2, 1, 4, 1, 1, 2, 5, 1}, {1, 1, 4, 1, 1, 3, 4, 2}, {1, 1, 4, 1, 1, 4, 4, 1}, {6, 2, 3, 2, 1, 1, 1, 1}, {1, 2, 3, 2, 1, 1, 5, 2}, {6, 1, 4, 1, 2, 1, 1, 1}, {1, 1, 4, 1, 2, 1, 5, 2}, {1, 2, 3, 2, 1, 2, 5, 1}, {1, 1, 4, 1, 2, 2, 5, 1}, {5, 3, 2, 3, 1, 1, 1, 1}, {5, 2, 3, 2, 2, 1, 1, 1}, {5, 1, 4, 1, 3, 1, 1, 1}, {4, 4, 1, 4, 1, 1, 1, 1}, {4, 3, 2, 3, 2, 1, 1, 1}, {4, 2, 3, 2, 3, 1, 1, 1}, {4, 1, 4, 1, 4, 1, 1, 1}, {3, 4, 1, 4, 2, 1, 1, 1}, {3, 3, 2, 3, 3, 1, 1, 1}, {3, 2, 3, 2, 4, 1, 1, 1}, {3, 1, 4, 1, 5, 1, 1, 1}, {2, 4, 1, 4, 3, 1, 1, 1}, {2, 3, 2, 3, 4, 1, 1, 1}, {2, 2, 3, 2, 5, 1, 1, 1}, {2, 1, 4, 1, 6, 1, 1, 1}, {1, 4, 1, 4, 4, 1, 1, 1}, {1, 3, 2, 3, 5, 1, 1, 1}, {1, 2, 3, 2, 6, 1, 1, 1}, {1, 1, 4, 2, 1, 1, 4, 3}, {2, 1, 4, 2, 1, 1, 5, 1}, {1, 1, 4, 2, 1, 2, 4, 2}, {1, 1, 4, 2, 1, 3, 4, 1}, {1, 2, 3, 3, 1, 1, 5, 1}, {1, 1, 4, 2, 2, 1, 5, 1}, {1, 1, 4, 3, 1, 1, 4, 2}, {1, 1, 4, 3, 1, 2, 4, 1}, {1, 1, 4, 4, 1, 1, 4, 1}, {4, 5, 1, 1, 1, 1, 1, 3}, {4, 5, 1, 1, 1, 2, 1, 2}, {4, 5, 1, 1, 1, 3, 1, 1}, {3, 5, 1, 1, 2, 1, 1, 3}, {4, 5, 1, 1, 2, 1, 2, 1}, {3, 5, 1, 1, 2, 2, 1, 2}, {3, 5, 1, 1, 2, 3, 1, 1}, {2, 5, 1, 1, 3, 1, 1, 3}, {3, 5, 1, 1, 3, 1, 2, 1}, {2, 5, 1, 1, 3, 2, 1, 2}, {2, 5, 1, 1, 3, 3, 1, 1}, {1, 5, 1, 1, 4, 1, 1, 3}, {2, 5, 1, 1, 4, 1, 2, 1}, {1, 5, 1, 1, 4, 2, 1, 2}, {1, 5, 1, 1, 4, 3, 1, 1}, {1, 5, 1, 1, 5, 1, 2, 1}, {5, 4, 2, 1, 1, 1, 1, 2}, {1, 4, 2, 1, 1, 1, 6, 1}, {5, 4, 2, 1, 1, 2, 1, 1}, {4, 5, 1, 2, 1, 1, 1, 2}, {4, 4, 2, 1, 2, 1, 1, 2}, {4, 5, 1, 2, 1, 2, 1, 1}, {4, 4, 2, 1, 2, 2, 1, 1}, {3, 5, 1, 2, 2, 1, 1, 2}, {3, 4, 2, 1, 3, 1, 1, 2}, {3, 5, 1, 2, 2, 2, 1, 1}, {3, 4, 2, 1, 3, 2, 1, 1}, {2, 5, 1, 2, 3, 1, 1, 2}, {2, 4, 2, 1, 4, 1, 1, 2}, {2, 5, 1, 2, 3, 2, 1, 1}, {2, 4, 2, 1, 4, 2, 1, 1}, {1, 5, 1, 2, 4, 1, 1, 2}, {1, 4, 2, 1, 5, 1, 1, 2}, {1, 5, 1, 2, 4, 2, 1, 1}, {1, 4, 2, 1, 5, 2, 1, 1}, {6, 3, 3, 1, 1, 1, 1, 1}, {1, 3, 3, 1, 1, 1, 5, 2}, {1, 3, 3, 1, 1, 2, 5, 1}, {5, 4, 2, 2, 1, 1, 1, 1}, {5, 3, 3, 1, 2, 1, 1, 1}, {4, 5, 1, 3, 1, 1, 1, 1}, {4, 4, 2, 2, 2, 1, 1, 1}, {4, 3, 3, 1, 3, 1, 1, 1}, {3, 5, 1, 3, 2, 1, 1, 1}, {3, 4, 2, 2, 3, 1, 1, 1}, {3, 3, 3, 1, 4, 1, 1, 1}, {2, 5, 1, 3, 3, 1, 1, 1}, {2, 4, 2, 2, 4, 1, 1, 1}, {2, 3, 3, 1, 5, 1, 1, 1}, {1, 5, 1, 3, 4, 1, 1, 1}, {1, 4, 2, 2, 5, 1, 1, 1}, {1, 3, 3, 1, 6, 1, 1, 1}, {1, 2, 4, 1, 1, 1, 4, 3}, {2, 2, 4, 1, 1, 1, 5, 1}, {1, 2, 4, 1, 1, 2, 4, 2}, {1, 2, 4, 1, 1, 3, 4, 1}, {1, 3, 3, 2, 1, 1, 5, 1}, {1, 2, 4, 1, 2, 1, 5, 1}, {1, 1, 5, 1, 1, 1, 3, 4}, {2, 1, 5, 1, 1, 1, 4, 2}, {1, 1, 5, 1, 1, 2, 3, 3}, {2, 1, 5, 1, 1, 2, 4, 1}, {1, 1, 5, 1, 1, 3, 3, 2}, {1, 1, 5, 1, 1, 4, 3, 1}, {1, 2, 4, 2, 1, 1, 4, 2}, {1, 1, 5, 1, 2, 1, 4, 2}, {1, 2, 4, 2, 1, 2, 4, 1}, {1, 1, 5, 1, 2, 2, 4, 1}, {1, 1, 5, 2, 1, 1, 3, 3}, {2, 1, 5, 2, 1, 1, 4, 1}, {1, 1, 5, 2, 1, 2, 3, 2}, {1, 1, 5, 2, 1, 3, 3, 1}, {1, 2, 4, 3, 1, 1, 4, 1}, {1, 1, 5, 2, 2, 1, 4, 1}, {1, 1, 5, 3, 1, 1, 3, 2}, {1, 1, 5, 3, 1, 2, 3, 1}, {1, 1, 5, 4, 1, 1, 3, 1}, {3, 6, 1, 1, 2, 1, 1, 2}, {3, 6, 1, 1, 2, 2, 1, 1}, {2, 6, 1, 1, 3, 1, 1, 2}, {2, 6, 1, 1, 3, 2, 1, 1}, {1, 6, 1, 1, 4, 1, 1, 2}, {1, 6, 1, 1, 4, 2, 1, 1}, {4, 5, 2, 1, 2, 1, 1, 1}, {3, 6, 1, 2, 2, 1, 1, 1}, {3, 5, 2, 1, 3, 1, 1, 1}, {2, 6, 1, 2, 3, 1, 1, 1}, {2, 5, 2, 1, 4, 1, 1, 1}, {1, 6, 1, 2, 4, 1, 1, 1}, {1, 5, 2, 1, 5, 1, 1, 1}, {1, 4, 3, 1, 1, 1, 5, 1}, {1, 3, 4, 1, 1, 1, 4, 2}, {1, 3, 4, 1, 1, 2, 4, 1}, {1, 2, 5, 1, 1, 1, 3, 3}, {2, 2, 5, 1, 1, 1, 4, 1}, {1, 2, 5, 1, 1, 2, 3, 2}, {1, 2, 5, 1, 1, 3, 3, 1}, {1, 3, 4, 2, 1, 1, 4, 1}, {1, 2, 5, 1, 2, 1, 4, 1}, {1, 1, 6, 1, 1, 1, 2, 4}, {2, 1, 6, 1, 1, 1, 3, 2}, {1, 1, 6, 1, 1, 2, 2, 3}, {2, 1, 6, 1, 1, 2, 3, 1}, {1, 1, 6, 1, 1, 3, 2, 2}, {1, 1, 6, 1, 1, 4, 2, 1}, {1, 2, 5, 2, 1, 1, 3, 2}, {1, 1, 6, 1, 2, 1, 3, 2}, {1, 2, 5, 2, 1, 2, 3, 1}, {1, 1, 6, 1, 2, 2, 3, 1}, {1, 1, 6, 2, 1, 1, 2, 3}, {2, 1, 6, 2, 1, 1, 3, 1}, {1, 1, 6, 2, 1, 2, 2, 2}, {1, 1, 6, 2, 1, 3, 2, 1}, {1, 2, 5, 3, 1, 1, 3, 1}, {1, 1, 6, 2, 2, 1, 3, 1}, {1, 1, 6, 3, 1, 1, 2, 2}, {1, 1, 6, 3, 1, 2, 2, 1}, {1, 4, 4, 1, 1, 1, 4, 1}, {1, 3, 5, 1, 1, 1, 3, 2}, {1, 3, 5, 1, 1, 2, 3, 1}, {1, 2, 6, 1, 1, 1, 2, 3}, {2, 2, 6, 1, 1, 1, 3, 1}, {1, 2, 6, 1, 1, 2, 2, 2}, {1, 2, 6, 1, 1, 3, 2, 1}, {1, 3, 5, 2, 1, 1, 3, 1}, {1, 2, 6, 1, 2, 1, 3, 1}, {1, 2, 6, 2, 1, 1, 2, 2}, {1, 2, 6, 2, 1, 2, 2, 1}};
    }

    /*
     * Opcode count of 34379 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void lIF() {
        this.llf = new byte[][]{{2, 1, 1, 1, 1, 1, 5, 5}, {3, 1, 1, 1, 1, 1, 6, 3}, {1, 1, 1, 1, 1, 2, 4, 6}, {2, 1, 1, 1, 1, 2, 5, 4}, {3, 1, 1, 1, 1, 2, 6, 2}, {1, 1, 1, 1, 1, 3, 4, 5}, {2, 1, 1, 1, 1, 3, 5, 3}, {3, 1, 1, 1, 1, 3, 6, 1}, {1, 1, 1, 1, 1, 4, 4, 4}, {2, 1, 1, 1, 1, 4, 5, 2}, {1, 1, 1, 1, 1, 5, 4, 3}, {6, 1, 1, 1, 2, 1, 1, 4}, {1, 1, 1, 1, 2, 1, 5, 5}, {2, 1, 1, 1, 2, 1, 6, 3}, {6, 1, 1, 1, 2, 2, 1, 3}, {1, 1, 1, 1, 2, 2, 5, 4}, {2, 1, 1, 1, 2, 2, 6, 2}, {6, 1, 1, 1, 2, 3, 1, 2}, {1, 1, 1, 1, 2, 3, 5, 3}, {2, 1, 1, 1, 2, 3, 6, 1}, {6, 1, 1, 1, 2, 4, 1, 1}, {1, 1, 1, 1, 2, 4, 5, 2}, {5, 1, 1, 1, 3, 1, 1, 4}, {6, 1, 1, 1, 3, 1, 2, 2}, {1, 1, 1, 1, 3, 1, 6, 3}, {5, 1, 1, 1, 3, 2, 1, 3}, {6, 1, 1, 1, 3, 2, 2, 1}, {1, 1, 1, 1, 3, 2, 6, 2}, {5, 1, 1, 1, 3, 3, 1, 2}, {1, 1, 1, 1, 3, 3, 6, 1}, {5, 1, 1, 1, 3, 4, 1, 1}, {4, 1, 1, 1, 4, 1, 1, 4}, {5, 1, 1, 1, 4, 1, 2, 2}, {4, 1, 1, 1, 4, 2, 1, 3}, {5, 1, 1, 1, 4, 2, 2, 1}, {4, 1, 1, 1, 4, 3, 1, 2}, {4, 1, 1, 1, 4, 4, 1, 1}, {3, 1, 1, 1, 5, 1, 1, 4}, {4, 1, 1, 1, 5, 1, 2, 2}, {3, 1, 1, 1, 5, 2, 1, 3}, {4, 1, 1, 1, 5, 2, 2, 1}, {3, 1, 1, 1, 5, 3, 1, 2}, {3, 1, 1, 1, 5, 4, 1, 1}, {2, 1, 1, 1, 6, 1, 1, 4}, {3, 1, 1, 1, 6, 1, 2, 2}, {2, 1, 1, 1, 6, 2, 1, 3}, {3, 1, 1, 1, 6, 2, 2, 1}, {2, 1, 1, 1, 6, 3, 1, 2}, {1, 1, 1, 2, 1, 1, 4, 6}, {2, 1, 1, 2, 1, 1, 5, 4}, {3, 1, 1, 2, 1, 1, 6, 2}, {1, 1, 1, 2, 1, 2, 4, 5}, {2, 1, 1, 2, 1, 2, 5, 3}, {3, 1, 1, 2, 1, 2, 6, 1}, {1, 1, 1, 2, 1, 3, 4, 4}, {2, 1, 1, 2, 1, 3, 5, 2}, {1, 1, 1, 2, 1, 4, 4, 3}, {2, 1, 1, 2, 1, 4, 5, 1}, {1, 1, 1, 2, 1, 5, 4, 2}, {6, 1, 1, 2, 2, 1, 1, 3}, {1, 1, 1, 2, 2, 1, 5, 4}, {2, 1, 1, 2, 2, 1, 6, 2}, {6, 1, 1, 2, 2, 2, 1, 2}, {1, 1, 1, 2, 2, 2, 5, 3}, {2, 1, 1, 2, 2, 2, 6, 1}, {6, 1, 1, 2, 2, 3, 1, 1}, {1, 1, 1, 2, 2, 3, 5, 2}, {1, 1, 1, 2, 2, 4, 5, 1}, {5, 1, 1, 2, 3, 1, 1, 3}, {6, 1, 1, 2, 3, 1, 2, 1}, {1, 1, 1, 2, 3, 1, 6, 2}, {5, 1, 1, 2, 3, 2, 1, 2}, {1, 1, 1, 2, 3, 2, 6, 1}, {5, 1, 1, 2, 3, 3, 1, 1}, {4, 1, 1, 2, 4, 1, 1, 3}, {5, 1, 1, 2, 4, 1, 2, 1}, {4, 1, 1, 2, 4, 2, 1, 2}, {4, 1, 1, 2, 4, 3, 1, 1}, {3, 1, 1, 2, 5, 1, 1, 3}, {4, 1, 1, 2, 5, 1, 2, 1}, {3, 1, 1, 2, 5, 2, 1, 2}, {3, 1, 1, 2, 5, 3, 1, 1}, {2, 1, 1, 2, 6, 1, 1, 3}, {3, 1, 1, 2, 6, 1, 2, 1}, {2, 1, 1, 2, 6, 2, 1, 2}, {2, 1, 1, 2, 6, 3, 1, 1}, {1, 1, 1, 3, 1, 1, 4, 5}, {2, 1, 1, 3, 1, 1, 5, 3}, {3, 1, 1, 3, 1, 1, 6, 1}, {1, 1, 1, 3, 1, 2, 4, 4}, {2, 1, 1, 3, 1, 2, 5, 2}, {1, 1, 1, 3, 1, 3, 4, 3}, {2, 1, 1, 3, 1, 3, 5, 1}, {1, 1, 1, 3, 1, 4, 4, 2}, {1, 1, 1, 3, 1, 5, 4, 1}, {6, 1, 1, 3, 2, 1, 1, 2}, {1, 1, 1, 3, 2, 1, 5, 3}, {2, 1, 1, 3, 2, 1, 6, 1}, {6, 1, 1, 3, 2, 2, 1, 1}, {1, 1, 1, 3, 2, 2, 5, 2}, {1, 1, 1, 3, 2, 3, 5, 1}, {5, 1, 1, 3, 3, 1, 1, 2}, {1, 1, 1, 3, 3, 1, 6, 1}, {5, 1, 1, 3, 3, 2, 1, 1}, {4, 1, 1, 3, 4, 1, 1, 2}, {4, 1, 1, 3, 4, 2, 1, 1}, {3, 1, 1, 3, 5, 1, 1, 2}, {3, 1, 1, 3, 5, 2, 1, 1}, {2, 1, 1, 3, 6, 1, 1, 2}, {2, 1, 1, 3, 6, 2, 1, 1}, {1, 1, 1, 4, 1, 1, 4, 4}, {2, 1, 1, 4, 1, 1, 5, 2}, {1, 1, 1, 4, 1, 2, 4, 3}, {2, 1, 1, 4, 1, 2, 5, 1}, {1, 1, 1, 4, 1, 3, 4, 2}, {1, 1, 1, 4, 1, 4, 4, 1}, {6, 1, 1, 4, 2, 1, 1, 1}, {1, 1, 1, 4, 2, 1, 5, 2}, {1, 1, 1, 4, 2, 2, 5, 1}, {5, 1, 1, 4, 3, 1, 1, 1}, {4, 1, 1, 4, 4, 1, 1, 1}, {3, 1, 1, 4, 5, 1, 1, 1}, {1, 1, 1, 5, 1, 1, 4, 3}, {2, 1, 1, 5, 1, 1, 5, 1}, {1, 1, 1, 5, 1, 2, 4, 2}, {1, 1, 1, 5, 1, 3, 4, 1}, {1, 1, 1, 5, 2, 1, 5, 1}, {1, 1, 1, 6, 1, 1, 4, 2}, {1, 1, 1, 6, 1, 2, 4, 1}, {1, 2, 1, 1, 1, 1, 4, 6}, {2, 2, 1, 1, 1, 1, 5, 4}, {3, 2, 1, 1, 1, 1, 6, 2}, {1, 2, 1, 1, 1, 2, 4, 5}, {2, 2, 1, 1, 1, 2, 5, 3}, {3, 2, 1, 1, 1, 2, 6, 1}, {1, 2, 1, 1, 1, 3, 4, 4}, {2, 2, 1, 1, 1, 3, 5, 2}, {1, 2, 1, 1, 1, 4, 4, 3}, {2, 2, 1, 1, 1, 4, 5, 1}, {1, 2, 1, 1, 1, 5, 4, 2}, {6, 2, 1, 1, 2, 1, 1, 3}, {1, 2, 1, 1, 2, 1, 5, 4}, {2, 2, 1, 1, 2, 1, 6, 2}, {6, 2, 1, 1, 2, 2, 1, 2}, {1, 2, 1, 1, 2, 2, 5, 3}, {2, 2, 1, 1, 2, 2, 6, 1}, {6, 2, 1, 1, 2, 3, 1, 1}, {1, 2, 1, 1, 2, 3, 5, 2}, {1, 2, 1, 1, 2, 4, 5, 1}, {5, 2, 1, 1, 3, 1, 1, 3}, {6, 2, 1, 1, 3, 1, 2, 1}, {1, 2, 1, 1, 3, 1, 6, 2}, {5, 2, 1, 1, 3, 2, 1, 2}, {1, 2, 1, 1, 3, 2, 6, 1}, {5, 2, 1, 1, 3, 3, 1, 1}, {4, 2, 1, 1, 4, 1, 1, 3}, {5, 2, 1, 1, 4, 1, 2, 1}, {4, 2, 1, 1, 4, 2, 1, 2}, {4, 2, 1, 1, 4, 3, 1, 1}, {3, 2, 1, 1, 5, 1, 1, 3}, {4, 2, 1, 1, 5, 1, 2, 1}, {3, 2, 1, 1, 5, 2, 1, 2}, {3, 2, 1, 1, 5, 3, 1, 1}, {2, 2, 1, 1, 6, 1, 1, 3}, {3, 2, 1, 1, 6, 1, 2, 1}, {2, 2, 1, 1, 6, 2, 1, 2}, {2, 2, 1, 1, 6, 3, 1, 1}, {2, 1, 2, 1, 1, 1, 4, 5}, {3, 1, 2, 1, 1, 1, 5, 3}, {4, 1, 2, 1, 1, 1, 6, 1}, {1, 1, 2, 1, 1, 2, 3, 6}, {2, 1, 2, 1, 1, 2, 4, 4}, {3, 1, 2, 1, 1, 2, 5, 2}, {1, 1, 2, 1, 1, 3, 3, 5}, {2, 1, 2, 1, 1, 3, 4, 3}, {3, 1, 2, 1, 1, 3, 5, 1}, {1, 1, 2, 1, 1, 4, 3, 4}, {2, 1, 2, 1, 1, 4, 4, 2}, {1, 1, 2, 1, 1, 5, 3, 3}, {2, 1, 2, 1, 1, 5, 4, 1}, {1, 1, 2, 1, 1, 6, 3, 2}, {1, 2, 1, 2, 1, 1, 4, 5}, {2, 2, 1, 2, 1, 1, 5, 3}, {3, 2, 1, 2, 1, 1, 6, 1}, {1, 1, 2, 1, 2, 1, 4, 5}, {1, 2, 1, 2, 1, 2, 4, 4}, {2, 2, 1, 2, 1, 2, 5, 2}, {1, 1, 2, 1, 2, 2, 4, 4}, {2, 1, 2, 1, 2, 2, 5, 2}, {2, 2, 1, 2, 1, 3, 5, 1}, {1, 1, 2, 1, 2, 3, 4, 3}, {1, 2, 1, 2, 1, 4, 4, 2}, {1, 1, 2, 1, 2, 4, 4, 2}, {1, 2, 1, 2, 1, 5, 4, 1}, {1, 1, 2, 1, 2, 5, 4, 1}, {6, 2, 1, 2, 2, 1, 1, 2}, {1, 2, 1, 2, 2, 1, 5, 3}, {2, 2, 1, 2, 2, 1, 6, 1}, {6, 1, 2, 1, 3, 1, 1, 2}, {6, 2, 1, 2, 2, 2, 1, 1}, {1, 1, 2, 1, 3, 1, 5, 3}, {1, 2, 1, 2, 2, 2, 5, 2}, {6, 1, 2, 1, 3, 2, 1, 1}, {1, 1, 2, 1, 3, 2, 5, 2}, {1, 2, 1, 2, 2, 3, 5, 1}, {1, 1, 2, 1, 3, 3, 5, 1}, {5, 2, 1, 2, 3, 1, 1, 2}, {1, 2, 1, 2, 3, 1, 6, 1}, {5, 1, 2, 1, 4, 1, 1, 2}, {5, 2, 1, 2, 3, 2, 1, 1}, {1, 1, 2, 1, 4, 1, 6, 1}, {5, 1, 2, 1, 4, 2, 1, 1}, {4, 2, 1, 2, 4, 1, 1, 2}, {4, 1, 2, 1, 5, 1, 1, 2}, {4, 2, 1, 2, 4, 2, 1, 1}, {4, 1, 2, 1, 5, 2, 1, 1}, {3, 2, 1, 2, 5, 1, 1, 2}, {3, 1, 2, 1, 6, 1, 1, 2}, {3, 2, 1, 2, 5, 2, 1, 1}, {3, 1, 2, 1, 6, 2, 1, 1}, {2, 2, 1, 2, 6, 1, 1, 2}, {2, 2, 1, 2, 6, 2, 1, 1}, {1, 1, 2, 2, 1, 1, 3, 6}, {2, 1, 2, 2, 1, 1, 4, 4}, {3, 1, 2, 2, 1, 1, 5, 2}, {1, 1, 2, 2, 1, 2, 3, 5}, {2, 1, 2, 2, 1, 2, 4, 3}, {3, 1, 2, 2, 1, 2, 5, 1}, {1, 1, 2, 2, 1, 3, 3, 4}, {2, 1, 2, 2, 1, 3, 4, 2}, {1, 1, 2, 2, 1, 4, 3, 3}, {2, 1, 2, 2, 1, 4, 4, 1}, {1, 1, 2, 2, 1, 5, 3, 2}, {1, 1, 2, 2, 1, 6, 3, 1}, {1, 2, 1, 3, 1, 1, 4, 4}, {2, 2, 1, 3, 1, 1, 5, 2}, {1, 1, 2, 2, 2, 1, 4, 4}, {1, 2, 1, 3, 1, 2, 4, 3}, {2, 2, 1, 3, 1, 2, 5, 1}, {1, 1, 2, 2, 2, 2, 4, 3}, {2, 1, 2, 2, 2, 2, 5, 1}, {1, 1, 2, 2, 2, 3, 4, 2}, {1, 2, 1, 3, 1, 4, 4, 1}, {1, 1, 2, 2, 2, 4, 4, 1}, {6, 2, 1, 3, 2, 1, 1, 1}, {1, 2, 1, 3, 2, 1, 5, 2}, {6, 1, 2, 2, 3, 1, 1, 1}, {1, 1, 2, 2, 3, 1, 5, 2}, {1, 2, 1, 3, 2, 2, 5, 1}, {1, 1, 2, 2, 3, 2, 5, 1}, {5, 2, 1, 3, 3, 1, 1, 1}, {5, 1, 2, 2, 4, 1, 1, 1}, {4, 2, 1, 3, 4, 1, 1, 1}, {4, 1, 2, 2, 5, 1, 1, 1}, {3, 2, 1, 3, 5, 1, 1, 1}, {3, 1, 2, 2, 6, 1, 1, 1}, {2, 2, 1, 3, 6, 1, 1, 1}, {1, 1, 2, 3, 1, 1, 3, 5}, {2, 1, 2, 3, 1, 1, 4, 3}, {3, 1, 2, 3, 1, 1, 5, 1}, {1, 1, 2, 3, 1, 2, 3, 4}, {2, 1, 2, 3, 1, 2, 4, 2}, {1, 1, 2, 3, 1, 3, 3, 3}, {2, 1, 2, 3, 1, 3, 4, 1}, {1, 1, 2, 3, 1, 4, 3, 2}, {1, 1, 2, 3, 1, 5, 3, 1}, {1, 2, 1, 4, 1, 1, 4, 3}, {2, 2, 1, 4, 1, 1, 5, 1}, {1, 1, 2, 3, 2, 1, 4, 3}, {1, 2, 1, 4, 1, 2, 4, 2}, {1, 1, 2, 3, 2, 2, 4, 2}, {1, 2, 1, 4, 1, 3, 4, 1}, {1, 1, 2, 3, 2, 3, 4, 1}, {1, 2, 1, 4, 2, 1, 5, 1}, {1, 1, 2, 3, 3, 1, 5, 1}, {1, 1, 2, 4, 1, 1, 3, 4}, {2, 1, 2, 4, 1, 1, 4, 2}, {1, 1, 2, 4, 1, 2, 3, 3}, {2, 1, 2, 4, 1, 2, 4, 1}, {1, 1, 2, 4, 1, 3, 3, 2}, {1, 1, 2, 4, 1, 4, 3, 1}, {1, 2, 1, 5, 1, 1, 4, 2}, {1, 1, 2, 4, 2, 1, 4, 2}, {1, 2, 1, 5, 1, 2, 4, 1}, {1, 1, 2, 4, 2, 2, 4, 1}, {1, 1, 2, 5, 1, 1, 3, 3}, {2, 1, 2, 5, 1, 1, 4, 1}, {1, 1, 2, 5, 1, 2, 3, 2}, {1, 1, 2, 5, 1, 3, 3, 1}, {1, 2, 1, 6, 1, 1, 4, 1}, {1, 1, 2, 5, 2, 1, 4, 1}, {1, 1, 2, 6, 1, 1, 3, 2}, {1, 1, 2, 6, 1, 2, 3, 1}, {1, 3, 1, 1, 1, 1, 4, 5}, {2, 3, 1, 1, 1, 1, 5, 3}, {3, 3, 1, 1, 1, 1, 6, 1}, {1, 3, 1, 1, 1, 2, 4, 4}, {2, 3, 1, 1, 1, 2, 5, 2}, {1, 3, 1, 1, 1, 3, 4, 3}, {2, 3, 1, 1, 1, 3, 5, 1}, {1, 3, 1, 1, 1, 4, 4, 2}, {1, 3, 1, 1, 1, 5, 4, 1}, {6, 3, 1, 1, 2, 1, 1, 2}, {1, 3, 1, 1, 2, 1, 5, 3}, {2, 3, 1, 1, 2, 1, 6, 1}, {6, 3, 1, 1, 2, 2, 1, 1}, {1, 3, 1, 1, 2, 2, 5, 2}, {1, 3, 1, 1, 2, 3, 5, 1}, {5, 3, 1, 1, 3, 1, 1, 2}, {1, 3, 1, 1, 3, 1, 6, 1}, {5, 3, 1, 1, 3, 2, 1, 1}, {4, 3, 1, 1, 4, 1, 1, 2}, {4, 3, 1, 1, 4, 2, 1, 1}, {3, 3, 1, 1, 5, 1, 1, 2}, {3, 3, 1, 1, 5, 2, 1, 1}, {2, 3, 1, 1, 6, 1, 1, 2}, {2, 3, 1, 1, 6, 2, 1, 1}, {1, 2, 2, 1, 1, 1, 3, 6}, {2, 2, 2, 1, 1, 1, 4, 4}, {3, 2, 2, 1, 1, 1, 5, 2}, {1, 2, 2, 1, 1, 2, 3, 5}, {2, 2, 2, 1, 1, 2, 4, 3}, {3, 2, 2, 1, 1, 2, 5, 1}, {1, 2, 2, 1, 1, 3, 3, 4}, {2, 2, 2, 1, 1, 3, 4, 2}, {1, 2, 2, 1, 1, 4, 3, 3}, {2, 2, 2, 1, 1, 4, 4, 1}, {1, 2, 2, 1, 1, 5, 3, 2}, {1, 2, 2, 1, 1, 6, 3, 1}, {1, 3, 1, 2, 1, 1, 4, 4}, {2, 3, 1, 2, 1, 1, 5, 2}, {1, 2, 2, 1, 2, 1, 4, 4}, {1, 3, 1, 2, 1, 2, 4, 3}, {2, 3, 1, 2, 1, 2, 5, 1}, {1, 2, 2, 1, 2, 2, 4, 3}, {2, 2, 2, 1, 2, 2, 5, 1}, {1, 2, 2, 1, 2, 3, 4, 2}, {1, 3, 1, 2, 1, 4, 4, 1}, {1, 2, 2, 1, 2, 4, 4, 1}, {6, 3, 1, 2, 2, 1, 1, 1}, {1, 3, 1, 2, 2, 1, 5, 2}, {6, 2, 2, 1, 3, 1, 1, 1}, {1, 2, 2, 1, 3, 1, 5, 2}, {1, 3, 1, 2, 2, 2, 5, 1}, {1, 2, 2, 1, 3, 2, 5, 1}, {5, 3, 1, 2, 3, 1, 1, 1}, {5, 2, 2, 1, 4, 1, 1, 1}, {4, 3, 1, 2, 4, 1, 1, 1}, {4, 2, 2, 1, 5, 1, 1, 1}, {3, 3, 1, 2, 5, 1, 1, 1}, {3, 2, 2, 1, 6, 1, 1, 1}, {2, 3, 1, 2, 6, 1, 1, 1}, {2, 1, 3, 1, 1, 1, 3, 5}, {3, 1, 3, 1, 1, 1, 4, 3}, {4, 1, 3, 1, 1, 1, 5, 1}, {1, 1, 3, 1, 1, 2, 2, 6}, {2, 1, 3, 1, 1, 2, 3, 4}, {3, 1, 3, 1, 1, 2, 4, 2}, {1, 1, 3, 1, 1, 3, 2, 5}, {2, 1, 3, 1, 1, 3, 3, 3}, {3, 1, 3, 1, 1, 3, 4, 1}, {1, 1, 3, 1, 1, 4, 2, 4}, {2, 1, 3, 1, 1, 4, 3, 2}, {1, 1, 3, 1, 1, 5, 2, 3}, {2, 1, 3, 1, 1, 5, 3, 1}, {1, 1, 3, 1, 1, 6, 2, 2}, {1, 2, 2, 2, 1, 1, 3, 5}, {2, 2, 2, 2, 1, 1, 4, 3}, {3, 2, 2, 2, 1, 1, 5, 1}, {1, 1, 3, 1, 2, 1, 3, 5}, {1, 2, 2, 2, 1, 2, 3, 4}, {2, 2, 2, 2, 1, 2, 4, 2}, {1, 1, 3, 1, 2, 2, 3, 4}, {2, 1, 3, 1, 2, 2, 4, 2}, {2, 2, 2, 2, 1, 3, 4, 1}, {1, 1, 3, 1, 2, 3, 3, 3}, {1, 2, 2, 2, 1, 4, 3, 2}, {1, 1, 3, 1, 2, 4, 3, 2}, {1, 2, 2, 2, 1, 5, 3, 1}, {1, 1, 3, 1, 2, 5, 3, 1}, {1, 3, 1, 3, 1, 1, 4, 3}, {2, 3, 1, 3, 1, 1, 5, 1}, {1, 2, 2, 2, 2, 1, 4, 3}, {1, 3, 1, 3, 1, 2, 4, 2}, {1, 1, 3, 1, 3, 1, 4, 3}, {1, 2, 2, 2, 2, 2, 4, 2}, {1, 3, 1, 3, 1, 3, 4, 1}, {1, 1, 3, 1, 3, 2, 4, 2}, {1, 2, 2, 2, 2, 3, 4, 1}, {1, 1, 3, 1, 3, 3, 4, 1}, {1, 3, 1, 3, 2, 1, 5, 1}, {1, 2, 2, 2, 3, 1, 5, 1}, {1, 1, 3, 1, 4, 1, 5, 1}, {1, 1, 3, 2, 1, 1, 2, 6}, {2, 1, 3, 2, 1, 1, 3, 4}, {3, 1, 3, 2, 1, 1, 4, 2}, {1, 1, 3, 2, 1, 2, 2, 5}, {2, 1, 3, 2, 1, 2, 3, 3}, {3, 1, 3, 2, 1, 2, 4, 1}, {1, 1, 3, 2, 1, 3, 2, 4}, {2, 1, 3, 2, 1, 3, 3, 2}, {1, 1, 3, 2, 1, 4, 2, 3}, {2, 1, 3, 2, 1, 4, 3, 1}, {1, 1, 3, 2, 1, 5, 2, 2}, {1, 1, 3, 2, 1, 6, 2, 1}, {1, 2, 2, 3, 1, 1, 3, 4}, {2, 2, 2, 3, 1, 1, 4, 2}, {1, 1, 3, 2, 2, 1, 3, 4}, {1, 2, 2, 3, 1, 2, 3, 3}, {2, 2, 2, 3, 1, 2, 4, 1}, {1, 1, 3, 2, 2, 2, 3, 3}, {2, 1, 3, 2, 2, 2, 4, 1}, {1, 1, 3, 2, 2, 3, 3, 2}, {1, 2, 2, 3, 1, 4, 3, 1}, {1, 1, 3, 2, 2, 4, 3, 1}, {1, 3, 1, 4, 1, 1, 4, 2}, {1, 2, 2, 3, 2, 1, 4, 2}, {1, 3, 1, 4, 1, 2, 4, 1}, {1, 1, 3, 2, 3, 1, 4, 2}, {1, 2, 2, 3, 2, 2, 4, 1}, {1, 1, 3, 2, 3, 2, 4, 1}, {1, 1, 3, 3, 1, 1, 2, 5}, {2, 1, 3, 3, 1, 1, 3, 3}, {3, 1, 3, 3, 1, 1, 4, 1}, {1, 1, 3, 3, 1, 2, 2, 4}, {2, 1, 3, 3, 1, 2, 3, 2}, {1, 1, 3, 3, 1, 3, 2, 3}, {2, 1, 3, 3, 1, 3, 3, 1}, {1, 1, 3, 3, 1, 4, 2, 2}, {1, 1, 3, 3, 1, 5, 2, 1}, {1, 2, 2, 4, 1, 1, 3, 3}, {2, 2, 2, 4, 1, 1, 4, 1}, {1, 1, 3, 3, 2, 1, 3, 3}, {1, 2, 2, 4, 1, 2, 3, 2}, {1, 1, 3, 3, 2, 2, 3, 2}, {1, 2, 2, 4, 1, 3, 3, 1}, {1, 1, 3, 3, 2, 3, 3, 1}, {1, 3, 1, 5, 1, 1, 4, 1}, {1, 2, 2, 4, 2, 1, 4, 1}, {1, 1, 3, 3, 3, 1, 4, 1}, {1, 1, 3, 4, 1, 1, 2, 4}, {2, 1, 3, 4, 1, 1, 3, 2}, {1, 1, 3, 4, 1, 2, 2, 3}, {2, 1, 3, 4, 1, 2, 3, 1}, {1, 1, 3, 4, 1, 3, 2, 2}, {1, 1, 3, 4, 1, 4, 2, 1}, {1, 2, 2, 5, 1, 1, 3, 2}, {1, 1, 3, 4, 2, 1, 3, 2}, {1, 2, 2, 5, 1, 2, 3, 1}, {1, 1, 3, 4, 2, 2, 3, 1}, {1, 1, 3, 5, 1, 1, 2, 3}, {2, 1, 3, 5, 1, 1, 3, 1}, {1, 1, 3, 5, 1, 2, 2, 2}, {1, 1, 3, 5, 1, 3, 2, 1}, {1, 2, 2, 6, 1, 1, 3, 1}, {1, 1, 3, 5, 2, 1, 3, 1}, {1, 1, 3, 6, 1, 1, 2, 2}, {1, 1, 3, 6, 1, 2, 2, 1}, {1, 4, 1, 1, 1, 1, 4, 4}, {2, 4, 1, 1, 1, 1, 5, 2}, {1, 4, 1, 1, 1, 2, 4, 3}, {2, 4, 1, 1, 1, 2, 5, 1}, {1, 4, 1, 1, 1, 3, 4, 2}, {1, 4, 1, 1, 1, 4, 4, 1}, {1, 4, 1, 1, 2, 1, 5, 2}, {1, 4, 1, 1, 2, 2, 5, 1}, {5, 4, 1, 1, 3, 1, 1, 1}, {4, 4, 1, 1, 4, 1, 1, 1}, {3, 4, 1, 1, 5, 1, 1, 1}, {2, 4, 1, 1, 6, 1, 1, 1}, {1, 3, 2, 1, 1, 1, 3, 5}, {2, 3, 2, 1, 1, 1, 4, 3}, {3, 3, 2, 1, 1, 1, 5, 1}, {1, 3, 2, 1, 1, 2, 3, 4}, {2, 3, 2, 1, 1, 2, 4, 2}, {1, 3, 2, 1, 1, 3, 3, 3}, {2, 3, 2, 1, 1, 3, 4, 1}, {1, 3, 2, 1, 1, 4, 3, 2}, {1, 3, 2, 1, 1, 5, 3, 1}, {1, 4, 1, 2, 1, 1, 4, 3}, {2, 4, 1, 2, 1, 1, 5, 1}, {1, 3, 2, 1, 2, 1, 4, 3}, {1, 4, 1, 2, 1, 2, 4, 2}, {1, 3, 2, 1, 2, 2, 4, 2}, {1, 4, 1, 2, 1, 3, 4, 1}, {1, 3, 2, 1, 2, 3, 4, 1}, {1, 4, 1, 2, 2, 1, 5, 1}, {1, 3, 2, 1, 3, 1, 5, 1}, {1, 2, 3, 1, 1, 1, 2, 6}, {2, 2, 3, 1, 1, 1, 3, 4}, {3, 2, 3, 1, 1, 1, 4, 2}, {1, 2, 3, 1, 1, 2, 2, 5}, {2, 2, 3, 1, 1, 2, 3, 3}, {3, 2, 3, 1, 1, 2, 4, 1}, {1, 2, 3, 1, 1, 3, 2, 4}, {2, 2, 3, 1, 1, 3, 3, 2}, {1, 2, 3, 1, 1, 4, 2, 3}, {2, 2, 3, 1, 1, 4, 3, 1}, {1, 2, 3, 1, 1, 5, 2, 2}, {1, 2, 3, 1, 1, 6, 2, 1}, {1, 3, 2, 2, 1, 1, 3, 4}, {2, 3, 2, 2, 1, 1, 4, 2}, {1, 2, 3, 1, 2, 1, 3, 4}, {1, 3, 2, 2, 1, 2, 3, 3}, {2, 3, 2, 2, 1, 2, 4, 1}, {1, 2, 3, 1, 2, 2, 3, 3}, {1, 3, 2, 2, 1, 3, 3, 2}, {1, 2, 3, 1, 2, 3, 3, 2}, {1, 3, 2, 2, 1, 4, 3, 1}, {1, 2, 3, 1, 2, 4, 3, 1}, {1, 4, 1, 3, 1, 1, 4, 2}, {1, 3, 2, 2, 2, 1, 4, 2}, {1, 4, 1, 3, 1, 2, 4, 1}, {1, 2, 3, 1, 3, 1, 4, 2}, {1, 3, 2, 2, 2, 2, 4, 1}, {1, 2, 3, 1, 3, 2, 4, 1}, {2, 1, 4, 1, 1, 1, 2, 5}, {3, 1, 4, 1, 1, 1, 3, 3}, {4, 1, 4, 1, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 2, 1, 6}, {2, 1, 4, 1, 1, 2, 2, 4}, {3, 1, 4, 1, 1, 2, 3, 2}, {1, 1, 4, 1, 1, 3, 1, 5}, {2, 1, 4, 1, 1, 3, 2, 3}, {3, 1, 4, 1, 1, 3, 3, 1}, {1, 1, 4, 1, 1, 4, 1, 4}, {2, 1, 4, 1, 1, 4, 2, 2}, {1, 1, 4, 1, 1, 5, 1, 3}, {2, 1, 4, 1, 1, 5, 2, 1}, {1, 1, 4, 1, 1, 6, 1, 2}, {1, 2, 3, 2, 1, 1, 2, 5}, {2, 2, 3, 2, 1, 1, 3, 3}, {3, 2, 3, 2, 1, 1, 4, 1}, {1, 1, 4, 1, 2, 1, 2, 5}, {1, 2, 3, 2, 1, 2, 2, 4}, {2, 2, 3, 2, 1, 2, 3, 2}, {1, 1, 4, 1, 2, 2, 2, 4}, {2, 1, 4, 1, 2, 2, 3, 2}, {2, 2, 3, 2, 1, 3, 3, 1}, {1, 1, 4, 1, 2, 3, 2, 3}, {1, 2, 3, 2, 1, 4, 2, 2}, {1, 1, 4, 1, 2, 4, 2, 2}, {1, 2, 3, 2, 1, 5, 2, 1}, {1, 1, 4, 1, 2, 5, 2, 1}, {1, 3, 2, 3, 1, 1, 3, 3}, {2, 3, 2, 3, 1, 1, 4, 1}, {1, 2, 3, 2, 2, 1, 3, 3}, {1, 3, 2, 3, 1, 2, 3, 2}, {1, 1, 4, 1, 3, 1, 3, 3}, {1, 2, 3, 2, 2, 2, 3, 2}, {1, 3, 2, 3, 1, 3, 3, 1}, {1, 1, 4, 1, 3, 2, 3, 2}, {1, 2, 3, 2, 2, 3, 3, 1}, {1, 1, 4, 1, 3, 3, 3, 1}, {1, 4, 1, 4, 1, 1, 4, 1}, {1, 3, 2, 3, 2, 1, 4, 1}, {1, 2, 3, 2, 3, 1, 4, 1}, {1, 1, 4, 1, 4, 1, 4, 1}, {1, 1, 4, 2, 1, 1, 1, 6}, {2, 1, 4, 2, 1, 1, 2, 4}, {3, 1, 4, 2, 1, 1, 3, 2}, {1, 1, 4, 2, 1, 2, 1, 5}, {2, 1, 4, 2, 1, 2, 2, 3}, {3, 1, 4, 2, 1, 2, 3, 1}, {1, 1, 4, 2, 1, 3, 1, 4}, {2, 1, 4, 2, 1, 3, 2, 2}, {1, 1, 4, 2, 1, 4, 1, 3}, {2, 1, 4, 2, 1, 4, 2, 1}, {1, 1, 4, 2, 1, 5, 1, 2}, {1, 1, 4, 2, 1, 6, 1, 1}, {1, 2, 3, 3, 1, 1, 2, 4}, {2, 2, 3, 3, 1, 1, 3, 2}, {1, 1, 4, 2, 2, 1, 2, 4}, {1, 2, 3, 3, 1, 2, 2, 3}, {2, 2, 3, 3, 1, 2, 3, 1}, {1, 1, 4, 2, 2, 2, 2, 3}, {2, 1, 4, 2, 2, 2, 3, 1}, {1, 1, 4, 2, 2, 3, 2, 2}, {1, 2, 3, 3, 1, 4, 2, 1}, {1, 1, 4, 2, 2, 4, 2, 1}, {1, 3, 2, 4, 1, 1, 3, 2}, {1, 2, 3, 3, 2, 1, 3, 2}, {1, 3, 2, 4, 1, 2, 3, 1}, {1, 1, 4, 2, 3, 1, 3, 2}, {1, 2, 3, 3, 2, 2, 3, 1}, {1, 1, 4, 2, 3, 2, 3, 1}, {1, 1, 4, 3, 1, 1, 1, 5}, {2, 1, 4, 3, 1, 1, 2, 3}, {3, 1, 4, 3, 1, 1, 3, 1}, {1, 1, 4, 3, 1, 2, 1, 4}, {2, 1, 4, 3, 1, 2, 2, 2}, {1, 1, 4, 3, 1, 3, 1, 3}, {2, 1, 4, 3, 1, 3, 2, 1}, {1, 1, 4, 3, 1, 4, 1, 2}, {1, 1, 4, 3, 1, 5, 1, 1}, {1, 2, 3, 4, 1, 1, 2, 3}, {2, 2, 3, 4, 1, 1, 3, 1}, {1, 1, 4, 3, 2, 1, 2, 3}, {1, 2, 3, 4, 1, 2, 2, 2}, {1, 1, 4, 3, 2, 2, 2, 2}, {1, 2, 3, 4, 1, 3, 2, 1}, {1, 1, 4, 3, 2, 3, 2, 1}, {1, 3, 2, 5, 1, 1, 3, 1}, {1, 2, 3, 4, 2, 1, 3, 1}, {1, 1, 4, 3, 3, 1, 3, 1}, {1, 1, 4, 4, 1, 1, 1, 4}, {2, 1, 4, 4, 1, 1, 2, 2}, {1, 1, 4, 4, 1, 2, 1, 3}, {2, 1, 4, 4, 1, 2, 2, 1}, {1, 1, 4, 4, 1, 3, 1, 2}, {1, 1, 4, 4, 1, 4, 1, 1}, {1, 2, 3, 5, 1, 1, 2, 2}, {1, 1, 4, 4, 2, 1, 2, 2}, {1, 2, 3, 5, 1, 2, 2, 1}, {1, 1, 4, 4, 2, 2, 2, 1}, {1, 1, 4, 5, 1, 1, 1, 3}, {2, 1, 4, 5, 1, 1, 2, 1}, {1, 1, 4, 5, 1, 2, 1, 2}, {1, 1, 4, 5, 1, 3, 1, 1}, {1, 2, 3, 6, 1, 1, 2, 1}, {1, 1, 4, 5, 2, 1, 2, 1}, {1, 5, 1, 1, 1, 1, 4, 3}, {2, 5, 1, 1, 1, 1, 5, 1}, {1, 5, 1, 1, 1, 2, 4, 2}, {1, 5, 1, 1, 1, 3, 4, 1}, {1, 5, 1, 1, 2, 1, 5, 1}, {1, 4, 2, 1, 1, 1, 3, 4}, {2, 4, 2, 1, 1, 1, 4, 2}, {1, 4, 2, 1, 1, 2, 3, 3}, {2, 4, 2, 1, 1, 2, 4, 1}, {1, 4, 2, 1, 1, 3, 3, 2}, {1, 4, 2, 1, 1, 4, 3, 1}, {1, 5, 1, 2, 1, 1, 4, 2}, {1, 4, 2, 1, 2, 1, 4, 2}, {1, 5, 1, 2, 1, 2, 4, 1}, {1, 4, 2, 1, 2, 2, 4, 1}, {1, 3, 3, 1, 1, 1, 2, 5}, {2, 3, 3, 1, 1, 1, 3, 3}, {3, 3, 3, 1, 1, 1, 4, 1}, {1, 3, 3, 1, 1, 2, 2, 4}, {2, 3, 3, 1, 1, 2, 3, 2}, {1, 3, 3, 1, 1, 3, 2, 3}, {2, 3, 3, 1, 1, 3, 3, 1}, {1, 3, 3, 1, 1, 4, 2, 2}, {1, 3, 3, 1, 1, 5, 2, 1}, {1, 4, 2, 2, 1, 1, 3, 3}, {2, 4, 2, 2, 1, 1, 4, 1}, {1, 3, 3, 1, 2, 1, 3, 3}, {1, 4, 2, 2, 1, 2, 3, 2}, {1, 3, 3, 1, 2, 2, 3, 2}, {1, 4, 2, 2, 1, 3, 3, 1}, {1, 3, 3, 1, 2, 3, 3, 1}, {1, 5, 1, 3, 1, 1, 4, 1}, {1, 4, 2, 2, 2, 1, 4, 1}, {1, 3, 3, 1, 3, 1, 4, 1}, {1, 2, 4, 1, 1, 1, 1, 6}, {2, 2, 4, 1, 1, 1, 2, 4}, {3, 2, 4, 1, 1, 1, 3, 2}, {1, 2, 4, 1, 1, 2, 1, 5}, {2, 2, 4, 1, 1, 2, 2, 3}, {3, 2, 4, 1, 1, 2, 3, 1}, {1, 2, 4, 1, 1, 3, 1, 4}, {2, 2, 4, 1, 1, 3, 2, 2}, {1, 2, 4, 1, 1, 4, 1, 3}, {2, 2, 4, 1, 1, 4, 2, 1}, {1, 2, 4, 1, 1, 5, 1, 2}, {1, 2, 4, 1, 1, 6, 1, 1}, {1, 3, 3, 2, 1, 1, 2, 4}, {2, 3, 3, 2, 1, 1, 3, 2}, {1, 2, 4, 1, 2, 1, 2, 4}, {1, 3, 3, 2, 1, 2, 2, 3}, {2, 3, 3, 2, 1, 2, 3, 1}, {1, 2, 4, 1, 2, 2, 2, 3}, {2, 2, 4, 1, 2, 2, 3, 1}, {1, 2, 4, 1, 2, 3, 2, 2}, {1, 3, 3, 2, 1, 4, 2, 1}, {1, 2, 4, 1, 2, 4, 2, 1}, {1, 4, 2, 3, 1, 1, 3, 2}, {1, 3, 3, 2, 2, 1, 3, 2}, {1, 4, 2, 3, 1, 2, 3, 1}, {1, 2, 4, 1, 3, 1, 3, 2}, {1, 3, 3, 2, 2, 2, 3, 1}, {1, 2, 4, 1, 3, 2, 3, 1}, {2, 1, 5, 1, 1, 1, 1, 5}, {3, 1, 5, 1, 1, 1, 2, 3}, {4, 1, 5, 1, 1, 1, 3, 1}, {2, 1, 5, 1, 1, 2, 1, 4}, {3, 1, 5, 1, 1, 2, 2, 2}, {2, 1, 5, 1, 1, 3, 1, 3}, {3, 1, 5, 1, 1, 3, 2, 1}, {2, 1, 5, 1, 1, 4, 1, 2}, {2, 1, 5, 1, 1, 5, 1, 1}, {1, 2, 4, 2, 1, 1, 1, 5}, {2, 2, 4, 2, 1, 1, 2, 3}, {3, 2, 4, 2, 1, 1, 3, 1}, {1, 1, 5, 1, 2, 1, 1, 5}, {1, 2, 4, 2, 1, 2, 1, 4}, {2, 2, 4, 2, 1, 2, 2, 2}, {1, 1, 5, 1, 2, 2, 1, 4}, {2, 1, 5, 1, 2, 2, 2, 2}, {2, 2, 4, 2, 1, 3, 2, 1}, {1, 1, 5, 1, 2, 3, 1, 3}, {1, 2, 4, 2, 1, 4, 1, 2}, {1, 1, 5, 1, 2, 4, 1, 2}, {1, 2, 4, 2, 1, 5, 1, 1}, {1, 1, 5, 1, 2, 5, 1, 1}, {1, 3, 3, 3, 1, 1, 2, 3}, {2, 3, 3, 3, 1, 1, 3, 1}, {1, 2, 4, 2, 2, 1, 2, 3}, {1, 3, 3, 3, 1, 2, 2, 2}, {1, 1, 5, 1, 3, 1, 2, 3}, {1, 2, 4, 2, 2, 2, 2, 2}, {1, 3, 3, 3, 1, 3, 2, 1}, {1, 1, 5, 1, 3, 2, 2, 2}, {1, 2, 4, 2, 2, 3, 2, 1}, {1, 1, 5, 1, 3, 3, 2, 1}, {1, 4, 2, 4, 1, 1, 3, 1}, {1, 3, 3, 3, 2, 1, 3, 1}, {1, 2, 4, 2, 3, 1, 3, 1}, {1, 1, 5, 1, 4, 1, 3, 1}, {2, 1, 5, 2, 1, 1, 1, 4}, {3, 1, 5, 2, 1, 1, 2, 2}, {2, 1, 5, 2, 1, 2, 1, 3}, {3, 1, 5, 2, 1, 2, 2, 1}, {2, 1, 5, 2, 1, 3, 1, 2}, {2, 1, 5, 2, 1, 4, 1, 1}, {1, 2, 4, 3, 1, 1, 1, 4}, {2, 2, 4, 3, 1, 1, 2, 2}, {1, 1, 5, 2, 2, 1, 1, 4}, {1, 2, 4, 3, 1, 2, 1, 3}, {2, 2, 4, 3, 1, 2, 2, 1}, {1, 1, 5, 2, 2, 2, 1, 3}, {2, 1, 5, 2, 2, 2, 2, 1}, {1, 1, 5, 2, 2, 3, 1, 2}, {1, 2, 4, 3, 1, 4, 1, 1}, {1, 1, 5, 2, 2, 4, 1, 1}, {1, 3, 3, 4, 1, 1, 2, 2}, {1, 2, 4, 3, 2, 1, 2, 2}, {1, 3, 3, 4, 1, 2, 2, 1}, {1, 1, 5, 2, 3, 1, 2, 2}, {1, 2, 4, 3, 2, 2, 2, 1}, {1, 1, 5, 2, 3, 2, 2, 1}, {2, 1, 5, 3, 1, 1, 1, 3}, {3, 1, 5, 3, 1, 1, 2, 1}, {2, 1, 5, 3, 1, 2, 1, 2}, {2, 1, 5, 3, 1, 3, 1, 1}, {1, 2, 4, 4, 1, 1, 1, 3}, {2, 2, 4, 4, 1, 1, 2, 1}, {1, 1, 5, 3, 2, 1, 1, 3}, {1, 2, 4, 4, 1, 2, 1, 2}, {1, 1, 5, 3, 2, 2, 1, 2}, {1, 2, 4, 4, 1, 3, 1, 1}, {1, 1, 5, 3, 2, 3, 1, 1}, {1, 3, 3, 5, 1, 1, 2, 1}, {1, 2, 4, 4, 2, 1, 2, 1}, {1, 1, 5, 3, 3, 1, 2, 1}, {2, 1, 5, 4, 1, 1, 1, 2}, {2, 1, 5, 4, 1, 2, 1, 1}, {1, 2, 4, 5, 1, 1, 1, 2}, {1, 1, 5, 4, 2, 1, 1, 2}, {1, 2, 4, 5, 1, 2, 1, 1}, {1, 1, 5, 4, 2, 2, 1, 1}, {1, 6, 1, 1, 1, 1, 4, 2}, {1, 6, 1, 1, 1, 2, 4, 1}, {1, 5, 2, 1, 1, 1, 3, 3}, {2, 5, 2, 1, 1, 1, 4, 1}, {1, 5, 2, 1, 1, 2, 3, 2}, {1, 5, 2, 1, 1, 3, 3, 1}, {1, 6, 1, 2, 1, 1, 4, 1}, {1, 5, 2, 1, 2, 1, 4, 1}, {1, 4, 3, 1, 1, 1, 2, 4}, {2, 4, 3, 1, 1, 1, 3, 2}, {1, 4, 3, 1, 1, 2, 2, 3}, {2, 4, 3, 1, 1, 2, 3, 1}, {1, 4, 3, 1, 1, 3, 2, 2}, {1, 4, 3, 1, 1, 4, 2, 1}, {1, 5, 2, 2, 1, 1, 3, 2}, {1, 4, 3, 1, 2, 1, 3, 2}, {1, 5, 2, 2, 1, 2, 3, 1}, {1, 4, 3, 1, 2, 2, 3, 1}, {1, 3, 4, 1, 1, 1, 1, 5}, {2, 3, 4, 1, 1, 1, 2, 3}, {3, 3, 4, 1, 1, 1, 3, 1}, {1, 3, 4, 1, 1, 2, 1, 4}, {2, 3, 4, 1, 1, 2, 2, 2}, {1, 3, 4, 1, 1, 3, 1, 3}, {2, 3, 4, 1, 1, 3, 2, 1}, {1, 3, 4, 1, 1, 4, 1, 2}, {1, 3, 4, 1, 1, 5, 1, 1}, {1, 4, 3, 2, 1, 1, 2, 3}, {2, 4, 3, 2, 1, 1, 3, 1}, {1, 3, 4, 1, 2, 1, 2, 3}, {2, 3, 4, 1, 2, 1, 3, 1}, {1, 3, 4, 1, 2, 2, 2, 2}, {1, 4, 3, 2, 1, 3, 2, 1}, {1, 3, 4, 1, 2, 3, 2, 1}, {1, 5, 2, 3, 1, 1, 3, 1}, {1, 4, 3, 2, 2, 1, 3, 1}, {1, 3, 4, 1, 3, 1, 3, 1}, {2, 2, 5, 1, 1, 1, 1, 4}, {3, 2, 5, 1, 1, 1, 2, 2}, {2, 2, 5, 1, 1, 2, 1, 3}, {3, 2, 5, 1, 1, 2, 2, 1}, {2, 2, 5, 1, 1, 3, 1, 2}, {2, 2, 5, 1, 1, 4, 1, 1}, {1, 3, 4, 2, 1, 1, 1, 4}, {2, 3, 4, 2, 1, 1, 2, 2}, {1, 2, 5, 1, 2, 1, 1, 4}, {2, 2, 5, 1, 2, 1, 2, 2}, {2, 3, 4, 2, 1, 2, 2, 1}, {1, 2, 5, 1, 2, 2, 1, 3}, {1, 3, 4, 2, 1, 3, 1, 2}, {1, 2, 5, 1, 2, 3, 1, 2}, {1, 3, 4, 2, 1, 4, 1, 1}, {1, 2, 5, 1, 2, 4, 1, 1}, {1, 4, 3, 3, 1, 1, 2, 2}, {1, 3, 4, 2, 2, 1, 2, 2}, {1, 4, 3, 3, 1, 2, 2, 1}, {1, 2, 5, 1, 3, 1, 2, 2}, {1, 3, 4, 2, 2, 2, 2, 1}, {1, 2, 5, 1, 3, 2, 2, 1}, {3, 1, 6, 1, 1, 1, 1, 3}, {4, 1, 6, 1, 1, 1, 2, 1}, {3, 1, 6, 1, 1, 2, 1, 2}, {3, 1, 6, 1, 1, 3, 1, 1}, {2, 2, 5, 2, 1, 1, 1, 3}, {3, 2, 5, 2, 1, 1, 2, 1}, {2, 1, 6, 1, 2, 1, 1, 3}, {2, 2, 5, 2, 1, 2, 1, 2}, {2, 1, 6, 1, 2, 2, 1, 2}, {2, 2, 5, 2, 1, 3, 1, 1}, {2, 1, 6, 1, 2, 3, 1, 1}, {1, 3, 4, 3, 1, 1, 1, 3}, {2, 3, 4, 3, 1, 1, 2, 1}, {1, 2, 5, 2, 2, 1, 1, 3}, {1, 3, 4, 3, 1, 2, 1, 2}, {1, 1, 6, 1, 3, 1, 1, 3}, {1, 2, 5, 2, 2, 2, 1, 2}, {1, 3, 4, 3, 1, 3, 1, 1}, {1, 1, 6, 1, 3, 2, 1, 2}, {1, 2, 5, 2, 2, 3, 1, 1}, {1, 1, 6, 1, 3, 3, 1, 1}, {1, 4, 3, 4, 1, 1, 2, 1}, {1, 3, 4, 3, 2, 1, 2, 1}, {1, 2, 5, 2, 3, 1, 2, 1}, {1, 1, 6, 1, 4, 1, 2, 1}, {3, 1, 6, 2, 1, 1, 1, 2}, {3, 1, 6, 2, 1, 2, 1, 1}, {2, 2, 5, 3, 1, 1, 1, 2}, {2, 1, 6, 2, 2, 1, 1, 2}, {2, 2, 5, 3, 1, 2, 1, 1}, {2, 1, 6, 2, 2, 2, 1, 1}, {1, 3, 4, 4, 1, 1, 1, 2}, {1, 2, 5, 3, 2, 1, 1, 2}, {1, 3, 4, 4, 1, 2, 1, 1}, {1, 1, 6, 2, 3, 1, 1, 2}, {1, 2, 5, 3, 2, 2, 1, 1}, {1, 1, 6, 2, 3, 2, 1, 1}, {3, 1, 6, 3, 1, 1, 1, 1}, {2, 2, 5, 4, 1, 1, 1, 1}, {2, 1, 6, 3, 2, 1, 1, 1}, {1, 3, 4, 5, 1, 1, 1, 1}, {1, 2, 5, 4, 2, 1, 1, 1}, {1, 1, 6, 3, 3, 1, 1, 1}, {1, 6, 2, 1, 1, 1, 3, 2}, {1, 6, 2, 1, 1, 2, 3, 1}, {1, 5, 3, 1, 1, 1, 2, 3}, {2, 5, 3, 1, 1, 1, 3, 1}, {1, 5, 3, 1, 1, 2, 2, 2}, {1, 5, 3, 1, 1, 3, 2, 1}, {1, 6, 2, 2, 1, 1, 3, 1}, {1, 5, 3, 1, 2, 1, 3, 1}, {1, 4, 4, 1, 1, 1, 1, 4}, {2, 4, 4, 1, 1, 1, 2, 2}, {1, 4, 4, 1, 1, 2, 1, 3}, {2, 4, 4, 1, 1, 2, 2, 1}, {1, 4, 4, 1, 1, 3, 1, 2}, {1, 4, 4, 1, 1, 4, 1, 1}, {1, 5, 3, 2, 1, 1, 2, 2}, {1, 4, 4, 1, 2, 1, 2, 2}, {1, 5, 3, 2, 1, 2, 2, 1}, {1, 4, 4, 1, 2, 2, 2, 1}, {2, 3, 5, 1, 1, 1, 1, 3}, {3, 3, 5, 1, 1, 1, 2, 1}, {2, 3, 5, 1, 1, 2, 1, 2}, {2, 3, 5, 1, 1, 3, 1, 1}, {1, 4, 4, 2, 1, 1, 1, 3}, {2, 4, 4, 2, 1, 1, 2, 1}, {1, 3, 5, 1, 2, 1, 1, 3}, {2, 3, 5, 1, 2, 1, 2, 1}, {1, 3, 5, 1, 2, 2, 1, 2}, {1, 4, 4, 2, 1, 3, 1, 1}, {1, 3, 5, 1, 2, 3, 1, 1}, {1, 5, 3, 3, 1, 1, 2, 1}, {1, 4, 4, 2, 2, 1, 2, 1}, {1, 3, 5, 1, 3, 1, 2, 1}, {3, 2, 6, 1, 1, 1, 1, 2}, {3, 2, 6, 1, 1, 2, 1, 1}, {2, 3, 5, 2, 1, 1, 1, 2}, {2, 2, 6, 1, 2, 1, 1, 2}, {2, 3, 5, 2, 1, 2, 1, 1}, {2, 2, 6, 1, 2, 2, 1, 1}, {1, 4, 4, 3, 1, 1, 1, 2}, {1, 3, 5, 2, 2, 1, 1, 2}, {1, 4, 4, 3, 1, 2, 1, 1}, {1, 2, 6, 1, 3, 1, 1, 2}, {1, 3, 5, 2, 2, 2, 1, 1}, {1, 2, 6, 1, 3, 2, 1, 1}, {3, 2, 6, 2, 1, 1, 1, 1}, {2, 3, 5, 3, 1, 1, 1, 1}, {2, 2, 6, 2, 2, 1, 1, 1}, {1, 4, 4, 4, 1, 1, 1, 1}, {1, 3, 5, 3, 2, 1, 1, 1}, {1, 2, 6, 2, 3, 1, 1, 1}, {1, 6, 3, 1, 1, 1, 2, 2}, {1, 6, 3, 1, 1, 2, 2, 1}, {1, 5, 4, 1, 1, 1, 1, 3}, {2, 5, 4, 1, 1, 1, 2, 1}, {1, 5, 4, 1, 1, 2, 1, 2}, {1, 5, 4, 1, 1, 3, 1, 1}, {1, 6, 3, 2, 1, 1, 2, 1}, {1, 5, 4, 1, 2, 1, 2, 1}, {2, 4, 5, 1, 1, 1, 1, 2}, {2, 4, 5, 1, 1, 2, 1, 1}, {1, 5, 4, 2, 1, 1, 1, 2}, {1, 4, 5, 1, 2, 1, 1, 2}, {1, 5, 4, 2, 1, 2, 1, 1}, {1, 4, 5, 1, 2, 2, 1, 1}, {3, 3, 6, 1, 1, 1, 1, 1}};
    }

    static {
        lif.setUseParentHandlers(false);
        l0I = new int[]{27, 917};
        l01 = new int[]{522, 568, 723, 809};
        l0IF = new int[]{237, 308, 436, 284, 646, 653, 428, 379};
        l0lf = new int[]{274, 562, 232, 755, 599, 524, 801, 132, 295, 116, 442, 428, 295, 42, 176, 65};
        l0iF = new int[]{361, 575, 922, 525, 176, 586, 640, 321, 536, 742, 677, 742, 687, 284, 193, 517, 273, 494, 263, 147, 593, 800, 571, 320, 803, 133, 231, 390, 685, 330, 63, 410};
        l0If = new int[]{539, 422, 6, 93, 862, 771, 453, 106, 610, 287, 107, 505, 733, 877, 381, 612, 723, 476, 462, 172, 430, 609, 858, 822, 543, 376, 511, 400, 672, 762, 283, 184, 440, 35, 519, 31, 460, 594, 225, 535, 517, 352, 605, 158, 651, 201, 488, 502, 648, 733, 717, 83, 404, 97, 280, 771, 840, 629, 4, 381, 843, 623, 264, 543};
        l0f = new int[]{521, 310, 864, 547, 858, 580, 296, 379, 53, 779, 897, 444, 400, 925, 749, 415, 822, 93, 217, 208, 928, 244, 583, 620, 246, 148, 447, 631, 292, 908, 490, 704, 516, 258, 457, 907, 594, 723, 674, 292, 272, 96, 684, 432, 686, 606, 860, 569, 193, 219, 129, 186, 236, 287, 192, 775, 278, 173, 40, 379, 712, 463, 646, 776, 171, 491, 297, 763, 156, 732, 95, 270, 447, 90, 507, 48, 228, 821, 808, 898, 784, 663, 627, 378, 382, 262, 380, 602, 754, 336, 89, 614, 87, 432, 670, 616, 157, 374, 242, 726, 600, 269, 375, 898, 845, 454, 354, 130, 814, 587, 804, 34, 211, 330, 539, 297, 827, 865, 37, 517, 834, 315, 550, 86, 801, 4, 108, 539};
        l1if = new int[]{524, 894, 75, 766, 882, 857, 74, 204, 82, 586, 708, 250, 905, 786, 138, 720, 858, 194, 311, 913, 275, 190, 375, 850, 438, 733, 194, 280, 201, 280, 828, 757, 710, 814, 919, 89, 68, 569, 11, 204, 796, 605, 540, 913, 801, 700, 799, 137, 439, 418, 592, 668, 353, 859, 370, 694, 325, 240, 216, 257, 284, 549, 209, 884, 315, 70, 329, 793, 490, 274, 877, 162, 749, 812, 684, 461, 334, 376, 849, 521, 307, 291, 803, 712, 19, 358, 399, 908, 103, 511, 51, 8, 517, 225, 289, 470, 637, 731, 66, 255, 917, 269, 463, 830, 730, 433, 848, 585, 136, 538, 906, 90, 2, 290, 743, 199, 655, 903, 329, 49, 802, 580, 355, 588, 188, 462, 10, 134, 628, 320, 479, 130, 739, 71, 263, 318, 374, 601, 192, 605, 142, 673, 687, 234, 722, 384, 177, 752, 607, 640, 455, 193, 689, 707, 805, 641, 48, 60, 732, 621, 895, 544, 261, 852, 655, 309, 697, 755, 756, 60, 231, 773, 434, 421, 726, 528, 503, 118, 49, 795, 32, 144, 500, 238, 836, 394, 280, 566, 319, 9, 647, 550, 73, 914, 342, 126, 32, 681, 331, 792, 620, 60, 609, 441, 180, 791, 893, 754, 605, 383, 228, 749, 760, 213, 54, 297, 134, 54, 834, 299, 922, 191, 910, 532, 609, 829, 189, 20, 167, 29, 872, 449, 83, 402, 41, 656, 505, 579, 481, 173, 404, 251, 688, 95, 497, 555, 642, 543, 307, 159, 924, 558, 648, 55, 497, 10};
        l1l = new int[]{352, 77, 373, 504, 35, 599, 428, 207, 409, 574, 118, 498, 285, 380, 350, 492, 197, 265, 920, 155, 914, 299, 229, 643, 294, 871, 306, 88, 87, 193, 352, 781, 846, 75, 327, 520, 435, 543, 203, 666, 249, 346, 781, 621, 640, 268, 794, 534, 539, 781, 408, 390, 644, 102, 476, 499, 290, 632, 545, 37, 858, 916, 552, 41, 542, 289, 122, 272, 383, 800, 485, 98, 752, 472, 761, 107, 784, 860, 658, 741, 290, 204, 681, 407, 855, 85, 99, 62, 482, 180, 20, 297, 451, 593, 913, 142, 808, 684, 287, 536, 561, 76, 653, 899, 729, 567, 744, 390, 513, 192, 516, 258, 240, 518, 794, 395, 768, 848, 51, 610, 384, 168, 190, 826, 328, 596, 786, 303, 570, 381, 415, 641, 156, 237, 151, 429, 531, 207, 676, 710, 89, 168, 304, 402, 40, 708, 575, 162, 864, 229, 65, 861, 841, 512, 164, 477, 221, 92, 358, 785, 288, 357, 850, 836, 827, 736, 707, 94, 8, 494, 114, 521, 2, 499, 851, 543, 152, 729, 771, 95, 248, 361, 578, 323, 856, 797, 289, 51, 684, 466, 533, 820, 669, 45, 902, 452, 167, 342, 244, 173, 35, 463, 651, 51, 699, 591, 452, 578, 37, 124, 298, 332, 552, 43, 427, 119, 662, 777, 475, 850, 764, 364, 578, 911, 283, 711, 472, 420, 245, 288, 594, 394, 511, 327, 589, 777, 699, 688, 43, 408, 842, 383, 721, 521, 560, 644, 714, 559, 62, 145, 873, 663, 713, 159, 672, 729, 624, 59, 193, 417, 158, 209, 563, 564, 343, 693, 109, 608, 563, 365, 181, 772, 677, 310, 248, 353, 708, 410, 579, 870, 617, 841, 632, 860, 289, 536, 35, 777, 618, 586, 424, 833, 77, 597, 346, 269, 757, 632, 695, 751, 331, 247, 184, 45, 787, 680, 18, 66, 407, 369, 54, 492, 228, 613, 830, 922, 437, 519, 644, 905, 789, 420, 305, 441, 207, 300, 892, 827, 141, 537, 381, 662, 513, 56, 252, 341, 242, 797, 838, 837, 720, 224, 307, 631, 61, 87, 560, 310, 756, 665, 397, 808, 851, 309, 473, 795, 378, 31, 647, 915, 459, 806, 590, 731, 425, 216, 548, 249, 321, 881, 699, 535, 673, 782, 210, 815, 905, 303, 843, 922, 281, 73, 469, 791, 660, 162, 498, 308, 155, 422, 907, 817, 187, 62, 16, 425, 535, 336, 286, 437, 375, 273, 610, 296, 183, 923, 116, 667, 751, 353, 62, 366, 691, 379, 687, 842, 37, 357, 720, 742, 330, 5, 39, 923, 311, 424, 242, 749, 321, 54, 669, 316, 342, 299, 534, 105, 667, 488, 640, 672, 576, 540, 316, 486, 721, 610, 46, 656, 447, 171, 616, 464, 190, 531, 297, 321, 762, 752, 533, 175, 134, 14, 381, 433, 717, 45, 111, 20, 596, 284, 736, 138, 646, 411, 877, 669, 141, 919, 45, 780, 407, 164, 332, 899, 165, 726, 600, 325, 498, 655, 357, 752, 768, 223, 849, 647, 63, 310, 863, 251, 366, 304, 282, 738, 675, 410, 389, 244, 31, 121, 303, 263};
    }

    public static class BarcodeRow {
        public final byte[] Row;
        private int lif;

        public BarcodeRow(int width) {
            this.Row = new byte[width];
            this.lif = 0;
        }

        public void addSequence(byte[] code) {
            for (byte by : code) {
                this.Row[this.lif++] = by;
            }
        }
    }

    public static class HighLevelEncoder {
        private static final int lif = 900;
        private static final int ll = 901;
        private static final int lI = 902;
        private static final int l1 = 913;
        private static final int lIF = 924;
        private static final byte[] llf = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 15, -1, -1, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 10, 20, 15, 18, 21, 10, 28, 23, 24, 22, 20, 13, 16, 17, 19, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 0, 1, 23, 2, 25, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 4, 5, 6, 24, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 21, 27, 9, -1};
        private static final byte[] liF = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 8, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 8, 8, 4, 12, 4, 4, 8, 8, 8, 12, 4, 12, 12, 12, 12, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 8, 8, 4, 8, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 8, 8, 4, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 0};

        public static String encodeHighLevel(String txt, int compaction, I2I encoding) {
            I5l i5l = new I5l();
            int n = txt.length();
            int n2 = 0;
            int n3 = 1;
            byte[] byArray = null;
            switch (compaction) {
                case 1: {
                    HighLevelEncoder.lif(txt, n2, n, i5l, n3);
                    break;
                }
                case 2: {
                    byArray = HighLevelEncoder.lif(txt, encoding);
                    HighLevelEncoder.lif(byArray, n2, byArray.length, 2, i5l);
                    break;
                }
                case 3: {
                    i5l.lif('\u0386');
                    HighLevelEncoder.lif(txt, n2, n, i5l);
                    break;
                }
                default: {
                    int n4 = 1;
                    while (n2 < n) {
                        int n5;
                        int n6 = HighLevelEncoder.lif(txt, n2);
                        if (n6 >= 13) {
                            i5l.lif('\u0386');
                            n4 = 3;
                            n3 = 1;
                            HighLevelEncoder.lif(txt, n2, n6, i5l);
                            n2 += n6;
                            continue;
                        }
                        int n7 = HighLevelEncoder.ll(txt, n2);
                        if (n7 >= 5 || n6 == n) {
                            if (n4 != 1) {
                                i5l.lif('\u0384');
                                n4 = 1;
                                n3 = 1;
                            }
                            n3 = HighLevelEncoder.lif(txt, n2, n7, i5l, n3);
                            n2 += n7;
                            continue;
                        }
                        if (byArray == null) {
                            byArray = HighLevelEncoder.lif(txt, encoding);
                        }
                        if ((n5 = HighLevelEncoder.lif(txt, byArray, n2)) == 0) {
                            n5 = 1;
                        }
                        if (n5 == 1 && n4 == 1) {
                            HighLevelEncoder.lif(byArray, n2, 1, 1, i5l);
                        } else {
                            HighLevelEncoder.lif(byArray, HighLevelEncoder.lif(I254.ll(txt, 0, n2), encoding).length, HighLevelEncoder.lif(I254.ll(txt, n2, n5), encoding).length, n4, i5l);
                            n4 = 2;
                            n3 = 1;
                        }
                        n2 += n5;
                    }
                    break block0;
                }
            }
            return i5l.toString();
        }

        private static byte[] lif(String string, I2I i2I) {
            if (i2I == null) {
                try {
                    i2I = I2I.l1("ISO-8859-1");
                }
                catch (RuntimeException runtimeException) {
                    lif.log(Level.INFO, "Exception occur", runtimeException);
                }
                if (i2I == null) {
                    i2I = I2I.l1("UTF-8");
                }
            }
            return i2I.lI(string);
        }

        private static int lif(String string, int n, int n2, I5l i5l, int n3) {
            int n4;
            char c;
            I5l i5l2 = new I5l(n2);
            int n5 = n3;
            int n6 = 0;
            block5: while (true) {
                c = string.charAt(n + n6);
                switch (n5) {
                    case 1: {
                        if (HighLevelEncoder.lif(c)) {
                            i5l2.lif((char)llf[c]);
                            break;
                        }
                        if (HighLevelEncoder.ll(c)) {
                            n5 = 2;
                            i5l2.lif('\u001b');
                            continue block5;
                        }
                        if (HighLevelEncoder.lI(c)) {
                            n5 = 4;
                            i5l2.lif('\u001c');
                            continue block5;
                        }
                        i5l2.lif('\u001d').lif((char)llf[c]);
                        break;
                    }
                    case 2: {
                        if (HighLevelEncoder.ll(c)) {
                            i5l2.lif((char)llf[c]);
                            break;
                        }
                        if (HighLevelEncoder.lif(c)) {
                            i5l2.lif('\u001b').lif((char)llf[c]);
                            break;
                        }
                        if (HighLevelEncoder.lI(c)) {
                            n5 = 4;
                            i5l2.lif('\u001c');
                            continue block5;
                        }
                        i5l2.lif('\u001d').lif((char)llf[c]);
                        break;
                    }
                    case 4: {
                        if (HighLevelEncoder.lI(c)) {
                            i5l2.lif((char)llf[c]);
                            break;
                        }
                        if (HighLevelEncoder.lif(c)) {
                            n5 = 1;
                            i5l2.lif('\u001c');
                            continue block5;
                        }
                        if (HighLevelEncoder.ll(c)) {
                            n5 = 2;
                            i5l2.lif('\u001b');
                            continue block5;
                        }
                        if (n + n6 + 1 < n2 && HighLevelEncoder.l1((char)(n4 = (int)string.charAt(n + n6 + 1)))) {
                            n5 = 8;
                            i5l2.lif('\u0019');
                            continue block5;
                        }
                        i5l2.lif('\u001d').lif((char)llf[c]);
                        break;
                    }
                    default: {
                        if (HighLevelEncoder.l1(c)) {
                            i5l2.lif((char)llf[c]);
                            break;
                        }
                        n5 = 1;
                        i5l2.lif('\u001d');
                        continue block5;
                    }
                }
                if (++n6 >= n2) break;
            }
            c = '\u0000';
            n4 = i5l2.lI();
            for (int i = 0; i < n4; ++i) {
                if (i % 2 != 0) {
                    c = (char)(c * 30 + i5l2.lI(i));
                    i5l.lif(c);
                    continue;
                }
                c = i5l2.lI(i);
            }
            if (n4 % 2 != 0) {
                i5l.lif((char)(c * 30 + 29));
            }
            return n5;
        }

        private static void lif(byte[] byArray, int n, int n2, int n3, I5l i5l) {
            int n4;
            if (n2 == 1 && n3 == 1) {
                i5l.lif('\u0391');
            } else {
                int n5 = n4 = n2 % 6 == 0 ? 1 : 0;
                if (n4 != 0) {
                    i5l.lif('\u039c');
                } else {
                    i5l.lif('\u0385');
                }
            }
            n4 = n;
            if (n2 >= 6) {
                char[] cArray = new char[5];
                while (n + n2 - n4 >= 6) {
                    int n6;
                    long l = 0L;
                    for (n6 = 0; n6 < 6; ++n6) {
                        l <<= 8;
                        l += (long)(I4.lIF((Object)byArray[n4 + n6], 6) & 0xFF);
                    }
                    for (n6 = 0; n6 < 5; ++n6) {
                        cArray[n6] = (char)(l % 900L);
                        l /= 900L;
                    }
                    for (n6 = cArray.length - 1; n6 >= 0; --n6) {
                        i5l.lif(cArray[n6]);
                    }
                    n4 += 6;
                }
            }
            for (int i = n4; i < n + n2; ++i) {
                i5l.lIF(I4.l0I(byArray[i], 6) & 0xFF);
            }
        }

        private static void lif(String string, int n, int n2, I5l i5l) {
            int n3;
            I5l i5l2 = new I5l(n2 / 3 + 1);
            BigInteger bigInteger = BigInteger.valueOf(900L);
            BigInteger bigInteger2 = BigInteger.valueOf(0L);
            for (int i = 0; i < n2 - 1; i += n3) {
                BigInteger[] bigIntegerArray;
                i5l2.ll(0);
                n3 = I331.l1(44, n2 - i);
                String string2 = I254.lif(I4.lif(Character.valueOf('1')), I254.ll(string, n + i, n3));
                BigInteger bigInteger3 = HighLevelEncoder.parse(string2);
                do {
                    bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger);
                    i5l2.lif((char)bigIntegerArray[1].hashCode());
                } while (!(bigInteger3 = bigIntegerArray[0]).equals(bigInteger2));
                for (int j = i5l2.lI() - 1; j >= 0; --j) {
                    i5l.lif(i5l2.lI(j));
                }
            }
        }

        public static BigInteger parse(String number) {
            if (number == null) {
                throw new I04();
            }
            int n = 0;
            int n2 = number.length();
            boolean bl = false;
            BigInteger bigInteger = BigInteger.valueOf(0L);
            if (number.charAt(n) == '+') {
                ++n;
            } else if (number.charAt(n) == '-') {
                throw new I01();
            }
            while (n < n2) {
                char c = number.charAt(n);
                if (c == '\u0000') {
                    n = n2;
                } else if (c >= '0' && c <= '9') {
                    bigInteger = bigInteger.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(c - 48));
                    bl = true;
                } else {
                    if (I51.l0If(c)) {
                        ++n;
                        while (n < n2) {
                            if (!I51.l0If(number.charAt(n))) {
                                throw new I14l();
                            }
                            ++n;
                        }
                        break;
                    }
                    throw new I14l();
                }
                ++n;
            }
            if (!bl) {
                throw new I14l();
            }
            return bigInteger;
        }

        private static boolean lif(char c) {
            return (I4.lIF((Object)liF[c], 6) & I4.lIF((Object)1, 6)) == I4.lIF((Object)1, 6);
        }

        private static boolean ll(char c) {
            return (I4.lIF((Object)liF[c], 6) & I4.lIF((Object)2, 6)) == I4.lIF((Object)2, 6);
        }

        private static boolean lI(char c) {
            return (I4.lIF((Object)liF[c], 6) & I4.lIF((Object)4, 6)) == I4.lIF((Object)4, 6);
        }

        private static boolean l1(char c) {
            return (I4.lIF((Object)liF[c], 6) & I4.lIF((Object)8, 6)) == I4.lIF((Object)8, 6);
        }

        private static boolean lIF(char c) {
            return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '~';
        }

        private static int lif(String string, int n) {
            int n2 = 0;
            int n3 = n;
            int n4 = string.length();
            if (n3 < n4) {
                char c = string.charAt(n3);
                while (I51.lIF(c) && n3 < n4) {
                    ++n2;
                    if (++n3 >= n4) continue;
                    c = string.charAt(n3);
                }
            }
            return n2;
        }

        private static int ll(String string, int n) {
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                int n4;
                char c = string.charAt(n3);
                for (n4 = 0; n4 < 13 && I51.lIF(c) && n3 < n2; ++n4) {
                    if (++n3 >= n2) continue;
                    c = string.charAt(n3);
                }
                if (n4 >= 13) {
                    return n3 - n - n4;
                }
                if (n4 > 0) continue;
                c = string.charAt(n3);
                if (!HighLevelEncoder.lIF(c)) break;
                ++n3;
            }
            return n3 - n;
        }

        private static int lif(String string, byte[] byArray, int n) {
            int n2;
            int n3 = string.length();
            int n4 = n2 = n;
            while (n2 < n3) {
                int n5;
                char c = string.charAt(n2);
                int n6 = 0;
                while (n6 < 13 && I51.lIF(c) && (n5 = n2 + ++n6) < n3) {
                    c = string.charAt(n5);
                }
                if (n6 >= 13) {
                    return n2 - n;
                }
                c = string.charAt(n2);
                if (I4.lIF((Object)byArray[n4], 6) == 63 && c != '?') {
                    throw new I14l();
                }
                ++n2;
                ++n4;
                if (c < '\u0100') continue;
                ++n4;
            }
            return n2 - n;
        }

        public static final class CompactionModes
        extends I114 {
            public static final int Auto = 0;
            public static final int Text = 1;
            public static final int Byte = 2;
            public static final int Numeric = 3;

            private CompactionModes() {
            }

            static {
                I114.register(new I114.I4((Class)CompactionModes.class, Integer.class){
                    {
                        this.lif("Auto", 0L);
                        this.lif("Text", 1L);
                        this.lif("Byte", 2L);
                        this.lif("Numeric", 3L);
                    }
                });
            }
        }

        private static final class I7
        extends I114 {
            public static final int lif = 1;
            public static final int ll = 2;
            public static final int lI = 4;
            public static final int l1 = 8;

            private I7() {
            }

            static {
                I114.register(new I114.I4((Class)I7.class, Integer.class){
                    {
                        this.lif("Alpha", 1L);
                        this.lif("Lower", 2L);
                        this.lif("Mixed", 4L);
                        this.lif("Punctuation", 8L);
                    }
                });
            }
        }
    }
}

