/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Page;
import com.aspose.pdf.TextStamp;
import com.aspose.pdf.facades.FormattedText;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.ms.System.I177;
import com.aspose.pdf.internal.ms.System.I254;

public final class PageNumberStamp
extends TextStamp {
    private String l1;
    private int lIF = 1;
    private int llf = 0;

    public String getFormat() {
        return this.l1;
    }

    public void setFormat(String value) {
        this.l1 = value;
    }

    public int getStartingNumber() {
        return this.lIF;
    }

    public void setStartingNumber(int value) {
        this.lIF = value;
    }

    public PageNumberStamp(String format) {
        super((String)null);
        this.l1 = format;
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setBottomMargin(10.0);
    }

    private String lif(int n) {
        String string = "";
        String[][] stringArrayArray = new String[][]{{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"}, {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"}, {"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"}};
        while (n > 1000) {
            string = I254.lif(new String[]{string, "M"});
            n -= 1000;
        }
        String string2 = "";
        for (int i = 0; i < 3; ++i) {
            string2 = I254.lif(new String[]{stringArrayArray[i][n % 10], string2});
            n /= 10;
        }
        string = I254.lif(new String[]{string, string2});
        return string;
    }

    private String ll(int n) {
        String string = "";
        int n2 = --n / 26 + 1;
        char c = (char)(65 + n % 26);
        for (int i = 1; i <= n2; ++i) {
            string = I254.lif(string, I4.lif(Character.valueOf(c)));
        }
        return string;
    }

    private String lI(int n) {
        switch (this.getNumberingStyle()) {
            case 0: {
                return I177.ll(n);
            }
            case 2: {
                return I254.liF(this.lif(n));
            }
            case 1: {
                return I254.l01(this.lif(n));
            }
            case 4: {
                return I254.liF(this.ll(n));
            }
            case 3: {
                return I254.l01(this.ll(n));
            }
        }
        return I177.ll(n);
    }

    @Override
    public void put(Page page) {
        this.setValue(I254.lif(this.l1, "#", this.lI(page.getNumber() + this.getStartingNumber() - 1).toString()));
        super.put(page);
    }

    public PageNumberStamp() {
        this("#");
    }

    public PageNumberStamp(FormattedText formattedText) {
        super(formattedText);
        this.l1 = formattedText.getFirstLine();
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setBottomMargin(10.0);
    }

    public int getNumberingStyle() {
        return this.llf;
    }

    public void setNumberingStyle(int value) {
        this.llf = value;
    }
}

