/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Font;
import com.aspose.pdf.FontStyles;
import com.aspose.pdf.exceptions.FontNotFoundException;
import com.aspose.pdf.internal.l137.I2l;
import com.aspose.pdf.internal.l16l.Il;
import com.aspose.pdf.internal.l1961.I01;
import com.aspose.pdf.internal.l457.I271;
import com.aspose.pdf.internal.l457.I27l;
import com.aspose.pdf.internal.l457.I284;
import com.aspose.pdf.internal.l457.I29I;
import com.aspose.pdf.internal.l457.I31;
import com.aspose.pdf.internal.l457.I401;
import com.aspose.pdf.internal.ms.System.Collections.Generic.I27;
import com.aspose.pdf.internal.ms.System.I0I;
import com.aspose.pdf.internal.ms.System.I127;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I11;
import com.aspose.pdf.internal.ms.System.IO.I51;
import com.aspose.pdf.internal.ms.System.IO.I7;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.text.FontSourceCollection;
import com.aspose.pdf.text.FontSubstitutionCollection;
import com.aspose.pdf.text.FontTypes;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FontRepository {
    private static final Logger lif = Logger.getLogger(FontRepository.class.getName());
    private static final I01 ll;
    private static boolean lI;

    public static FontSubstitutionCollection getSubstitutions() {
        return I2l.ll().lI();
    }

    public static FontSourceCollection getSources() {
        return I2l.ll().l1();
    }

    public static Font findFont(String fontName) {
        I284 i284 = I2l.ll().ll(fontName);
        if (i284 == null) {
            throw new FontNotFoundException(I254.lif("Font {0} was not found", new Object[]{fontName}));
        }
        I401 i401 = Il.lif(i284);
        return new Font(i401);
    }

    public static Font findFont(String fontName, boolean ignoreCase) {
        I284 i284 = I2l.ll().lif(fontName, false, ignoreCase);
        if (i284 == null) {
            throw new FontNotFoundException(I254.lif("Font {0} was not found", new Object[]{fontName}));
        }
        I401 i401 = Il.lif(i284);
        return new Font(i401);
    }

    public static Font findFont(String fontFamilyName, int stl) {
        return FontRepository.findFont(fontFamilyName, stl, false);
    }

    public static Font findFont(String fontFamilyName, int stl, boolean ignoreCase) {
        int n = stl;
        String string = fontFamilyName;
        String string2 = I254.lif;
        I27<String> i27 = new I27<String>();
        if (I254.lIf(fontFamilyName, "Bold") != -1) {
            n |= 1;
            string = I254.lif(string, "Bold", I254.lif);
        }
        if (I254.lIf(fontFamilyName, "Italic") != -1) {
            n |= 2;
            string = I254.lif(string, "Italic", I254.lif);
        }
        if (I254.lIf(fontFamilyName, "Oblique") != -1) {
            n |= 2;
            string = I254.lif(string, "Oblique", I254.lif);
        }
        if ((n & 1) != 0) {
            string2 = "Bold";
        }
        if ((n & 2) != 0) {
            i27.addItem(I254.lif(new String[]{string, string2, "Italic"}));
            i27.addItem(I254.lif(new String[]{string, "Italic", string2}));
            i27.addItem(I254.lif(new String[]{string, string2, "Oblique"}));
            i27.addItem(I254.lif(new String[]{string, "Oblique", string2}));
        } else {
            i27.addItem(I254.lif(new String[]{string, string2}));
            if (n == 0) {
                i27.addItem(I254.lif(new String[]{string, "Regular"}));
            }
        }
        I284 i284 = FontRepository.lif(i27, ignoreCase);
        if (i284 == null) {
            if (n != 0) {
                throw new I0I(I254.lif("Font {0} with style {1} was not found", new Object[]{fontFamilyName, I127.lif(FontStyles.class, n)}));
            }
            throw new I0I(I254.lif("Font {0} was not found", new Object[]{fontFamilyName}));
        }
        I401 i401 = Il.lif(i284);
        return new Font(i401);
    }

    private static I284 lif(I27<String> i27, boolean bl) {
        I284 i284 = null;
        for (String string : i27) {
            i284 = I2l.ll().lif(string, false, bl);
            if (i284 == null) continue;
            return i284;
        }
        return null;
    }

    public static Font openFont(InputStream fontStream, int fontType) {
        return FontRepository.lif(Stream.fromJava(fontStream), fontType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font lif(Stream stream, int n) {
        if (n == 0 || n == 1) {
            byte[] byArray;
            int n2 = n == 0 ? 0 : 3;
            I7 i7 = new I7(stream);
            try {
                byArray = i7.lf((int)stream.getLength());
            }
            finally {
                if (i7 != null) {
                    i7.dispose();
                }
            }
            try {
                return new Font(I271.lif(new I284(n2, new I29I[]{new I29I(new I31(byArray))})));
            }
            catch (Exception exception) {
                lif.log(Level.INFO, "Exception occur", exception);
                return null;
            }
        }
        throw new IllegalStateException(I254.lif("font type {0} is not supported", new Object[]{I127.lif(FontTypes.class, n)}));
    }

    public static Font openFont(String fontFilePath) {
        return FontRepository.openFont(fontFilePath, null);
    }

    public static Font openFont(String fontFilePath, String metricsFilePath) {
        int n;
        if (!I11.lIF(fontFilePath)) {
            throw new I0I("Specified font file was not found" + fontFilePath);
        }
        String string = I254.lif(I254.liF(I51.lIF(fontFilePath)), ".", I254.lif);
        switch (ll.lif(string)) {
            case 0: 
            case 1: 
            case 2: {
                n = 0;
                break;
            }
            case 3: 
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new I0I("Could not determine font type of font file specified");
            }
        }
        I27<I29I> i27 = new I27<I29I>(2);
        i27.addItem(new I29I(string, new I27l(fontFilePath)));
        if (metricsFilePath != null && !I254.lIF(metricsFilePath, I254.lif)) {
            if (!I11.lIF(metricsFilePath)) {
                throw new IllegalStateException("Specified font metrics file was not found");
            }
            i27.addItem(new I29I(I254.liF(I51.lIF(metricsFilePath)), new I27l(fontFilePath)));
        }
        try {
            return new Font(I271.lif(new I284(n, i27.toArray(new I29I[0]))));
        }
        catch (Exception exception) {
            lif.log(Level.INFO, "Exception occur", exception);
            throw new I0I("The font object can't be created from the file: " + fontFilePath);
        }
    }

    public static void loadFonts() {
        I2l.ll();
    }

    public static boolean isReplaceNotFoundFonts() {
        return lI;
    }

    public static void setReplaceNotFoundFonts(boolean value) {
        lI = value;
    }

    static {
        lif.setUseParentHandlers(false);
        ll = new I01("ttf", "ttc", "otf", "pfb", "pfa");
    }
}

