/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.ADocument;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LoadOptions;
import com.aspose.pdf.SaveOptions;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.internal.ms.System.I254;
import com.aspose.pdf.internal.ms.System.IO.I5l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;

public final class DocumentWeb
extends ADocument
implements IDocument {
    private static final Logger lIF = Logger.getLogger(DocumentWeb.class.getName());

    public DocumentWeb() {
    }

    public DocumentWeb(InputStream input) {
        super(input);
    }

    public DocumentWeb(InputStream input, String password) {
        super(input, password);
    }

    DocumentWeb(Stream input) {
        super(input);
    }

    public DocumentWeb(InputStream input, LoadOptions options) {
        super(Stream.fromJava(input), options);
    }

    DocumentWeb(Stream input, LoadOptions options) {
        super(input, options);
    }

    public DocumentWeb(String filename, LoadOptions options) {
        super(filename, options);
    }

    DocumentWeb(Stream input, String password) {
        super(input, password);
    }

    public DocumentWeb(String filename) {
        super(filename);
    }

    public DocumentWeb(String filename, String password) {
        super(filename, password);
    }

    public void save(HttpServletResponse response, String outputFileName, int disposition, SaveOptions options) {
        this.lif(response, outputFileName, disposition, options);
    }

    private void lif(HttpServletResponse httpServletResponse, String string, int n, SaveOptions saveOptions) {
        this.l1if();
        httpServletResponse.reset();
        httpServletResponse.resetBuffer();
        switch (n) {
            case 1: {
                httpServletResponse.addHeader("content-disposition", I254.lif(new String[]{"attachment; filename=", string}));
                break;
            }
            case 0: {
                httpServletResponse.addHeader("content-disposition", I254.lif(new String[]{"inline; filename=", string}));
                break;
            }
            default: {
                throw new PdfException("Unsupported content-disposition value");
            }
        }
        switch (saveOptions.getSaveFormat()) {
            case 0: {
                httpServletResponse.setContentType("application/pdf");
                break;
            }
            case 1: {
                httpServletResponse.setContentType("application/msword");
                break;
            }
            case 3: {
                httpServletResponse.setContentType("text/html");
                break;
            }
            case 2: {
                httpServletResponse.setContentType("application/vnd.ms-xpsdocument");
                break;
            }
            case 7: {
                httpServletResponse.setContentType("image/svg+xml");
                break;
            }
            default: {
                throw new PdfException("Unsupported options for saving pdf on web");
            }
        }
        try {
            I5l i5l = new I5l();
            this.lif((Stream)i5l, saveOptions);
            httpServletResponse.getOutputStream().write(i5l.l1());
            httpServletResponse.flushBuffer();
            i5l.dispose();
        }
        catch (Exception exception) {
            lIF.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception);
        }
    }

    static {
        lIF.setUseParentHandlers(false);
    }
}

