/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.drawing.PatternColorSpace;
import com.aspose.pdf.internal.l1614.I07;
import com.aspose.pdf.internal.l1961.I4;
import com.aspose.pdf.internal.l224.I14;
import com.aspose.pdf.internal.ms.System.I177;
import com.aspose.pdf.internal.ms.System.I1I;
import com.aspose.pdf.internal.ms.System.I21l;
import com.aspose.pdf.internal.ms.System.I254;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Color {
    private static final Logger lif = Logger.getLogger(Color.class.getName());
    private double[] ll;
    private boolean lI = false;
    private double l1 = 1.0;
    public static final Color Empty;
    private PatternColorSpace lIF;

    public double getA() {
        return this.l1;
    }

    public double[] getData() {
        return this.ll;
    }

    public int getColorSpace() {
        if (this.getData() != null) {
            switch (this.getData().length) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public Color() {
    }

    public Color(double[] vector) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.ll = vector;
    }

    private Color(double[] vector, boolean isEmpty, double alpha) {
        for (double d : vector) {
            if (!(d > 1.0)) continue;
            throw new IllegalStateException("Invalid input data: color element is out of range [0..1]");
        }
        this.ll = vector;
        this.lI = isEmpty;
        this.l1 = alpha;
    }

    public Color deepClone() {
        double[] dArray = new double[this.ll.length];
        for (int i = 0; i < this.ll.length; ++i) {
            dArray[i] = this.ll[i];
        }
        return new Color(dArray, this.lif(), this.l1);
    }

    boolean lif() {
        return this.lI;
    }

    public static Color parse(String value) {
        try {
            String string = I254.lIF(value, 1);
            double[] dArray = new double[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                dArray[i / 2] = (double)I177.lif(I254.ll(string, i, 2), 515) / 255.0;
            }
            return new Color(dArray, false, 1.0);
        }
        catch (RuntimeException runtimeException) {
            lif.log(Level.INFO, "Exception occur", runtimeException);
            return Color.lif(I07.lif(value).l16IF());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        for (double d : this.ll) {
            stringBuilder.append(I254.lif("{0:X2}", new Object[]{(int)(d * 255.0 + 0.5)}));
        }
        return stringBuilder.toString();
    }

    public java.awt.Color toRgb() {
        return this.ll().lif();
    }

    I07 ll() {
        Color color = this.lI();
        return I07.lif((int)(255.0 * color.getData()[0] + 0.5), (int)(255.0 * color.getData()[1] + 0.5), (int)(255.0 * color.getData()[2] + 0.5));
    }

    static Color lif(I07 i07) {
        return new Color(new double[]{(double)(i07.l0IF() & 0xFF) / 255.0, (double)(i07.l0lf() & 0xFF) / 255.0, (double)(i07.l0iF() & 0xFF) / 255.0}, i07.l0I() || I4.lIF((Object)i07.l01(), 6) == 0, I4.l0if(i07.l01(), 6) / 255.0);
    }

    public static Color fromRgb(java.awt.Color color) {
        return Color.lif(I07.lif(color));
    }

    Color lI() {
        if (I1I.lI((Object)this.ll).l0if() == 1) {
            return Color.fromRgb(this.ll[0], this.ll[0], this.ll[0]);
        }
        if (I1I.lI((Object)this.ll).l0if() == 4) {
            double d;
            double d2;
            double d3 = this.ll[0];
            double d4 = this.ll[1];
            double d5 = this.ll[2];
            double d6 = this.ll[3];
            double d7 = 1.0 - d3;
            double d8 = 1.0 - d4;
            double d9 = 1.0 - d5;
            double d10 = 1.0 - d6;
            double d11 = d2 = (d = d7 * d8 * d9 * d10);
            double d12 = d2;
            d = d7 * d8 * d9 * d6;
            d12 += 0.1373 * d;
            d11 += 0.1216 * d;
            d2 += 0.1255 * d;
            d = d7 * d8 * d5 * d10;
            d12 += d;
            d11 += 0.949 * d;
            d = d7 * d8 * d5 * d6;
            d12 += 0.1098 * d;
            d11 += 0.102 * d;
            d = d7 * d4 * d9 * d10;
            d12 += 0.9255 * d;
            d2 += 0.549 * d;
            d = d7 * d4 * d9 * d6;
            d12 += 0.1412 * d;
            d = d7 * d4 * d5 * d10;
            d12 += 0.9294 * d;
            d11 += 0.1098 * d;
            d2 += 0.1412 * d;
            d = d7 * d4 * d5 * d6;
            d12 += 0.1333 * d;
            d = d3 * d8 * d9 * d10;
            d11 += 0.6784 * d;
            d2 += 0.9373 * d;
            d = d3 * d8 * d9 * d6;
            d11 += 0.0588 * d;
            d2 += 0.1412 * d;
            d = d3 * d8 * d5 * d10;
            d11 += 0.651 * d;
            d2 += 0.3137 * d;
            d = d3 * d8 * d5 * d6;
            d11 += 0.0745 * d;
            d = d3 * d4 * d9 * d10;
            d12 += 0.1804 * d;
            d11 += 0.1922 * d;
            d2 += 0.5725 * d;
            d = d3 * d4 * d9 * d6;
            d2 += 0.0078 * d;
            d = d3 * d4 * d5 * d10;
            return Color.fromRgb(I14.lif(d12 += 0.2118 * d), I14.lif(d11 += 0.2119 * d), I14.lif(d2 += 0.2235 * d));
        }
        return new Color(this.ll);
    }

    Color l1() {
        if (I1I.lI((Object)this.ll).l0if() == 3) {
            if (com.aspose.pdf.internal.l3I.I4.lif(this.ll[0], this.ll[1]) && com.aspose.pdf.internal.l3I.I4.lif(this.ll[1], this.ll[2])) {
                return new Color(new double[]{this.ll[0]});
            }
            return new Color(new double[]{I14.lif(0.299 * this.ll[0] + 0.587 * this.ll[1] + 0.114 * this.ll[2])});
        }
        if (I1I.lI((Object)this.ll).l0if() == 4) {
            return this.lI().l1();
        }
        return new Color(this.ll);
    }

    Color lIF() {
        if (I1I.lI((Object)this.ll).l0if() == 1) {
            return new Color(new double[]{0.0, 0.0, 0.0, 1.0 - this.ll[0]});
        }
        if (I1I.lI((Object)this.ll).l0if() == 3) {
            double[] dArray = new double[4];
            double d = I14.lif(1.0 - this.ll[0]);
            double d2 = I14.lif(1.0 - this.ll[1]);
            double d3 = I14.lif(1.0 - this.ll[2]);
            double d4 = d;
            if (d2 < d4) {
                d4 = d2;
            }
            if (d3 < d4) {
                d4 = d3;
            }
            dArray[0] = I14.lif(d - d4);
            dArray[1] = I14.lif(d2 - d4);
            dArray[2] = I14.lif(d3 - d4);
            dArray[3] = I14.lif(d4);
            return new Color(dArray);
        }
        return new Color(this.ll);
    }

    public static Color fromArgb(int r, int g, int b) {
        return Color.lif(I07.lif(r, g, b).l16IF());
    }

    public static Color fromArgb(int a, int r, int g, int b) {
        return Color.lif(I07.lif(a, r, g, b).l16IF());
    }

    public static Color fromRgb(double r, double g, double b) {
        return new Color(new double[]{r, g, b});
    }

    public static Color fromGray(double g) {
        return new Color(new double[]{g});
    }

    public static Color fromCmyk(double c, double m, double y, double k) {
        return new Color(new double[]{c, m, y, k});
    }

    public int hashCode() {
        return super.hashCode();
    }

    boolean lif(Color color) {
        boolean bl = true;
        for (int i = 0; i < color.getData().length; ++i) {
            bl &= com.aspose.pdf.internal.l3I.I4.lif(color.getData()[i], this.getData()[i]);
        }
        return bl;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Color)) {
            return false;
        }
        Color color = (Color)obj;
        if (this.lI != color.lI || color.getData().length != this.getData().length) {
            return false;
        }
        return this.lif(color);
    }

    public static boolean op_Equality(Color x, Color y) {
        if (I21l.ll(x, y)) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean op_Inequality(Color x, Color y) {
        return !Color.op_Equality(x, y);
    }

    public PatternColorSpace getPatternColorSpace() {
        return this.lIF;
    }

    public void setPatternColorSpace(PatternColorSpace value) {
        this.lIF = value;
    }

    public static Color getTransparent() {
        return Color.lif(I07.l0If().l16IF());
    }

    public static Color getAliceBlue() {
        return Color.lif(I07.l0f().l16IF());
    }

    public static Color getAntiqueWhite() {
        return Color.lif(I07.l1if().l16IF());
    }

    public static Color getAqua() {
        return Color.lif(I07.l1l().l16IF());
    }

    public static Color getAquamarine() {
        return Color.lif(I07.l1I().l16IF());
    }

    public static Color getAzure() {
        return Color.lif(I07.l11().l16IF());
    }

    public static Color getBeige() {
        return Color.lif(I07.l1IF().l16IF());
    }

    public static Color getBisque() {
        return Color.lif(I07.l1lf().l16IF());
    }

    public static Color getBlack() {
        return Color.fromRgb(I07.l1iF().l16IF().lif());
    }

    public static Color getBlanchedAlmond() {
        return Color.lif(I07.l1If().l16IF());
    }

    public static Color getBlue() {
        return Color.lif(I07.l1f().l16IF());
    }

    public static Color getBlueViolet() {
        return Color.lif(I07.l2if().l16IF());
    }

    public static Color getBrown() {
        return Color.lif(I07.l2l().l16IF());
    }

    public static Color getBurlyWood() {
        return Color.lif(I07.l2I().l16IF());
    }

    public static Color getCadetBlue() {
        return Color.lif(I07.l21().l16IF());
    }

    public static Color getChartreuse() {
        return Color.lif(I07.l2IF().l16IF());
    }

    public static Color getChocolate() {
        return Color.lif(I07.l2lf().l16IF());
    }

    public static Color getCoral() {
        return Color.lif(I07.l2iF().l16IF());
    }

    public static Color getCornflowerBlue() {
        return Color.lif(I07.l2If().l16IF());
    }

    public static Color getCornsilk() {
        return Color.lif(I07.l2f().l16IF());
    }

    public static Color getCrimson() {
        return Color.lif(I07.l3if().l16IF());
    }

    public static Color getCyan() {
        return Color.lif(I07.l3l().l16IF());
    }

    public static Color getDarkBlue() {
        return Color.lif(I07.l3I().l16IF());
    }

    public static Color getDarkCyan() {
        return Color.lif(I07.l31().l16IF());
    }

    public static Color getDarkGoldenrod() {
        return Color.lif(I07.l3IF().l16IF());
    }

    public static Color getDarkGray() {
        return Color.lif(I07.l3lf().l16IF());
    }

    public static Color getDarkGreen() {
        return Color.lif(I07.l3iF().l16IF());
    }

    public static Color getDarkKhaki() {
        return Color.lif(I07.l3If().l16IF());
    }

    public static Color getDarkMagenta() {
        return Color.lif(I07.l3f().l16IF());
    }

    public static Color getDarkOliveGreen() {
        return Color.lif(I07.l4if().l16IF());
    }

    public static Color getDarkOrange() {
        return Color.lif(I07.l4l().l16IF());
    }

    public static Color getDarkOrchid() {
        return Color.lif(I07.l4I().l16IF());
    }

    public static Color getDarkRed() {
        return Color.lif(I07.l41().l16IF());
    }

    public static Color getDarkSalmon() {
        return Color.lif(I07.l4IF().l16IF());
    }

    public static Color getDarkSeaGreen() {
        return Color.lif(I07.l4lf().l16IF());
    }

    public static Color getDarkSlateBlue() {
        return Color.lif(I07.l4iF().l16IF());
    }

    public static Color getDarkSlateGray() {
        return Color.lif(I07.l4If().l16IF());
    }

    public static Color getDarkTurquoise() {
        return Color.lif(I07.l4f().l16IF());
    }

    public static Color getDarkViolet() {
        return Color.lif(I07.l5if().l16IF());
    }

    public static Color getDeepPink() {
        return Color.lif(I07.l5l().l16IF());
    }

    public static Color getDeepSkyBlue() {
        return Color.lif(I07.l5I().l16IF());
    }

    public static Color getDimGray() {
        return Color.lif(I07.l51().l16IF());
    }

    public static Color getDodgerBlue() {
        return Color.lif(I07.l5IF().l16IF());
    }

    public static Color getFirebrick() {
        return Color.lif(I07.l5lf().l16IF());
    }

    public static Color getFloralWhite() {
        return Color.lif(I07.l5iF().l16IF());
    }

    public static Color getForestGreen() {
        return Color.lif(I07.l5If().l16IF());
    }

    public static Color getFuchsia() {
        return Color.lif(I07.l5f().l16IF());
    }

    public static Color getGainsboro() {
        return Color.lif(I07.l6if().l16IF());
    }

    public static Color getGhostWhite() {
        return Color.lif(I07.l6l().l16IF());
    }

    public static Color getGold() {
        return Color.lif(I07.l6I().l16IF());
    }

    public static Color getGoldenrod() {
        return Color.lif(I07.l61().l16IF());
    }

    public static Color getGray() {
        return Color.lif(I07.l6IF().l16IF());
    }

    public static Color getGreen() {
        return Color.lif(I07.l6lf().l16IF());
    }

    public static Color getGreenYellow() {
        return Color.lif(I07.l6iF().l16IF());
    }

    public static Color getHoneydew() {
        return Color.lif(I07.l6If().l16IF());
    }

    public static Color getHotPink() {
        return Color.lif(I07.l6f().l16IF());
    }

    public static Color getIndianRed() {
        return Color.lif(I07.l7if().l16IF());
    }

    public static Color getIndigo() {
        return Color.lif(I07.l7l().l16IF());
    }

    public static Color getIvory() {
        return Color.lif(I07.l7I().l16IF());
    }

    public static Color getKhaki() {
        return Color.lif(I07.l71().l16IF());
    }

    public static Color getLavender() {
        return Color.lif(I07.l7IF().l16IF());
    }

    public static Color getLavenderBlush() {
        return Color.lif(I07.l7lf().l16IF());
    }

    public static Color getLawnGreen() {
        return Color.lif(I07.l7iF().l16IF());
    }

    public static Color getLemonChiffon() {
        return Color.lif(I07.l7If().l16IF());
    }

    public static Color getLightBlue() {
        return Color.lif(I07.l7f().l16IF());
    }

    public static Color getLightCoral() {
        return Color.lif(I07.l8if().l16IF());
    }

    public static Color getLightCyan() {
        return Color.lif(I07.l8l().l16IF());
    }

    public static Color getLightGoldenrodYellow() {
        return Color.lif(I07.l8I().l16IF());
    }

    public static Color getLightGreen() {
        return Color.lif(I07.l81().l16IF());
    }

    public static Color getLightGray() {
        return Color.lif(I07.l8IF().l16IF());
    }

    public static Color getLightPink() {
        return Color.lif(I07.l8lf().l16IF());
    }

    public static Color getLightSalmon() {
        return Color.lif(I07.l8iF().l16IF());
    }

    public static Color getLightSeaGreen() {
        return Color.lif(I07.l8If().l16IF());
    }

    public static Color getLightSkyBlue() {
        return Color.lif(I07.l8f().l16IF());
    }

    public static Color getLightSlateGray() {
        return Color.lif(I07.l9if().l16IF());
    }

    public static Color getLightSteelBlue() {
        return Color.lif(I07.l9l().l16IF());
    }

    public static Color getLightYellow() {
        return Color.lif(I07.l9I().l16IF());
    }

    public static Color getLime() {
        return Color.lif(I07.l91().l16IF());
    }

    public static Color getLimeGreen() {
        return Color.lif(I07.l9IF().l16IF());
    }

    public static Color getLinen() {
        return Color.lif(I07.l9lf().l16IF());
    }

    public static Color getMagenta() {
        return Color.lif(I07.l9iF().l16IF());
    }

    public static Color getMaroon() {
        return Color.lif(I07.l9If().l16IF());
    }

    public static Color getMediumAquamarine() {
        return Color.lif(I07.l9f().l16IF());
    }

    public static Color getMediumBlue() {
        return Color.lif(I07.l10if().l16IF());
    }

    public static Color getMediumOrchid() {
        return Color.lif(I07.l10l().l16IF());
    }

    public static Color getMediumPurple() {
        return Color.lif(I07.l10I().l16IF());
    }

    public static Color getMediumSeaGreen() {
        return Color.lif(I07.l101().l16IF());
    }

    public static Color getMediumSlateBlue() {
        return Color.lif(I07.l10IF().l16IF());
    }

    public static Color getMediumSpringGreen() {
        return Color.lif(I07.l10lf().l16IF());
    }

    public static Color getMediumTurquoise() {
        return Color.lif(I07.l10iF().l16IF());
    }

    public static Color getMediumVioletRed() {
        return Color.lif(I07.l10If().l16IF());
    }

    public static Color getMidnightBlue() {
        return Color.lif(I07.l10f().l16IF());
    }

    public static Color getMintCream() {
        return Color.lif(I07.l11if().l16IF());
    }

    public static Color getMistyRose() {
        return Color.lif(I07.l11l().l16IF());
    }

    public static Color getMoccasin() {
        return Color.lif(I07.l11I().l16IF());
    }

    public static Color getNavajoWhite() {
        return Color.lif(I07.l111().l16IF());
    }

    public static Color getNavy() {
        return Color.lif(I07.l11IF().l16IF());
    }

    public static Color getOldLace() {
        return Color.lif(I07.l11lf().l16IF());
    }

    public static Color getOlive() {
        return Color.lif(I07.l11iF().l16IF());
    }

    public static Color getOliveDrab() {
        return Color.lif(I07.l11If().l16IF());
    }

    public static Color getOrange() {
        return Color.lif(I07.l11f().l16IF());
    }

    public static Color getOrangeRed() {
        return Color.lif(I07.l12if().l16IF());
    }

    public static Color getOrchid() {
        return Color.lif(I07.l12l().l16IF());
    }

    public static Color getPaleGoldenrod() {
        return Color.lif(I07.l12I().l16IF());
    }

    public static Color getPaleGreen() {
        return Color.lif(I07.l121().l16IF());
    }

    public static Color getPaleTurquoise() {
        return Color.lif(I07.l12IF().l16IF());
    }

    public static Color getPaleVioletRed() {
        return Color.lif(I07.l12lf().l16IF());
    }

    public static Color getPapayaWhip() {
        return Color.lif(I07.l12iF().l16IF());
    }

    public static Color getPeachPuff() {
        return Color.lif(I07.l12If().l16IF());
    }

    public static Color getPeru() {
        return Color.lif(I07.l12f().l16IF());
    }

    public static Color getPink() {
        return Color.lif(I07.l13if().l16IF());
    }

    public static Color getPlum() {
        return Color.lif(I07.l13l().l16IF());
    }

    public static Color getPowderBlue() {
        return Color.lif(I07.l13I().l16IF());
    }

    public static Color getPurple() {
        return Color.lif(I07.l131().l16IF());
    }

    public static Color getRed() {
        return Color.lif(I07.l13IF().l16IF());
    }

    public static Color getRosyBrown() {
        return Color.lif(I07.l13lf().l16IF());
    }

    public static Color getRoyalBlue() {
        return Color.lif(I07.l13iF().l16IF());
    }

    public static Color getSaddleBrown() {
        return Color.lif(I07.l13If().l16IF());
    }

    public static Color getSalmon() {
        return Color.lif(I07.l13f().l16IF());
    }

    public static Color getSandyBrown() {
        return Color.lif(I07.l14if().l16IF());
    }

    public static Color getSeaGreen() {
        return Color.lif(I07.l14l().l16IF());
    }

    public static Color getSeaShell() {
        return Color.lif(I07.l14I().l16IF());
    }

    public static Color getSienna() {
        return Color.lif(I07.l141().l16IF());
    }

    public static Color getSilver() {
        return Color.lif(I07.l14IF().l16IF());
    }

    public static Color getSkyBlue() {
        return Color.lif(I07.l14lf().l16IF());
    }

    public static Color getSlateBlue() {
        return Color.lif(I07.l14iF().l16IF());
    }

    public static Color getSlateGray() {
        return Color.lif(I07.l14If().l16IF());
    }

    public static Color getSnow() {
        return Color.lif(I07.l14f().l16IF());
    }

    public static Color getSpringGreen() {
        return Color.lif(I07.l15if().l16IF());
    }

    public static Color getSteelBlue() {
        return Color.lif(I07.l15l().l16IF());
    }

    public static Color getTan() {
        return Color.lif(I07.l15I().l16IF());
    }

    public static Color getTeal() {
        return Color.lif(I07.l151().l16IF());
    }

    public static Color getThistle() {
        return Color.lif(I07.l15IF().l16IF());
    }

    public static Color getTomato() {
        return Color.lif(I07.l15lf().l16IF());
    }

    public static Color getTurquoise() {
        return Color.lif(I07.l15iF().l16IF());
    }

    public static Color getViolet() {
        return Color.lif(I07.l15If().l16IF());
    }

    public static Color getWheat() {
        return Color.lif(I07.l15f().l16IF());
    }

    public static Color getWhite() {
        return Color.lif(I07.l16if().l16IF());
    }

    public static Color getWhiteSmoke() {
        return Color.lif(I07.l16l().l16IF());
    }

    public static Color getYellow() {
        return Color.lif(I07.l16I().l16IF());
    }

    public static Color getYellowGreen() {
        return Color.lif(I07.l161().l16IF());
    }

    static {
        lif.setUseParentHandlers(false);
        Empty = new Color(new double[]{0.0, 0.0, 0.0}, true, 1.0);
    }
}

