/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering.pdf;

import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.drawing.IBrush;
import com.aspose.pdf.internal.html.io.ICreateStreamProvider;
import com.aspose.pdf.internal.html.rendering.Device;
import com.aspose.pdf.internal.html.rendering.GraphicContext;
import com.aspose.pdf.internal.html.rendering.pdf.PdfRenderingOptions;
import com.aspose.pdf.internal.html.rendering.pdf.l0if;
import com.aspose.pdf.internal.html.rendering.pdf.l0k;
import com.aspose.pdf.internal.html.rendering.pdf.l2if;
import com.aspose.pdf.internal.html.rendering.pdf.lb;
import com.aspose.pdf.internal.html.rendering.pdf.lc;
import com.aspose.pdf.internal.l27j.l0t;
import com.aspose.pdf.internal.l27j.l1f;
import com.aspose.pdf.internal.l27j.l2v;
import com.aspose.pdf.internal.l27v.lv;
import com.aspose.pdf.internal.l42j.lt;
import com.aspose.pdf.internal.l67k.l13h;
import com.aspose.pdf.internal.l67k.l14p;
import com.aspose.pdf.internal.l67k.l2t;
import com.aspose.pdf.internal.l67k.ld;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.Uri;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l5f;
import java.io.OutputStream;

public class PdfDevice
extends Device<lj, PdfRenderingOptions> {
    private l0if _pdfDoc;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, lf>> _uriIdLocationMap;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, Integer> _uriPage;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<lI> _internalLinks;
    private int _currentPageNumber = 0;

    public PdfDevice(ICreateStreamProvider streamProvider) {
        this(new PdfRenderingOptions(), streamProvider);
    }

    public PdfDevice(PdfRenderingOptions options, ICreateStreamProvider streamProvider) {
        super(options, streamProvider, lj.class);
    }

    public PdfDevice(String file) {
        this(new PdfRenderingOptions(), file);
    }

    public PdfDevice(PdfRenderingOptions options, String file) {
        super(options, file, lj.class);
    }

    public PdfDevice(Stream stream) {
        this(new PdfRenderingOptions(), stream);
    }

    public PdfDevice(OutputStream outputStream) {
        this(new PdfRenderingOptions(), outputStream);
    }

    public PdfDevice(PdfRenderingOptions options, Stream stream) {
        super(options, stream, lj.class);
    }

    public PdfDevice(PdfRenderingOptions options, OutputStream outputStream) {
        super(options, outputStream, lj.class);
    }

    private static l13h transformRect(com.aspose.pdf.internal.l68if.l2t transformationMatrix, l13h rect) {
        l2t[] l2tArray = (l2t[])com.aspose.pdf.internal.ms.System.ly.lI(com.aspose.pdf.internal.ms.System.ly.lI(com.aspose.pdf.internal.l82p.lb.lI(l2t.class), 2));
        l2tArray[0] = new l2t(rect.lb(), rect.lh());
        l2tArray[1] = new l2t(rect.lu(), rect.lf());
        transformationMatrix.lI(l2tArray);
        l13h l13h2 = new l13h(l13p.lf(l2tArray[0].lf(), l2tArray[1].lf()), l13p.lf(l2tArray[0].lj(), l2tArray[1].lj()), l13p.lI(l2tArray[0].lf() - l2tArray[1].lf()), l13p.lI(l2tArray[0].lj() - l2tArray[1].lj()));
        return l13h2;
    }

    @Override
    public void saveGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.lk().ld();
        try {
            ((lj)this.getGraphicContext()).lI(true);
            super.saveGraphicContext();
        }
        finally {
            ((lj)this.getGraphicContext()).lI(false);
        }
    }

    @Override
    public void restoreGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.lk().l0l();
        super.restoreGraphicContext();
    }

    @Override
    public void addRect(l13h rect) {
        this._pdfDoc.lk().lI(rect.ly());
    }

    @Override
    public void beginDocument(Document document, Class<? extends GraphicContext> clazz) {
        this._currentPageNumber = 0;
        super.beginDocument(document, clazz);
        ((lj)this.getGraphicContext()).lI(this);
        this._pdfDoc = new l0if(this.getOutputStream(), (PdfRenderingOptions)this.getOptions_Rename_Namesake(), this);
        this._uriIdLocationMap = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();
        this._internalLinks = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t();
        this._uriPage = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf();
    }

    @Override
    public boolean beginElement(Element element, l13h rect) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, lf> lf2;
        HTMLElement hTMLElement;
        if (element != null && !l10l.lf(element.getBaseURI()) && !this._uriPage.containsKey(element.getBaseURI())) {
            this._uriPage.set_Item(element.getBaseURI(), this._currentPageNumber);
        }
        if ((hTMLElement = (HTMLElement)((Object)com.aspose.pdf.internal.l82p.lb.lI(element, HTMLElement.class))) != null && !l10l.lf(hTMLElement.getId_Rename_Namesake()) && !l10l.lf(element.getBaseURI())) {
            lf2 = null;
            Object[] objectArray = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf[]{lf2};
            boolean bl = !this._uriIdLocationMap.tryGetValue(element.getBaseURI(), objectArray);
            lf2 = objectArray[0];
            if (bl) {
                lf2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.lf<String, lf>();
                this._uriIdLocationMap.set_Item(element.getBaseURI(), lf2);
            }
            Object object = null;
            Object[] objectArray2 = new lf[]{object};
            lf2.tryGetValue(hTMLElement.getId_Rename_Namesake(), objectArray2);
            object = objectArray2[0];
            if (object == null) {
                lf2.set_Item(hTMLElement.getId_Rename_Namesake(), new lf(this._pdfDoc.lk().lh(), this.transformRect(rect.ly()).ld().lt()));
            }
        }
        if ((lf2 = com.aspose.pdf.internal.html.rendering.lI.lI(element, rect.ly(), this.getGraphicContext())) != null) {
            this.addFormElement((l0t)((Object)lf2));
            return com.aspose.pdf.internal.l82p.lb.lf((Object)lf2, com.aspose.pdf.internal.l27j.lk.class);
        }
        if (l10l.lt(element.getTagName(), "A", (short)3)) {
            this.addHyperlink(hTMLElement, rect.ly());
        }
        return true;
    }

    private void addHyperlink(HTMLElement element, l13h rect) {
        if (!element.hasAttribute("href")) {
            return;
        }
        lb lb2 = this._pdfDoc.lk().lI(this.transformRect(rect.ly()).ly(), null);
        String string = element.getAttribute("href");
        if (Uri.isWellFormedUriString(string, 1)) {
            lb2.lI(new lt(string));
        } else {
            String[] stringArray = l10l.lI(string, new char[]{'#'}, (short)1);
            if (stringArray.length < 2) {
                this._internalLinks.addItem(new lI(lb2, string, ""));
            } else {
                String string2 = stringArray[0];
                String string3 = stringArray.length == 2 ? stringArray[1] : l10l.lI;
                this._internalLinks.addItem(new lI(lb2, string2, string3));
            }
        }
    }

    @Override
    public void beginPage(l14p size) {
        ++this._currentPageNumber;
        super.beginPage(size.ld());
        this._pdfDoc.lI(size.ld());
        this.saveGraphicContext();
        ((lj)this.getGraphicContext()).transform(new com.aspose.pdf.internal.l68if.l2t(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, size.lj()));
    }

    @Override
    public void clip(int mode) {
        this._pdfDoc.lk().lj(mode);
    }

    @Override
    public void closePath() {
        this._pdfDoc.lk().lj();
    }

    @Override
    public void cubicBezierTo(l2t pt1, l2t pt2, l2t pt3) {
        this._pdfDoc.lk().lI(pt1.lt(), pt2.lt(), pt3.lt());
    }

    @Override
    public void drawImage(byte[] data, int type, l13h rect) {
        this.saveGraphicContext();
        this._pdfDoc.lk().lI(data, rect.ly());
        this.restoreGraphicContext();
    }

    @Override
    public void endDocument() {
        this.addInternalLinksDestinations();
        this._pdfDoc.lI();
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    private void addFormElement(l0t formElement) {
        if (formElement != null) {
            l2v l2v2 = (l2v)((Object)com.aspose.pdf.internal.l82p.lb.lI(formElement, l2v.class));
            if (l2v2 != null) {
                this._pdfDoc.lh().lI(l2v2, this._pdfDoc.lk());
                return;
            }
            com.aspose.pdf.internal.l27j.lk lk2 = (com.aspose.pdf.internal.l27j.lk)((Object)com.aspose.pdf.internal.l82p.lb.lI(formElement, com.aspose.pdf.internal.l27j.lk.class));
            if (lk2 != null) {
                this._pdfDoc.lh().lI(lk2, this._pdfDoc.lk());
                return;
            }
            l1f l1f2 = (l1f)((Object)com.aspose.pdf.internal.l82p.lb.lI(formElement, l1f.class));
            if (l1f2 != null) {
                this._pdfDoc.lh().lI(l1f2, this._pdfDoc.lk());
                return;
            }
            com.aspose.pdf.internal.l27j.lc lc2 = (com.aspose.pdf.internal.l27j.lc)((Object)com.aspose.pdf.internal.l82p.lb.lI(formElement, com.aspose.pdf.internal.l27j.lc.class));
            if (lc2 != null) {
                this._pdfDoc.lh().lI(lc2, this._pdfDoc.lk());
                return;
            }
            com.aspose.pdf.internal.l27j.ly ly2 = (com.aspose.pdf.internal.l27j.ly)((Object)com.aspose.pdf.internal.l82p.lb.lI(formElement, com.aspose.pdf.internal.l27j.ly.class));
            if (ly2 != null) {
                this._pdfDoc.lh().lI(ly2, this._pdfDoc.lk());
                return;
            }
        }
    }

    @Override
    public void endPage() {
        this.restoreGraphicContext();
        this._pdfDoc.lf();
        super.endPage();
    }

    @Override
    public void fill(int mode) {
        this._pdfDoc.lk().lf(mode);
    }

    @Override
    public void fillText(String text, l2t pt) {
        this._pdfDoc.lk().lI(text, pt.lt());
    }

    @Override
    public void lineTo(l2t pt) {
        this._pdfDoc.lk().lf(pt.lt());
    }

    @Override
    public void moveTo(l2t pt) {
        this._pdfDoc.lk().lI(pt.lt());
    }

    @Override
    public void stroke() {
        this._pdfDoc.lk().lf();
    }

    @Override
    public void strokeAndFill(int mode) {
        this._pdfDoc.lk().lI(mode);
    }

    @Override
    public void strokeText(String text, l2t pt) {
    }

    @Override
    protected String getExtension() {
        return ".pdf";
    }

    public void setExtGraphicState() {
        this._pdfDoc.lk().ld();
        ((lj)this.getGraphicContext()).lI(((lj)this.getGraphicContext()).lf() + 1);
    }

    public void clearExtGraphicState() {
        while (((lj)this.getGraphicContext()).lf() > 0) {
            ((lj)this.getGraphicContext()).lI(((lj)this.getGraphicContext()).lf() - 1);
            this._pdfDoc.lk().l0l();
        }
    }

    private l13h transformRect(l13h rect) {
        if (((lj)this.getGraphicContext()).getTransformationMatrix() == null || ((lj)this.getGraphicContext()).getTransformationMatrix().lf()) {
            return rect;
        }
        return PdfDevice.transformRect(((lj)this.getGraphicContext()).getTransformationMatrix(), rect.ly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addInternalLinksDestinations() {
        lk lk2 = this._internalLinks.iterator();
        try {
            while (lk2.hasNext()) {
                lI lI2 = (lI)lk2.next();
                lk lk3 = this._uriIdLocationMap.iterator();
                try {
                    while (lk3.hasNext()) {
                        ly ly2 = (ly)lk3.next();
                        Object object = null;
                        int n = 0;
                        if (!l10l.lj((String)ly2.lI(), lI2.lf())) continue;
                        Object[] objectArray = new Integer[]{n};
                        boolean bl = l10l.lf(lI2.lj()) && this._uriPage.tryGetValue((String)ly2.lI(), objectArray);
                        n = objectArray[0];
                        if (bl) {
                            lI2.lI().lI(new com.aspose.pdf.internal.l42j.lf(new lc((String)this._pdfDoc.l0if().lt().get_Item(n - 1), new l2t(0.0f, this._pdfDoc.l0if().lI().get_Item(n - 1).lj()))));
                            continue;
                        }
                        Object[] objectArray2 = new lf[]{object};
                        boolean bl2 = ((com.aspose.pdf.internal.ms.System.Collections.Generic.lf)ly2.lf()).tryGetValue(lI2.lj(), objectArray2);
                        object = objectArray2[0];
                        if (!bl2) continue;
                        lI2.lI().lI(new com.aspose.pdf.internal.l42j.lf(new lc(((lf)object).lI(), ((lf)object).lf().lt())));
                    }
                }
                finally {
                    if (!com.aspose.pdf.internal.l82p.lb.lf((Object)lk3, l5f.class)) continue;
                    ((l5f)lk3).dispose();
                }
            }
            return;
        }
        finally {
            if (com.aspose.pdf.internal.l82p.lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
    }

    @Override
    public Class<? extends GraphicContext> getGraphicContextClass() {
        return lj.class;
    }

    public static class lj
    extends GraphicContext
    implements Cloneable {
        private ld lI = com.aspose.pdf.internal.l67k.ld.l0f().l12if();
        private com.aspose.pdf.internal.l43if.lj lf = com.aspose.pdf.internal.l43if.lj.lI();
        private ld lj = com.aspose.pdf.internal.l67k.ld.l0f().l12if();
        private com.aspose.pdf.internal.l43if.lj lt = com.aspose.pdf.internal.l43if.lj.lI();
        private float lb = 1.0f;
        private float ld = 1.0f;
        private boolean lu;
        private int le;
        private float lh;
        private l0k lk;
        private int lv;
        private PdfDevice lc;
        private boolean ly;

        public PdfDevice lI() {
            return this.lc;
        }

        public void lI(PdfDevice pdfDevice) {
            this.lc = pdfDevice;
        }

        public int lf() {
            return this.lv;
        }

        public void lI(int n) {
            this.lv = n;
        }

        public boolean lj() {
            return this.ly;
        }

        public void lI(boolean bl) {
            this.ly = bl;
        }

        public l0k lt() {
            return this.lk;
        }

        public void lI(l0k l0k2) {
            this.lk = l0k2;
        }

        @Override
        public IBrush getFillBrush() {
            return super.getFillBrush();
        }

        @Override
        public void setFillBrush(IBrush value) {
            this.lI().clearExtGraphicState();
            this.lk.l0v().lI(value, false);
            super.setFillBrush(value);
        }

        @Override
        public int getLineCap() {
            return super.getLineCap();
        }

        @Override
        public void setLineCap(int value) {
            super.setLineCap(value);
            int n = 0;
            switch (value) {
                case 2: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                }
            }
            this.lk.l0t().lj("{0} J", com.aspose.pdf.internal.l27v.lv.lf(n));
        }

        @Override
        public int getLineJoin() {
            return super.getLineJoin();
        }

        @Override
        public void setLineJoin(int value) {
            super.setLineJoin(value);
            int n = 0;
            switch (value) {
                case 2: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                }
            }
            this.lk.l0t().lj("{0} j", com.aspose.pdf.internal.l27v.lv.lf(n));
        }

        @Override
        public float getLineWidth() {
            return super.getLineWidth();
        }

        @Override
        public void setLineWidth(float value) {
            super.setLineWidth(value);
            this.lk.l0t().lj("{0} w", l2if.lI(value));
        }

        @Override
        public float getMiterLimit() {
            return super.getMiterLimit();
        }

        @Override
        public void setMiterLimit(float value) {
            super.setMiterLimit(value);
            this.lk.l0t().lj("{0} M", l2if.lI(value));
        }

        @Override
        public IBrush getStrokeBrush() {
            return super.getStrokeBrush();
        }

        @Override
        public void setStrokeBrush(IBrush value) {
            this.lI().clearExtGraphicState();
            this.lk.l0v().lI(value, true);
            super.setStrokeBrush(value);
        }

        @Override
        public void transform(com.aspose.pdf.internal.l68if.l2t matrix) {
            float[] fArray = matrix.lI();
            this.lk.l0t().lI(new com.aspose.pdf.internal.l26k.lv(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
            if (super.getTransformationMatrix() != null) {
                super.getTransformationMatrix().lf(matrix);
            } else {
                super.setTransformationMatrix(matrix.ld());
            }
        }

        @Override
        public com.aspose.pdf.internal.l68if.l2t getTransformationMatrix() {
            return super.getTransformationMatrix();
        }

        @Override
        public void setTransformationMatrix(com.aspose.pdf.internal.l68if.l2t value) {
            if (this.lj()) {
                super.setTransformationMatrix(value);
            } else if (super.getTransformationMatrix() != null && !super.getTransformationMatrix().lf() && super.getTransformationMatrix().lj()) {
                super.getTransformationMatrix().lu();
                float[] fArray = super.getTransformationMatrix().lI();
                this.lk.l0t().lI(new com.aspose.pdf.internal.l26k.lv(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                com.aspose.pdf.internal.l68if.l2t l2t2 = new com.aspose.pdf.internal.l68if.l2t(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.lk.lb());
                l2t2.lf(value);
                fArray = l2t2.lI();
                this.lk.l0t().lI(new com.aspose.pdf.internal.l26k.lv(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                super.setTransformationMatrix(l2t2);
            }
        }

        @Override
        public GraphicContext deepClone() {
            lj lj2 = (lj)this.memberwiseClone();
            if (this.getTransformationMatrix() != null) {
                lj2.setTransformationMatrix(this.getTransformationMatrix().ld());
            }
            this.lv = 0;
            return lj2;
        }

        public boolean lb() {
            return this.lb < 1.0f || this.ld < 1.0f;
        }

        public float ld() {
            return this.lh;
        }

        public void lI(float f) {
            this.lh = f;
        }

        private void lI(com.aspose.pdf.internal.l43if.ld ld2) {
            this.lI().setExtGraphicState();
            this.lk.l0t().lj("/{0} gs", ld2.lv());
        }

        public void lI(ld ld2, boolean bl) {
            if (bl) {
                if (this.lf == com.aspose.pdf.internal.l43if.lj.lf() && com.aspose.pdf.internal.l67k.ld.lI(ld2, this.lI)) {
                    return;
                }
                this.lf = com.aspose.pdf.internal.l43if.lj.lf();
                ld2.lI(this.lI);
            } else {
                if (this.lt == com.aspose.pdf.internal.l43if.lj.lf() && com.aspose.pdf.internal.l67k.ld.lI(ld2, this.lj)) {
                    return;
                }
                this.lt = com.aspose.pdf.internal.l43if.lj.lf();
                ld2.lI(this.lj);
            }
            if (com.aspose.pdf.internal.l82p.lb.lb((Object)ld2.ly(), 6) < 255) {
                com.aspose.pdf.internal.l43if.ld ld3 = this.lk.lu().lj().lI();
                float f = com.aspose.pdf.internal.l82p.lb.lh(ld2.ly(), 6) / 255.0f;
                if (bl) {
                    this.lb = f;
                } else {
                    this.ld = f;
                }
                ld3.lf(this.ld);
                ld3.lI(this.lb);
                this.lI(ld3);
                this.lu = true;
            } else if (this.lb()) {
                com.aspose.pdf.internal.l43if.ld ld4 = this.lk.lu().lj().lI();
                float f = 1.0f;
                if (bl) {
                    this.lb = 1.0f;
                } else {
                    this.ld = 1.0f;
                }
                ld4.lf(this.ld);
                ld4.lI(this.lb);
                this.lI(ld4);
            }
            this.lk.l0t().lj("{0} {1}", l2if.lI(com.aspose.pdf.internal.l26k.lt.lI(ld2.l12if())), bl ? "RG" : "rg");
        }

        public void lI(com.aspose.pdf.internal.l42k.lf lf2) {
            this.lk.l0t().lj("/{0} {1} Tf", lf2.lv(), l2if.lI(this.getFontSize()));
        }

        public void lu() {
            this.lk.l0t().lj("{0} Tc", l2if.lI(this.getCharacterSpacing()));
        }

        public void lf(int n) {
            if (n == this.le) {
                return;
            }
            this.le = n;
            this.lk.l0t().lj("{0} Tr", com.aspose.pdf.internal.l27v.lv.lf(n));
        }

        public void lf(float f) {
            if (f == this.lh) {
                return;
            }
            this.lh = f;
            this.lk.l0t().lj("{0} TL", l2if.lI(f));
        }

        public void lI(com.aspose.pdf.internal.l43if.lj lj2, boolean bl) {
            if (bl) {
                if (lj2 == this.lf) {
                    return;
                }
                this.lf = lj2;
            } else {
                if (lj2 == this.lt) {
                    return;
                }
                this.lt = lj2;
            }
            this.lk.l0t().lj("/{0} {1}", lj2.ld(), bl ? "CS" : "cs");
        }

        @Override
        protected Object memberwiseClone() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }
    }

    private static class lI {
        private final lb lI;
        private final String lf;
        private final String lj;

        public lI(lb lb2, String string, String string2) {
            this.lI = lb2;
            this.lj = string2;
            this.lf = string;
        }

        public lb lI() {
            return this.lI;
        }

        public String lf() {
            return this.lf;
        }

        public String lj() {
            return this.lj;
        }
    }

    private static class lf {
        private final String lI;
        private final l2t lf = new l2t();

        public lf(String string, l2t l2t2) {
            this.lI = string;
            l2t2.lI(this.lf);
        }

        public String lI() {
            return this.lI;
        }

        public l2t lf() {
            return this.lf;
        }
    }
}

