/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering.image;

import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.drawing.IBrush;
import com.aspose.pdf.internal.html.io.ICreateStreamProvider;
import com.aspose.pdf.internal.html.rendering.Device;
import com.aspose.pdf.internal.html.rendering.GraphicContext;
import com.aspose.pdf.internal.html.rendering.image.ImageFormat;
import com.aspose.pdf.internal.html.rendering.image.ImageRenderingOptions;
import com.aspose.pdf.internal.html.rendering.lb;
import com.aspose.pdf.internal.html.rendering.ld;
import com.aspose.pdf.internal.html.rendering.lk;
import com.aspose.pdf.internal.html.rendering.lu;
import com.aspose.pdf.internal.l27v.lf;
import com.aspose.pdf.internal.l28y.l0k;
import com.aspose.pdf.internal.l41n.lj;
import com.aspose.pdf.internal.l67k.l0l;
import com.aspose.pdf.internal.l67k.l0n;
import com.aspose.pdf.internal.l67k.l13h;
import com.aspose.pdf.internal.l67k.l13y;
import com.aspose.pdf.internal.l67k.l14k;
import com.aspose.pdf.internal.l67k.l14p;
import com.aspose.pdf.internal.l67k.l1n;
import com.aspose.pdf.internal.l67k.l1v;
import com.aspose.pdf.internal.l68if.l1l;
import com.aspose.pdf.internal.l68if.l2t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l2l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l4p;
import com.aspose.pdf.internal.ms.System.l7k;

public class ImageDevice
extends Device<lI, ImageRenderingOptions> {
    private com.aspose.pdf.internal.l41n.lI renderingStrategy;
    private final l2l<l1l> states = new l2l();
    private final lk pathBuilder = new lk();
    private l14k stringFormat;
    private com.aspose.pdf.internal.l27v.l0l privateFontCache;

    public com.aspose.pdf.internal.l41n.lI getRenderingStrategy() {
        return this.renderingStrategy;
    }

    public ImageDevice(ICreateStreamProvider streamProvider) {
        this(new ImageRenderingOptions(), streamProvider);
    }

    public ImageDevice(ImageRenderingOptions options, ICreateStreamProvider streamProvider) {
        super(options, streamProvider, lI.class);
        this.initializeDevice();
    }

    public ImageDevice(String file) {
        this(new ImageRenderingOptions(), file);
    }

    public ImageDevice(ImageRenderingOptions options, String file) {
        super(options, file, lI.class);
        this.initializeDevice();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(ImageRenderingOptions options, Stream stream) {
        super(options, stream, lI.class);
        this.initializeDevice();
    }

    private void initializeDevice() {
        this.stringFormat = new l14k(l14k.lh());
        this.stringFormat.lj(this.stringFormat.lj() | 0x800);
        this.renderingStrategy = this.createRenderingStrategy();
    }

    private com.aspose.pdf.internal.l41n.lI createRenderingStrategy() {
        switch (((ImageRenderingOptions)this.getOptions_Rename_Namesake()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new com.aspose.pdf.internal.l41n.lf(this);
            }
            case 5: {
                return new lj(this);
            }
        }
        throw new l7k();
    }

    @Override
    protected void initialize(Class<? extends GraphicContext> clazz) {
        super.initialize(lI.class);
        ((lI)this.getGraphicContext()).lI(this);
        this.privateFontCache = new com.aspose.pdf.internal.l27v.l0l();
    }

    @Override
    public void endDocument() {
        this.renderingStrategy.lb();
        this.privateFontCache.dispose();
        this.privateFontCache = null;
        super.endDocument();
    }

    @Override
    public Class<? extends GraphicContext> getGraphicContextClass() {
        return lI.class;
    }

    @Override
    public void saveGraphicContext() {
        this.states.lf(this.getGraphics().lf());
        super.saveGraphicContext();
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().lI(this.states.lb());
        super.restoreGraphicContext();
    }

    @Override
    public boolean beginElement(Element element, l13h rect) {
        return true;
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void closePath() {
        this.pathBuilder.lj();
    }

    @Override
    public void moveTo(com.aspose.pdf.internal.l67k.l2t pt) {
        this.pathBuilder.lf(pt.lt());
    }

    @Override
    public void lineTo(com.aspose.pdf.internal.l67k.l2t pt) {
        this.pathBuilder.lj(pt.lt());
    }

    @Override
    public void addRect(l13h rect) {
        this.pathBuilder.lI(rect.ly());
    }

    @Override
    public void cubicBezierTo(com.aspose.pdf.internal.l67k.l2t pt1, com.aspose.pdf.internal.l67k.l2t pt2, com.aspose.pdf.internal.l67k.l2t pt3) {
        this.pathBuilder.lI(pt1.lt(), pt2.lt(), pt3.lt());
    }

    public com.aspose.pdf.internal.l67k.lj toNativeBrush(IBrush brush) {
        switch (brush.getType()) {
            case 1: {
                return lf.lI((com.aspose.pdf.internal.l26k.lf)((lu)brush).lI());
            }
            case 2: {
                return lf.lI((com.aspose.pdf.internal.l26k.lf)((lb)brush).lI());
            }
            case 0: {
                return lf.lI((com.aspose.pdf.internal.l26k.lf)((ld)brush).lI());
            }
        }
        return null;
    }

    private l1n createPen() {
        l1n l1n2 = new l1n(this.toNativeBrush(((lI)this.getGraphicContext()).getStrokeBrush()));
        l1n2.lj(((lI)this.getGraphicContext()).getLineWidth());
        l1n2.lt(((lI)this.getGraphicContext()).getLineCap());
        l1n2.lb(((lI)this.getGraphicContext()).getLineCap());
        l1n2.ld(((lI)this.getGraphicContext()).getLineJoin());
        l1n2.lf(((lI)this.getGraphicContext()).getMiterLimit());
        l1n2.lI(((lI)this.getGraphicContext()).getLineDashOffset() / l1n2.l0p());
        l1n2.lj(((lI)this.getGraphicContext()).getLineDashStyle());
        l1n2.lf(((lI)this.getGraphicContext()).getLineDashCap());
        if (l1n2.lv() == 5) {
            int n = ((lI)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = ((lI)this.getGraphicContext()).getLineDashPattern()[i] / ((lI)this.getGraphicContext()).getLineWidth();
            }
            l1n2.lf(fArray);
        }
        return l1n2;
    }

    private void strokePath() {
        l1n l1n2 = this.createPen();
        try {
            this.getGraphics().lI(l1n2, this.pathBuilder.lb());
        }
        finally {
            if (l1n2 != null) {
                l1n2.dispose();
            }
        }
    }

    @Override
    public void stroke() {
        this.strokePath();
        this.pathBuilder.ld();
    }

    private void fillPath(int mode) {
        com.aspose.pdf.internal.l67k.lj lj2 = this.toNativeBrush(((lI)this.getGraphicContext()).getFillBrush());
        try {
            this.pathBuilder.lb().lI(mode);
            this.getGraphics().lI(lj2, this.pathBuilder.lb());
        }
        finally {
            if (lj2 != null) {
                lj2.dispose();
            }
        }
    }

    @Override
    public void fill(int mode) {
        this.fillPath(mode);
        this.pathBuilder.ld();
    }

    @Override
    public void clip(int mode) {
        this.pathBuilder.lb().lI(mode);
        this.getGraphics().lI(new l13y(this.pathBuilder.lb()), 1);
        this.pathBuilder.ld();
    }

    @Override
    public void strokeAndFill(int mode) {
        this.fillPath(mode);
        this.strokePath();
        this.pathBuilder.ld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String text, com.aspose.pdf.internal.l67k.l2t pt) {
        if (((lI)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pt.lf(pt.lj() - ((lI)this.getGraphicContext()).getFont().getAscent(((lI)this.getGraphicContext()).getFontSize()));
        com.aspose.pdf.internal.l67k.lj lj2 = this.toNativeBrush(((lI)this.getGraphicContext()).getFillBrush());
        try {
            l0l l0l2 = com.aspose.pdf.internal.l27v.lk.lI((l0k)((lI)this.getGraphicContext()).getFont(), ((lI)this.getGraphicContext()).getFontSize(), ((lI)this.getGraphicContext()).getFontStyle(), this.privateFontCache);
            try {
                this.getGraphics().lI(text, l0l2, lj2, pt.lt(), this.stringFormat);
            }
            finally {
                if (l0l2 != null) {
                    l0l2.dispose();
                }
            }
        }
        finally {
            if (lj2 != null) {
                lj2.dispose();
            }
        }
    }

    @Override
    public void strokeText(String text, com.aspose.pdf.internal.l67k.l2t pt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] data, int type, l13h rect) {
        l1v l1v2 = l1v.lI(new l1j(data));
        try {
            int n = 2;
            com.aspose.pdf.internal.l82p.lu<Integer> lu2 = new com.aspose.pdf.internal.l82p.lu<Integer>(n);
            l13h l13h2 = l1v2.lI(lu2).ly();
            n = (Integer)lu2.lI;
            com.aspose.pdf.internal.l67k.l2t[] l2tArray = new com.aspose.pdf.internal.l67k.l2t[]{rect.ld(), new com.aspose.pdf.internal.l67k.l2t(rect.lv() + rect.lk(), rect.lc()), new com.aspose.pdf.internal.l67k.l2t(rect.lv(), rect.lc() + rect.lj())};
            this.getGraphics().lI(l1v2, l2tArray, l13h2.ly(), n, null);
        }
        finally {
            if (l1v2 != null) {
                l1v2.dispose();
            }
        }
    }

    public Stream getInternalOutputStream() {
        return this.getOutputStream();
    }

    public int getInternalPageIndex() {
        return this.getPageIndex();
    }

    @Override
    protected String getExtension() {
        return l10l.lI(new String[]{".", l10l.ld(l4p.lI(ImageFormat.class, ((ImageRenderingOptions)this.getOptions_Rename_Namesake()).getFormat()))});
    }

    @Override
    protected Device.lI getConfiguration() {
        return this.renderingStrategy.ld();
    }

    public l0n getGraphics() {
        return this.renderingStrategy.lf();
    }

    @Override
    public void beginPage(l14p size) {
        super.beginPage(size.ld());
        this.renderingStrategy.lI(size.ld());
    }

    @Override
    public void endPage() {
        this.renderingStrategy.lt();
        super.endPage();
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.renderingStrategy != null && disposing) {
            this.renderingStrategy.dispose();
            this.renderingStrategy = null;
        }
        super.dispose(disposing);
    }

    public static class lI
    extends GraphicContext {
        private l2t lI;
        private ImageDevice lf;

        @Override
        public l2t getTransformationMatrix() {
            return this.lI;
        }

        @Override
        public void setTransformationMatrix(l2t value) {
            this.lI = value;
            if (this.lI().getGraphics() != null) {
                this.lI().getGraphics().lf(value);
            }
        }

        @Override
        public void transform(l2t matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().lf(matrix);
                if (this.lI().getGraphics() != null) {
                    this.lI().getGraphics().lf(this.lI);
                }
            } else {
                this.setTransformationMatrix(matrix.ld());
            }
        }

        public ImageDevice lI() {
            return this.lf;
        }

        public void lI(ImageDevice imageDevice) {
            this.lf = imageDevice;
        }

        @Override
        public GraphicContext deepClone() {
            lI lI2 = (lI)super.deepClone();
            if (this.lI != null) {
                lI2.lI = this.lI.ld();
            }
            return lI2;
        }
    }
}

