/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering;

import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.css.CSSPrimitiveValue;
import com.aspose.pdf.internal.html.dom.css.CSSValue;
import com.aspose.pdf.internal.html.dom.css.IDocumentStyle;
import com.aspose.pdf.internal.html.dom.css.IViewCSS;
import com.aspose.pdf.internal.html.dom.svg.SVGDocument;
import com.aspose.pdf.internal.html.dom.svg.SVGSVGElement;
import com.aspose.pdf.internal.html.drawing.LengthOrAuto;
import com.aspose.pdf.internal.html.drawing.Page;
import com.aspose.pdf.internal.html.drawing.Unit;
import com.aspose.pdf.internal.html.drawing.UnitType;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.rendering.Renderer;
import com.aspose.pdf.internal.html.rendering.RenderingOptions;
import com.aspose.pdf.internal.html.rendering.l0k;
import com.aspose.pdf.internal.html.rendering.l0t;
import com.aspose.pdf.internal.l26u.l1t;
import com.aspose.pdf.internal.l33if.le;
import com.aspose.pdf.internal.l34h.lI;
import com.aspose.pdf.internal.l34n.lu;
import com.aspose.pdf.internal.l34y.lf;
import com.aspose.pdf.internal.l34y.lj;
import com.aspose.pdf.internal.l37h.ld;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.l5f;

public class SvgRenderer
extends Renderer<SVGDocument> {
    @Override
    public void render(IDevice device, SVGDocument document) {
        this.render(device, document.getRootElement());
    }

    @Override
    public void render(IDevice device, SVGSVGElement element) {
        this.render(device, element, false);
    }

    public void renderPage(IDevice device, SVGSVGElement element) {
        this.render(device, element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(IDevice device, SVGSVGElement element, boolean pageMode) {
        if (element == null) {
            return;
        }
        l5f l5f2 = (l5f)((l1t)com.aspose.pdf.internal.l26u.l0k.lI("Func3<IDevice, RendererBase, IDisposable>")).lI(device, this);
        if (l5f2 != null) {
            l5f2.dispose();
        }
        Document document = element.getOwnerDocument();
        l0t l0t2 = (l0t)document.getContext().getService(l0t.class);
        com.aspose.pdf.internal.l31p.lI lI2 = (com.aspose.pdf.internal.l31p.lI)document.getContext().getService(com.aspose.pdf.internal.html.services.ld.class);
        try {
            RenderingOptions renderingOptions = ld.lI(device.getOptions(), document);
            com.aspose.pdf.internal.l88t.lI lI3 = new com.aspose.pdf.internal.l88t.lI(document.getContext(), renderingOptions);
            try {
                Object object;
                Object object2;
                lI2.lI(document);
                if (renderingOptions.getPageSetup().getAdjustToWidestPage() && lb.lt((Object)((CSSPrimitiveValue)(object2 = (CSSPrimitiveValue)(object = ((IViewCSS)((Object)document.getContext().getWindow())).getComputedStyle(element, null)).getPropertyCSSValue("width"))).getPrimitiveType(), 8) != lb.lt((Object)2, 8)) {
                    renderingOptions = this.adjustPageSize(lu.lI((CSSValue)object2, null, null).getValue(UnitType.PT), renderingOptions.deepClone());
                }
                object = com.aspose.pdf.internal.l33if.lj.lI(renderingOptions, document);
                try {
                    object2 = new l0k();
                    document.getContext().addService(object2, l0t.class);
                    object2.lI((IDocumentStyle)((Object)document));
                    document.getContext().addService(new lj(), com.aspose.pdf.internal.l34h.lf.class);
                    document.getContext().addService(new lf(new com.aspose.pdf.internal.l33t.lj((l0t)document.getContext().getService(l0t.class))), lI.class);
                    com.aspose.pdf.internal.l33if.ld ld2 = new com.aspose.pdf.internal.l33if.ld((com.aspose.pdf.internal.l33if.lj)object);
                    com.aspose.pdf.internal.l33v.lf lf2 = ld2.lI(element, pageMode);
                    le le2 = le.lI(device, document);
                    try {
                        lf2.lI(le2);
                    }
                    finally {
                        if (le2 != null) {
                            le2.dispose();
                        }
                    }
                }
                finally {
                    if (object != null) {
                        object.dispose();
                    }
                }
            }
            finally {
                if (lI3 != null) {
                    lI3.dispose();
                }
            }
        }
        finally {
            lI2.lI(document);
            document.getContext().addService(l0t2, l0t.class);
            document.getContext().addService(null, com.aspose.pdf.internal.l34h.lf.class);
            document.getContext().addService(null, lI.class);
        }
    }

    private RenderingOptions adjustPageSize(double svgWidth, RenderingOptions renderingOptions) {
        boolean bl = false;
        if (renderingOptions.getPageSetup().getFirstPage() != null) {
            bl |= this.needsResize(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        if (renderingOptions.getPageSetup().getAnyPage() == null) {
            bl |= this.needsResize(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
            if (bl |= this.needsResize(renderingOptions.getPageSetup().getRightPage(), svgWidth)) {
                this.updatePageWidth(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
                this.updatePageWidth(renderingOptions.getPageSetup().getRightPage(), svgWidth);
            }
        } else if (bl |= this.needsResize(renderingOptions.getPageSetup().getAnyPage(), svgWidth)) {
            this.updatePageWidth(renderingOptions.getPageSetup().getAnyPage(), svgWidth);
        }
        if (bl && renderingOptions.getPageSetup().getFirstPage() != null) {
            this.updatePageWidth(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        return renderingOptions;
    }

    private void updatePageWidth(Page page, double widestBlock) {
        page.getSize().setWidth(Unit.fromPoints(widestBlock + this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight())));
    }

    private boolean needsResize(Page page, double widestBlock) {
        double d = this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight());
        return widestBlock + d > page.getSize().getWidth().getValue(UnitType.PT);
    }

    private double getMarginWidth(LengthOrAuto lengthOrAuto) {
        return lengthOrAuto.isAuto() ? 0.0 : lengthOrAuto.getLength().getValue(UnitType.PT);
    }
}

