/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.net;

import com.aspose.pdf.internal.html.net.Content;
import com.aspose.pdf.internal.html.net.MultipartContent;
import com.aspose.pdf.internal.html.net.headers.ContentDispositionHeaderValue;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.lh;
import com.aspose.pdf.internal.ms.System.lk;

public class MultipartFormDataContent
extends MultipartContent {
    private static final String FormData = "form-data";

    public MultipartFormDataContent() {
        super(FormData);
    }

    public MultipartFormDataContent(String boundary) {
        super(FormData, boundary);
    }

    @Override
    public void add(Content content) {
        if (content == null) {
            throw new lk("content");
        }
        if (content.getHeaders().get_Item("Content-Disposition") == null) {
            content.getHeaders().set_Item("Content-Disposition", new ContentDispositionHeaderValue(FormData).toString());
        }
        super.add(content);
    }

    public void add(Content content, String name) {
        if (content == null) {
            throw new lk("content");
        }
        if (l10l.lf(name)) {
            throw new lh("Name is empty argument");
        }
        this.addInternal(content, name, null);
    }

    public void add(Content content, String name, String fileName) {
        if (content == null) {
            throw new lk("content");
        }
        if (l10l.lf(name)) {
            throw new lh("Name is empty");
        }
        if (l10l.lf(fileName)) {
            throw new lh("File name is empty");
        }
        this.addInternal(content, name, fileName);
    }

    private void addInternal(Content content, String name, String fileName) {
        if (content.getHeaders().get_Item("Content-Disposition") == null) {
            ContentDispositionHeaderValue contentDispositionHeaderValue = new ContentDispositionHeaderValue(FormData);
            if (!l10l.lf(name) && !l10l.lI(name, "\"", (short)4)) {
                name = l10l.lI(new String[]{"\"", name, "\""});
            }
            contentDispositionHeaderValue.setName(name);
            if (!l10l.lf(fileName) && !l10l.lI(fileName, "\"", (short)4)) {
                fileName = l10l.lI(new String[]{"\"", fileName, "\""});
            }
            contentDispositionHeaderValue.setFileName(fileName);
            content.getHeaders().set_Item("Content-Disposition", contentDispositionHeaderValue.toString());
        }
        super.add(content);
    }
}

