/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.net;

import com.aspose.pdf.internal.html.net.Content;
import com.aspose.pdf.internal.html.net.headers.NameValueHeaderValue;
import com.aspose.pdf.internal.l67p.l0t;
import com.aspose.pdf.internal.l70u.l1j;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l5j;
import com.aspose.pdf.internal.ms.System.lh;
import com.aspose.pdf.internal.ms.System.lk;
import com.aspose.pdf.internal.ms.System.lv;

public class MultipartContent
extends Content
implements com.aspose.pdf.internal.ms.System.Collections.Generic.lh<Content> {
    private static final String CrLf = "\r\n";
    private final com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Content> _nestedContent;
    private final String _boundary;

    public MultipartContent() {
        this("mixed", MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String subtype) {
        this(subtype, MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String subtype, String boundary) {
        if (l10l.lf(subtype)) {
            throw new lh("The argument cannot be null or empty string.", subtype);
        }
        MultipartContent.validateBoundary(boundary);
        this._boundary = boundary;
        String string = boundary;
        if (!l10l.lI(string, "\"", (short)4)) {
            string = l10l.lI(new String[]{"\"", string, "\""});
        }
        this.getHeaders().setByHttpRequestHeader(12, l10l.lI(new String[]{"multipart/", subtype}));
        this.getHeaders().setByHttpRequestHeader(12, l10l.lI(new String[]{this.getHeaders().get_Item("Content-Type"), ";"}) + new NameValueHeaderValue("boundary", string));
        this._nestedContent = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t();
    }

    private static void validateBoundary(String boundary) {
        if (l10l.lf(boundary)) {
            throw new lh("The argument cannot be null or empty string.", "boundary");
        }
        if (boundary.length() > 70) {
            throw new lv("boundary", (Object)boundary, "Http content field too long");
        }
        if (l10l.lf(boundary, " ", (short)4)) {
            throw new lh(l10l.lI("Invalid value for {0}.", new Object[]{boundary}), "boundary");
        }
        String string = "'()+_,-./:=? ";
        for (int i = 0; i < boundary.length(); ++i) {
            char c = boundary.charAt(i);
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || l10l.lt("'()+_,-./:=? ", c) >= 0) continue;
            throw new lh(l10l.lI(com.aspose.pdf.internal.l68p.lh.lt(), "Invalid value for {0}", boundary), "boundary");
        }
    }

    private static String getDefaultBoundary() {
        return l5j.lf().toString();
    }

    private static void encodeStringToStream(Stream stream, String input) {
        byte[] byArray = DefaultHttpEncoding.lj(input);
        stream.write(byArray, 0, byArray.length);
    }

    public void add(Content content) {
        if (content == null) {
            throw new lk("content");
        }
        this._nestedContent.addItem(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        if (disposing) {
            com.aspose.pdf.internal.ms.System.Collections.Generic.lk lk2 = this._nestedContent.iterator();
            try {
                while (lk2.hasNext()) {
                    Content content = (Content)lk2.next();
                    content.dispose();
                }
            }
            finally {
                if (lb.lf((Object)lk2, l5f.class)) {
                    ((l5f)lk2).dispose();
                }
            }
            this._nestedContent.clear();
        }
        super.dispose(disposing);
    }

    @Override
    public com.aspose.pdf.internal.ms.System.Collections.Generic.lk<Content> iterator() {
        return this._nestedContent.iterator();
    }

    public l0t iterator_Rename_Namesake() {
        return this._nestedContent.iterator();
    }

    @Override
    protected void serializeToStream(Stream stream) {
        MultipartContent.encodeStringToStream(stream, l10l.lI(new String[]{"--", this._boundary, CrLf}));
        for (int i = 0; i < this._nestedContent.size(); ++i) {
            l1j l1j2 = new l1j();
            Content content = this._nestedContent.get_Item(i);
            MultipartContent.encodeStringToStream(stream, this.serializeHeadersToString(l1j2, i, content));
            byte[] byArray = content.readAsByteArray();
            stream.write(byArray, 0, byArray.length);
        }
        MultipartContent.encodeStringToStream(stream, l10l.lI(CrLf, "--", this._boundary, "--", CrLf));
    }

    private String serializeHeadersToString(l1j scratch, int contentIndex, Content content) {
        if (contentIndex != 0) {
            scratch.lI(l10l.lI(new String[]{CrLf, "--"}));
            scratch.lI(this._boundary);
            scratch.lI(CrLf);
        }
        for (String string : content.getHeaders()) {
            scratch.lI(string);
            scratch.lI(": ");
            scratch.lI(content.getHeaders().get_Item(string));
            scratch.lI(CrLf);
        }
        scratch.lI(CrLf);
        return scratch.toString();
    }
}

