/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.drawing;

import com.aspose.pdf.internal.html.drawing.Dimension;
import com.aspose.pdf.internal.html.drawing.Numeric;
import com.aspose.pdf.internal.html.drawing.UnitType;
import com.aspose.pdf.internal.l35l.lb;
import com.aspose.pdf.internal.ms.System.l8t;

public final class Resolution
extends Dimension {
    private static final lb converter = new lb();

    public Resolution(double value, UnitType type) {
        super(value, type);
    }

    public static Resolution to_Resolution(double value) {
        return Resolution.fromDotsPerInch(value);
    }

    public static Resolution to_Resolution(float value) {
        return Resolution.fromDotsPerInch(value);
    }

    public static Resolution op_Addition(Resolution a, Resolution b) {
        double d = Numeric.lI.lI(a, b);
        d = converter.lI(d, a.getUnitType().getFraction(), a.getUnitType());
        return new Resolution(d, a.getUnitType());
    }

    public static Resolution op_Subtraction(Resolution a, Resolution b) {
        double d = Numeric.lI.lf(a, b);
        d = converter.lI(d, a.getUnitType().getFraction(), a.getUnitType());
        return new Resolution(d, a.getUnitType());
    }

    public static boolean op_LessThan(Resolution a, Resolution b) {
        return Numeric.lI.lt(a, b);
    }

    public static boolean op_GreaterThan(Resolution a, Resolution b) {
        return Numeric.lI.ld(a, b);
    }

    public static boolean op_LessThanOrEqual(Resolution a, Resolution b) {
        return Numeric.lI.lb(a, b);
    }

    public static boolean op_GreaterThanOrEqual(Resolution a, Resolution b) {
        return Numeric.lI.lu(a, b);
    }

    public static boolean op_Equality(Resolution a, Resolution b) {
        if (l8t.lf(a, b)) {
            return true;
        }
        if (l8t.lf(a, null)) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean op_Inequality(Resolution a, Resolution b) {
        return !Resolution.op_Equality(a, b);
    }

    @Override
    protected double onConvert(double value, UnitType fromType, UnitType toType) {
        return converter.lI(value, fromType, toType);
    }
}

