/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom;

import com.aspose.pdf.internal.html.collections.NamedNodeMap;
import com.aspose.pdf.internal.html.collections.NodeList;
import com.aspose.pdf.internal.html.dom.CharacterData;
import com.aspose.pdf.internal.html.dom.Comment;
import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.EventTarget;
import com.aspose.pdf.internal.html.dom.ProcessingInstruction;
import com.aspose.pdf.internal.html.dom.Text;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMParameterAttribute;
import com.aspose.pdf.internal.html.dom.events.IEventListener;
import com.aspose.pdf.internal.html.dom.events.lt;
import com.aspose.pdf.internal.html.dom.l0t;
import com.aspose.pdf.internal.html.dom.lc;
import com.aspose.pdf.internal.html.dom.lv;
import com.aspose.pdf.internal.html.dom.traversal.filters.lI;
import com.aspose.pdf.internal.html.dom.traversal.lj;
import com.aspose.pdf.internal.html.dom.xpath.IXPathNSResolver;
import com.aspose.pdf.internal.html.lf;
import com.aspose.pdf.internal.l37y.lh;
import com.aspose.pdf.internal.l37y.lk;
import com.aspose.pdf.internal.l37y.lu;
import com.aspose.pdf.internal.l70u.l1j;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l7n;
import com.aspose.pdf.internal.ms.System.l8t;

@DOMObjectAttribute
@DOMNameAttribute(name="Node")
public abstract class Node
extends EventTarget
implements IXPathNSResolver {
    @DOMNameAttribute(name="ELEMENT_NODE")
    public static final int ELEMENT_NODE = 1;
    @DOMNameAttribute(name="ATTRIBUTE_NODE")
    public static final int ATTRIBUTE_NODE = 2;
    @DOMNameAttribute(name="TEXT_NODE")
    public static final int TEXT_NODE = 3;
    @DOMNameAttribute(name="CDATA_SECTION_NODE")
    public static final int CDATA_SECTION_NODE = 4;
    @DOMNameAttribute(name="ENTITY_REFERENCE_NODE")
    public static final int ENTITY_REFERENCE_NODE = 5;
    @DOMNameAttribute(name="ENTITY_NODE")
    public static final int ENTITY_NODE = 6;
    @DOMNameAttribute(name="PROCESSING_INSTRUCTION_NODE")
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    @DOMNameAttribute(name="COMMENT_NODE")
    public static final int COMMENT_NODE = 8;
    @DOMNameAttribute(name="DOCUMENT_NODE")
    public static final int DOCUMENT_NODE = 9;
    @DOMNameAttribute(name="DOCUMENT_TYPE_NODE")
    public static final int DOCUMENT_TYPE_NODE = 10;
    @DOMNameAttribute(name="DOCUMENT_FRAGMENT_NODE")
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    @DOMNameAttribute(name="NOTATION_NODE")
    public static final int NOTATION_NODE = 12;
    @DOMNameAttribute(name="DOCUMENT_POSITION_DISCONNECTED")
    private static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    @DOMNameAttribute(name="DOCUMENT_POSITION_PRECEDING")
    private static final int DOCUMENT_POSITION_PRECEDING = 2;
    @DOMNameAttribute(name="DOCUMENT_POSITION_FOLLOWING")
    private static final int DOCUMENT_POSITION_FOLLOWING = 4;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINS")
    private static final int DOCUMENT_POSITION_CONTAINS = 8;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINED_BY")
    private static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    @DOMNameAttribute(name="DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC")
    private static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    protected Node parentNode;
    private Document ownerDocument;
    private Node previousSibling;
    private Node nextSibling;
    private Node firstChild;
    private NodeList childNodes;
    private lv namespaceResolver;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<lh> auto_RegisteredObservers;
    private String auto_LocalName;
    private String auto_NamespaceURI;
    private String auto_Prefix;

    protected Node(Document document) {
        this.ownerDocument = document;
        this.childNodes = new com.aspose.pdf.internal.html.collections.lt(this, new lI(this));
        l0t.lI(this);
        this.namespaceResolver = new lc(this);
        this._EventListenerInvoker = lt.lI(this);
        this.setRegisteredObservers(new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<lh>());
    }

    private static void replaceAll(final Node node, final Node parent) {
        final com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node> l0t2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(parent.childNodes);
        final com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node> l0t3 = node == null ? new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t() : (lb.lt((Object)node.getNodeType(), 8) == lb.lt((Object)11, 8) ? new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(node.childNodes) : new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
            {
                this.add(node);
            }
        });
        for (Node node2 = parent.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            Node.remove(node3, parent, true);
        }
        if (node != null) {
            parent.insertBefore(node, null);
        }
        ((lf)parent.ownerDocument.getContext()).lI(new lu(){
            {
                this.lI("childList");
                this.lI(parent);
                this.lI(l0t3);
                this.lf(l0t2);
            }
        });
    }

    private static void remove(Node node, Node parent) {
        Node.remove(node, parent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(final Node node, final Node parent, boolean suppressObserversFlag) {
        Object object;
        Node node2 = node.previousSibling;
        if (!suppressObserversFlag) {
            object = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
                {
                    this.add(node);
                }
            };
            ((lf)parent.ownerDocument.getContext()).lI(new lu((com.aspose.pdf.internal.ms.System.Collections.Generic.l0t)object, node, node2){
                final /* synthetic */ com.aspose.pdf.internal.ms.System.Collections.Generic.l0t lf;
                final /* synthetic */ Node lj;
                final /* synthetic */ Node lt;
                {
                    this.lf = l0t2;
                    this.lj = node2;
                    this.lt = node3;
                    this.lI("childList");
                    this.lI(parent);
                    this.lf(this.lf);
                    this.lj(this.lj.getNextSibling());
                    this.lf(this.lt);
                }
            });
        }
        object = node.parentNode;
        while (object != null) {
            com.aspose.pdf.internal.ms.System.Collections.Generic.lk lk2 = ((Node)object).getRegisteredObservers().iterator();
            try {
                while (lk2.hasNext()) {
                    lh lh2 = (lh)lk2.next();
                    if (!lh2.lf().lt()) continue;
                    node.getRegisteredObservers().addItem(new lk(lh2.lf(), lh2.lI(), lh2));
                }
            }
            finally {
                if (lb.lf((Object)lk2, l5f.class)) {
                    ((l5f)lk2).dispose();
                }
            }
            object = ((Node)object).parentNode;
        }
        parent.removeChild(node);
    }

    public com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<lh> getRegisteredObservers() {
        return this.auto_RegisteredObservers;
    }

    private void setRegisteredObservers(com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<lh> value) {
        this.auto_RegisteredObservers = value;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public boolean isFirstChild() {
        return l0t.lI((DOMObject)this).lf(l0t.lu);
    }

    public boolean isReadOnly() {
        return l0t.lI((DOMObject)this).lf(l0t.le);
    }

    public void setReadOnly(boolean value) {
        l0t.lI((DOMObject)this).lf(l0t.le, value);
    }

    @DOMNameAttribute(name="nodeType")
    public abstract int getNodeType();

    @DOMNameAttribute(name="localName")
    public String getLocalName() {
        return this.auto_LocalName;
    }

    @DOMNameAttribute(name="localName")
    protected void setLocalName(String value) {
        this.auto_LocalName = value;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.auto_NamespaceURI;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    protected void setNamespaceURI(String value) {
        this.auto_NamespaceURI = value;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.auto_Prefix;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public void setPrefix(String value) {
        this.auto_Prefix = value;
    }

    @DOMNameAttribute(name="nodeName")
    public abstract String getNodeName();

    @DOMNameAttribute(name="baseURI")
    public String getBaseURI() {
        if (this.getOwnerDocument() == null) {
            return null;
        }
        return this.getOwnerDocument().getBaseURI();
    }

    @DOMNameAttribute(name="ownerDocument")
    @DOMNullableAttribute
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    @DOMNameAttribute(name="ownerDocument")
    @DOMNullableAttribute
    public void setOwnerDocument(Document value) {
        this.ownerDocument = value;
        Node node = this.firstChild;
        while (node != null) {
            node.setOwnerDocument(value);
            node = node.nextSibling;
        }
    }

    @DOMNameAttribute(name="parentNode")
    @DOMNullableAttribute
    public Node getParentNode() {
        return this.parentNode;
    }

    @DOMNameAttribute(name="parentElement")
    @DOMNullableAttribute
    public Element getParentElement() {
        if (this.getParentNode() == null || lb.lt((Object)this.getParentNode().getNodeType(), 8) != lb.lt((Object)1, 8)) {
            return null;
        }
        return (Element)this.getParentNode();
    }

    @DOMNameAttribute(name="hasChildNodes")
    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    @DOMNameAttribute(name="childNodes")
    public NodeList getChildNodes() {
        return this.childNodes;
    }

    @DOMNameAttribute(name="firstChild")
    public Node getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(boolean value) {
        l0t.lI((DOMObject)this).lf(l0t.lu, value);
    }

    @DOMNameAttribute(name="lastChild")
    public Node getLastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    @DOMNameAttribute(name="previousSibling")
    public Node getPreviousSibling() {
        return this.isFirstChild() ? null : this.previousSibling;
    }

    @DOMNameAttribute(name="nextSibling")
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @DOMNameAttribute(name="attributes")
    public NamedNodeMap getAttributes() {
        return null;
    }

    @DOMNameAttribute(name="nodeValue")
    public String getNodeValue() {
        switch (this.getNodeType()) {
            case 3: {
                return ((Text)this).getData();
            }
            case 7: {
                return ((ProcessingInstruction)this).getData();
            }
            case 8: {
                return ((Comment)this).getData();
            }
        }
        return null;
    }

    @DOMNameAttribute(name="nodeValue")
    public void setNodeValue(String value) {
        switch (this.getNodeType()) {
            case 3: 
            case 8: {
                CharacterData characterData = (CharacterData)this;
                String string = value;
                if (string == null) {
                    string = l10l.lI;
                }
                characterData.replaceData(0, characterData.getLength(), string);
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)this;
                String string = value;
                if (string == null) {
                    string = l10l.lI;
                }
                processingInstruction.setData(string);
                break;
            }
        }
    }

    @DOMNameAttribute(name="textContent")
    public String getTextContent() {
        switch (this.getNodeType()) {
            case 1: 
            case 11: {
                if (this.childNodes.getLength() == 0) {
                    return l10l.lI;
                }
                lj lj2 = new lj(this, 4L, null);
                l1j l1j2 = new l1j();
                while (lj2.nextNode() != null) {
                    l1j2.lI(lj2.getCurrentNode());
                }
                return l1j2.toString();
            }
            case 3: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    @DOMNameAttribute(name="textContent")
    public void setTextContent(String value) {
        switch (this.getNodeType()) {
            case 1: 
            case 11: {
                Node.replaceAll(l10l.lf(value) ? null : new Text(value, this.ownerDocument), this);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                CharacterData characterData = (CharacterData)this;
                String string = value;
                if (string == null) {
                    string = l10l.lI;
                }
                characterData.replaceData(0, characterData.getLength(), string);
                break;
            }
        }
    }

    @DOMNameAttribute(name="normalize")
    public void normalize() {
        lj lj2 = new lj(this, 4L, null);
        while (lj2.nextNode() != null) {
            Text text = (Text)lj2.getCurrentNode();
            int n = text.getLength();
            if (n == 0) {
                text.parentNode.removeChild(text);
                continue;
            }
            l1j l1j2 = new l1j();
            Node node = text.getNextSibling();
            while (node != null && lb.lt((Object)node.getNodeType(), 8) == lb.lt((Object)3, 8)) {
                Text text2 = (Text)node;
                l1j2.lI(text2.getData());
                n += text2.getLength();
                text.parentNode.removeChild(node);
                node = text.getNextSibling();
            }
            text.replaceData(text.getLength(), 0, l1j2.toString());
        }
    }

    @DOMNameAttribute(name="cloneNode")
    public abstract Node cloneNode(@DOMParameterAttribute(name="deep", optional=true) boolean var1);

    @DOMNameAttribute(name="isEqualNode")
    public boolean isEqualNode(@DOMNullableAttribute Node arg) {
        return this.isSameNode(arg);
    }

    @DOMNameAttribute(name="isSameNode")
    public boolean isSameNode(Node other) {
        return l8t.lf(this, other);
    }

    @DOMNameAttribute(name="compareDocumentPosition")
    private short compareDocumentPosition(Node other) {
        throw new l7n();
    }

    @DOMNameAttribute(name="lookupPrefix")
    public String lookupPrefix(@DOMNullableAttribute String namespaceURI) {
        return this.namespaceResolver.lf(namespaceURI);
    }

    @Override
    @DOMNameAttribute(name="lookupNamespaceURI")
    public String lookupNamespaceURI(@DOMNullableAttribute String prefix) {
        return this.namespaceResolver.lI(prefix);
    }

    @DOMNameAttribute(name="isDefaultNamespace")
    public boolean isDefaultNamespace(@DOMNullableAttribute String namespaceURI) {
        return this.namespaceResolver.lj(namespaceURI);
    }

    @DOMNameAttribute(name="insertBefore")
    public Node insertBefore(final Node newChild, @DOMNullableAttribute Node refChild) {
        Object object;
        Node node;
        Node node2;
        if (newChild == refChild) {
            refChild = refChild.getNextSibling();
            this.removeChild(newChild);
            this.insertBefore(newChild, refChild);
            return newChild;
        }
        if (this.ownerDocument.getStrictErrorChecking()) {
            if (this.isAncestorNode(newChild, this)) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("HierarchyRequestError");
            }
            if (newChild.getOwnerDocument() != this.ownerDocument) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("WrongDocumentError");
            }
            if (this.isReadOnly()) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("NoModificationAllowedError");
            }
            if (refChild != null && refChild.getParentNode() != this) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("NotFoundError");
            }
        }
        if ((node2 = (node = newChild).getParentNode()) != null) {
            node2.removeChild(node);
        }
        node.parentNode = this;
        Node node3 = refChild;
        if (node3 == null) {
            if (this.firstChild == null) {
                this.firstChild = node;
                node.setFirstChild(true);
                node.previousSibling = node;
            } else {
                object = this.firstChild.previousSibling;
                ((Node)object).nextSibling = node;
                node.previousSibling = object;
                this.firstChild.previousSibling = node;
            }
        } else if (this.firstChild == node3) {
            object = this.firstChild.previousSibling;
            this.firstChild.setFirstChild(false);
            node.nextSibling = this.firstChild;
            node.previousSibling = object;
            this.firstChild.previousSibling = node;
            this.firstChild = node;
            node.setFirstChild(true);
        } else {
            object = node3.previousSibling;
            node.nextSibling = node3;
            ((Node)object).nextSibling = node;
            node3.previousSibling = node;
            node.previousSibling = object;
        }
        if (!this.getObjectState().lf(l0t.lh)) {
            object = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
                {
                    this.add(newChild);
                }
            };
            ((lf)this.ownerDocument.getContext()).lI(new lu((com.aspose.pdf.internal.ms.System.Collections.Generic.l0t)object){
                final /* synthetic */ com.aspose.pdf.internal.ms.System.Collections.Generic.l0t lI;
                {
                    this.lI = l0t2;
                    this.lI("childList");
                    this.lI(Node.this);
                    this.lI(this.lI);
                    this.lf(new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>());
                }
            });
        }
        return newChild;
    }

    @DOMNameAttribute(name="replaceChild")
    public Node replaceChild(final Node newChild, final @DOMNullableAttribute Node oldChild) {
        Node node = oldChild.getNextSibling();
        this.getObjectState().lf(l0t.lh, true);
        this.removeChild(oldChild);
        this.insertBefore(newChild, node);
        this.getObjectState().lf(l0t.lh, false);
        final com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node> l0t2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
            {
                this.add(newChild);
            }
        };
        final com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node> l0t3 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
            {
                this.add(oldChild);
            }
        };
        ((lf)this.ownerDocument.getContext()).lI(new lu(){
            {
                this.lI("childList");
                this.lI(Node.this);
                this.lI(l0t2);
                this.lf(l0t3);
            }
        });
        return oldChild;
    }

    @DOMNameAttribute(name="removeChild")
    public Node removeChild(Node oldChild) {
        Object object;
        Node node;
        if (this.ownerDocument.getStrictErrorChecking()) {
            if (this.isReadOnly()) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("NoModificationAllowedError");
            }
            if (oldChild != null && oldChild.getParentNode() != this) {
                throw com.aspose.pdf.internal.l31h.lI.lI().lf("NotFoundError");
            }
        }
        if (this.firstChild == (node = oldChild)) {
            node.setFirstChild(false);
            this.firstChild = node.nextSibling;
            if (this.firstChild != null) {
                this.firstChild.setFirstChild(true);
                this.firstChild.previousSibling = node.previousSibling;
            }
        } else {
            Node node2;
            object = node.previousSibling;
            ((Node)object).nextSibling = node2 = node.nextSibling;
            if (node2 == null) {
                this.firstChild.previousSibling = object;
            } else {
                node2.previousSibling = object;
            }
        }
        node.setOwnerDocument(this.ownerDocument);
        node.parentNode = null;
        node.nextSibling = null;
        node.previousSibling = null;
        if (!this.getObjectState().lf(l0t.lh)) {
            object = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>(){
                {
                    this.add(node);
                }
            };
            ((lf)this.ownerDocument.getContext()).lI(new lu((com.aspose.pdf.internal.ms.System.Collections.Generic.l0t)object){
                final /* synthetic */ com.aspose.pdf.internal.ms.System.Collections.Generic.l0t lI;
                {
                    this.lI = l0t2;
                    this.lI("childList");
                    this.lI(Node.this);
                    this.lI(new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<Node>());
                    this.lf(this.lI);
                }
            });
        }
        return node;
    }

    @DOMNameAttribute(name="appendChild")
    public Node appendChild(Node newChild) {
        this.insertBefore(newChild, null);
        return newChild;
    }

    @DOMNameAttribute(name="hasAttributes")
    public boolean hasAttributes() {
        return false;
    }

    protected void invoke(IEventListener listener, com.aspose.pdf.internal.html.dom.events.lI event) {
        ((lf)this.getOwnerDocument().getContext()).lI(listener, event);
    }

    private boolean isAncestorNode(Node child, Node parent) {
        for (Node node = parent; node != null; node = node.getParentNode()) {
            if (node != child) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return l10l.lI("{0}, Value=\"{1}\"", new Object[]{this.getNodeName(), this.getNodeValue()});
    }
}

