/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html;

import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.HTMLFormElement;
import com.aspose.pdf.internal.html.HTMLOptionElement;
import com.aspose.pdf.internal.html.IHTMLOptionsCollection;
import com.aspose.pdf.internal.html.collections.lI;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.lu;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLSelectElement")
public class HTMLSelectElement
extends HTMLElement {
    private HTMLFormElement form;
    private int selectedIndex = -1;

    public HTMLSelectElement(lu name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    @DOMNameAttribute(name="selectedIndex")
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @DOMNameAttribute(name="selectedIndex")
    public void setSelectedIndex(int value) {
        if (value < 0 || value > this.getLength() - 1) {
            this.selectedIndex = -1;
        }
        this.selectedIndex = value;
    }

    @DOMNameAttribute(name="value")
    public String getValue() {
        lk lk2 = this.getOptions().iterator();
        try {
            while (lk2.hasNext()) {
                if (!((HTMLOptionElement)lk2.next()).getSelected()) continue;
                String string = ((HTMLOptionElement)lk2.next()).getTextContent();
                return string;
            }
        }
        finally {
            if (lk2 != null) {
                lk2.dispose();
            }
        }
        return l10l.lI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="value")
    public void setValue(String value) {
        lk lk2 = this.getOptions().iterator();
        try {
            while (lk2.hasNext()) {
                ((HTMLOptionElement)lk2.next()).setSelected(false);
            }
            lk2.ah_();
            int n = 0;
            int n2 = -1;
            while (lk2.hasNext()) {
                if (l10l.lb(((Element)lk2.next()).getTextContent(), value)) {
                    n2 = n;
                    ((HTMLOptionElement)lk2.next()).setSelected(true);
                    break;
                }
                ++n;
            }
            this.selectedIndex = n2;
        }
        finally {
            if (lk2 != null) {
                lk2.dispose();
            }
        }
    }

    @DOMNameAttribute(name="length")
    public int getLength() {
        return this.getOptions().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="length")
    public void setLength(int value) {
        if (value == this.getOptions().getLength()) {
            return;
        }
        if (value < 0) {
            value = 0;
        }
        if (value < this.getOptions().getLength()) {
            lk lk2 = this.getOptions().iterator();
            l0t l0t2 = new l0t();
            while (lk2.hasNext()) {
                if (value == 0) {
                    l0t2.addItem(lk2.next());
                    continue;
                }
                --value;
            }
            lk lk3 = l0t2.iterator();
            try {
                while (lk3.hasNext()) {
                    Node node = (Node)lk3.next();
                    this.removeChild(node);
                }
            }
            finally {
                if (lb.lf((Object)lk3, l5f.class)) {
                    ((l5f)lk3).dispose();
                }
            }
            return;
        }
        for (int i = value - this.getOptions().getLength(); i != 0; --i) {
            this.appendChild(this.getOwnerDocument().createElement("OPTION"));
        }
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    @DOMNameAttribute(name="options")
    public IHTMLOptionsCollection getOptions() {
        return new lI((Node)this, "OPTION");
    }

    @DOMNameAttribute(name="disabled")
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @DOMNameAttribute(name="disabled")
    public void setDisabled(boolean value) {
        this.toggleAttribute("disabled", value);
    }

    @DOMNameAttribute(name="multiple")
    public boolean getMultiple() {
        return this.hasAttribute("multiple");
    }

    @DOMNameAttribute(name="multiple")
    public void setMultiple(boolean value) {
        this.toggleAttribute("multiple", value);
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.getAttributeOrDefault("name", l10l.lI);
    }

    @DOMNameAttribute(name="name")
    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @DOMNameAttribute(name="size")
    public int getSize() {
        return this.getAttributeOrDefault("size", 0);
    }

    @DOMNameAttribute(name="size")
    public void setSize(int value) {
        this.setAttribute("size", value);
    }

    @DOMNameAttribute(name="tabIndex")
    public int getTabIndex() {
        return this.getAttributeOrDefault("tabindex", 0);
    }

    @DOMNameAttribute(name="tabIndex")
    public void setTabIndex(int value) {
        this.setAttribute("tabindex", value);
    }

    @DOMNameAttribute(name="add")
    public void add(HTMLElement element, HTMLElement before) {
    }

    @DOMNameAttribute(name="remove")
    public void remove(int index) {
    }

    @DOMNameAttribute(name="blur")
    public void blur() {
    }

    @DOMNameAttribute(name="focus")
    public void focus() {
    }
}

