/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.DocumentInfo;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XmpValue;
import com.aspose.pdf.exceptions.InvalidPasswordException;
import com.aspose.pdf.facades.DocumentPrivilege;
import com.aspose.pdf.facades.PdfXmpMetadata;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.l0k.lI;
import com.aspose.pdf.internal.l11h.lt;
import com.aspose.pdf.internal.l5n.l1f;
import com.aspose.pdf.internal.l68p.lv;
import com.aspose.pdf.internal.l6t.lf;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l3t;
import com.aspose.pdf.internal.ms.System.l5if;
import com.aspose.pdf.internal.ms.System.l7f;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileInfo
extends SaveableFacade {
    private static final Logger lI = Logger.getLogger(PdfFileInfo.class.getName());
    private String lf;
    private InputStream lj;
    private boolean lt;
    private String lb = null;
    private Map<String, String> ld;
    private boolean lu = false;
    private static final String le = "xmp";
    private static final String lh = "http://ns.adobe.com/xap/1.0/";

    @Override
    protected void lI(Stream stream, String string) {
        try {
            super.lI(stream, string);
            this.lI();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            lI.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.lb = invalidPasswordException.getMessage();
            this.lu = true;
            this.lt = true;
        }
        catch (RuntimeException runtimeException) {
            lI.log(Level.INFO, "Exception occur", runtimeException);
            this.lb = runtimeException.getMessage();
            this.lt = false;
        }
    }

    @Override
    public void bindPdf(String srcFile, String password) {
        try {
            super.bindPdf(srcFile, password);
            this.lI();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            lI.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.lb = invalidPasswordException.getMessage();
            this.lu = true;
        }
        catch (RuntimeException runtimeException) {
            lI.log(Level.INFO, "Exception occur", runtimeException);
            this.lb = runtimeException.getMessage();
            this.lt = false;
        }
    }

    public void bindPdf(Document srcDoc) {
        super.bindPdf(srcDoc);
        this.lt = true;
    }

    private void lI() {
        this.lt();
        this.lt = true;
        this.ld = new HashMap<String, String>();
        for (ly ly2 : this.getDocument().getInfo()) {
            if (DocumentInfo.isPredefinedKey((String)ly2.lI())) continue;
            this.ld.put((String)ly2.lI(), (String)ly2.lf());
        }
        this.getDocument().getPages().get_Item(1);
    }

    @Override
    protected void lt() {
        if (this.lv == null) {
            String string = "PdfFileInfo is not initialized. Use constructors with parameters or properties for initialization.";
            if (this.lf != null) {
                string = l10l.lI(string, l10l.lI(new String[]{" (File: ", this.lf, ")"}));
            }
            if (this.lb != null) {
                string = l10l.lI(string, l10l.lI(new String[]{" (Reason: ", this.lb, ")"}));
            }
            throw new l7f(string);
        }
    }

    public String getAuthor() {
        this.lt();
        return this.lv.getInfo().getAuthor();
    }

    public void setAuthor(String value) {
        this.lt();
        this.getDocument().getInfo().setAuthor(value);
    }

    public boolean isEncrypted() {
        if (this.lu) {
            return true;
        }
        this.lt();
        return this.getDocument().isEncrypted();
    }

    public boolean isPdfFile() {
        return this.lt;
    }

    public String getCreationDate() {
        this.lt();
        if (this.getDocument().getInfo().containsKey("CreationDate")) {
            return this.getDocument().getInfo().get_Item("CreationDate");
        }
        return null;
    }

    public void setCreationDate(String value) {
        this.lt();
        this.getDocument().getInfo().setCreationDate(l3t.lt(com.aspose.pdf.internal.l6t.lf.lI(new l1f(this.getDocument().getEngineDoc().lf(), value)).lI().l1y()));
    }

    public String getCreator() {
        this.lt();
        return this.getDocument().getInfo().getCreator();
    }

    public void setCreator(String value) {
        this.lt();
        InternalHelper.lI(this.getDocument().getInfo(), value);
    }

    public boolean hasCollection() {
        this.lt();
        return this.getDocument().getCollection() != null;
    }

    public Map<String, String> getHeader() {
        return this.ld;
    }

    public void setHeader(Map<String, String> value) {
        this.ld = value;
    }

    @Deprecated
    public String getInputFile() {
        return this.lf;
    }

    @Deprecated
    public void setInputFile(String value) {
        this.lf = value;
        this.bindPdf(value, null);
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.lj;
    }

    @Deprecated
    public void setInputStream(InputStream value) {
        this.lj = value;
        this.bindPdf(value, null);
    }

    public String getKeywords() {
        this.lt();
        return this.lv.getInfo().getKeywords();
    }

    public void setKeywords(String value) {
        this.lt();
        this.getDocument().getInfo().setKeywords(value);
    }

    public String getModDate() {
        this.lt();
        if (this.getDocument().getInfo().containsKey("ModDate")) {
            return this.getDocument().getInfo().get_Item("ModDate");
        }
        return null;
    }

    public void setModDate(String value) {
        this.lt();
        this.getDocument().getInfo().setModDate(l3t.lt(com.aspose.pdf.internal.l6t.lf.lI(new l1f(this.getDocument().getEngineDoc().lf(), value)).lI().l1y()));
    }

    public int getNumberOfPages() {
        this.lt();
        return this.getDocument().getPages().size();
    }

    public String getProducer() {
        this.lt();
        return this.getDocument().getInfo().getProducer();
    }

    public String getSubject() {
        this.lt();
        return this.getDocument().getInfo().getSubject();
    }

    public void setSubject(String value) {
        this.lt();
        this.getDocument().getInfo().setSubject(value);
    }

    public String getTitle() {
        this.lt();
        return this.getDocument().getInfo().getTitle();
    }

    public void setTitle(String value) {
        this.lt();
        this.getDocument().getInfo().setTitle(value);
    }

    public PdfFileInfo() {
    }

    public PdfFileInfo(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfFileInfo(InputStream inputStream, String password) {
        this.lj = inputStream;
        this.bindPdf(inputStream, password);
    }

    public PdfFileInfo(String inputFile) {
        this(inputFile, null);
    }

    public PdfFileInfo(String inputFile, String password) {
        this.lf = inputFile;
        this.bindPdf(inputFile, password);
    }

    public void clearInfo() {
        this.lt();
        this.getDocument().getInfo().clear();
        this.ld.clear();
    }

    public DocumentPrivilege getDocumentPrivilege() {
        this.lt();
        return new DocumentPrivilege(this.getDocument().getPermissions());
    }

    public String getMetaInfo(String name) {
        this.lt();
        if (!DocumentInfo.isPredefinedKey(name) && this.ld.containsKey(name)) {
            return this.ld.get(name);
        }
        return l10l.lI;
    }

    public float getPageHeight(int pageNum) {
        this.lt();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getHeight();
    }

    public int getPageRotation(int pageNum) {
        this.lt();
        switch (this.getDocument().getPages().get_Item(pageNum).getRotate()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public float getPageWidth(int pageNum) {
        this.lt();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getWidth();
    }

    public float getPageXOffset(int pageNum) {
        this.lt();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLX();
    }

    public float getPageYOffset(int pageNum) {
        this.lt();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLY();
    }

    public String getPdfVersion() {
        this.lt();
        return this.getDocument().getVersion();
    }

    @Deprecated
    public boolean saveNewInfo(OutputStream outputStream) {
        this.lt();
        try {
            this.save(outputStream);
            return true;
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            return false;
        }
    }

    public boolean saveNewInfo(String outputFile) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.saveNewInfo(fileOutputStream);
        }
        catch (Exception exception) {
            lI.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream destStream) {
        this.lI(l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            destStream.write(byArray);
        }
    }

    @Override
    void lI(Stream stream) {
        this.lf();
        InternalHelper.lI(this.getDocument(), stream);
    }

    private void lf() {
        this.lt();
        this.getDocument().getInfo().clearCustomData();
        for (Map.Entry<String, String> entry : this.ld.entrySet()) {
            this.getDocument().getInfo().addItem(entry.getKey(), entry.getValue());
        }
    }

    public void setMetaInfo(String name, String value) {
        this.lt();
        if (this.ld.containsKey(name)) {
            this.ld.remove(name);
        }
        this.ld.put(name, value);
    }

    public boolean saveNewInfoWithXmp(String outputFileName) {
        PdfXmpMetadata pdfXmpMetadata = new PdfXmpMetadata();
        pdfXmpMetadata.bindPdf(this.lf);
        IDocument iDocument = pdfXmpMetadata.getDocument();
        this.getDocument().getMetadata().registerNamespaceUri(le, lh);
        if (this.getAuthor() != null) {
            iDocument.getInfo().setAuthor(this.getAuthor());
            pdfXmpMetadata.set_Item("dc:creator", new XmpValue(new XmpValue[]{new XmpValue(this.getAuthor())}));
        }
        if (this.getCreator() != null) {
            InternalHelper.lI(iDocument.getInfo(), this.getCreator());
            pdfXmpMetadata.set_Item("xmp:CreatorTool", new XmpValue(this.getCreator()));
        }
        if (this.getKeywords() != null) {
            iDocument.getInfo().setKeywords(this.getKeywords());
            pdfXmpMetadata.set_Item("pdf:Keywords", new XmpValue(this.getKeywords()));
        }
        if (this.getSubject() != null) {
            iDocument.getInfo().setSubject(this.getSubject());
            pdfXmpMetadata.set_Item("dc:description", new XmpValue(new XmpValue[]{new XmpValue(this.getSubject())}));
        }
        if (this.getTitle() != null) {
            iDocument.getInfo().setTitle(this.getTitle());
            pdfXmpMetadata.set_Item("dc:title", new XmpValue(new XmpValue[]{new XmpValue(this.getTitle())}));
        }
        pdfXmpMetadata.set_Item("pdf:Producer", new XmpValue(com.aspose.pdf.internal.l0k.lI.le));
        if (this.getCreationDate() != null) {
            iDocument.getInfo().setCreationDate(this.getDocument().getInfo().getCreationDate());
            pdfXmpMetadata.set_Item("xmp:CreateDate", new XmpValue(PdfFileInfo.lI(l3t.lI(this.lv.getInfo().getCreationDate()))));
        }
        if (this.getModDate() != null) {
            iDocument.getInfo().setModDate(this.getDocument().getInfo().getModDate());
            pdfXmpMetadata.set_Item("xmp:ModifyDate", new XmpValue(PdfFileInfo.lI(l3t.lI(this.lv.getInfo().getModDate()))));
        }
        for (Map.Entry<String, String> object : this.ld.entrySet()) {
            pdfXmpMetadata.registerNamespaceURI("pdfx", "http://ns.adobe.com/pdfx/1.3/");
            pdfXmpMetadata.addItem(l10l.lI(new String[]{"pdfx:", object.getKey()}), new XmpValue(object.getValue()));
        }
        for (String string : this.ld.keySet()) {
            iDocument.getInfo().removeItemByKey(string);
        }
        for (Map.Entry entry : this.ld.entrySet()) {
            iDocument.getInfo().addItem((String)entry.getKey(), (String)entry.getValue());
        }
        iDocument.save(outputFileName);
        return true;
    }

    public PdfFileInfo(IDocument document) {
        super(document);
    }

    private static String lI(l3t l3t2) {
        String string = l3t2.lf("yyyy-MM-ddTHH\\:mm\\:ss\\.fff");
        string = l10l.lI(string, l3t.lI(l3t2, "zzz", com.aspose.pdf.internal.l68p.lv.l1if()));
        return string;
    }

    public int getPasswordType() {
        if (this.lu) {
            return 3;
        }
        if (this.isEncrypted() && this.getDocument() != null) {
            lt lt2 = this.getDocument().getEngineDoc().lf().l6if();
            if (lt2.lI(lt2.lb())) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean hasOpenPassword() {
        lt lt2 = this.getDocument() != null ? this.getDocument().getEngineDoc().lf().l6if() : null;
        switch (this.getPasswordType()) {
            case 3: {
                return true;
            }
            case 1: {
                return !l10l.lb(lt2.lb(), l10l.lI);
            }
            case 2: {
                return !lt2.lI(l10l.lI);
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public boolean hasEditPassword() {
        switch (this.getPasswordType()) {
            case 1: {
                lt lt2 = this.getDocument().getEngineDoc().lf().l6if();
                return !lt2.lf(lt2.lb());
            }
            case 3: {
                throw new InvalidPasswordException("Document must be opened with valid password in order to read this property.");
            }
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        this.lj = null;
        this.lf = null;
        this.ld = null;
        this.lt = false;
        this.lu = false;
        this.lb = null;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lI.setUseParentHandlers(false);
    }
}

