/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.BmpDevice;
import com.aspose.pdf.devices.EmfDevice;
import com.aspose.pdf.devices.GifDevice;
import com.aspose.pdf.devices.GraphicsDevice;
import com.aspose.pdf.devices.ImageDevice;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.PngDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffDevice;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.l5n.ld;
import com.aspose.pdf.internal.l5n.lh;
import com.aspose.pdf.internal.l67k.l0n;
import com.aspose.pdf.internal.l67k.l13h;
import com.aspose.pdf.internal.l67k.l13j;
import com.aspose.pdf.internal.l67k.l1v;
import com.aspose.pdf.internal.l67k.l2l;
import com.aspose.pdf.internal.l67k.lf;
import com.aspose.pdf.internal.l68l.l1h;
import com.aspose.pdf.internal.l70k.l30p;
import com.aspose.pdf.internal.l70k.l30y;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l0if;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.IO.l1t;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5if;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfConverter
extends Facade {
    private static final Logger lI = Logger.getLogger(PdfConverter.class.getName());
    private Resolution lf = new Resolution(150);
    private int lj = 1;
    private int lt = Integer.MAX_VALUE;
    private int lb = 1;
    private String ld;
    private String lu;
    private int le = 0;
    private RenderingOptions lh = new RenderingOptions();
    private boolean lk = true;
    private boolean lc = false;
    private int ly = 1;

    public int getCoordinateType() {
        return this.ly;
    }

    public void setCoordinateType(int value) {
        this.ly = value;
    }

    @Deprecated
    public boolean isShowHiddenAreas() {
        return this.lk;
    }

    @Deprecated
    public void setShowHiddenAreas(boolean value) {
        this.lc = true;
        this.lk = value;
    }

    private ImageDevice lI(float f, float f2, int n, int n2, l13j l13j2, float f3, Resolution resolution, int n3, boolean bl, int n4, int n5, boolean bl2) {
        GraphicsDevice graphicsDevice = new GraphicsDevice(new Point(f, f2), n, n2, l13j2.ly(), f3, resolution, n3, bl, n4, n5, bl2);
        graphicsDevice.setFormPresentationMode(this.getFormPresentationMode());
        graphicsDevice.setRenderingOptions(this.getRenderingOptions());
        return graphicsDevice;
    }

    private ImageDevice lI(ImageType imageType, int n, int n2, Resolution resolution, int n3) {
        ImageDevice imageDevice = null;
        if (InternalHelper.lI(imageType) == l1h.lk()) {
            imageDevice = new JpegDevice(n, n2, resolution, n3);
        } else if (InternalHelper.lI(imageType) == l1h.lc()) {
            imageDevice = new PngDevice(n, n2, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.lb()) {
            imageDevice = new BmpDevice(n, n2, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.le()) {
            imageDevice = new GifDevice(n, n2, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.ld()) {
            imageDevice = new EmfDevice(n, n2, resolution);
        } else {
            if (InternalHelper.lI(imageType) == l1h.ly()) {
                throw new l5if(l10l.lI(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new l5if(l10l.lI(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    private ImageDevice lI(ImageType imageType, PageSize pageSize, Resolution resolution, int n) {
        ImageDevice imageDevice = null;
        if (InternalHelper.lI(imageType) == l1h.lk()) {
            imageDevice = new JpegDevice(pageSize, resolution, n);
        } else if (InternalHelper.lI(imageType) == l1h.lc()) {
            imageDevice = new PngDevice(pageSize, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.lb()) {
            imageDevice = new BmpDevice(pageSize, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.le()) {
            imageDevice = new GifDevice(pageSize, resolution);
        } else if (InternalHelper.lI(imageType) == l1h.ld()) {
            imageDevice = new EmfDevice(pageSize, resolution);
        } else {
            if (InternalHelper.lI(imageType) == l1h.ly()) {
                throw new l5if(l10l.lI(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new l5if(l10l.lI(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    public RenderingOptions getRenderingOptions() {
        return this.lh;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.lh = value;
    }

    public int getFormPresentationMode() {
        return this.le;
    }

    public void setFormPresentationMode(int value) {
        this.le = value;
    }

    public Resolution getResolution() {
        return this.lf;
    }

    public void setResolution(Resolution value) {
        this.lf = value.getX() <= 0 || value.getY() <= 0 ? new Resolution(150) : value;
    }

    public int getStartPage() {
        return this.lj;
    }

    public void setStartPage(int value) {
        this.lb = this.lj = value < 1 ? 1 : value;
    }

    public int getEndPage() {
        this.lt();
        if (this.lt != Integer.MAX_VALUE) {
            return this.lt;
        }
        return this.getDocument().getPages().size();
    }

    public void setEndPage(int value) {
        this.lt();
        int n = this.lt = value > this.getDocument().getPages().size() ? this.getDocument().getPages().size() : value;
        if (this.lt < this.lj) {
            this.lt = this.lj;
        }
    }

    public void setRangeOfPages(int startPage, int EndPage) {
        if (startPage > EndPage) {
            this.lt = startPage > this.lv.getPages().size() ? this.lv.getPages().size() : startPage;
            this.lj = EndPage < 1 ? 1 : EndPage;
        } else {
            this.lt = EndPage > this.lv.getPages().size() ? this.lv.getPages().size() : EndPage;
            this.lj = startPage < 1 ? 1 : startPage;
        }
    }

    public String getPassword() {
        return this.ld;
    }

    public void setPassword(String value) {
        this.ld = value;
    }

    public String getUserPassword() {
        return this.lu;
    }

    public void setUserPassword(String value) {
        this.lu = value;
    }

    public int getPageCount() {
        this.lt();
        return this.getDocument().getPages().size();
    }

    public void doConvert() {
        this.lt();
        this.lb = this.lj;
    }

    public void saveAsTIFF(String outputFile) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI(l1t2);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int compressionType) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, 0, 0, compressionType);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, imageWidth, imageHeight);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, pageSize);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize, TiffSettings settings) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, pageSize, settings);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, int compressionType) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, imageWidth, imageHeight, compressionType);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, imageWidth, imageHeight, settings);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI(l1t2, imageWidth, imageHeight, settings, converter);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, imageWidth, imageHeight);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream, int imageWidth, int imageHeight) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, tiffSettings);
    }

    public void saveAsTIFFClassF(OutputStream outputStream, PageSize pageSize) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, pageSize, tiffSettings);
    }

    public void saveAsTIFF(OutputStream outputStream) {
        this.saveAsTIFF(outputStream, 0, 0, new TiffSettings());
    }

    private void lI(Stream stream) {
        this.lI(stream, 0, 0, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int compressionType) {
        this.saveAsTIFF(outputStream, 0, 0, compressionType);
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize) {
        this.saveAsTIFF(outputStream, pageSize, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize, TiffSettings settings) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), settings);
        tiffDevice.process(this.lv, this.getStartPage(), this.getEndPage(), outputStream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, int compressionType) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings(compressionType));
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    private void lI(Stream stream, int n, int n2, TiffSettings tiffSettings) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.processInternal(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lI(Stream stream, int n, int n2, int n3) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), new TiffSettings(n3));
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.processInternal(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lI(Stream stream, int n, int n2) {
        this.lI(stream, n, n2, new TiffSettings());
    }

    private void lI(Stream stream, int n, int n2, TiffSettings tiffSettings, IIndexBitmapConverter iIndexBitmapConverter) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings, iIndexBitmapConverter);
        tiffDevice.processInternal(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    private void lI(Stream stream, PageSize pageSize) {
        this.lI(stream, pageSize, new TiffSettings());
    }

    private void lI(Stream stream, PageSize pageSize, TiffSettings tiffSettings) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.processInternal(this.getDocument(), this.getStartPage(), this.getEndPage(), stream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        this.lt();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings, converter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    public boolean hasNextImage() {
        this.lt();
        return this.lb <= this.getEndPage();
    }

    public void getNextImage(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public l1j convertPageToPNGMemoryStream(Page page) {
        l1j l1j2 = new l1j();
        Resolution resolution = new Resolution(300);
        PngDevice pngDevice = new PngDevice(resolution);
        pngDevice.processInternal(page, l1j2);
        l1j2.seek(0L, 0);
        return l1j2;
    }

    byte[] lI(Page page) {
        return this.convertPageToPNGMemoryStream(page).lt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] lf(Stream stream) {
        byte[] byArray = new byte[16384];
        l1j l1j2 = new l1j();
        try {
            int n;
            while ((n = stream.read(byArray, 0, byArray.length)) > 0) {
                l1j2.write(byArray, 0, n);
            }
            byte[] byArray2 = l1j2.lt();
            return byArray2;
        }
        finally {
            if (l1j2 != null) {
                l1j2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream) {
        this.getNextImage(outputStream, ImageType.getJpeg(), 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize) {
        this.getNextImage(outputStream, pageSize, ImageType.getJpeg(), 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format) {
        this.lt();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, 100);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format) {
        this.lt();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, pageSize, format, 100);
        }
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight, int quality) {
        this.lt();
        l1j l1j2 = new l1j();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.lI(format, imageWidth, imageHeight, this.getResolution(), quality);
            imageDevice.setCoordinateType(this.ly);
            imageDevice.processInternal(this.lv.getPages().get_Item(this.lb), l1j2);
            ++this.lb;
        }
        try {
            if (l1j2 != null) {
                outputStream.write(l1j2.lt());
            }
            l1j2.close();
        }
        catch (IOException iOException) {
            lI.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public void getNextImage(String outputFile, ImageType format, double imageWidth, double imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, double imageWidth, double imageHeight, int quality) {
        this.getNextImage(outputStream, format, (int)imageWidth, (int)imageHeight, quality);
    }

    private void lI() {
        l30y l30y2;
        if (this.getDocument().getForm().hasXfa() && (l30y2 = this.getDocument().getForm().getXFA().getConfig()) != null) {
            ld ld2;
            lh lh2;
            l30p l30p2 = new l30p(this.getDocument().getForm().getXFA().getConfig().lh().l0f());
            l30p2.lj("cfg", this.getDocument().getForm().getXFA().getConfig().ld());
            l30y l30y3 = l30y2.lf("cfg:acrobat/cfg:acrobat7/cfg:dynamicRender", l30p2);
            if (l30y3 != null && l30y3.lk() != null && l10l.le(l30y3.lk(), "required") != -1 && (lh2 = this.getDocument().getEngineDoc().lf().l5l()).lt("NeedsRendering") && (ld2 = lh2.lj("NeedsRendering").l5p()).lf()) {
                this.getDocument().getForm().setType(0);
            }
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        if (this.getPassword() != null) {
            this.bindPdf(inputFile, this.getPassword());
        } else if (this.getUserPassword() != null) {
            this.bindPdf(inputFile, this.getUserPassword());
        } else {
            this.bindPdf(inputFile, this.getPassword());
        }
        this.lI();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.lu(Stream.fromJava(inputStream));
    }

    @Override
    void lu(Stream stream) {
        this.lI(stream, this.getPassword());
        this.lI();
    }

    public PdfConverter() {
    }

    public PdfConverter(IDocument document) {
        super(document);
        this.lt = this.getDocument().getPages().size();
    }

    @Override
    public void close() {
        super.close();
    }

    public void saveAsTIFFClassF(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, 0, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, 0, 0, tiffSettings);
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI((Stream)l1t2, 0, 0, settings);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings, IIndexBitmapConverter converter) {
        l1t l1t2 = null;
        try {
            l1t2 = l0if.le(outputFile);
            this.lI(l1t2, 0, 0, settings, converter);
        }
        catch (l5if l5if2) {
            lI.log(Level.INFO, "Exception occur", l5if2);
            throw new RuntimeException(l5if2.getMessage());
        }
        finally {
            if (l1t2 != null) {
                try {
                    l1t2.close();
                }
                catch (l5if l5if3) {
                    lI.log(Level.INFO, "Exception occur", l5if3);
                }
            }
        }
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings) {
        this.saveAsTIFF(outputStream, 0, 0, settings);
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings, IIndexBitmapConverter converter) {
        this.saveAsTIFF(outputStream, 0, 0, settings, converter);
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, 100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight) {
        this.getNextImage(outputStream, format, 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int quality) {
        this.lt();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, quality);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format, int quality) {
        this.lt();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.lI(format, pageSize, this.getResolution(), quality);
            if (this.lc) {
                if (!this.lk && !this.getDocument().getPages().get_Item(this.lb).getCropBox().equals(this.getDocument().getPages().get_Item(this.lb).getMediaBox())) {
                    imageDevice.setCoordinateType(0);
                }
            } else {
                imageDevice.setCoordinateType(this.ly);
            }
            imageDevice.process(this.getDocument().getPages().get_Item(this.lb), outputStream);
            ++this.lb;
        }
    }

    public void getNextImage(String outputFile, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, PageSize pageSize, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            lI.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    lI.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lI(l0n l0n2, float f, float f2, int n, int n2, l13j l13j2, float f3, int n3, boolean bl, int n4, int n5, boolean bl2, boolean bl3, boolean bl4) {
        this.lt();
        if (this.hasNextImage()) {
            block22: {
                ImageDevice imageDevice = !bl3 ? (bl4 ? new PngDevice() : this.lI(f, f2, n, n2, l13j2.ly(), f3, this.getResolution(), n3, bl, n4, n5, bl2)) : new PngDevice();
                if (this.lc) {
                    if (!this.lk && !this.getDocument().getPages().get_Item(this.lb).getCropBox().equals(this.getDocument().getPages().get_Item(this.lb).getMediaBox())) {
                        imageDevice.setCoordinateType(0);
                    }
                } else {
                    imageDevice.setCoordinateType(this.ly);
                }
                if (bl3) {
                    l1j l1j2 = new l1j();
                    try {
                        imageDevice.processInternal(this.getDocument().getPages().get_Item(this.lb), l1j2);
                        l1v l1v2 = l1v.lI(l1j2);
                        try {
                            l0n2.lI(l1v2, new l2l(com.aspose.pdf.internal.l82p.lb.lb((Object)Float.valueOf(f), 13), com.aspose.pdf.internal.l82p.lb.lb((Object)Float.valueOf(f2), 13)));
                            break block22;
                        }
                        finally {
                            if (l1v2 != null) {
                                l1v2.dispose();
                            }
                        }
                    }
                    finally {
                        if (l1j2 != null) {
                            l1j2.dispose();
                        }
                    }
                }
                if (bl4) {
                    l1j l1j3 = new l1j();
                    try {
                        imageDevice.processInternal(this.getDocument().getPages().get_Item(this.lb), l1j3);
                        l1j3.setPosition(0L);
                        lf lf2 = InternalHelper.lI(l1j3, this.getDocument());
                        try {
                            l0n2.lI((l1v)lf2, new l13h(0.0f, 0.0f, n, n2));
                            break block22;
                        }
                        finally {
                            if (lf2 != null) {
                                lf2.dispose();
                            }
                        }
                    }
                    finally {
                        if (l1j3 != null) {
                            l1j3.dispose();
                        }
                    }
                }
                imageDevice.process(this.getDocument().getPages().get_Item(this.lb), l0n2);
            }
            ++this.lb;
        }
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        lI.setUseParentHandlers(false);
    }
}

