/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextFragment;
import com.aspose.pdf.TextFragmentAbsorber;
import com.aspose.pdf.TextFragmentCollection;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l0t;
import com.aspose.pdf.internal.l5n.l1p;
import com.aspose.pdf.internal.l5n.lb;
import com.aspose.pdf.internal.l70k.l33if;
import com.aspose.pdf.internal.l70k.l48y;
import com.aspose.pdf.internal.l70u.l1j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l4l;
import com.aspose.pdf.internal.ms.System.l4u;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.internal.ms.System.ly;
import java.util.ArrayList;
import java.util.List;

public abstract class TextMarkupAnnotation
extends MarkupAnnotation {
    TextMarkupAnnotation(l0if annotation, IDocument document) {
        super(annotation, document);
    }

    protected TextMarkupAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        l0n l0n2 = new l0n(page.EnginePage);
        l0n2.lI((l0t)new l1p(this.getRect().getLLX()));
        l0n2.lI((l0t)new l1p(this.getRect().getURY()));
        l0n2.lI((l0t)new l1p(this.getRect().getURX()));
        l0n2.lI((l0t)new l1p(this.getRect().getURY()));
        l0n2.lI((l0t)new l1p(this.getRect().getLLX()));
        l0n2.lI((l0t)new l1p(this.getRect().getLLY()));
        l0n2.lI((l0t)new l1p(this.getRect().getURX()));
        l0n2.lI((l0t)new l1p(this.getRect().getLLY()));
        this.getEngineDict().lf("QuadPoints", (l0t)l0n2);
    }

    @Override
    protected void lf(l48y l48y2) {
        StringBuilder stringBuilder;
        super.lf(l48y2);
        if (this.getEngineDict().lt("QuadPoints")) {
            stringBuilder = new StringBuilder();
            for (Point point : this.getQuadPoints()) {
                stringBuilder.append(l10l.lI(this.lf, "{0},{1},", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        l48y2.lj("coords", stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length()).toString());
    }

    @Override
    protected void lf(l33if l33if2) {
        Point[] pointArray;
        super.lf(l33if2);
        if (l33if2.lt("coords")) {
            String[] stringArray = l10l.ld(l33if2.lj("coords"), ',');
            int n = stringArray.length / 2;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                double d = l4l.lI(stringArray[2 * i], (l6l)this.lf);
                double d2 = l4l.lI(stringArray[2 * i + 1], (l6l)this.lf);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setQuadPoints(pointArray);
    }

    @Override
    void lI(l33if l33if2) {
        this.lf(l33if2);
        super.lI(XfdfReader.lI(l33if2));
    }

    public Point[] getQuadPoints() {
        if (this.getEngineDict().lt("QuadPoints")) {
            lb lb2 = this.getEngineDict().lj("QuadPoints").l5t();
            int n = lb2.lv() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(lb2.lI(2 * i).l5h().lu(), lb2.lI(2 * i + 1).l5h().lu());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoints(Point[] value) {
        l0n l0n2 = new l0n(this.getEngineDict());
        for (Point point : value) {
            l0n2.lI((l0t)new l1p(point.getX()));
            l0n2.lI((l0t)new l1p(point.getY()));
        }
        this.getEngineDict().lI("QuadPoints", (l0t)l0n2);
        this.updateAppearances();
    }

    public String getMarkedText() {
        double d = 0.13;
        l1j l1j2 = new l1j();
        TextFragmentCollection textFragmentCollection = this.getMarkedTextFragments();
        if (textFragmentCollection.size() == 0) {
            return l10l.lI;
        }
        TextFragment textFragment = textFragmentCollection.get_Item(1);
        l1j2.lI(textFragment.getText());
        for (int i = 2; i <= textFragmentCollection.size(); ++i) {
            TextFragment textFragment2 = textFragmentCollection.get_Item(i);
            if (l13p.lI(textFragment.getRectangle().getLLY() - textFragment2.getRectangle().getLLY()) > (double)(textFragment.getTextState().getFontSize() / 2.0f)) {
                l1j2.lI(l4u.le());
            } else if (l13p.lI(textFragment2.getRectangle().getLLX() - textFragment.getRectangle().getURX()) > d * (double)textFragment.getTextState().getFontSize()) {
                l1j2.lI(' ');
            }
            l1j2.lI(textFragment2.getText());
            textFragment = textFragment2;
        }
        return l1j2.toString();
    }

    public TextFragmentCollection getMarkedTextFragments() {
        TextFragmentCollection textFragmentCollection = new TextFragmentCollection();
        List<TextFragmentAbsorber> list = this.l0j();
        for (TextFragmentAbsorber textFragmentAbsorber : list) {
            for (TextFragment textFragment : textFragmentAbsorber.getTextFragments()) {
                textFragmentCollection.add(textFragment);
            }
        }
        return textFragmentCollection;
    }

    private List<TextFragmentAbsorber> l0j() {
        ArrayList<TextFragmentAbsorber> arrayList = new ArrayList<TextFragmentAbsorber>();
        if (this.getQuadPoints() != null) {
            Point[] pointArray = new Point[4];
            for (int i = 0; i < this.getQuadPoints().length; i += 4) {
                ly.lf(ly.lj(this.getQuadPoints()), i, ly.lj(pointArray), 0, 4);
                Rectangle rectangle = new Rectangle(pointArray[0].getX(), pointArray[0].getY(), pointArray[3].getX(), pointArray[3].getY());
                if (!this.getRect().lI(rectangle, 0.0)) continue;
                TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber();
                textFragmentAbsorber.setTextSearchOptions(new TextSearchOptions(false));
                textFragmentAbsorber.getTextSearchOptions().setLimitToPageBounds(true);
                textFragmentAbsorber.getTextSearchOptions().setRectangle(rectangle);
                textFragmentAbsorber.visit(this.lj.getPages().get_Item(this.getPageIndex()));
                arrayList.add(textFragmentAbsorber);
            }
        } else {
            TextFragmentAbsorber textFragmentAbsorber = new TextFragmentAbsorber();
            textFragmentAbsorber.setTextSearchOptions(new TextSearchOptions(false));
            textFragmentAbsorber.getTextSearchOptions().setLimitToPageBounds(true);
            textFragmentAbsorber.getTextSearchOptions().setRectangle(this.getRect());
            arrayList.add(textFragmentAbsorber);
        }
        return arrayList;
    }
}

