/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.internal.l5n.l0h;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l0t;
import com.aspose.pdf.internal.l5n.l1p;
import com.aspose.pdf.internal.l67k.l13h;
import com.aspose.pdf.internal.l67k.l13j;
import com.aspose.pdf.internal.l68p.lh;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.l8f.l0l;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l4l;
import com.aspose.pdf.internal.ms.System.l5if;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.internal.ms.System.lv;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Rectangle
implements Cloneable,
Comparable<Object> {
    private static final Logger lf = Logger.getLogger(Rectangle.class.getName());
    private double lj;
    private double lt;
    private double lb;
    private double ld;
    private boolean lu;
    @Deprecated
    static Rectangle lI;

    public double getWidth() {
        return l13p.lI(this.getURX() - this.getLLX());
    }

    public double getHeight() {
        return l13p.lI(this.getURY() - this.getLLY());
    }

    public double getLLX() {
        return this.lj;
    }

    public void setLLX(double value) {
        this.lj = value;
    }

    public double getLLY() {
        return this.lt;
    }

    public void setLLY(double value) {
        this.lt = value;
    }

    public double getURX() {
        return this.lb;
    }

    public void setURX(double value) {
        this.lb = value;
    }

    public double getURY() {
        return this.ld;
    }

    public void setURY(double value) {
        this.ld = value;
    }

    public Rectangle(double llx, double lly, double urx, double ury) {
        this(llx, lly, urx, ury, false);
    }

    private Rectangle(double llx, double lly, double urx, double ury, boolean isEmpty) {
        this.lj = llx;
        this.lt = lly;
        this.lb = urx;
        this.ld = ury;
        this.lu = isEmpty;
        this.lj();
    }

    private void lj() {
        double d = l13p.lt(this.lj, this.lb);
        double d2 = l13p.lt(this.lt, this.ld);
        double d3 = l13p.lj(this.lj, this.lb);
        double d4 = l13p.lj(this.lt, this.ld);
        this.lj = d;
        this.lt = d2;
        this.lb = d3;
        this.ld = d4;
    }

    l13j lI() {
        return new l13j((int)this.getLLX(), (int)this.getLLY(), (int)this.getWidth(), (int)this.getHeight());
    }

    l13h lf() {
        l13h l13h2 = new l13h(com.aspose.pdf.internal.l82p.lb.lh(this.getLLX(), 14), com.aspose.pdf.internal.l82p.lb.lh(this.getLLY(), 14), com.aspose.pdf.internal.l82p.lb.lh(this.getWidth(), 14), com.aspose.pdf.internal.l82p.lb.lh(this.getHeight(), 14));
        return l13h2;
    }

    public java.awt.Rectangle toRect() {
        return this.lI().lI();
    }

    static Rectangle lI(l13j l13j2) {
        return new Rectangle(l13j2.lb(), l13j2.lh(), l13j2.lb() + l13j2.lk(), l13j2.lh() + l13j2.lj());
    }

    public static Rectangle fromRect(java.awt.Rectangle src) {
        return Rectangle.lI(l13j.lI(src));
    }

    public l0n toArray(l0h trailerable) {
        return new l0n(trailerable, new l0t[]{new l1p(this.lj), new l1p(this.lt), new l1p(this.lb), new l1p(this.ld)});
    }

    public String toString() {
        return l10l.lI(lh.lt(), "{0},{1},{2},{3}", this.lj, this.lt, this.lb, this.ld);
    }

    public static Rectangle parse(String value) {
        lh lh2 = lh.lt();
        try {
            String[] stringArray = l10l.ld(value, ',');
            double d = l4l.lI(stringArray[0], (l6l)lh2);
            double d2 = l4l.lI(stringArray[1], (l6l)lh2);
            double d3 = l4l.lI(stringArray[2], (l6l)lh2);
            double d4 = l4l.lI(stringArray[3], (l6l)lh2);
            return new Rectangle(d, d2, d3, d4);
        }
        catch (l5if l5if2) {
            lf.log(Level.INFO, "Exception occur", l5if2);
            throw new IllegalStateException("Wrong input string.");
        }
    }

    public static Rectangle getEmpty() {
        if (lI == null) {
            lI = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
        }
        return lI;
    }

    public static Rectangle getTrivial() {
        return new Rectangle(0.0, 0.0, 0.0, 0.0);
    }

    public boolean isTrivial() {
        return Double.doubleToRawLongBits(this.getLLX()) == 0L && Double.doubleToRawLongBits(this.getLLY()) == 0L && Double.doubleToRawLongBits(this.getURX()) == 0L && Double.doubleToRawLongBits(this.getURY()) == 0L;
    }

    public boolean isEmpty() {
        return this.lu;
    }

    public boolean isPoint() {
        return Double.compare(this.lj, this.lb) == 0 && Double.compare(this.lt, this.ld) == 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        return Double.compare(this.getLLX(), ((Rectangle)other).getLLX()) == 0 && Double.compare(this.getLLY(), ((Rectangle)other).getLLY()) == 0 && Double.compare(this.getURX(), ((Rectangle)other).getURX()) == 0 && Double.compare(this.getURY(), ((Rectangle)other).getURY()) == 0;
    }

    public boolean nearEquals(Rectangle other, double delta) {
        if (other == null) {
            return false;
        }
        return l13p.lI(this.getLLX() - other.getLLX()) < delta && l13p.lI(this.getLLY() - other.getLLY()) < delta && l13p.lI(this.getURX() - other.getURX()) < delta && l13p.lI(this.getURY() - other.getURY()) < delta;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private double[] lI(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = l13p.lj(d, d3);
        if (d6 > (d5 = l13p.lt(d2, d4))) {
            return null;
        }
        return new double[]{d6, d5};
    }

    public Rectangle intersect(Rectangle otherRect) {
        double[] dArray = this.lI(this.getLLX(), this.getURX(), otherRect.getLLX(), otherRect.getURX());
        double[] dArray2 = this.lI(this.getLLY(), this.getURY(), otherRect.getLLY(), otherRect.getURY());
        if (dArray != null && dArray2 != null) {
            return new Rectangle(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        }
        return null;
    }

    public Rectangle join(Rectangle otherRect) {
        if (otherRect == null) {
            return this;
        }
        otherRect.lj();
        double d = l13p.lt(this.getLLX(), otherRect.getLLX());
        double d2 = l13p.lj(this.getURX(), otherRect.getURX());
        double d3 = l13p.lt(this.getLLY(), otherRect.getLLY());
        double d4 = l13p.lj(this.getURY(), otherRect.getURY());
        return new Rectangle(d, d3, d2, d4);
    }

    @Deprecated
    public void _Intersect(Rectangle otherRect) {
        this.lj = Math.max(this.getLLX(), otherRect.getLLX());
        this.lb = Math.min(this.getURX(), otherRect.getURX());
        this.lt = Math.max(this.getLLY(), otherRect.getLLY());
        this.ld = Math.min(this.getURY(), otherRect.getURY());
        this.lj();
    }

    public boolean isIntersect(Rectangle otherRect) {
        if (this.getLLX() > otherRect.getURX() || this.getURX() < otherRect.getLLX()) {
            return false;
        }
        return !(this.getLLY() > otherRect.getURY()) && !(this.getURY() < otherRect.getLLY());
    }

    public boolean contains(Point point) {
        return point.getX() > this.getLLX() && point.getX() < this.getURX() && point.getY() > this.getLLY() && point.getY() < this.getURY();
    }

    public Point center() {
        return new Point((this.getLLX() + this.getURX()) / 2.0, (this.getLLY() + this.getURY()) / 2.0);
    }

    boolean lI(Rectangle rectangle, double d) {
        this.lj();
        if (l0l.lI(d, 0.0, 1.0E-4)) {
            double d2;
            if (!this.lI(rectangle.getLLX(), rectangle.getLLY())) {
                return false;
            }
            double d3 = rectangle.getLLX();
            double d4 = rectangle.getLLY();
            double d5 = d3 + rectangle.getWidth() * l13p.le(d) - rectangle.getHeight() * l13p.lu(d);
            if (!this.lI(d5, d2 = d4 + rectangle.getWidth() * l13p.lu(d) + rectangle.getHeight() * l13p.le(d))) {
                return false;
            }
            d5 = d3 + rectangle.getWidth() * l13p.le(d);
            if (!this.lI(d5, d2 = d4 + rectangle.getWidth() * l13p.lu(d))) {
                return false;
            }
            d5 = d3 - rectangle.getHeight() * l13p.lu(d);
            return this.lI(d5, d2 = d4 + rectangle.getHeight() * l13p.le(d));
        }
        return this.lI(rectangle);
    }

    private boolean lI(Rectangle rectangle) {
        return this.lI(rectangle.getURX(), rectangle.getURY()) && this.lI(rectangle.getURX(), rectangle.getLLY()) && this.lI(rectangle.getLLX(), rectangle.getURY()) && this.lI(rectangle.getLLX(), rectangle.getLLY());
    }

    private boolean lI(double d, double d2) {
        return d >= this.getLLX() && d < this.getURX() && d2 >= this.getLLY() && d2 < this.getURY();
    }

    public void rotate(int angle) {
        switch (angle) {
            case 1: 
            case 3: {
                double d = this.lj;
                this.lj = this.lt;
                this.lt = d;
                d = this.lb;
                this.lb = this.ld;
                this.ld = d;
                break;
            }
        }
    }

    public void rotateAngle(int angle) {
        if (angle < 0 || angle > 360) {
            throw new lv("angle", "Must be between 0 and 360");
        }
        double d = (double)angle * Math.PI / 180.0;
        double d2 = l13p.lI((this.lj + this.lb) / 2.0, 2);
        double d3 = l13p.lI((this.lt + this.ld) / 2.0, 2);
        double d4 = this.getHeight();
        double d5 = this.getWidth();
        this.lj = l13p.lI(d2 + d5 / 2.0 * l13p.le(d) + d4 / 2.0 * l13p.lu(d), 2);
        this.lt = l13p.lI(d3 - d4 / 2.0 * l13p.le(d) + d5 / 2.0 * l13p.lu(d), 2);
        this.lb = l13p.lI(d2 - d5 / 2.0 * l13p.le(d) - d4 / 2.0 * l13p.lu(d), 2);
        this.ld = l13p.lI(d3 + d4 / 2.0 * l13p.le(d) - d5 / 2.0 * l13p.lu(d), 2);
    }

    @Override
    public int compareTo(Object arg0) {
        if (((Rectangle)arg0).getLLX() > this.getLLX()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLX() < this.getLLX()) {
            return -1;
        }
        if (((Rectangle)arg0).getLLY() > this.getLLY()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLY() < this.getLLY()) {
            return -1;
        }
        if (((Rectangle)arg0).getURX() > this.getURX()) {
            return 1;
        }
        if (((Rectangle)arg0).getURX() < this.getURX()) {
            return -1;
        }
        if (((Rectangle)arg0).getURY() > this.getURY()) {
            return 1;
        }
        if (((Rectangle)arg0).getURY() < this.getURY()) {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    public Object deepClone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    static {
        lf.setUseParentHandlers(false);
        lI = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
    }
}

