/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Border;
import com.aspose.pdf.Color;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LineEndingConverter;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Measure;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.l0k.ld;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l1p;
import com.aspose.pdf.internal.l5n.l1t;
import com.aspose.pdf.internal.l5n.lb;
import com.aspose.pdf.internal.l70k.l33if;
import com.aspose.pdf.internal.l70k.l45f;
import com.aspose.pdf.internal.l70k.l48y;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lf;
import com.aspose.pdf.internal.ms.System.IO.l2k;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l4l;
import com.aspose.pdf.internal.ms.System.l5if;
import com.aspose.pdf.internal.ms.System.l6l;
import com.aspose.pdf.l12u;
import com.aspose.pdf.operators.ClosePathStroke;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GSave;
import com.aspose.pdf.operators.LineTo;
import com.aspose.pdf.operators.MoveTo;
import com.aspose.pdf.operators.SetRGBColor;
import com.aspose.pdf.operators.SetRGBColorStroke;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PolyAnnotation
extends MarkupAnnotation {
    private static final Logger le = Logger.getLogger(PolyAnnotation.class.getName());
    protected Measure lu = null;

    PolyAnnotation(l0if annotation, IDocument document) {
        super(annotation, document);
    }

    protected PolyAnnotation(IDocument document, Point[] vertices) {
        super(document);
        this.setVertices(vertices);
    }

    protected PolyAnnotation(Page page, Rectangle rect, Point[] vertices) {
        super(page, rect);
        this.setVertices(vertices);
    }

    public Measure getMeasure() {
        if (this.lu == null && this.getEngineDict().lt("Measure") && this.getEngineDict().lf("Measure").l5l() != null) {
            this.lu = new Measure(this.getEngineDict().lf("Measure").l5l());
        }
        return this.lu;
    }

    public void setMeasure(Measure value) {
        if (value == null) {
            this.getEngineDict().lb("Measure");
        } else {
            this.getEngineDict().lI("Measure", (com.aspose.pdf.internal.l5n.l0t)value.lI());
        }
        this.lu = value;
    }

    @Override
    protected void lf(l48y l48y2) {
        super.lf(l48y2);
        if (this.getEngineDict().lt("AP") && !this.getEngineDict().lt("BS")) {
            this.getBorder().lf(l48y2);
        }
        if (this.getEngineDict().lt("BS")) {
            this.getBorder().lI(l48y2);
        }
        if (this.getEngineDict().lt("IC")) {
            l48y2.lj("interior-color", this.getInteriorColor().toString());
        }
        if (this.getEngineDict().lt("LE")) {
            l48y2.lj("head", LineEndingConverter.toString(this.getStartingStyle()));
            l48y2.lj("tail", LineEndingConverter.toString(this.getEndingStyle()));
        }
        if (this.getEngineDict().lt("IT")) {
            l48y2.lj("intent", l12u.lf(this.getIntent()));
        }
        if (this.getEngineDict().lt("Measure")) {
            l48y2.l0t("measure");
            this.getMeasure().lI(l48y2);
            l48y2.lk();
        }
    }

    @Override
    protected void lj(l48y l48y2) {
        StringBuilder stringBuilder;
        if (this.getEngineDict().lt("Vertices")) {
            l48y2.l0t("vertices");
            stringBuilder = new StringBuilder();
            for (Point point : this.getVertices()) {
                stringBuilder.append(l10l.lI(this.lf, "{0},{1};", point.getX(), point.getY()));
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        l48y2.lb(stringBuilder.toString());
        l48y2.lk();
        super.lj(l48y2);
    }

    @Override
    protected void lf(l33if l33if2) {
        super.lf(l33if2);
        this.setBorder(new Border(this));
        this.getBorder().lI(l33if2);
        if (l33if2.lt("interior-color")) {
            this.setInteriorColor(Color.parse(l33if2.lj("interior-color")));
        }
        if (l33if2.lt("head")) {
            this.setStartingStyle(LineEndingConverter.toEnum(l33if2.lj("head")));
        }
        if (l33if2.lt("tail")) {
            this.setEndingStyle(LineEndingConverter.toEnum(l33if2.lj("tail")));
        }
        if (l33if2.lt("intent")) {
            this.setIntent(l12u.lI(l33if2.lj("intent")));
        }
    }

    @Override
    protected void lI(lf<String, String> lf2) {
        Point[] pointArray;
        Object object;
        if (lf2.containsKey("vertices")) {
            object = l10l.ld(lf2.get_Item("vertices"), ';');
            int n = ((String[])object).length;
            pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                String[] stringArray = l10l.ld(object[i], ',');
                double d = l4l.lI(stringArray[0], (l6l)this.lf);
                double d2 = l4l.lI(stringArray[1], (l6l)this.lf);
                pointArray[i] = new Point(d, d2);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setVertices(pointArray);
        if (lf2.containsKey("measure")) {
            object = new l45f(new l2k(lf2.get_Item("measure")));
            this.setMeasure(new Measure(this));
            while (((l33if)object).le() && (((l33if)object).l1if() != 1 || !"measure".equals(((l33if)object).l0n()))) {
            }
            this.getMeasure().lI((l33if)object);
            while (((l33if)object).le() && (((l33if)object).l1if() != 15 || !"measure".equals(((l33if)object).l0n()))) {
            }
        }
        super.lI(lf2);
    }

    @Override
    void lI(l33if l33if2) {
        this.lf(l33if2);
        this.lI(XfdfReader.lI(l33if2));
    }

    public Point[] getVertices() {
        try {
            lb lb2 = this.getEngineDict().lj("Vertices").l5t();
            int n = lb2.lv() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(lb2.lI(2 * i).l5h().lu(), lb2.lI(2 * i + 1).l5h().lu());
            }
            return pointArray;
        }
        catch (l5if l5if2) {
            le.log(Level.INFO, "Exception occur", l5if2);
            return null;
        }
    }

    public void setVertices(Point[] value) {
        if (value != null) {
            l0n l0n2 = new l0n(this.getEngineDict());
            for (Point point : value) {
                l0n2.lI((com.aspose.pdf.internal.l5n.l0t)new l1p(point.getX()));
                l0n2.lI((com.aspose.pdf.internal.l5n.l0t)new l1p(point.getY()));
            }
            this.getEngineDict().lI("Vertices", (com.aspose.pdf.internal.l5n.l0t)l0n2);
        }
    }

    public Color getInteriorColor() {
        if (this.getEngineDict().lt("IC")) {
            lb lb2 = this.getEngineDict().lj("IC").l5t();
            double[] dArray = new double[lb2.lv()];
            for (int i = 0; i < lb2.lv(); ++i) {
                dArray[i] = lb2.lI(i).l5h().lu();
            }
            return new Color(dArray);
        }
        return null;
    }

    public void setInteriorColor(Color value) {
        l0n l0n2 = new l0n(this.getEngineDict());
        for (double d : value.getData()) {
            l0n2.lI((com.aspose.pdf.internal.l5n.l0t)new l1p(d));
        }
        this.getEngineDict().lI("IC", (com.aspose.pdf.internal.l5n.l0t)l0n2);
    }

    public int getStartingStyle() {
        try {
            lb lb2 = this.getEngineDict().lj("LE").l5t();
            return LineEndingConverter.toEnum(lb2.lI(0).l5if().toString());
        }
        catch (l5if l5if2) {
            le.log(Level.INFO, "Exception occur", l5if2);
            return 0;
        }
    }

    public void setStartingStyle(int value) {
        lb lb2 = null;
        if (this.getEngineDict().lt("LE") && (lb2 = this.getEngineDict().lj("LE").l5t()).lv() != 2) {
            lb2 = null;
        }
        if (lb2 == null) {
            lb2 = new l0n(this.getEngineDict());
            lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t("None"));
            lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t("None"));
            this.getEngineDict().lI("LE", (com.aspose.pdf.internal.l5n.l0t)lb2);
        }
        lb2.lf(0);
        lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t(LineEndingConverter.toString(value)), 0);
    }

    public int getEndingStyle() {
        try {
            lb lb2 = this.getEngineDict().lj("LE").l5t();
            return LineEndingConverter.toEnum(lb2.lI(1).l5if().toString());
        }
        catch (l5if l5if2) {
            le.log(Level.INFO, "Exception occur", l5if2);
            return 0;
        }
    }

    public void setEndingStyle(int value) {
        lb lb2 = null;
        if (this.getEngineDict().lt("LE") && (lb2 = this.getEngineDict().lj("LE").l5t()).lv() != 2) {
            lb2 = null;
        }
        if (lb2 == null) {
            lb2 = new l0n(this.getEngineDict());
            lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t("None"));
            lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t("None"));
            this.getEngineDict().lI("LE", (com.aspose.pdf.internal.l5n.l0t)lb2);
        }
        lb2.lf(1);
        lb2.lI((com.aspose.pdf.internal.l5n.l0t)new l1t(LineEndingConverter.toString(value)), 1);
    }

    public int getIntent() {
        return l12u.lI(com.aspose.pdf.internal.l0k.ld.lf(this.getEngineDict(), "IT"));
    }

    public void setIntent(int value) {
        if (value != 0) {
            this.getEngineDict().lI("IT", (com.aspose.pdf.internal.l5n.l0t)new l1t(l12u.lI(value)));
        }
    }

    @Override
    boolean le() {
        return this.lt;
    }

    l0t<Operator> lj(Annotation.lI lI2, Annotation annotation) {
        l0t<Operator> l0t2 = new l0t<Operator>();
        l0t2.addItem(new GSave());
        l0t2.addItem(new SetRGBColor(this.getColor().toRgb()));
        l0t2.addItem(new SetRGBColorStroke(this.getColor().toRgb()));
        int n = 0;
        for (Point point : this.getVertices()) {
            if (n == 0) {
                l0t2.addItem(new MoveTo(point.getX(), point.getY()));
            } else {
                l0t2.addItem(new LineTo(point.getX(), point.getY()));
            }
            ++n;
        }
        l0t2.addItem(new ClosePathStroke());
        l0t2.addItem(new GRestore());
        return l0t2;
    }

    @Override
    XForm lI(String string, Annotation annotation) {
        XForm xForm = super.lI(string, annotation);
        Rectangle rectangle = null;
        for (Point point : this.getVertices()) {
            if (rectangle == null) {
                rectangle = new Rectangle(point.getX(), point.getY(), point.getX(), point.getY());
                continue;
            }
            double d = l13p.lt(rectangle.getLLX(), point.getX());
            double d2 = l13p.lt(rectangle.getLLY(), point.getY());
            double d3 = l13p.lj(rectangle.getURX(), point.getX());
            double d4 = l13p.lj(rectangle.getURY(), point.getY());
            rectangle.setLLX(d);
            rectangle.setLLY(d2);
            rectangle.setURX(d3);
            rectangle.setURY(d4);
        }
        xForm.setBBox(rectangle);
        this.setRect(rectangle);
        xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -rectangle.getLLX(), -rectangle.getLLY()));
        return xForm;
    }

    /* synthetic */ List lf(Annotation.lI lI2, Annotation annotation) {
        return this.lj(lI2, annotation);
    }

    static {
        le.setUseParentHandlers(false);
    }
}

