/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.SaveOptions;
import com.aspose.pdf.UnifiedSaveOptions;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.internal.l76u.lI;
import com.aspose.pdf.internal.l76u.lf;
import com.aspose.pdf.internal.l82p.lb;
import com.aspose.pdf.internal.ms.System.l0h;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l4v;
import com.aspose.pdf.internal.ms.System.l5h;
import com.aspose.pdf.internal.ms.System.l7j;
import com.aspose.pdf.internal.ms.System.lv;
import com.aspose.pdf.text.FontSourceCollection;
import java.io.InputStream;

public class HtmlSaveOptions
extends UnifiedSaveOptions {
    public UnifiedSaveOptions.ConversionProgressEventHandler CustomProgressHandler = null;
    public int AntialiasingProcessing = 0;
    public boolean SaveTransparentTexts = false;
    public boolean SaveShadowedTextsAsTransparentTexts = false;
    public int FontSavingMode = 0;
    public SaveOptions.BorderInfo PageBorderIfAny = null;
    public int LettersPositioningMethod = 1;
    public int[] ExplicitListOfSavedPages;
    private int lI;
    private boolean lf;
    private int lj = 96;
    private String lt;
    public ResourceSavingStrategy CustomResourceSavingStrategy = null;
    public CssSavingStrategy CustomCssSavingStrategy = null;
    public HtmlPageMarkupSavingStrategy CustomHtmlSavingStrategy = null;
    public CssUrlMakingStrategy CustomStrategyOfCssUrlCreation = null;
    private boolean lb;
    public String SpecialFolderForSvgImages = null;
    public String SpecialFolderForAllImages = null;
    private boolean ld;
    public String CssClassNamesPrefix;
    private boolean lu;
    public int PartsEmbeddingMode = 2;
    public int HtmlMarkupGenerationMode = 0;
    public int RasterImagesSavingMode = 1;
    public boolean RemoveEmptyAreasOnTopAndBottom = false;
    private FontSourceCollection le = new FontSourceCollection();
    public byte FontEncodingStrategy;
    public boolean PagesFlowTypeDependsOnViewersScreenSize;
    public boolean TrySaveTextUnderliningAndStrikeoutingInCss = false;
    private int l0t = 0;
    private boolean l0v = false;
    private boolean l0p;
    private float l0u;
    private boolean l0j;
    private int l0h;

    public HtmlSaveOptions() {
        this(1);
    }

    public HtmlSaveOptions(int documentType) {
        this(documentType, true);
    }

    public HtmlSaveOptions(boolean fixedLayout) {
        this(1, fixedLayout);
    }

    public HtmlSaveOptions(int documentType, boolean fixedLayout) {
        this.setConvertMarkedContentToLayers(false);
        this.lh = 3;
        this.lI = documentType;
        this.lf = fixedLayout;
        this.FontEncodingStrategy = 0;
    }

    public int getDocumentType() {
        return this.lI;
    }

    public void setDocumentType(int value) {
        this.lI = value;
    }

    public boolean getCompressSvgGraphicsIfAny() {
        return this.lb;
    }

    public void setCompressSvgGraphicsIfAny(boolean value) {
        this.lb = value;
    }

    public boolean getSplitCssIntoPages() {
        return this.ld;
    }

    public void setSplitCssIntoPages(boolean value) {
        this.ld = value;
    }

    public boolean getSplitIntoPages() {
        return this.lu;
    }

    public void setSplitIntoPages(boolean value) {
        this.lu = value;
    }

    public boolean getFixedLayout() {
        return this.lf;
    }

    public void setFixedLayout(boolean value) {
        this.lf = value;
    }

    public int getImageResolution() {
        return this.lj;
    }

    public void setImageResolution(int value) {
        this.lj = value;
    }

    public String getDefaultFontName() {
        return this.lt;
    }

    public void setDefaultFontName(String value) {
        this.lt = value;
    }

    public FontSourceCollection getFontSources() {
        return this.le;
    }

    void lI(boolean bl) {
        switch (this.PartsEmbeddingMode) {
            case 0: {
                if (this.getSplitIntoPages()) {
                    throw new PdfException("If selected mode of embedding of all resources into one HTML(PartsEmbeddingModes.EmbedAllIntoHtml), splitting of result into pages not allowed. Please set HtmlSaveOptions.SplitIntoPages to 'false'");
                }
                if (this.getSplitCssIntoPages()) {
                    throw new PdfException("If selected mode of embedding of all resources into one HTML(PartsEmbeddingModes.EmbedAllIntoHtml), splitting of CSSes for pages not allowed, please set HtmlSaveOptions.SplitCssIntoPages to 'false'");
                }
                if (this.CustomCssSavingStrategy != null) {
                    throw new PdfException("If selected mode of embedding into HTML(PartsEmbeddingModes.EmbedAllIntoHtml), custom CSS saving stategy not allowed and must be null! Please set HtmlSaveOptions.CustomCssSavingStrategy=null!'");
                }
                if (this.CustomStrategyOfCssUrlCreation != null) {
                    throw new PdfException("If selected mode of embedding CSSes into HTML(PartsEmbeddingModes.EmbedAllIntoHtml), custom CSS URL creation strategy not allowed and must be null! Please set HtmlSaveOptions.CustomStrategyOfCssUrlCreation=null!'");
                }
                if (this.CustomResourceSavingStrategy != null) {
                    throw new PdfException("If selected mode of embedding of external resources into HTML (PartsEmbeddingModes.EmbedAllIntoHtml), custom resource saving strategy not allowed and must be null! Please set HtmlSaveOptions.CustomResourceSavingStrategy=null!'");
                }
                if (this.RasterImagesSavingMode != 2) {
                    throw new PdfException("If selected mode of embedding into HTML (PartsEmbeddingModes.EmbedAllIntoHtml), images can be saved only as embedded PNGs, so, please use HtmlSaveOptions.RasterImagesSavingMode=RasterImagesSavingModes.AsEmbeddedPartsOfPngPageBackground!");
                }
                if (!l10l.lf(this.SpecialFolderForAllImages)) {
                    throw new PdfException(l10l.lI(new String[]{"If selected mode of embedding of images into HTML(PartsEmbeddingModes.EmbedAllIntoHtml), images will be saved only as PNGs embedded in HTML, so, setting HtmlSaveOptions.SpecialFolderForAllImages='", this.SpecialFolderForAllImages, "'  not allowed. Please use HtmlSaveOptions.SpecialFolderForAllImages=null!"}));
                }
                if (l10l.lf(this.SpecialFolderForSvgImages)) break;
                throw new PdfException(l10l.lI(new String[]{"If selected mode of embedding of images into HTML(PartsEmbeddingModes.EmbedAllIntoHtml), images will be saved only as PNGs embedded in HTML, so, setting HtmlSaveOptions.SpecialFolderForSvgImage='", this.SpecialFolderForSvgImages, "'  not allowed. Please use HtmlSaveOptions.SpecialFolderForSvgImages=null!"}));
            }
            case 1: {
                if (this.CustomCssSavingStrategy != null) {
                    throw new PdfException("If selected mode of embedding Csses into HTML(PartsEmbeddingModes.EmbedOnlyCss), custom CSS saving stategy not allowed and must be null! Please set HtmlSaveOptions.CustomCssSavingStrategy=null!'");
                }
                if (this.CustomStrategyOfCssUrlCreation == null) break;
                throw new PdfException("If selected mode of embedding Csses into HTML(PartsEmbeddingModes.EmbedOnlyCss), custom CSS URL creation strategy not allowed and must be null! Please set HtmlSaveOptions.CustomStrategyOfCssUrlCreation=null!'");
            }
            case 2: {
                break;
            }
            default: {
                throw new PdfException("Unexpected  PartsEmbeddingMode detected (14)!");
            }
        }
        if (bl) {
            this.lj();
        } else {
            this.lt();
        }
    }

    private void lj() {
        if (this.CustomStrategyOfCssUrlCreation == null || this.CustomCssSavingStrategy == null || this.CustomResourceSavingStrategy == null) {
            throw new PdfException("Inconsistent saving options detected : 'CustomStrategyOfCssUrlCreation','CustomCssSavingStrategy','CustomResourceSavingStrategy' may not be null when requested saving to stream!");
        }
        if (this.getSplitIntoPages()) {
            throw new PdfException("Inconsistent saving options detected : 'SplitIntoPages'  may not be 'true' when requested saving to stream!");
        }
        if (this.getSplitCssIntoPages()) {
            throw new PdfException("Inconsistent saving options detected : 'SplitCssIntoPages'  may not be 'true' when requested saving to stream!");
        }
    }

    private void lt() {
        CssUrlRequestInfo cssUrlRequestInfo;
        String string;
        if (this.CustomStrategyOfCssUrlCreation == null ^ this.CustomCssSavingStrategy == null) {
            throw new PdfException("Inconsistent saving options detected : 'CustomStrategyOfCssUrlCreation' and 'CustomCssSavingStrategy' must be both set or both unset");
        }
        if (this.getSplitCssIntoPages() && !this.getSplitIntoPages()) {
            throw new PdfException("Inconsistent saving options detected : 'SplitCssIntoPages' can be 'true' only if  'SplitIntoPages' also is 'true'!");
        }
        if (this.getSplitCssIntoPages() && this.CustomStrategyOfCssUrlCreation != null && l10l.le(string = this.CustomStrategyOfCssUrlCreation.invoke(cssUrlRequestInfo = new CssUrlRequestInfo()), "{0}") == -1) {
            throw new PdfException("Inconsistent saving options detected : if 'SplitCssIntoPages' set as 'true' and 'CustomStrategyOfCssUrlCreation' set, then 'CustomStrategyOfCssUrlCreation()' must return formatting string like this one : 'SomeTargetLocation-page_{0}.css' that can be used with String.Format() method to generate URL for this or that page number!");
        }
    }

    public int getAdditionalMarginWidthInPoints() {
        return this.l0t;
    }

    public void setAdditionalMarginWidthInPoints(int value) {
        if (value < 0) {
            throw new lv("AdditionalMarginWidthInPoints may not be negative!");
        }
        this.l0t = value;
    }

    public boolean getUseZOrder() {
        return this.l0v;
    }

    public void setUseZOrder(boolean value) {
        this.l0v = value;
    }

    public boolean getConvertMarkedContentToLayers() {
        return this.l0p;
    }

    public void setConvertMarkedContentToLayers(boolean value) {
        this.l0p = value;
    }

    public float getMinimalLineWidth() {
        return this.l0u;
    }

    public void setMinimalLineWidth(float value) {
        this.l0u = value;
    }

    public boolean getPreventGlyphsGrouping() {
        return this.l0j;
    }

    public void setPreventGlyphsGrouping(boolean value) {
        this.l0j = value;
    }

    int lI() {
        return this.l0h;
    }

    void lI(int n) {
        this.l0h = n;
    }

    void lf() {
        this.lI(0);
    }

    public static final class FontEncodingRules
    extends l4v {
        public static final byte Default = 0;
        public static final byte DecreaseToUnicodePriorityLevel = 1;

        private FontEncodingRules() {
        }

        static {
            l4v.register(new l4v.lb((Class)FontEncodingRules.class, Byte.class){
                {
                    this.lI("Default", 0L);
                    this.lI("DecreaseToUnicodePriorityLevel", 1L);
                }
            });
        }
    }

    public static final class PartsEmbeddingModes
    extends l4v {
        public static final int EmbedAllIntoHtml = 0;
        public static final int EmbedCssOnly = 1;
        public static final int NoEmbedding = 2;

        private PartsEmbeddingModes() {
        }

        static {
            l4v.register(new l4v.lb((Class)PartsEmbeddingModes.class, Integer.class){
                {
                    this.lI("EmbedAllIntoHtml", 0L);
                    this.lI("EmbedCssOnly", 1L);
                    this.lI("NoEmbedding", 2L);
                }
            });
        }
    }

    public static final class HtmlMarkupGenerationModes
    extends l4v {
        public static final int WriteAllHtml = 0;
        public static final int WriteOnlyBodyContent = 1;

        private HtmlMarkupGenerationModes() {
        }

        static {
            l4v.register(new l4v.lb((Class)HtmlMarkupGenerationModes.class, Integer.class){
                {
                    this.lI("WriteAllHtml", 0L);
                    this.lI("WriteOnlyBodyContent", 1L);
                }
            });
        }
    }

    public static final class RasterImagesSavingModes
    extends l4v {
        public static final int AsPngImagesEmbeddedIntoSvg = 0;
        public static final int AsExternalPngFilesReferencedViaSvg = 1;
        public static final int AsEmbeddedPartsOfPngPageBackground = 2;

        private RasterImagesSavingModes() {
        }

        static {
            l4v.register(new l4v.lb((Class)RasterImagesSavingModes.class, Integer.class){
                {
                    this.lI("AsPngImagesEmbeddedIntoSvg", 0L);
                    this.lI("AsExternalPngFilesReferencedViaSvg", 1L);
                    this.lI("AsEmbeddedPartsOfPngPageBackground", 2L);
                }
            });
        }
    }

    public static final class ImageParentTypes
    extends l4v {
        public static final int HtmlPage = 0;
        public static final int SvgImage = 1;

        private ImageParentTypes() {
        }

        static {
            l4v.register(new l4v.lb((Class)ImageParentTypes.class, Integer.class){
                {
                    this.lI("HtmlPage", 0L);
                    this.lI("SvgImage", 1L);
                }
            });
        }
    }

    public static final class HtmlImageType
    extends l4v {
        public static final int Jpeg = 0;
        public static final int Png = 1;
        public static final int Bmp = 2;
        public static final int Gif = 3;
        public static final int Tiff = 4;
        public static final int Svg = 5;
        public static final int ZippedSvg = 6;
        public static final int Unknown = 7;

        private HtmlImageType() {
        }

        static {
            l4v.register(new l4v.lb((Class)HtmlImageType.class, Integer.class){
                {
                    this.lI("Jpeg", 0L);
                    this.lI("Png", 1L);
                    this.lI("Bmp", 2L);
                    this.lI("Gif", 3L);
                    this.lI("Tiff", 4L);
                    this.lI("Svg", 5L);
                    this.lI("ZippedSvg", 6L);
                    this.lI("Unknown", 7L);
                }
            });
        }
    }

    public static abstract class CssUrlMakingStrategy
    extends l7j {
        public abstract String invoke(CssUrlRequestInfo var1);

        public final l5h beginInvoke(final CssUrlRequestInfo cssUrlRequestInfo, l0h callback, Object state) {
            return com.aspose.pdf.internal.l76u.lI.lI(new lf(this, callback, state){

                @Override
                public void lI() {
                    this.pushResult(this.invoke(cssUrlRequestInfo));
                }
            });
        }

        public final String endInvoke(l5h result) {
            com.aspose.pdf.internal.l76u.lI.lI(this, result);
            return com.aspose.pdf.internal.l82p.lb.lt(this.peekResult(), String.class);
        }
    }

    public static abstract class CssSavingStrategy
    extends l7j {
        public abstract void invoke(CssSavingInfo var1);

        public final l5h beginInvoke(final CssSavingInfo partSavingInfo, l0h callback, Object state) {
            return com.aspose.pdf.internal.l76u.lI.lI(new lf(this, callback, state){

                @Override
                public void lI() {
                    this.invoke(partSavingInfo);
                }
            });
        }

        public final void endInvoke(l5h result) {
            com.aspose.pdf.internal.l76u.lI.lI(this, result);
        }
    }

    public static abstract class HtmlPageMarkupSavingStrategy
    extends l7j {
        public abstract void invoke(HtmlPageMarkupSavingInfo var1);

        public final l5h beginInvoke(final HtmlPageMarkupSavingInfo htmlSavingInfo, l0h callback, Object state) {
            return com.aspose.pdf.internal.l76u.lI.lI(new lf(this, callback, state){

                @Override
                public void lI() {
                    this.invoke(htmlSavingInfo);
                }
            });
        }

        public final void endInvoke(l5h result) {
            com.aspose.pdf.internal.l76u.lI.lI(this, result);
        }
    }

    public static abstract class ResourceSavingStrategy
    extends l7j {
        public abstract String invoke(SaveOptions.ResourceSavingInfo var1);

        final l5h lI(final SaveOptions.ResourceSavingInfo resourceSavingInfo, l0h l0h2, Object object) {
            return com.aspose.pdf.internal.l76u.lI.lI(new lf(this, l0h2, object){

                @Override
                public void lI() {
                    this.pushResult(this.invoke(resourceSavingInfo));
                }
            });
        }

        final String lI(l5h l5h2) {
            com.aspose.pdf.internal.l76u.lI.lI(this, l5h2);
            return com.aspose.pdf.internal.l82p.lb.lt(this.peekResult(), String.class);
        }
    }

    public static class HtmlImageSavingInfo
    extends SaveOptions.ResourceSavingInfo {
        public int ImageType;
        public int ParentType;
        public int PdfHostPageNumber = 1;
        public int HtmlHostPageNumber = 1;

        public HtmlImageSavingInfo() {
            super(0);
        }
    }

    public static class CssUrlRequestInfo {
        public boolean CustomProcessingCancelled;
    }

    public static class HtmlPageMarkupSavingInfo {
        public String SupposedFileName;
        public InputStream ContentStream;
        public int PdfHostPageNumber = 0;
        public int HtmlHostPageNumber = 1;
        public boolean CustomProcessingCancelled;

        HtmlPageMarkupSavingInfo() {
        }
    }

    public static class CssSavingInfo {
        public int CssNumber;
        public String SupposedURL;
        public InputStream ContentStream;

        CssSavingInfo() {
        }
    }

    public static final class AntialiasingProcessingType
    extends l4v {
        public static final int NoAdditionalProcessing = 0;
        public static final int TryCorrectResultHtml = 1;

        private AntialiasingProcessingType() {
        }

        static {
            l4v.register(new l4v.lb((Class)AntialiasingProcessingType.class, Integer.class){
                {
                    this.lI("NoAdditionalProcessing", 0L);
                    this.lI("TryCorrectResultHtml", 1L);
                }
            });
        }
    }

    public static final class FontSavingModes
    extends l4v {
        public static final int AlwaysSaveAsWOFF = 0;
        public static final int AlwaysSaveAsTTF = 1;
        public static final int AlwaysSaveAsEOT = 2;
        public static final int SaveInAllFormats = 3;

        private FontSavingModes() {
        }

        static {
            l4v.register(new l4v.lb((Class)FontSavingModes.class, Integer.class){
                {
                    this.lI("AlwaysSaveAsWOFF", 0L);
                    this.lI("AlwaysSaveAsTTF", 1L);
                    this.lI("AlwaysSaveAsEOT", 2L);
                    this.lI("SaveInAllFormats", 3L);
                }
            });
        }
    }
}

