/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Font;
import com.aspose.pdf.FontStyles;
import com.aspose.pdf.exceptions.FontNotFoundException;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.internal.l19n.l0k;
import com.aspose.pdf.internal.l19n.l10k;
import com.aspose.pdf.internal.l19n.l10y;
import com.aspose.pdf.internal.l19n.l11h;
import com.aspose.pdf.internal.l19n.l11p;
import com.aspose.pdf.internal.l19n.l16if;
import com.aspose.pdf.internal.l4k.l0v;
import com.aspose.pdf.internal.l6t.lf;
import com.aspose.pdf.internal.l82p.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l0t;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l0if;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.IO.lI;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l4p;
import com.aspose.pdf.text.FontSourceCollection;
import com.aspose.pdf.text.FontSubstitutionCollection;
import com.aspose.pdf.text.FontTypes;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FontRepository {
    private static final Logger lI = Logger.getLogger(FontRepository.class.getName());
    private static final lh lf;
    private static boolean lj;

    public static FontSubstitutionCollection getSubstitutions() {
        return l0v.lf().lj();
    }

    public static FontSourceCollection getSources() {
        return l0v.lf().lt();
    }

    public static Font findFont(String fontName) {
        l11p l11p2 = l0v.lf().lf(fontName);
        if (l11p2 == null) {
            throw new FontNotFoundException(l10l.lI("Font {0} was not found", new Object[]{fontName}));
        }
        l16if l16if2 = com.aspose.pdf.internal.l6t.lf.lI(l11p2);
        return new Font(l16if2);
    }

    public static Font findFont(String fontName, boolean ignoreCase) {
        l11p l11p2 = l0v.lf().lI(fontName, false, ignoreCase);
        if (l11p2 == null) {
            throw new FontNotFoundException(l10l.lI("Font {0} was not found", new Object[]{fontName}));
        }
        l16if l16if2 = com.aspose.pdf.internal.l6t.lf.lI(l11p2);
        return new Font(l16if2);
    }

    public static Font findFont(String fontFamilyName, int stl) {
        return FontRepository.findFont(fontFamilyName, stl, false);
    }

    public static Font findFont(String fontFamilyName, int stl, boolean ignoreCase) {
        int n = stl;
        String string = fontFamilyName;
        String string2 = l10l.lI;
        l0t<String> l0t2 = new l0t<String>();
        if (l10l.le(fontFamilyName, "Bold") != -1) {
            n |= 1;
            string = l10l.lI(string, "Bold", l10l.lI);
        }
        if (l10l.le(fontFamilyName, "Italic") != -1) {
            n |= 2;
            string = l10l.lI(string, "Italic", l10l.lI);
        }
        if (l10l.le(fontFamilyName, "Oblique") != -1) {
            n |= 2;
            string = l10l.lI(string, "Oblique", l10l.lI);
        }
        if ((n & 1) != 0) {
            string2 = "Bold";
        }
        if ((n & 2) != 0) {
            l0t2.addItem(l10l.lI(new String[]{string, string2, "Italic"}));
            l0t2.addItem(l10l.lI(new String[]{string, "Italic", string2}));
            l0t2.addItem(l10l.lI(new String[]{string, string2, "Oblique"}));
            l0t2.addItem(l10l.lI(new String[]{string, "Oblique", string2}));
        } else {
            l0t2.addItem(l10l.lI(new String[]{string, string2}));
            if (n == 0) {
                l0t2.addItem(l10l.lI(new String[]{string, "Regular"}));
            }
        }
        l11p l11p2 = FontRepository.lI(l0t2, ignoreCase);
        if (l11p2 == null) {
            if (n != 0) {
                throw new PdfException(l10l.lI("Font {0} with style {1} was not found", new Object[]{fontFamilyName, l4p.lI(FontStyles.class, n)}));
            }
            throw new PdfException(l10l.lI("Font {0} was not found", new Object[]{fontFamilyName}));
        }
        l16if l16if2 = com.aspose.pdf.internal.l6t.lf.lI(l11p2);
        return new Font(l16if2);
    }

    private static l11p lI(l0t<String> l0t2, boolean bl) {
        l11p l11p2 = null;
        for (String string : l0t2) {
            l11p2 = l0v.lf().lI(string, false, bl);
            if (l11p2 == null) continue;
            return l11p2;
        }
        return null;
    }

    public static Font openFont(InputStream fontStream, int fontType) {
        return FontRepository.lI(Stream.fromJava(fontStream), fontType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font lI(Stream stream, int n) {
        if (n == 0 || n == 1) {
            byte[] byArray;
            int n2 = n == 0 ? 0 : 3;
            lI lI2 = new lI(stream);
            try {
                byArray = lI2.lh((int)stream.getLength());
            }
            finally {
                if (lI2 != null) {
                    lI2.dispose();
                }
            }
            try {
                return new Font(l10k.lI(new l11p(n2, new l11h[]{new l11h(new l0k(byArray))})));
            }
            catch (Exception exception) {
                lI.log(Level.INFO, "Exception occur", exception);
                return null;
            }
        }
        throw new IllegalStateException(l10l.lI("font type {0} is not supported", new Object[]{l4p.lI(FontTypes.class, n)}));
    }

    public static Font openFont(String fontFilePath) {
        return FontRepository.openFont(fontFilePath, null);
    }

    public static Font openFont(String fontFilePath, String metricsFilePath) {
        int n;
        if (!l0if.lb(fontFilePath)) {
            throw new PdfException("Specified font file was not found" + fontFilePath);
        }
        String string = l10l.lI(l10l.lu(l1y.lb(fontFilePath)), ".", l10l.lI);
        switch (lf.lI(string)) {
            case 0: 
            case 1: 
            case 2: {
                n = 0;
                break;
            }
            case 3: 
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new PdfException("Could not determine font type of font file specified");
            }
        }
        l0t<l11h> l0t2 = new l0t<l11h>(2);
        l0t2.addItem(new l11h(string, new l10y(fontFilePath)));
        if (metricsFilePath != null && !l10l.lb(metricsFilePath, l10l.lI)) {
            if (!l0if.lb(metricsFilePath)) {
                throw new IllegalStateException("Specified font metrics file was not found");
            }
            l0t2.addItem(new l11h(l10l.lu(l1y.lb(metricsFilePath)), new l10y(fontFilePath)));
        }
        try {
            return new Font(l10k.lI(new l11p(n, l0t2.toArray(new l11h[0]))));
        }
        catch (Exception exception) {
            lI.log(Level.INFO, "Exception occur", exception);
            throw new PdfException("The font object can't be created from the file: " + fontFilePath);
        }
    }

    public static void loadFonts() {
        l0v.lf();
    }

    public static boolean isReplaceNotFoundFonts() {
        return lj;
    }

    public static void setReplaceNotFoundFonts(boolean value) {
        lj = value;
    }

    static {
        lI.setUseParentHandlers(false);
        lf = new lh("ttf", "ttc", "otf", "pfb", "pfa");
    }
}

