/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.DocumentInfo;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.exceptions.InvalidPasswordException;
import com.aspose.pdf.facades.DocumentPrivilege;
import com.aspose.pdf.facades.PdfXmpMetadata;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.ms.System.z107;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z50;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.p143.z4;
import com.aspose.pdf.internal.p639.z9;
import com.aspose.pdf.internal.p651.z11;
import com.aspose.pdf.internal.p652.z32;
import com.aspose.pdf.internal.p652.z41;
import com.aspose.pdf.internal.p77.z37;
import com.aspose.pdf.internal.p81.z2;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileInfo
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfFileInfo.class.getName());
    private String m2;
    private InputStream m3;
    private boolean m4;
    private String m5 = null;
    private Map<String, String> m6;
    private boolean m7 = false;
    private static final String m8 = "xmp";
    private static final String m9 = "http://ns.adobe.com/xap/1.0/";

    @Override
    protected void m1(z41 z4110, String string) {
        try {
            super.m1(z4110, string);
            this.m1();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            m1.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.m5 = invalidPasswordException.getMessage();
            this.m7 = true;
            this.m4 = true;
        }
        catch (RuntimeException runtimeException) {
            m1.log(Level.INFO, "Exception occur", runtimeException);
            this.m5 = runtimeException.getMessage();
            this.m4 = false;
        }
    }

    @Override
    public void bindPdf(String srcFile, String password) {
        try {
            super.bindPdf(srcFile, password);
            this.m1();
        }
        catch (InvalidPasswordException invalidPasswordException) {
            m1.log(Level.INFO, "Exception occur", invalidPasswordException);
            this.m5 = invalidPasswordException.getMessage();
            this.m7 = true;
        }
        catch (RuntimeException runtimeException) {
            m1.log(Level.INFO, "Exception occur", runtimeException);
            this.m5 = runtimeException.getMessage();
            this.m4 = false;
        }
    }

    public void bindPdf(Document srcDoc) {
        super.bindPdf(srcDoc);
        this.m4 = true;
    }

    private void m1() {
        this.m4();
        this.m4 = true;
        this.m6 = new HashMap<String, String>();
        for (z9 z910 : this.getDocument().getInfo()) {
            if (DocumentInfo.isPredefinedKey((String)z910.getKey())) continue;
            this.m6.put((String)z910.getKey(), (String)z910.getValue());
        }
        this.getDocument().getPages().get_Item(1);
    }

    @Override
    protected void m4() {
        if (this.m11 == null) {
            String string = "PdfFileInfo is not initialized. Use constructors with parameters or properties for initialization.";
            if (this.m2 != null) {
                string = z133.m1(string, z133.m1(new String[]{" (File: ", this.m2, ")"}));
            }
            if (this.m5 != null) {
                string = z133.m1(string, z133.m1(new String[]{" (Reason: ", this.m5, ")"}));
            }
            throw new z107(string);
        }
    }

    public String getAuthor() {
        this.m4();
        return this.m11.getInfo().getAuthor();
    }

    public void setAuthor(String value) {
        this.m4();
        this.getDocument().getInfo().setAuthor(value);
    }

    public boolean isEncrypted() {
        if (this.m7) {
            return true;
        }
        this.m4();
        return this.getDocument().isEncrypted();
    }

    public boolean isPdfFile() {
        return this.m4;
    }

    public String getCreationDate() {
        this.m4();
        if (this.getDocument().getInfo().contains("CreationDate")) {
            return (String)this.getDocument().getInfo().get_Item("CreationDate");
        }
        return null;
    }

    public void setCreationDate(String value) {
        this.m4();
        this.getDocument().getInfo().setCreationDate(z50.m4(z2.m1(new z37(this.getDocument().getEngineDoc().m2(), value)).m1().m34()));
    }

    public String getCreator() {
        this.m4();
        return this.getDocument().getInfo().getCreator();
    }

    public void setCreator(String value) {
        this.m4();
        InternalHelper.m1(this.getDocument().getInfo(), value);
    }

    public boolean hasCollection() {
        this.m4();
        return this.getDocument().getCollection() != null;
    }

    public Map<String, String> getHeader() {
        return this.m6;
    }

    public void setHeader(Map<String, String> value) {
        this.m6 = value;
    }

    @Deprecated
    public String getInputFile() {
        return this.m2;
    }

    @Deprecated
    public void setInputFile(String value) {
        this.m2 = value;
        this.bindPdf(value, null);
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.m3;
    }

    @Deprecated
    public void setInputStream(InputStream value) {
        this.m3 = value;
        this.bindPdf(value, null);
    }

    public String getKeywords() {
        this.m4();
        return this.m11.getInfo().getKeywords();
    }

    public void setKeywords(String value) {
        this.m4();
        this.getDocument().getInfo().setKeywords(value);
    }

    public String getModDate() {
        this.m4();
        if (this.getDocument().getInfo().contains("ModDate")) {
            return (String)this.getDocument().getInfo().get_Item("ModDate");
        }
        return null;
    }

    public void setModDate(String value) {
        this.m4();
        this.getDocument().getInfo().setModDate(z50.m4(z2.m1(new z37(this.getDocument().getEngineDoc().m2(), value)).m1().m34()));
    }

    public int getNumberOfPages() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public String getProducer() {
        this.m4();
        return this.getDocument().getInfo().getProducer();
    }

    public String getSubject() {
        this.m4();
        return this.getDocument().getInfo().getSubject();
    }

    public void setSubject(String value) {
        this.m4();
        this.getDocument().getInfo().setSubject(value);
    }

    public String getTitle() {
        this.m4();
        return this.getDocument().getInfo().getTitle();
    }

    public void setTitle(String value) {
        this.m4();
        this.getDocument().getInfo().setTitle(value);
    }

    public PdfFileInfo() {
    }

    public PdfFileInfo(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfFileInfo(InputStream inputStream, String password) {
        this.m3 = inputStream;
        this.bindPdf(inputStream, password);
    }

    public PdfFileInfo(String inputFile) {
        this(inputFile, null);
    }

    public PdfFileInfo(String inputFile, String password) {
        this.m2 = inputFile;
        this.bindPdf(inputFile, password);
    }

    public void clearInfo() {
        this.m4();
        this.getDocument().getInfo().clear();
        this.m6.clear();
    }

    public DocumentPrivilege getDocumentPrivilege() {
        this.m4();
        return new DocumentPrivilege(this.getDocument().getPermissions());
    }

    public String getMetaInfo(String name) {
        this.m4();
        if (!DocumentInfo.isPredefinedKey(name) && this.m6.containsKey(name)) {
            return this.m6.get(name);
        }
        return z133.m1;
    }

    public float getPageHeight(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getHeight();
    }

    public int getPageRotation(int pageNum) {
        this.m4();
        switch (this.getDocument().getPages().get_Item(pageNum).getRotate()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public float getPageWidth(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getWidth();
    }

    public float getPageXOffset(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLX();
    }

    public float getPageYOffset(int pageNum) {
        this.m4();
        Rectangle rectangle = this.getDocument().getPages().get_Item(pageNum).getRect();
        rectangle.rotate(this.getDocument().getPages().get_Item(pageNum).getRotate());
        return (float)rectangle.getLLY();
    }

    public String getPdfVersion() {
        this.m4();
        return this.getDocument().getVersion();
    }

    @Deprecated
    public boolean saveNewInfo(OutputStream outputStream) {
        this.m4();
        try {
            this.save(outputStream);
            return true;
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            return false;
        }
    }

    public boolean saveNewInfo(String outputFile) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.saveNewInfo(fileOutputStream);
        }
        catch (Exception exception) {
            m1.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream destStream) {
        z32 z3210 = new z32();
        this.m1(z3210);
        try {
            if (((z41)z3210).m3()) {
                ((z41)z3210).m1(0L, 0);
            }
            byte[] byArray = new byte[z3210.m24().available()];
            z3210.m24().read(byArray);
            destStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.m1();
            }
        }
    }

    @Override
    void m1(z41 z4110) {
        this.m2();
        this.getDocument().saveInternal(z4110);
    }

    private void m2() {
        this.m4();
        this.getDocument().getInfo().clearCustomData();
        for (Map.Entry<String, String> entry : this.m6.entrySet()) {
            this.getDocument().getInfo().addItem(entry.getKey(), entry.getValue());
        }
    }

    public void setMetaInfo(String name, String value) {
        this.m4();
        if (this.m6.containsKey(name)) {
            this.m6.remove(name);
        }
        this.m6.put(name, value);
    }

    public boolean saveNewInfoWithXmp(String outputFileName) {
        PdfXmpMetadata pdfXmpMetadata = new PdfXmpMetadata();
        pdfXmpMetadata.bindPdf(this.m2);
        IDocument iDocument = pdfXmpMetadata.getDocument();
        this.getDocument().getMetadata().registerNamespaceUri(m8, m9);
        if (this.getAuthor() != null) {
            iDocument.getInfo().setAuthor(this.getAuthor());
            pdfXmpMetadata.set_Item("dc:creator", new Object[]{this.getAuthor()});
        }
        if (this.getCreator() != null) {
            InternalHelper.m1(iDocument.getInfo(), this.getCreator());
            pdfXmpMetadata.set_Item("xmp:CreatorTool", this.getCreator());
        }
        if (this.getKeywords() != null) {
            iDocument.getInfo().setKeywords(this.getKeywords());
            pdfXmpMetadata.set_Item("pdf:Keywords", this.getKeywords());
        }
        if (this.getSubject() != null) {
            iDocument.getInfo().setSubject(this.getSubject());
            pdfXmpMetadata.set_Item("dc:description", new Object[]{this.getSubject()});
        }
        if (this.getTitle() != null) {
            iDocument.getInfo().setTitle(this.getTitle());
            pdfXmpMetadata.set_Item("dc:title", new Object[]{this.getTitle()});
        }
        pdfXmpMetadata.set_Item("pdf:Producer", "Aspose.Pdf for Java 16.12.0");
        if (this.getCreationDate() != null) {
            iDocument.getInfo().setCreationDate(this.getDocument().getInfo().getCreationDate());
            pdfXmpMetadata.set_Item("xmp:CreateDate", PdfFileInfo.m1(z50.m1(this.m11.getInfo().getCreationDate())));
        }
        if (this.getModDate() != null) {
            iDocument.getInfo().setModDate(this.getDocument().getInfo().getModDate());
            pdfXmpMetadata.set_Item("xmp:ModifyDate", PdfFileInfo.m1(z50.m1(this.m11.getInfo().getModDate())));
        }
        for (Map.Entry<String, String> object : this.m6.entrySet()) {
            pdfXmpMetadata.registerNamespaceURI("pdfx", "http://ns.adobe.com/pdfx/1.3/");
            pdfXmpMetadata.addItem(z133.m1(new String[]{"pdfx:", object.getKey().toString()}), object.getValue().toString());
        }
        for (String string : this.m6.keySet()) {
            iDocument.getInfo().removeItem(string);
        }
        for (Map.Entry entry : this.m6.entrySet()) {
            iDocument.getInfo().addItem(entry.getKey(), entry.getValue());
        }
        iDocument.save(outputFileName);
        return true;
    }

    public PdfFileInfo(IDocument document) {
        super(document);
    }

    private static String m1(z50 z5010) {
        String string = z5010.m2("yyyy-MM-ddTHH\\:mm\\:ss\\.fff");
        string = z133.m1(string, z50.m1(z5010, "zzz", z11.m26()));
        return string;
    }

    public int getPasswordType() {
        if (this.m7) {
            return 3;
        }
        if (this.isEncrypted() && this.getDocument() != null) {
            z4 z4100 = this.getDocument().getEngineDoc().m2().m75();
            if (z4100.m1(z4100.m5())) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean hasOpenPassword() {
        z4 z4100 = this.getDocument() != null ? this.getDocument().getEngineDoc().m2().m75() : null;
        switch (this.getPasswordType()) {
            case 3: {
                return true;
            }
            case 1: {
                return !z133.m5(z4100.m5(), z133.m1);
            }
            case 2: {
                return !z4100.m1(z133.m1);
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public boolean hasEditPassword() {
        switch (this.getPasswordType()) {
            case 1: {
                z4 z4100 = this.getDocument().getEngineDoc().m2().m75();
                return !z4100.m2(z4100.m5());
            }
            case 3: {
                throw new InvalidPasswordException("Document must be opened with valid password in order to read this property.");
            }
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        this.m3 = null;
        this.m2 = null;
        this.m6 = null;
        this.m4 = false;
        this.m7 = false;
        this.m5 = null;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

