/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.DocumentDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.devices.z1;
import com.aspose.pdf.exceptions.IndexOutOfRangeException;
import com.aspose.pdf.internal.ms.System.z107;
import com.aspose.pdf.internal.ms.System.z11;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.p132.z5;
import com.aspose.pdf.internal.p135.z8;
import com.aspose.pdf.internal.p138.z4;
import com.aspose.pdf.internal.p138.z9;
import com.aspose.pdf.internal.p645.z2;
import com.aspose.pdf.internal.p652.z32;
import com.aspose.pdf.internal.p652.z41;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TiffDevice
extends DocumentDevice {
    private static final Logger m1 = Logger.getLogger(TiffDevice.class.getName());
    private Resolution m2;
    private TiffSettings m3 = new TiffSettings();
    private IIndexBitmapConverter m4;
    private int m5 = 0;
    private int m6 = 0;
    private int m7 = 0;
    private boolean m8 = false;
    private RenderingOptions m9 = new RenderingOptions();
    private Rectangle m10 = null;

    boolean m1() {
        return this.m8;
    }

    void m1(boolean bl) {
        this.m8 = bl;
    }

    public RenderingOptions getRenderingOptions() {
        return this.m9;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.m9 = value;
    }

    public int getFormPresentationMode() {
        return this.m7;
    }

    public void setFormPresentationMode(int value) {
        this.m7 = value;
    }

    public TiffSettings getSettings() {
        return this.m3;
    }

    public Resolution getResolution() {
        return this.m2;
    }

    public TiffDevice(Resolution resolution) {
        this.m2 = resolution;
        this.m3 = new TiffSettings();
    }

    public TiffDevice(Resolution resolution, TiffSettings settings) {
        this.m2 = resolution;
        this.m3 = settings;
    }

    public TiffDevice(Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.m2 = resolution;
        this.m3 = settings;
        this.m4 = converter;
    }

    public TiffDevice(TiffSettings settings) {
        this.m2 = new Resolution(150);
        this.m3 = settings;
    }

    public TiffDevice(TiffSettings settings, IIndexBitmapConverter converter) {
        this.m2 = new Resolution(150);
        this.m3 = settings;
        this.m4 = converter;
    }

    public TiffDevice() {
        this.m2 = new Resolution(150);
        this.m3 = new TiffSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal(IDocument document, int fromPage, int toPage, z41 output) {
        int n;
        if (document == null) {
            throw new z107("Document is null");
        }
        switch (this.m3.getCompression()) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                throw new z11();
            }
        }
        z4 z4100 = new z4(this.m3.getMargins().getLeft(), this.m3.getMargins().getRight(), this.m3.getMargins().getTop(), this.m3.getMargins().getBottom());
        int n2 = 0;
        switch (this.m3.getDepth()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 196865;
                break;
            }
            case 2: {
                n2 = 197634;
                break;
            }
            case 1: {
                n2 = 198659;
            }
        }
        int n3 = this.m3.getShape();
        z9 z910 = new z9(n, n2, z4100, this.m3.getSkipBlankPages(), n3);
        z910.m1(this.m3.getBrightness());
        z5 z5100 = null;
        com.aspose.pdf.internal.p138.z8 z810 = new com.aspose.pdf.internal.p138.z8(output, z910, this.m2.getX(), this.m2.getY(), this.m4);
        try {
            try {
                for (int i = fromPage; i <= toPage; ++i) {
                    z2 z2100 = null;
                    z1 z1100 = new z1(document.getPages().get_Item(i), new Point(0.0, 0.0), this.m5, this.m6, new Resolution(this.m2.getX(), this.m2.getY()), this.getFormPresentationMode(), this.getRenderingOptions(), this.m1(), this.m3.getCoordinateType());
                    com.aspose.pdf.internal.p42.z5 z5101 = null;
                    com.aspose.pdf.internal.p42.z5[] z5Array = new com.aspose.pdf.internal.p42.z5[]{z5101};
                    if (this.m10 != null) {
                        if (this.m10.getHeight() <= 0.0 || this.m10.getHeight() > document.getPages().get_Item(i).getMediaBox().getHeight() || this.m10.getWidth() <= 0.0 || this.m10.getWidth() > document.getPages().get_Item(i).getMediaBox().getWidth()) {
                            throw new IndexOutOfRangeException("Rectangle has falls parametrs");
                        }
                        z8 z811 = (z8)z1100.m1();
                        z811.m1(this.m10);
                        z5100 = z811;
                    } else {
                        z5100 = z1100.m1(z5Array);
                    }
                    z5101 = z5Array[0];
                    try {
                        z2100 = (z2)z5100.m2().m10();
                        if (this.m3.getSkipBlankPages() && z5101.m2().m1(1.0E-5)) continue;
                        z810.m1(z2100);
                        continue;
                    }
                    finally {
                        if (z5100 != null) {
                            z5100.dispose();
                        }
                    }
                }
            }
            finally {
                z810.m1();
            }
        }
        finally {
            if (z810 != null) {
                z810.dispose();
            }
        }
    }

    @Override
    public void process(IDocument document, int fromPage, int toPage, OutputStream output) {
        z32 z3210 = new z32();
        this.processInternal(document, fromPage, toPage, z3210);
        try {
            if (z3210 != null) {
                output.write(z3210.m11());
            }
            z3210.m1();
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings) {
        this.m5 = width;
        this.m6 = height;
        this.m2 = resolution;
        this.m3 = settings;
    }

    public TiffDevice(int width, int height, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        this.m5 = width;
        this.m6 = height;
        this.m2 = resolution;
        this.m3 = settings;
        this.m4 = converter;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.m5 = (int)z172.m4((float)resolution.getX() * f / 72.0f);
        this.m6 = (int)z172.m4((float)resolution.getY() * f2 / 72.0f);
        this.m2 = resolution;
        this.m3 = settings;
    }

    public TiffDevice(PageSize pageSize, Resolution resolution, TiffSettings settings, IIndexBitmapConverter converter) {
        float f = pageSize.getWidth();
        float f2 = pageSize.getHeight();
        this.m5 = (int)z172.m4((float)resolution.getX() * f / 72.0f);
        this.m6 = (int)z172.m4((float)resolution.getY() * f2 / 72.0f);
        this.m2 = resolution;
        this.m3 = settings;
        this.m4 = converter;
    }

    public TiffDevice(int width, int height, Resolution resolution) {
        this(width, height, resolution, new TiffSettings());
    }

    public TiffDevice(PageSize pageSize, Resolution resolution) {
        this(pageSize, resolution, new TiffSettings());
    }

    public TiffDevice(int width, int height, TiffSettings settings) {
        this(width, height, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height, TiffSettings settings, IIndexBitmapConverter converter) {
        this(width, height, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings, IIndexBitmapConverter converter) {
        this(pageSize, new Resolution(150), settings, converter);
    }

    public TiffDevice(PageSize pageSize, TiffSettings settings) {
        this(pageSize, new Resolution(150), settings);
    }

    public TiffDevice(int width, int height) {
        this(width, height, new Resolution(150), new TiffSettings());
    }

    public TiffDevice(PageSize pageSize) {
        this(pageSize, new Resolution(150), new TiffSettings());
    }

    public int getWidth() {
        return this.m5;
    }

    public int getHeight() {
        return this.m6;
    }

    public Rectangle getCropRectangle() {
        return this.m10;
    }

    public void setCropRectangle(Rectangle cropRectangle) {
        this.m10 = cropRectangle;
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

