/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.Page;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.devices.PageDevice;
import com.aspose.pdf.internal.ms.System.z107;
import com.aspose.pdf.internal.p652.z32;
import com.aspose.pdf.internal.p652.z41;
import com.aspose.pdf.internal.p677.z18;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TextDevice
extends PageDevice {
    private static final Logger m1 = Logger.getLogger(TextDevice.class.getName());
    private TextExtractionOptions m2;
    private z18 m3;

    private void m1(TextExtractionOptions textExtractionOptions, z18 z1810) {
        this.m2 = textExtractionOptions;
        this.m3 = z1810;
    }

    public TextExtractionOptions getExtractionOptions() {
        return this.m2;
    }

    public void setExtractionOptions(TextExtractionOptions value) {
        this.m2 = value;
    }

    public TextEncodingInternal getEncodingInternal() {
        if (z18.m20().equals(this.m3)) {
            return TextEncodingInternal.getASCII();
        }
        if (z18.m21().equals(this.m3)) {
            return TextEncodingInternal.getBigEndianUnicode();
        }
        if (z18.m22().equals(this.m3)) {
            return TextEncodingInternal.getDefault();
        }
        if (z18.m27().equals(this.m3)) {
            return TextEncodingInternal.getUnicode();
        }
        if (z18.m28().equals(this.m3)) {
            return TextEncodingInternal.getUTF32();
        }
        if (z18.m29().equals(this.m3)) {
            return TextEncodingInternal.getUTF32BE();
        }
        if (z18.m23().equals(this.m3)) {
            return TextEncodingInternal.getUTF7();
        }
        if (z18.m24().equals(this.m3)) {
            return TextEncodingInternal.getUTF8();
        }
        if (z18.m25().equals(this.m3)) {
            return TextEncodingInternal.getUTF8Unmarked();
        }
        return null;
    }

    public Charset getEncoding() {
        return z18.m1(this.m3);
    }

    public void setEncodingInternal(TextEncodingInternal value) {
        this.m3 = value.getInternalFormat();
    }

    public void setEncoding(Charset value) {
        this.setEncodingInternal(TextEncodingInternal.getEncoding(value.displayName()));
    }

    @Override
    public void processInternal(Page page, z41 output) {
        if (page == null) {
            throw new z107("Page is null");
        }
        TextAbsorber textAbsorber = new TextAbsorber(this.m2);
        textAbsorber.visit(page);
        byte[] byArray = this.m3.m3(textAbsorber.getText());
        output.m1(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Page page, OutputStream output) {
        z32 z3210 = new z32();
        this.processInternal(page, z3210);
        try {
            if (((z41)z3210).m3()) {
                ((z41)z3210).m1(0L, 0);
            }
            byte[] byArray = new byte[z3210.m24().available()];
            z3210.m24().read(byArray);
            output.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.m1();
            }
        }
    }

    public TextDevice(TextExtractionOptions extractionOptions) {
        this.m1(extractionOptions, z18.m27());
    }

    public TextDevice() {
        this.m1(new TextExtractionOptions(0), z18.m27());
    }

    public TextDevice(TextEncodingInternal encoding) {
        this.m1(new TextExtractionOptions(0), encoding.getInternalFormat());
    }

    public TextDevice(Charset encoding) {
        this(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public TextDevice(TextExtractionOptions extractionOptions, TextEncodingInternal encoding) {
        this.m1(extractionOptions, encoding.getInternalFormat());
    }

    public TextDevice(TextExtractionOptions extractionOptions, Charset encoding) {
        this(extractionOptions, TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

