/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.DocMDPSignature;
import com.aspose.pdf.Document;
import com.aspose.pdf.Field;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.PKCS1;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Signature;
import com.aspose.pdf.SignatureField;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.ms.System.z13;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z8;
import com.aspose.pdf.internal.ms.System.z9;
import com.aspose.pdf.internal.p129.z2;
import com.aspose.pdf.internal.p129.z6;
import com.aspose.pdf.internal.p609.z14;
import com.aspose.pdf.internal.p622.z19;
import com.aspose.pdf.internal.p622.z28;
import com.aspose.pdf.internal.p622.z32;
import com.aspose.pdf.internal.p622.z41;
import com.aspose.pdf.internal.p790.z5;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfFileSignature
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfFileSignature.class.getName());
    private String m2;
    private String m3;
    private InputStream m4;
    private Signature m5;
    private int m6;
    private String m7;
    private boolean m8;
    private Rectangle m9;
    private String m10;
    private String m12;
    private int m13;

    private void m3(String string) {
        this.m4();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() == null) {
            throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field or signature field is empty.", new Object[]{string}));
        }
    }

    private void m4(String string) {
        this.m4();
        if (!(this.getDocument().getForm().get_Item(string) instanceof SignatureField) || ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature() != null) {
            throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field or signature field is not empty.", new Object[]{string}));
        }
    }

    private void m1() {
        if (this.m5 != null) {
            throw new z8("Several signatures can't be placed at once. Please, after each Sign invoke Save.");
        }
    }

    private String m2() {
        int n = 1;
        String string = "Signature";
        do {
            string = z133.m1("Signature{0}", new Object[]{z5.m1(n)});
            ++n;
        } while (this.getDocument().getForm().get(string) != null);
        return string;
    }

    public String getSignatureAppearance() {
        return this.m3;
    }

    public void setSignatureAppearance(String value) {
        this.m3 = value;
        if (value != null) {
            this.m4 = null;
        }
    }

    public PdfFileSignature() {
    }

    @Deprecated
    public PdfFileSignature(String inputFile) {
        this.bindPdf(inputFile);
    }

    @Deprecated
    public PdfFileSignature(String inputFile, String outputFile) {
        this.bindPdf(inputFile);
        this.m2 = outputFile;
    }

    @Override
    public void bindPdf(String inputFile) {
        this.m13 = (int)new z19(inputFile).m3();
        super.bindPdf(inputFile);
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.m7(z41.fromJava(inputStream));
    }

    @Override
    void m7(z41 z4110) {
        this.m13 = (int)z4110.getLength();
        super.m7(z4110);
    }

    @Override
    public void save(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.save(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        this.m4();
        String string = null;
        if (this.getDocument().getEngineDoc().m1() != null && this.getDocument().getEngineDoc().m1().m1() != null && !z133.m2(this.getDocument().getEngineDoc().m1().m1().m72())) {
            string = this.getDocument().getEngineDoc().m1().m1().m72();
        }
        z32 z3210 = new z32();
        this.m1(this.getDocument().getEngineDoc().m12(), z3210, string);
        try {
            if (((z41)z3210).canSeek()) {
                ((z41)z3210).seek(0L, 0);
            }
            byte[] byArray = new byte[z3210.toInputStream().available()];
            z3210.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.close();
            }
        }
    }

    private void m1(z41 z4110, z41 z4111, String string) {
        if (this.m5 != null) {
            Object object;
            Document document;
            int n;
            if (z4110.canSeek()) {
                z4110.seek(0L, 0);
            }
            byte[] byArray = new byte[1024];
            while ((n = z4110.read(byArray, 0, z13.m1((Object)byArray).m6())) == z13.m1((Object)byArray).m6()) {
                z4111.write(byArray, 0, z13.m1((Object)byArray).m6());
            }
            z4111.write(byArray, 0, n);
            if (z4111.canSeek()) {
                z4111.seek(0L, 0);
            }
            if (string != null) {
                document = new Document(z4111.toInputStream(), string, false);
                document.decrypt();
            } else {
                document = new Document(z4111);
            }
            for (int i = 0; i < document.getEngineDoc().m2().m71().m9().length; ++i) {
                object = document.getEngineDoc().m2().m71();
                com.aspose.pdf.internal.p18.z2 z2100 = object.m9()[i];
                com.aspose.pdf.internal.p68.z14 z1410 = object.m1(z2100);
                object.m1(z1410, false);
            }
            if (this.m3 != null) {
                this.m5.setImageInternal(new z28(this.m3, 3, 1, 1));
            } else if (this.m4 != null) {
                this.m5.setImage(this.m4);
            }
            if (this.m7 != null) {
                SignatureField signatureField = (SignatureField)((Object)z5.m1(document.getForm().get_Item(this.m7), SignatureField.class));
                if (signatureField != null) {
                    if (!this.m8) {
                        signatureField.setRect(Rectangle.getTrivial());
                    } else if (this.m9 != null) {
                        signatureField.setRect(this.m9);
                    }
                    signatureField.sign(this.m5);
                }
            } else {
                SignatureField signatureField;
                if (!this.m8) {
                    signatureField = new SignatureField(document.getPages().get_Item(this.m6), Rectangle.getTrivial());
                } else {
                    object = this.m9 == null ? new Rectangle(10.0, 10.0, 110.0, 110.0) : this.m9;
                    signatureField = new SignatureField(document.getPages().get_Item(this.m6), (Rectangle)object);
                }
                object = this.m2();
                signatureField.setPartialName((String)object);
                document.getForm().add(signatureField, this.m6);
                document.getEngineDoc().m1(false);
                document.save();
                signatureField = (SignatureField)((Object)z5.m1(document.getForm().get_Item((String)object), SignatureField.class));
                signatureField.sign(this.m5);
            }
        } else {
            this.getDocument().save(z4111.toOutputStream());
        }
        if (this.m5 != null && this.m5.getImageInternal() != null) {
            this.m5.getImageInternal().dispose();
        }
        this.m5 = null;
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect) {
        if (this.m10 == null) {
            throw new IllegalStateException("Certificate file and password was not set. Please call SetCertificate.");
        }
        this.sign(page, SigReason, SigContact, SigLocation, visible, annotRect, new PKCS1(this.m10, this.m12));
    }

    public void sign(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.m1();
        this.m6 = page;
        this.m5 = sig;
        this.m5.setReason(SigReason);
        this.m5.setContactInfo(SigContact);
        this.m5.setLocation(SigLocation);
        this.m8 = visible;
        this.m9 = new Rectangle(annotRect.getX(), annotRect.getY(), annotRect.getX() + annotRect.getWidth(), annotRect.getY() - annotRect.getHeight());
    }

    public void sign(int page, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.sign(page, sig.getReason(), sig.getContactInfo(), sig.getLocation(), visible, annotRect, sig);
    }

    public void sign(String SigName, String SigReason, String SigContact, String SigLocation, Signature sig) {
        this.m1();
        this.m4(SigName);
        this.m7 = SigName;
        this.m5 = sig;
        this.m5.setReason(SigReason);
        this.m5.setContactInfo(SigContact);
        this.m5.setLocation(SigLocation);
        this.m8 = true;
    }

    public void sign(int page, String SigName, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, Signature sig) {
        this.m1();
        this.m6 = page;
        this.m5 = sig;
        this.m7 = SigName;
        this.m5.setReason(SigReason);
        this.m5.setContactInfo(SigContact);
        this.m5.setLocation(SigLocation);
        this.m8 = visible;
        this.m9 = new Rectangle(annotRect.getX(), annotRect.getY(), annotRect.getX() + annotRect.getWidth(), annotRect.getY() - annotRect.getHeight());
    }

    public void sign(String SigName, Signature sig) {
        this.sign(SigName, sig.getReason(), sig.getContactInfo(), sig.getLocation(), sig);
    }

    public boolean isCertified() {
        this.m4();
        for (Field field : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)z5.m1(field, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null || signatureField.getSignature().getSignatureReferences() == null) continue;
            for (z6 z6100 : signatureField.getSignature().getSignatureReferences()) {
                if (!z133.m5(z6100.m2().toString(), "DocMDP")) continue;
                return true;
            }
        }
        return false;
    }

    public int getAccessPermissions() {
        this.m4();
        for (Field field : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)z5.m1(field, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null || signatureField.getSignature().getSignatureReferences() == null) continue;
            for (z6 z6100 : signatureField.getSignature().getSignatureReferences()) {
                z2 z2100;
                if (!z133.m5(z6100.m2().toString(), "DocMDP") || (z2100 = (z2)((Object)z5.m1(z6100.m3(), z2.class))) == null) continue;
                return z2100.m2().m1();
            }
        }
        throw new z8("The document is not certified.");
    }

    public void certify(int page, String SigReason, String SigContact, String SigLocation, boolean visible, java.awt.Rectangle annotRect, DocMDPSignature docMdpSignature) {
        Signature signature = docMdpSignature.getSignature();
        this.sign(page, signature.getReason(), signature.getContactInfo(), signature.getLocation(), visible, annotRect, signature);
    }

    public List<String> getSignNames() {
        this.m4();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : this.getDocument().getForm()) {
            if (!(field instanceof SignatureField) || ((SignatureField)((Object)z5.m1(field, SignatureField.class))).getSignature() == null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    public List<String> getBlankSignNames() {
        this.m4();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : this.getDocument().getForm()) {
            if (!(field instanceof SignatureField) || ((SignatureField)((Object)z5.m1(field, SignatureField.class))).getSignature() != null) continue;
            arrayList.add(field.getPartialName());
        }
        return arrayList;
    }

    @Deprecated
    public boolean isContainSignature() {
        return this.containsSignature();
    }

    public boolean containsSignature() {
        return this.getSignNames().size() > 0;
    }

    public boolean containsUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)z5.m1(object, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null) continue;
            for (z6 z6100 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(z6100.m2().toString())) continue;
                return true;
            }
        }
        if (this.getDocument().getEngineDoc().m2().m16() != null) {
            for (Object object : this.getDocument().getEngineDoc().m2().m16()) {
                if (!"UR3".equals(((z14)object).m1())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean isCoversWholeDocument(String signName) {
        return this.coversWholeDocument(signName);
    }

    public boolean coversWholeDocument(String signName) {
        this.m4();
        this.m3(signName);
        int n = ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return n == this.m13;
    }

    public int getRevision(String signName) {
        this.m4();
        this.m3(signName);
        int[] nArray = new int[this.getTotalRevision()];
        int n = 0;
        for (String string : this.getSignNames()) {
            nArray[n++] = ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class))).getSignature().getByteRange()[3];
        }
        z13.m5(z13.m1((Object)nArray));
        int n2 = ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[2] + ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getByteRange()[3];
        return Arrays.binarySearch(nArray, n2) + 1;
    }

    public int getTotalRevision() {
        this.m4();
        return this.getSignNames().size();
    }

    public void removeUsageRights() {
        for (Object object : this.getDocument().getForm()) {
            SignatureField signatureField = (SignatureField)((Object)z5.m1(object, SignatureField.class));
            if (signatureField == null || signatureField.getSignature() == null) continue;
            for (z6 z6100 : signatureField.getSignature().getSignatureReferences()) {
                if (!"UR3".equals(z6100.m2().toString())) continue;
                signatureField.clear();
                return;
            }
        }
        if (this.getDocument().getEngineDoc().m2().m16() != null) {
            for (Object object : this.getDocument().getEngineDoc().m2().m16()) {
                if (!"UR3".equals(((z14)object).m1())) continue;
                this.getDocument().getEngineDoc().m2().m16().m5("UR3");
                return;
            }
        }
    }

    public void removeSignature(String signName) {
        this.m4();
        if (!(this.getDocument().getForm().get_Item(signName) instanceof SignatureField)) {
            throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
        }
        this.getDocument().getForm().delete(signName);
    }

    public void removeSignature(String signName, boolean removeField) {
        if (removeField) {
            this.removeSignature(signName);
        } else {
            SignatureField signatureField = (SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class));
            if (signatureField == null) {
                throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
            }
            signatureField.clear();
        }
    }

    public boolean verifySigned(String signName) {
        return this.verifySignature(signName);
    }

    public String getSignerName(String signName) {
        this.m3(signName);
        return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getAuthority();
    }

    public Date getDateTime(String signName) {
        this.m3(signName);
        return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getDate();
    }

    public String getReason(String signName) {
        this.m3(signName);
        return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getReason();
    }

    public String getLocation(String signName) {
        this.m3(signName);
        return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getLocation();
    }

    public String getContactInfo(String signName) {
        this.m3(signName);
        return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().getContactInfo();
    }

    public boolean verifySignature(String signName) {
        this.m4();
        if (this.getDocument().getForm().get_Item(signName) instanceof SignatureField) {
            if (((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature() != null) {
                return ((SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(signName), SignatureField.class))).getSignature().verify();
            }
            throw new z9(z133.m1("Signature field '{0}' is empty.", new Object[]{signName}));
        }
        throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field.", new Object[]{signName}));
    }

    public InputStream extractImage(String signName) {
        z41 z4110 = this.m1(signName);
        if (z4110.canSeek()) {
            z4110.seek(0L, 0);
        }
        return z41.toJava(z4110);
    }

    z41 m1(String string) {
        this.m4();
        SignatureField signatureField = (SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return z41.fromJava(signatureField.extractImage());
            }
            throw new z9(z133.m1("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    z41 m2(String string) {
        this.m4();
        SignatureField signatureField = (SignatureField)((Object)z5.m1(this.getDocument().getForm().get_Item(string), SignatureField.class));
        if (signatureField != null) {
            if (signatureField.getSignature() != null) {
                return z41.fromJava(signatureField.extractCertificate());
            }
            throw new z9(z133.m1("Signature field '{0}' is empty.", new Object[]{string}));
        }
        throw new z9(z133.m1("The name '{0}' doesn't represent valid signature field.", new Object[]{string}));
    }

    public InputStream extractCertificate(String signName) {
        return z41.toJava(this.m2(signName));
    }

    @Deprecated
    public void save() {
        if (this.m2 == null) {
            throw new IllegalStateException("Output file is not defined. Please use proper PdfFileSignature constuctor to set output file.");
        }
        this.save(this.m2);
    }

    @Override
    public void bindPdf(Pdf pdf) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        pdf.save(byteArrayOutputStream);
        this.bindPdf(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public PdfFileSignature(IDocument document) {
        super(document);
        if (document.getEngineDoc() != null && document.getEngineDoc().m12() != null && document.getEngineDoc().m12().canRead()) {
            this.m13 = (int)document.getEngineDoc().m12().getLength();
        }
    }

    @Deprecated
    public PdfFileSignature(IDocument document, String outputFile) {
        super(document);
        this.m2 = outputFile;
    }

    public void setCertificate(String pfx, String pass) {
        this.m10 = pfx;
        this.m12 = pass;
    }

    public InputStream getSignatureAppearanceStream() {
        return this.m4;
    }

    public void setSignatureAppearanceStream(InputStream value) {
        this.m4 = value;
        if (value != null) {
            this.m3 = null;
        }
    }

    @Override
    public void close() {
        super.close();
        this.m2 = null;
        this.m3 = null;
        if (this.m5 != null && this.m5.getImageInternal() != null) {
            this.m5.getImageInternal().close();
        }
        if (this.m4 != null) {
            try {
                this.m4.close();
            }
            catch (IOException iOException) {
                m1.log(Level.INFO, "Exception occur", iOException);
            }
        }
        this.m4 = null;
        this.m5 = null;
        this.m6 = 0;
        this.m7 = null;
        this.m8 = false;
        this.m9 = null;
        this.m10 = null;
        this.m12 = null;
        this.m13 = 0;
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

