/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.internal.ms.System.z11;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z61;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.ms.System.z85;
import com.aspose.pdf.internal.p615.z176;
import com.aspose.pdf.internal.p615.z177;
import com.aspose.pdf.internal.p621.z9;
import com.aspose.pdf.internal.p68.z16;
import com.aspose.pdf.internal.p68.z20;
import com.aspose.pdf.internal.p68.z22;
import com.aspose.pdf.internal.p68.z29;
import com.aspose.pdf.internal.p790.z5;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Rectangle
implements Comparable<Object> {
    private static final Logger m2 = Logger.getLogger(Rectangle.class.getName());
    private double m3;
    private double m4;
    private double m5;
    private double m6;
    private boolean m7;
    @Deprecated
    static Rectangle m1;

    public double getWidth() {
        return z172.m1(this.getURX() - this.getLLX());
    }

    public double getHeight() {
        return z172.m1(this.getURY() - this.getLLY());
    }

    public double getLLX() {
        return this.m3;
    }

    public void setLLX(double value) {
        this.m3 = value;
    }

    public double getLLY() {
        return this.m4;
    }

    public void setLLY(double value) {
        this.m4 = value;
    }

    public double getURX() {
        return this.m5;
    }

    public void setURX(double value) {
        this.m5 = value;
    }

    public double getURY() {
        return this.m6;
    }

    public void setURY(double value) {
        this.m6 = value;
    }

    public Rectangle(double llx, double lly, double urx, double ury) {
        this(llx, lly, urx, ury, false);
    }

    private Rectangle(double llx, double lly, double urx, double ury, boolean isEmpty) {
        this.m3 = llx;
        this.m4 = lly;
        this.m5 = urx;
        this.m6 = ury;
        this.m7 = isEmpty;
        this.m3();
    }

    private void m3() {
        double d = z172.m4(this.m3, this.m5);
        double d2 = z172.m4(this.m4, this.m6);
        double d3 = z172.m3(this.m3, this.m5);
        double d4 = z172.m3(this.m4, this.m6);
        this.m3 = d;
        this.m4 = d2;
        this.m5 = d3;
        this.m6 = d4;
    }

    z176 m1() {
        return new z176((int)this.getLLX(), (int)this.getLLY(), (int)this.getWidth(), (int)this.getHeight());
    }

    z177 m2() {
        z177 z1772 = new z177(z5.m9(this.getLLX(), 14), z5.m9(this.getLLY(), 14), z5.m9(this.getWidth(), 14), z5.m9(this.getHeight(), 14));
        return z1772;
    }

    public java.awt.Rectangle toRect() {
        return this.m1().m1();
    }

    static Rectangle m1(z176 z1762) {
        return new Rectangle(z1762.m5(), z1762.m9(), z1762.m5() + z1762.m10(), z1762.m9() + z1762.m3());
    }

    public static Rectangle fromRect(java.awt.Rectangle src) {
        return Rectangle.m1(z176.m1(src));
    }

    public z22 toArray(z20 trailerable) {
        return new z22(trailerable, new z16[]{new z29(this.m3), new z29(this.m4), new z29(this.m5), new z29(this.m6)});
    }

    public String toString() {
        return z133.m1(z9.m4(), "{0},{1},{2},{3}", this.m3, this.m4, this.m5, this.m6);
    }

    public static Rectangle parse(String value) {
        z9 z9100 = z9.m4();
        try {
            String[] stringArray = z133.m6(value, ',');
            double d = z61.m1(stringArray[0], (z85)z9100);
            double d2 = z61.m1(stringArray[1], (z85)z9100);
            double d3 = z61.m1(stringArray[2], (z85)z9100);
            double d4 = z61.m1(stringArray[3], (z85)z9100);
            return new Rectangle(d, d2, d3, d4);
        }
        catch (z72 z7210) {
            m2.log(Level.INFO, "Exception occur", z7210);
            throw new IllegalStateException("Wrong input string.");
        }
    }

    public static Rectangle getEmpty() {
        if (m1 == null) {
            m1 = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
        }
        return m1;
    }

    public static Rectangle getTrivial() {
        return new Rectangle(0.0, 0.0, 0.0, 0.0);
    }

    public boolean isTrivial() {
        return Double.doubleToRawLongBits(this.getLLX()) == 0L && Double.doubleToRawLongBits(this.getLLY()) == 0L && Double.doubleToRawLongBits(this.getURX()) == 0L && Double.doubleToRawLongBits(this.getURY()) == 0L;
    }

    public boolean isEmpty() {
        return this.m7;
    }

    public boolean isPoint() {
        return Double.compare(this.m3, this.m5) == 0 && Double.compare(this.m4, this.m6) == 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        return Double.compare(this.getLLX(), ((Rectangle)other).getLLX()) == 0 && Double.compare(this.getLLY(), ((Rectangle)other).getLLY()) == 0 && Double.compare(this.getURX(), ((Rectangle)other).getURX()) == 0 && Double.compare(this.getURY(), ((Rectangle)other).getURY()) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private double[] m1(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = z172.m3(d, d3);
        if (d6 > (d5 = z172.m4(d2, d4))) {
            return null;
        }
        return new double[]{d6, d5};
    }

    public Rectangle intersect(Rectangle otherRect) {
        double[] dArray = this.m1(this.getLLX(), this.getURX(), otherRect.getLLX(), otherRect.getURX());
        double[] dArray2 = this.m1(this.getLLY(), this.getURY(), otherRect.getLLY(), otherRect.getURY());
        if (dArray != null && dArray2 != null) {
            return new Rectangle(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        }
        return null;
    }

    @Deprecated
    public void _Intersect(Rectangle otherRect) {
        this.m3 = Math.max(this.getLLX(), otherRect.getLLX());
        this.m5 = Math.min(this.getURX(), otherRect.getURX());
        this.m4 = Math.max(this.getLLY(), otherRect.getLLY());
        this.m6 = Math.min(this.getURY(), otherRect.getURY());
        this.m3();
    }

    boolean m1(Rectangle rectangle) {
        if (this.getLLX() > rectangle.getURX() || this.getURX() < rectangle.getLLX()) {
            return false;
        }
        return !(this.getLLY() > rectangle.getURY()) && !(this.getURY() < rectangle.getLLY());
    }

    public void rotate(int angle) {
        switch (angle) {
            case 1: 
            case 3: {
                double d = this.m3;
                this.m3 = this.m4;
                this.m4 = d;
                d = this.m5;
                this.m5 = this.m6;
                this.m6 = d;
            }
        }
    }

    public void rotateAngle(int angle) {
        if (angle < 0 || angle > 360) {
            throw new z11("angle", "Must be between 0 and 360");
        }
        double d = (double)angle * Math.PI / 180.0;
        double d2 = z172.m1((this.m3 + this.m5) / 2.0, 2);
        double d3 = z172.m1((this.m4 + this.m6) / 2.0, 2);
        double d4 = this.getHeight();
        double d5 = this.getWidth();
        this.m3 = z172.m1(d2 + d5 / 2.0 * z172.m8(d) + d4 / 2.0 * z172.m7(d), 2);
        this.m4 = z172.m1(d3 - d4 / 2.0 * z172.m8(d) + d5 / 2.0 * z172.m7(d), 2);
        this.m5 = z172.m1(d2 - d5 / 2.0 * z172.m8(d) - d4 / 2.0 * z172.m7(d), 2);
        this.m6 = z172.m1(d3 + d4 / 2.0 * z172.m8(d) - d5 / 2.0 * z172.m7(d), 2);
    }

    @Override
    public int compareTo(Object arg0) {
        if (((Rectangle)arg0).getLLX() > this.getLLX()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLX() < this.getLLX()) {
            return -1;
        }
        if (((Rectangle)arg0).getLLY() > this.getLLY()) {
            return 1;
        }
        if (((Rectangle)arg0).getLLY() < this.getLLY()) {
            return -1;
        }
        if (((Rectangle)arg0).getURX() > this.getURX()) {
            return 1;
        }
        if (((Rectangle)arg0).getURX() < this.getURX()) {
            return -1;
        }
        if (((Rectangle)arg0).getURY() > this.getURY()) {
            return 1;
        }
        if (((Rectangle)arg0).getURY() < this.getURY()) {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    public Object deepClone() {
        return new Rectangle(this.getLLX(), this.getLLY(), this.getURX(), this.getURY());
    }

    static {
        m2.setUseParentHandlers(false);
        m1 = new Rectangle(0.0, 0.0, 0.0, 0.0, true);
    }
}

