/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.xps.metadata;

import com.aspose.page.internal.l18l.I184;
import com.aspose.xps.metadata.Feature;
import com.aspose.xps.metadata.IFeatureItem;
import com.aspose.xps.metadata.IOptionItem;
import com.aspose.xps.metadata.IPrintTicketElementChild;
import com.aspose.xps.metadata.IPropertyItem;
import com.aspose.xps.metadata.IScoredPropertyItem;
import com.aspose.xps.metadata.IntegerValue;
import com.aspose.xps.metadata.Option;
import com.aspose.xps.metadata.Property;
import com.aspose.xps.metadata.ScoredProperty;
import com.aspose.xps.metadata.SelectionType;
import com.aspose.xps.metadata.StringValue;

public abstract class InputBin
extends Feature {
    InputBin(String name, IInputBinItem ... items) {
        super(name, items);
        this.lif(0, (IPrintTicketElementChild)SelectionType.PickOne);
    }

    public static final class InputBinOption
    extends Option
    implements IInputBinItem {
        private static String[] lif = new String[]{"psk:BinType", "psk:FeedType", "psk:MediaCapacity", "psk:MediaSizeAutoSense", "psk:MediaTypeAutoSense", "psk:MediaSheetCapacity", "psk:MediaPath", "psk:FeedFace", "psk:FeedDirection"};
        public static InputBinOption AutoSelect = new InputBinOption("psk:AutoSelect");
        public static InputBinOption Manual = new InputBinOption("psk:Manual");
        public static InputBinOption Cassette = (InputBinOption)new InputBinOption("psk:Cassette", BinType.SheetFeed).makeConst();
        public static InputBinOption Tractor = (InputBinOption)new InputBinOption("psk:Tractor", BinType.ContinuousFeed).makeConst();
        public static InputBinOption AutoSheetFeeder = new InputBinOption("psk:AutoSheetFeeder");

        public InputBinOption(String optionName, IInputBinOptionItem ... items) {
            super(optionName, (IOptionItem[])items);
        }

        public InputBinOption(InputBinOption option) {
            super(option);
        }

        private InputBinOption(String name) {
            super(name, new IOptionItem[0]);
            this.makeConst();
        }

        public InputBinOption add(IInputBinOptionItem ... items) {
            super.add(items);
            return this;
        }

        public InputBinOption setMediaCapacity(int mediaCapacity) {
            if (mediaCapacity <= 0) {
                throw new IllegalArgumentException(I184.lif("Invalid value: {0}.", new Object[]{mediaCapacity}));
            }
            this.add(new ScoredProperty("psk:MediaCapacity", new IntegerValue(mediaCapacity), new IScoredPropertyItem[0]));
            return this;
        }

        public InputBinOption setMediaSheetCapacity(int mediaSheetCapacity) {
            if (mediaSheetCapacity <= 0) {
                throw new IllegalArgumentException(I184.lif("Invalid value: {0}.", new Object[]{mediaSheetCapacity}));
            }
            this.add(new ScoredProperty("psk:MediaSheetCapacity", new IntegerValue(mediaSheetCapacity), new IScoredPropertyItem[0]));
            return this;
        }

        public InputBinOption clone() {
            return new InputBinOption(this);
        }

        @Override
        String[] am_() {
            return lif;
        }
    }

    public static final class FeedDirection
    extends Property
    implements IInputBinOptionItem {
        public static FeedDirection LongEdgeFirst = new FeedDirection("LongEdgeFirst");
        public static FeedDirection ShortEdgeFirst = new FeedDirection("ShortEdgeFirst");

        private FeedDirection(String value) {
            super("psk:FeedDirection", new StringValue(value), new IPropertyItem[0]);
        }
    }

    public static final class FeedFace
    extends Property
    implements IInputBinOptionItem {
        public static FeedFace FaceUp = new FeedFace("FaceUp");
        public static FeedFace FaceDown = new FeedFace("FaceDown");

        private FeedFace(String value) {
            super("psk:FeedFace", new StringValue(value), new IPropertyItem[0]);
        }
    }

    public static final class MediaPath
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static MediaPath Straight = new MediaPath("Straight");
        public static MediaPath Serpentine = new MediaPath("Serpentine");

        private MediaPath(String value) {
            super("psk:MediaPath", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class MediaTypeAutoSense
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static MediaTypeAutoSense Supported = new MediaTypeAutoSense("Supported");
        public static MediaTypeAutoSense None = new MediaTypeAutoSense("None");

        private MediaTypeAutoSense(String value) {
            super("psk:MediaTypeAutoSense", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class MediaSizeAutoSense
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static MediaSizeAutoSense Supported = new MediaSizeAutoSense("Supported");
        public static MediaSizeAutoSense None = new MediaSizeAutoSense("None");

        private MediaSizeAutoSense(String value) {
            super("psk:MediaSizeAutoSense", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class FeedType
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static FeedType Automatic = new FeedType("Automatic");
        public static FeedType Manual = new FeedType("Manual");

        private FeedType(String value) {
            super("psk:FeedType", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static final class BinType
    extends ScoredProperty
    implements IInputBinOptionItem {
        public static BinType ContinuousFeed = new BinType("ContinuousFeed");
        public static BinType SheetFeed = new BinType("SheetFeed");

        private BinType(String value) {
            super("psk:BinType", new StringValue(value), new IScoredPropertyItem[0]);
        }
    }

    public static interface IInputBinOptionItem
    extends IOptionItem {
    }

    public static interface IInputBinItem
    extends IFeatureItem {
    }
}

