/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.internal.l50l;

import com.aspose.page.internal.l404.I07;
import com.aspose.page.internal.l404.I104;
import com.aspose.page.internal.l404.I10I;
import com.aspose.page.internal.l404.I10l;
import com.aspose.page.internal.l404.I21;
import com.aspose.page.internal.l404.I27;
import com.aspose.page.internal.l404.I37;
import com.aspose.page.internal.l404.I3l;
import com.aspose.page.internal.l404.I41;
import com.aspose.page.internal.l404.I84;
import com.aspose.page.internal.l43l.I4;
import com.aspose.page.internal.l451.I1;
import com.aspose.page.internal.l454.I0l;
import com.aspose.page.internal.l454.I11;
import com.aspose.page.internal.l454.I14;
import com.aspose.page.internal.l454.I1I;
import com.aspose.page.internal.l45I.II;
import com.aspose.page.internal.l45l.I7;
import com.aspose.page.internal.l50l.I1604;
import com.aspose.page.internal.l50l.I1624;
import com.aspose.page.internal.l50l.I4l;
import com.aspose.page.internal.l52I.I2l;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I162I
extends X509Certificate {
    private final I4l lif;
    private final I0l ll;
    private final com.aspose.page.internal.l454.II lI;
    private final boolean[] l1;
    private volatile PublicKey lIF;
    private volatile boolean llf;
    private volatile int liF;

    public I162I(I4l i4l, I0l i0l) throws CertificateParsingException {
        byte[] byArray;
        this.lif = i4l;
        this.ll = i0l;
        try {
            byArray = this.lif("2.5.29.19");
            this.lI = byArray != null ? com.aspose.page.internal.l454.II.lif(I37.ll(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.lif("2.5.29.15");
            if (byArray != null) {
                I84 i84 = I84.lif(I37.ll(byArray));
                int n = (byArray = i84.llf()).length * 8 - i84.liF();
                this.l1 = new boolean[n < 9 ? 9 : n];
                for (int i = 0; i != n; ++i) {
                    this.l1[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
                }
            } else {
                this.l1 = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.ll.liF().lif());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.ll.llf().lif());
        }
    }

    public int getVersion() {
        return this.ll.lI();
    }

    public BigInteger getSerialNumber() {
        return this.ll.l1().ll();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I21 i21 = new I21(byteArrayOutputStream);
            i21.lif(this.ll.lIF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I21 i21 = new I21(byteArrayOutputStream);
            i21.lif(this.ll.lIf());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.ll.llf().ll();
    }

    public Date getNotAfter() {
        return this.ll.liF().ll();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.l01().l1();
    }

    public String getSigAlgName() {
        Object object;
        I4l i4l = this.lif;
        if (i4l != null && (object = i4l.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.ll.l0if().lif().ll();
    }

    public byte[] getSigAlgParams() {
        if (this.ll.l0if().ll() != null) {
            try {
                return this.ll.l0if().ll().l0l().lif("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        I84 i84 = this.ll.lif().l0if();
        if (i84 != null) {
            byte[] byArray = i84.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i84.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        I84 i84 = this.ll.lif().l01();
        if (i84 != null) {
            byte[] byArray = i84.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i84.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.l1;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.lif("2.5.29.37");
        if (byArray != null) {
            try {
                I3l i3l = I3l.lif(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != i3l.llf(); ++i) {
                    arrayList.add(((I27)i3l.lif(i)).ll());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.lI != null) {
            if (this.lI.lif()) {
                if (this.lI.ll() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.lI.ll().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return I162I.lif(this.lif(I1I.lIF.ll()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return I162I.lif(this.lif(I1I.llf.ll()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I11 i11 = this.ll.lif().l0IF();
            if (i11 != null) {
                Enumeration enumeration = i11.lif();
                while (enumeration.hasMoreElements()) {
                    I27 i27 = (I27)enumeration.nextElement();
                    I1I i1I = i11.lif(i27);
                    if (!i1I.ll()) continue;
                    hashSet.add(i27.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] lif(String string) {
        I1I i1I;
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null && (i1I = i11.lif(new I27(string))) != null) {
            return i1I.lI().l1();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        I1I i1I;
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null && (i1I = i11.lif(new I27(string))) != null) {
            try {
                return i1I.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I11 i11 = this.ll.lif().l0IF();
            if (i11 != null) {
                Enumeration enumeration = i11.lif();
                while (enumeration.hasMoreElements()) {
                    I27 i27 = (I27)enumeration.nextElement();
                    I1I i1I = i11.lif(i27);
                    if (i1I.ll()) continue;
                    hashSet.add(i27.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        I11 i11;
        if (this.getVersion() == 3 && (i11 = this.ll.lif().l0IF()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(I1604.l0f);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.lIF == null) {
                this.lIF = this.lif.lif(this.ll.lf());
            }
            return this.lIF;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof I162I) {
            I162I i162I = (I162I)object;
            if (this.llf && i162I.llf && this.liF != i162I.liF) {
                return false;
            }
            return this.ll.equals(i162I.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = I2l.ll();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I2l.ll(com.aspose.page.internal.l521.I07.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I2l.ll(com.aspose.page.internal.l521.I07.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I2l.ll(com.aspose.page.internal.l521.I07.ll(byArray, i, byArray.length - i))).append(string);
        }
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null) {
            Enumeration enumeration = i11.lif();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                I27 i27 = (I27)enumeration.nextElement();
                I1I i1I = i11.lif(i27);
                if (i1I.lI() != null) {
                    byte[] byArray2 = i1I.lI().l1();
                    stringBuffer.append("                       critical(").append(i1I.ll()).append(") ");
                    try {
                        I37 i37 = I37.ll(byArray2);
                        if (i27.equals(I1I.liF)) {
                            stringBuffer.append(com.aspose.page.internal.l454.II.lif(i37)).append(string);
                            continue;
                        }
                        if (i27.equals(I1I.lI)) {
                            stringBuffer.append(com.aspose.page.internal.l454.I21.lif(i37)).append(string);
                            continue;
                        }
                        if (i27.equals(com.aspose.page.internal.l43l.II.ll)) {
                            stringBuffer.append(new com.aspose.page.internal.l43l.I1((I84)i37)).append(string);
                            continue;
                        }
                        if (i27.equals(com.aspose.page.internal.l43l.II.l1)) {
                            stringBuffer.append(new I4((I10l)i37)).append(string);
                            continue;
                        }
                        if (i27.equals(com.aspose.page.internal.l43l.II.l0l)) {
                            stringBuffer.append(new com.aspose.page.internal.l43l.I0l((I10l)i37)).append(string);
                            continue;
                        }
                        stringBuffer.append(i27.ll());
                        stringBuffer.append(" value = ").append(I7.lif(i37)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(i27.ll());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = I1624.lif(this.ll.l0if());
        Signature signature = this.lif(this.lif, string);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = I1624.lif(this.ll.l0if());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = I1624.lif(this.ll.l0if());
        Signature signature = this.lif(provider, string);
        this.lif(publicKey, signature);
    }

    private Signature lif(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.lif(this.ll.l0if(), this.ll.lif().l1())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        I07 i07 = this.ll.l0if().ll();
        I1624.lif(signature, i07);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean lif(com.aspose.page.internal.l454.I7 i7, com.aspose.page.internal.l454.I7 i72) {
        if (!i7.lif().equals(i72.lif())) {
            return false;
        }
        if (i7.ll() == null) {
            return i72.ll() == null || i72.ll().equals(I10I.lif);
        }
        if (i72.ll() == null) {
            return i7.ll() == null || i7.ll().equals(I10I.lif);
        }
        return i7.ll().equals(i72.ll());
    }

    private static Collection lif(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = I3l.lif(byArray).lI();
            block11: while (enumeration.hasMoreElements()) {
                I14 i14 = I14.lif(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(com.aspose.page.internal.l52I.I07.lif(i14.lif()));
                switch (i14.lif()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(i14.l0I());
                        break;
                    }
                    case 4: {
                        arrayList2.add(II.lif(I1.l3If, i14.ll()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((I41)((Object)i14.ll())).ll());
                        break;
                    }
                    case 8: {
                        arrayList2.add(I27.lif(i14.ll()).ll());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = I104.lif(i14.ll()).l1();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + i14.lif());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

