/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.internal.l50l;

import com.aspose.page.internal.l44l.I27;
import com.aspose.page.internal.l454.I44;
import com.aspose.page.internal.l50l.I4l;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

class I1621
extends KeyFactorySpi {
    private final I4l lif;

    I1621(I4l i4l) {
        this.lif = i4l;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                I27 i27 = I27.lif(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                PrivateKey privateKey = this.lif.lif(i27);
                if (privateKey != null) {
                    return privateKey;
                }
                throw new InvalidKeySpecException("no factory found for OID: " + i27.ll().lif());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.getMessage(), exception);
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                I44 i44 = I44.lif(((X509EncodedKeySpec)keySpec).getEncoded());
                PublicKey publicKey = this.lif.lif(i44);
                if (publicKey != null) {
                    return publicKey;
                }
                throw new InvalidKeySpecException("no factory found for OID: " + i44.lif().lif());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.getMessage(), exception);
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("Unable to transform key to KeySpec: " + clazz.getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Unsupported operation: " + key);
    }
}

