/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.eps;

import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class PageConstants {
    public static final String ORIENTATION = "Orientation";
    public static final String ORIENTATION_PORTRAIT = "Portrait";
    public static final String ORIENTATION_LANDSCAPE = "Landscape";
    public static final String ORIENTATION_BEST_FIT = "Best Fit";
    public static final String PAGE_SIZE = "PageSize";
    public static final String SIZE_INTERNATIONAL = "International";
    public static final String SIZE_A3 = "A3";
    public static final String SIZE_A4 = "A4";
    public static final String SIZE_A5 = "A5";
    public static final String SIZE_A6 = "A6";
    public static final String SIZE_LETTER = "Letter";
    public static final String SIZE_LEGAL = "Legal";
    public static final String SIZE_EXECUTIVE = "Executive";
    public static final String SIZE_LEDGER = "Ledger";
    private static final Map<String, Dimension> lif = new HashMap<String, Dimension>();
    public static final String PAGE_MARGINS = "PageMargins";
    public static final String MARGINS_ZERO = "Zero";
    public static final String MARGINS_SMALL = "Small";
    public static final String MARGINS_MEDIUM = "Medium";
    public static final String MARGINS_LARGE = "Large";
    private static final Map<String, Insets> ll;
    public static final String FIT_TO_PAGE = "FitToPage";
    public static final String TRANSPARENT = "Transparent";
    public static final String BACKGROUND_COLOR = "BackgroundColor";
    public static final String BACKGROUND = "Background";

    private PageConstants() {
    }

    public static final String[] getOrientationList() {
        return new String[]{ORIENTATION_PORTRAIT, ORIENTATION_LANDSCAPE};
    }

    public static final String[] getSizeList() {
        return new String[]{SIZE_INTERNATIONAL, SIZE_A4, SIZE_LETTER, SIZE_A3, SIZE_LEGAL, SIZE_A5, SIZE_A6, SIZE_EXECUTIVE, SIZE_LEDGER};
    }

    public static final Dimension getSize(String size) {
        return PageConstants.getSize(size, ORIENTATION_PORTRAIT);
    }

    public static final Dimension getSize(String size, String orientation) {
        Dimension dimension = lif.get(size);
        if (orientation.equals(ORIENTATION_PORTRAIT)) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public static final Dimension getSize(Dimension size, String orientation) {
        if (orientation.equals(ORIENTATION_PORTRAIT)) {
            return size;
        }
        return new Dimension(size.height, size.width);
    }

    public static final Insets getMargins(String size) {
        return ll.get(size);
    }

    public static final Insets getMargins(Insets insets, String orientation) {
        if (orientation.equals(ORIENTATION_PORTRAIT)) {
            return insets;
        }
        return new Insets(insets.left, insets.bottom, insets.right, insets.top);
    }

    static {
        lif.put(SIZE_INTERNATIONAL, new Dimension(595, 791));
        lif.put(SIZE_A3, new Dimension(842, 1191));
        lif.put(SIZE_A4, new Dimension(595, 842));
        lif.put(SIZE_A5, new Dimension(420, 595));
        lif.put(SIZE_A6, new Dimension(298, 420));
        lif.put(SIZE_LETTER, new Dimension(612, 791));
        lif.put(SIZE_LEGAL, new Dimension(612, 1009));
        lif.put(SIZE_EXECUTIVE, new Dimension(539, 720));
        lif.put(SIZE_LEDGER, new Dimension(791, 1225));
        ll = new HashMap<String, Insets>();
        ll.put(MARGINS_ZERO, new Insets(0, 0, 0, 0));
        ll.put(MARGINS_SMALL, new Insets(20, 20, 20, 20));
        ll.put(MARGINS_MEDIUM, new Insets(30, 30, 30, 30));
        ll.put(MARGINS_LARGE, new Insets(40, 40, 40, 40));
    }
}

