/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.internal.l48l;

import com.aspose.page.internal.l391.I101;
import com.aspose.page.internal.l391.I107;
import com.aspose.page.internal.l391.I10l;
import com.aspose.page.internal.l391.I14;
import com.aspose.page.internal.l391.I24;
import com.aspose.page.internal.l391.I2I;
import com.aspose.page.internal.l391.I37;
import com.aspose.page.internal.l391.I4I;
import com.aspose.page.internal.l391.I81;
import com.aspose.page.internal.l411.I4;
import com.aspose.page.internal.l431.I1;
import com.aspose.page.internal.l434.I0l;
import com.aspose.page.internal.l434.I11;
import com.aspose.page.internal.l434.I1I;
import com.aspose.page.internal.l434.I21;
import com.aspose.page.internal.l434.I7;
import com.aspose.page.internal.l434.II;
import com.aspose.page.internal.l48l.I139l;
import com.aspose.page.internal.l48l.I141l;
import com.aspose.page.internal.l48l.I34;
import com.aspose.page.internal.l494.I27;
import com.aspose.page.internal.l507.I07;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I1404
extends X509Certificate {
    private final I34 lif;
    private final I0l ll;
    private final II lI;
    private final boolean[] l1;
    private volatile PublicKey lIF;
    private volatile boolean llf;
    private volatile int liF;

    public I1404(I34 i34, I0l i0l) throws CertificateParsingException {
        byte[] byArray;
        this.lif = i34;
        this.ll = i0l;
        try {
            byArray = this.lif("2.5.29.19");
            this.lI = byArray != null ? II.lif(I24.ll(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.lif("2.5.29.15");
            if (byArray != null) {
                I81 i81 = I81.lif(I24.ll(byArray));
                int n = (byArray = i81.llf()).length * 8 - i81.liF();
                this.l1 = new boolean[n < 9 ? 9 : n];
                for (int i = 0; i != n; ++i) {
                    this.l1[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
                }
            } else {
                this.l1 = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.ll.liF().lif());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.ll.llf().lif());
        }
    }

    public int getVersion() {
        return this.ll.lI();
    }

    public BigInteger getSerialNumber() {
        return this.ll.l1().ll();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I2I i2I = new I2I(byteArrayOutputStream);
            i2I.lif(this.ll.lIF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I2I i2I = new I2I(byteArrayOutputStream);
            i2I.lif(this.ll.lIf());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.ll.llf().ll();
    }

    public Date getNotAfter() {
        return this.ll.liF().ll();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.l01().l1();
    }

    public String getSigAlgName() {
        Object object;
        I34 i34 = this.lif;
        if (i34 != null && (object = i34.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.ll.l0if().lif().ll();
    }

    public byte[] getSigAlgParams() {
        if (this.ll.l0if().ll() != null) {
            try {
                return this.ll.l0if().ll().l0l().lif("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        I81 i81 = this.ll.lif().l0if();
        if (i81 != null) {
            byte[] byArray = i81.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i81.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        I81 i81 = this.ll.lif().l01();
        if (i81 != null) {
            byte[] byArray = i81.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i81.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.l1;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.lif("2.5.29.37");
        if (byArray != null) {
            try {
                I37 i37 = I37.lif(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != i37.llf(); ++i) {
                    arrayList.add(((I14)i37.lif(i)).ll());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.lI != null) {
            if (this.lI.lif()) {
                if (this.lI.ll() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.lI.ll().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return I1404.lif(this.lif(I1I.lIF.ll()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return I1404.lif(this.lif(I1I.llf.ll()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I11 i11 = this.ll.lif().l0IF();
            if (i11 != null) {
                Enumeration enumeration = i11.lif();
                while (enumeration.hasMoreElements()) {
                    I14 i14 = (I14)enumeration.nextElement();
                    I1I i1I = i11.lif(i14);
                    if (!i1I.ll()) continue;
                    hashSet.add(i14.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] lif(String string) {
        I1I i1I;
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null && (i1I = i11.lif(new I14(string))) != null) {
            return i1I.lI().l1();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        I1I i1I;
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null && (i1I = i11.lif(new I14(string))) != null) {
            try {
                return i1I.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I11 i11 = this.ll.lif().l0IF();
            if (i11 != null) {
                Enumeration enumeration = i11.lif();
                while (enumeration.hasMoreElements()) {
                    I14 i14 = (I14)enumeration.nextElement();
                    I1I i1I = i11.lif(i14);
                    if (i1I.ll()) continue;
                    hashSet.add(i14.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        I11 i11;
        if (this.getVersion() == 3 && (i11 = this.ll.lif().l0IF()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(I139l.l0f);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.lIF == null) {
                this.lIF = this.lif.lif(this.ll.lf());
            }
            return this.lIF;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof I1404) {
            I1404 i1404 = (I1404)object;
            if (this.llf && i1404.llf && this.liF != i1404.liF) {
                return false;
            }
            return this.ll.equals(i1404.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = I27.ll();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I27.ll(I07.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I27.ll(I07.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I27.ll(I07.ll(byArray, i, byArray.length - i))).append(string);
        }
        I11 i11 = this.ll.lif().l0IF();
        if (i11 != null) {
            Enumeration enumeration = i11.lif();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                I14 i14 = (I14)enumeration.nextElement();
                I1I i1I = i11.lif(i14);
                if (i1I.lI() != null) {
                    byte[] byArray2 = i1I.lI().l1();
                    stringBuffer.append("                       critical(").append(i1I.ll()).append(") ");
                    try {
                        I24 i24 = I24.ll(byArray2);
                        if (i14.equals(I1I.liF)) {
                            stringBuffer.append(II.lif(i24)).append(string);
                            continue;
                        }
                        if (i14.equals(I1I.lI)) {
                            stringBuffer.append(I21.lif(i24)).append(string);
                            continue;
                        }
                        if (i14.equals(com.aspose.page.internal.l411.II.ll)) {
                            stringBuffer.append(new com.aspose.page.internal.l411.I1((I81)i24)).append(string);
                            continue;
                        }
                        if (i14.equals(com.aspose.page.internal.l411.II.l1)) {
                            stringBuffer.append(new I4((I107)i24)).append(string);
                            continue;
                        }
                        if (i14.equals(com.aspose.page.internal.l411.II.l0l)) {
                            stringBuffer.append(new com.aspose.page.internal.l411.I07((I107)i24)).append(string);
                            continue;
                        }
                        stringBuffer.append(i14.ll());
                        stringBuffer.append(" value = ").append(com.aspose.page.internal.l43l.I7.lif(i24)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(i14.ll());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = I141l.lif(this.ll.l0if());
        Signature signature = this.lif(this.lif, string);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = I141l.lif(this.ll.l0if());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = I141l.lif(this.ll.l0if());
        Signature signature = this.lif(provider, string);
        this.lif(publicKey, signature);
    }

    private Signature lif(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.lif(this.ll.l0if(), this.ll.lif().l1())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        com.aspose.page.internal.l391.I07 i07 = this.ll.l0if().ll();
        I141l.lif(signature, i07);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean lif(I7 i7, I7 i72) {
        if (!i7.lif().equals(i72.lif())) {
            return false;
        }
        if (i7.ll() == null) {
            return i72.ll() == null || i72.ll().equals(I10l.lif);
        }
        if (i72.ll() == null) {
            return i7.ll() == null || i7.ll().equals(I10l.lif);
        }
        return i7.ll().equals(i72.ll());
    }

    private static Collection lif(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = I37.lif(byArray).lI();
            block11: while (enumeration.hasMoreElements()) {
                com.aspose.page.internal.l434.I14 i14 = com.aspose.page.internal.l434.I14.lif(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(com.aspose.page.internal.l494.I4.lif(i14.lif()));
                switch (i14.lif()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(i14.l0I());
                        break;
                    }
                    case 4: {
                        arrayList2.add(com.aspose.page.internal.l43I.II.lif(I1.l3If, i14.ll()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((I4I)((Object)i14.ll())).ll());
                        break;
                    }
                    case 8: {
                        arrayList2.add(I14.lif(i14.ll()).ll());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = I101.lif(i14.ll()).l1();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + i14.lif());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

