/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.page.internal.l48l;

import com.aspose.page.internal.l391.I07;
import com.aspose.page.internal.l391.I14;
import com.aspose.page.internal.l434.I1I;
import com.aspose.page.internal.l434.I31;
import com.aspose.page.internal.l434.I7;
import com.aspose.page.internal.l474.I27;
import com.aspose.page.internal.l474.I2l;
import com.aspose.page.internal.l48l.I127;
import com.aspose.page.internal.l48l.I139l;
import com.aspose.page.internal.l48l.I41;
import com.aspose.page.internal.l48l.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I114
extends CertPathValidatorSpi {
    private final Provider lif;

    I114(Provider provider) {
        this.lif = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        I2l i2l;
        if (certPathParameters instanceof I2l) {
            i2l = (I2l)certPathParameters;
        } else if (certPathParameters instanceof I27) {
            i2l = ((I27)certPathParameters).lif();
        } else if (certPathParameters instanceof PKIXParameters) {
            i2l = new I2l.I7((PKIXParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + I2l.class.getName() + " instance.");
        }
        if (i2l.lf() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = i2l.l0if();
        try {
            trustAnchor = I41.lif((X509Certificate)list.get(list.size() - 1), i2l.lf(), i2l.l0l());
        }
        catch (II iI) {
            throw new CertPathValidatorException(iI.getMessage(), (Throwable)iI, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        i2l = new I2l.I7(i2l).lif(trustAnchor).lif();
        int n2 = 0;
        List[] listArray = new ArrayList[n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        I127 i127 = new I127(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(i127);
        I31 i31 = new I31();
        HashSet hashSet3 = new HashSet();
        int n3 = i2l.l0I() ? 0 : n + 1;
        int n4 = i2l.l01() ? 0 : n + 1;
        int n5 = i2l.l0IF() ? 0 : n + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = I41.ll(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        I7 i7 = null;
        try {
            i7 = I41.lif(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        I14 i14 = i7.lif();
        I07 i07 = i7.ll();
        int n6 = n;
        if (i2l.lIf() != null && !i2l.lIf().lif((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = i2l.l0lf();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            boolean bl;
            int n7 = n - n2;
            x509Certificate2 = (X509Certificate)list.get(n2);
            boolean bl2 = bl = n2 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n2);
            }
            I139l.lif(certPath, i2l, n2, publicKey, bl, x500Principal, x509Certificate, this.lif);
            I139l.lif(certPath, n2, i31);
            i127 = I139l.lif(certPath, n2, hashSet3, i127, listArray, n4);
            i127 = I139l.lif(certPath, n2, i127);
            I139l.lif(certPath, n2, i127, n3);
            if (n7 == n) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n2);
            }
            I139l.lif(certPath, n2);
            i127 = I139l.lif(certPath, n2, listArray, i127, n5);
            I139l.ll(certPath, n2, i31);
            n3 = I139l.llf(certPath, n2, n3);
            n5 = I139l.liF(certPath, n2, n5);
            n4 = I139l.lIf(certPath, n2, n4);
            n3 = I139l.lif(certPath, n2, n3);
            n5 = I139l.ll(certPath, n2, n5);
            n4 = I139l.lI(certPath, n2, n4);
            I139l.ll(certPath, n2);
            n6 = I139l.l1(certPath, n2, n6);
            n6 = I139l.lIF(certPath, n2, n6);
            I139l.lI(certPath, n2);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(I139l.l0f);
            } else {
                hashSet = new HashSet();
            }
            I139l.lif(certPath, n2, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = I41.ll(x509Certificate);
            try {
                publicKey = I41.lif(certPath.getCertificates(), n2, this.lif);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n2);
            }
            i7 = I41.lif(publicKey);
            i14 = i7.lif();
            i07 = i7.ll();
        }
        n3 = I139l.lif(n3, x509Certificate2);
        n3 = I139l.lf(certPath, n2 + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(I139l.l0f);
            set2.remove(I1I.l1I.ll());
        } else {
            set2 = new HashSet<String>();
        }
        I139l.lif(certPath, n2 + 1, list2, set2);
        hashSet = I139l.lif(certPath, i2l, set, n2 + 1, listArray, i127, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n2);
    }
}

