/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note.system.collections.Generic;

import com.aspose.note.internal.ap.V;
import com.aspose.note.internal.ap.aI;
import com.aspose.note.internal.ap.ai;
import com.aspose.note.internal.ap.an;
import com.aspose.note.internal.ap.r;
import com.aspose.note.internal.ap.v;
import com.aspose.note.internal.cy.j;
import com.aspose.note.system.collections.Generic.IGenericEnumerable;
import com.aspose.note.system.collections.Generic.IGenericEnumerator;
import com.aspose.note.system.collections.Generic.IGenericList;
import com.aspose.note.system.collections.Generic.d;
import com.aspose.note.system.collections.Generic.e;
import com.aspose.note.system.collections.ObjectModel.ReadOnlyCollection;
import com.aspose.note.system.exceptions.ArgumentException;
import com.aspose.note.system.exceptions.ArgumentNullException;
import com.aspose.note.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.note.system.exceptions.InvalidOperationException;
import com.aspose.note.system.exceptions.NotImplementedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] b;
    private int c;
    private int d;
    static Object[] a = new Object[0];
    private static final int e = 4;

    public List() {
        this.b = a;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.b = a;
        this.a(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.b = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.b = data;
        this.c = size;
    }

    protected int getVersion() {
        return this.d;
    }

    @Override
    public void addItem(T item) {
        if (this.c == this.b.length) {
            this.b(1);
        }
        this.b[this.c++] = item;
        ++this.d;
    }

    private void b(int n2) {
        int n3 = this.c + n2;
        if (n3 > this.b.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n3));
        }
    }

    private void a(int n2, int n3) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void a(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.addItem(t2);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.a(collection);
        ++this.d;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t2 : collection) {
            this.addItem(t2);
        }
        ++this.d;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return aI.a(this.b, 0, this.c, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return aI.a(this.b, 0, this.c, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.a(index, count);
        return aI.a(this.b, index, count, item, comparer);
    }

    @Override
    public void clear() {
        aI.b(this.b, 0, this.b.length);
        this.c = 0;
        ++this.d;
    }

    public <TOutput> List<TOutput> convertAll(v<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            list.b[i2] = converter.a((T)this.b[i2]);
        }
        list.c = this.c;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), 0, com.aspose.note.internal.ap.e.a(array), 0, this.c);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), 0, com.aspose.note.internal.ap.e.a(array), arrayIndex, this.c);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.a(index, count);
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), index, com.aspose.note.internal.ap.e.a(array), arrayIndex, count);
    }

    public boolean exists(an<T> match) {
        List.a(match);
        return this.a(0, this.c, match) != -1;
    }

    public T find(an<T> match) {
        List.a(match);
        int n2 = this.a(0, this.c, match);
        return (T)(n2 != -1 ? this.b[n2] : null);
    }

    static <T> void a(an<T> an2) {
        if (an2 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(an<T> match) {
        List.a(match);
        return this.b(match);
    }

    private List<T> b(an<T> an2) {
        List<Object> list = new List<Object>();
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!an2.a(this.b[i2])) continue;
            list.addItem(this.b[i2]);
        }
        return list;
    }

    public int findIndex(an<T> match) {
        List.a(match);
        return this.a(0, this.c, match);
    }

    public int findIndex(int startIndex, an<T> match) {
        List.a(match);
        this.c(startIndex);
        return this.a(startIndex, this.c - startIndex, match);
    }

    public int findIndex(int startIndex, int count, an<T> match) {
        List.a(match);
        this.a(startIndex, count);
        return this.a(startIndex, count, match);
    }

    private int a(int n2, int n3, an<T> an2) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (!an2.a(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public T findLast(an<T> match) {
        List.a(match);
        int n2 = this.b(0, this.c, match);
        if (n2 == -1) {
            return null;
        }
        return this.get_Item(n2);
    }

    public int findLastIndex(an<T> match) {
        List.a(match);
        return this.b(0, this.c, match);
    }

    public int findLastIndex(int startIndex, an<T> match) {
        List.a(match);
        this.c(startIndex);
        return this.b(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, an<T> match) {
        List.a(match);
        int n2 = startIndex - count + 1;
        this.a(n2, count);
        return this.b(n2, count, match);
    }

    private int b(int n2, int n3, an<T> an2) {
        int n4 = n2 + n3;
        while (n4 != n2) {
            if (!an2.a(this.b[--n4])) continue;
            return n4;
        }
        return -1;
    }

    @Override
    public void forEach(com.aspose.note.internal.ap.a<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            action.a(this.b[i2]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    public List<T> getRange(int index, int count) {
        this.a(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), index, com.aspose.note.internal.ap.e.a(objectArray), 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.note.internal.ap.e.a(this.b, item, 0, this.c);
    }

    public int indexOf(T item, int index) {
        this.c(index);
        return com.aspose.note.internal.ap.e.a(this.b, item, index, this.c - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return aI.a(this.b, item, index, count);
    }

    private void b(int n2, int n3) {
        if (n3 < 0) {
            n2 -= n3;
        }
        if (n2 < this.c) {
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), n2, com.aspose.note.internal.ap.e.a(this.b), n2 + n3, this.c - n2);
        }
        this.c += n3;
        if (n3 < 0) {
            aI.b(this.b, this.c, -n3);
        }
    }

    private void c(int n2) {
        if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.c(index);
        if (this.c == this.b.length) {
            this.b(1);
        }
        this.b(index, 1);
        this.b[index] = item;
        ++this.d;
    }

    void a(int n2) {
        Object[] objectArray = new Object[this.c];
        this.copyToTArray(objectArray, 0);
        this.b(this.c);
        this.b(n2, objectArray.length);
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(objectArray), 0, com.aspose.note.internal.ap.e.a(this.b), n2, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.c(index);
        if (collection == this) {
            this.a(index);
        } else {
            this.a(index, collection);
        }
        ++this.d;
    }

    private void a(int n2, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t2 : iGenericEnumerable) {
            this.insertItem(n2++, t2);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.c == 0) {
            return -1;
        }
        return aI.b(this.b, item, this.c - 1, this.c);
    }

    public int lastIndexOf(T item, int index) {
        this.c(index);
        return aI.b(this.b, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return aI.b(this.b, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n2 = this.indexOfItem(item);
        if (n2 != -1) {
            this.removeAt(n2);
        }
        return n2 != -1;
    }

    public int removeAll(an<T> match) {
        List.a(match);
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < this.c && !match.a(this.b[n2]); ++n2) {
        }
        if (n2 == this.c) {
            return 0;
        }
        ++this.d;
        for (n3 = n2 + 1; n3 < this.c; ++n3) {
            if (match.a(this.b[n3])) continue;
            this.b[n2++] = this.b[n3];
        }
        if (n3 - n2 > 0) {
            aI.b(this.b, n2, n3 - n2);
        }
        this.c = n2;
        return n3 - n2;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b(index, -1);
        aI.b(this.b, this.c, 1);
        ++this.d;
    }

    public void removeRange(int index, int count) {
        this.a(index, count);
        if (count > 0) {
            this.b(index, -count);
            aI.b(this.b, this.c, count);
            ++this.d;
        }
    }

    public void reverse() {
        aI.a(this.b, 0, this.c);
        ++this.d;
    }

    public void reverse(int index, int count) {
        this.a(index, count);
        aI.a(this.b, index, count);
        ++this.d;
    }

    public void sort() {
        Arrays.sort(this.b, 0, this.c);
        ++this.d;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.b, 0, this.c, comparer);
        ++this.d;
    }

    @Override
    public void sort(r<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.b, 0, this.c, new aI.a<T>(comparison));
        ++this.d;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.a(index, count);
        Arrays.sort(this.b, index, index + count, comparer);
        ++this.d;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.c) {
            return Arrays.copyOf(this.b, this.c, a2.getClass());
        }
        System.arraycopy(this.b, 0, a2, 0, this.c);
        if (a2.length > this.c) {
            a2[this.c] = null;
        }
        return a2;
    }

    public void trimExcess() {
        this.setCapacity(this.c);
    }

    public boolean trueForAll(an<T> match) {
        List.a(match);
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (match.a(this.b[i2])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.b = Arrays.copyOf(this.b, value);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.b[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.c(index);
        if ((long)index == (long)this.c) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b[index] = value;
        ++this.d;
    }

    public void copyTo(com.aspose.note.internal.ap.e array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.e() > 1 || array.b(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b), 0, array, arrayIndex, this.c);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.c == 0;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!this.b[i3].equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return true;
            }
            return false;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!this.b[i3].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.c];
        System.arraycopy(this.b, 0, objectArray, 0, this.c);
        return objectArray;
    }

    @Override
    public boolean add(T t2) {
        int n2 = this.c;
        this.addItem(t2);
        return n2 != this.c;
    }

    @Override
    public boolean remove(Object o2) {
        int n2 = this.c;
        this.removeItem(o2);
        return n2 != this.c;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object obj : c2) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        int n2 = 0;
        int n3 = this.size();
        for (T t2 : c2) {
            this.insertItem(n2++, t2);
        }
        return n3 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c2) {
        int n2 = index;
        int n3 = this.size();
        for (T t2 : c2) {
            this.insertItem(n2++, t2);
        }
        return n3 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        int n2 = this.size();
        for (Object obj : c2) {
            this.remove(obj);
        }
        return n2 != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        Object[] objectArray;
        int n2 = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c2.contains(object)) continue;
            this.remove(object);
        }
        return n2 != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t2 = this.get_Item(index);
        this.set_Item(index, element);
        return t2;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t2 = this.get_Item(index);
        this.removeAt(index);
        return t2;
    }

    @Override
    public int indexOf(Object o2) {
        if (o2 == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.b[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.c; ++i3) {
            if (!o2.equals(this.b[i3])) continue;
            return i3;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new c(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new c(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n2 = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n2);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new b<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    /* synthetic */ List(Object[] x0, int x1, d x2) {
        this(x0, x1);
    }

    static class b<T>
    extends List<T> {
        private java.util.List<T> b;
        private int c;

        public b() {
            this.b = new ArrayList<T>();
        }

        public b(java.util.List<T> list) {
            super(list.size());
            for (T t2 : list) {
                super.addItem(t2);
            }
            this.b = list;
        }

        public b(IGenericEnumerable<T> iGenericEnumerable) {
            if (iGenericEnumerable == null) {
                throw new ArgumentNullException("collection");
            }
            this.b = new ArrayList<T>();
            this.a(iGenericEnumerable);
        }

        public b(int n2) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: capacity");
            }
            this.b = new ArrayList<T>(n2);
        }

        @Override
        protected int getVersion() {
            return this.c;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.a(collection);
            ++this.c;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t2 : collection) {
                this.addItem(t2);
            }
            ++this.c;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return aI.a(this.b.toArray(), 0, this.b.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return aI.a(this.b.toArray(), 0, this.b.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.a(index, count);
            return aI.a(this.b.toArray(), index, count, item, comparer);
        }

        @Override
        private void a(int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(v<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.b.size());
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                list.b[i2] = converter.a(this.get_Item(i2));
            }
            list.c = this.b.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b.toArray()), 0, com.aspose.note.internal.ap.e.a(array), 0, this.b.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b.toArray()), 0, com.aspose.note.internal.ap.e.a(array), arrayIndex, this.b.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.a(index, count);
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b.toArray()), index, com.aspose.note.internal.ap.e.a(array), arrayIndex, count);
        }

        @Override
        public boolean exists(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            return this.a(0, this.b.size(), match) != -1;
        }

        @Override
        private int a(int n2, int n3, an<T> an2) {
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                if (!an2.a(this.b.get(i2))) continue;
                return i2;
            }
            return -1;
        }

        static <T> void b(an<T> an2) {
            if (an2 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            int n2 = this.a(0, this.b.size(), match);
            return n2 != -1 ? (T)this.b.get(n2) : null;
        }

        @Override
        public List<T> findAll(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            return this.c(match);
        }

        private List<T> c(an<T> an2) {
            List<T> list = new List<T>();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (!an2.a(this.b.get(i2))) continue;
                list.addItem(this.b.get(i2));
            }
            return list;
        }

        @Override
        public int findIndex(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            return this.a(0, this.b.size(), match);
        }

        @Override
        public int findIndex(int startIndex, an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            this.b(startIndex);
            return this.a(startIndex, this.b.size() - startIndex, match);
        }

        @Override
        private void b(int n2) {
            if (n2 < 0 || ((long)n2 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            this.a(startIndex, count);
            return this.a(startIndex, count, match);
        }

        @Override
        public T findLast(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            int n2 = this.b(0, this.b.size(), match);
            if (n2 == -1) {
                return null;
            }
            return this.get_Item(n2);
        }

        @Override
        private int b(int n2, int n3, an<T> an2) {
            int n4 = n2 + n3;
            while (n4 != n2) {
                if (!an2.a(this.b.get(--n4))) continue;
                return n4;
            }
            return -1;
        }

        @Override
        public int findLastIndex(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            return this.b(0, this.b.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            this.b(startIndex);
            return this.b(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            int n2 = startIndex - count + 1;
            this.a(n2, count);
            return this.b(n2, count, match);
        }

        @Override
        public void forEach(com.aspose.note.internal.ap.a<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                action.a(this.b.get(i2));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.a(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b.toArray()), index, com.aspose.note.internal.ap.e.a(objectArray), 0, count);
            return new List(objectArray, count, null);
        }

        @Override
        public int indexOfItem(T item) {
            return this.b.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.b(index);
            return com.aspose.note.internal.ap.e.a(this.b.toArray(), item, index, this.b.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return aI.a(this.b.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.b.size() == 0) {
                return -1;
            }
            return aI.b(this.b.toArray(), item, this.b.size() - 1, this.b.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.b(index);
            return aI.b(this.b.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return aI.b(this.b.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n2 = this.indexOfItem(item);
            if (n2 != -1) {
                this.removeAt(n2);
            }
            return n2 != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a2) {
            return this.b.toArray(a2);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.b.size());
        }

        @Override
        public boolean trueForAll(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                if (match.a(this.b.get(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.b.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i2 = 0; i2 < value - this.b.size(); ++i2) {
                this.b.add(null);
            }
        }

        @Override
        public int size() {
            return this.b.size();
        }

        @Override
        public T get_Item(int index) {
            return this.b.get(index);
        }

        @Override
        public void copyTo(com.aspose.note.internal.ap.e array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.e() > 1 || array.b(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.note.internal.ap.e.b(com.aspose.note.internal.ap.e.a(this.b.toArray()), 0, array, arrayIndex, this.b.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o2) {
            if (o2 == null) {
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    if (this.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < this.b.size(); ++i3) {
                if (!this.get(i3).equals(o2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    if (this.b.get(i2) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i3 = 0; i3 < this.b.size(); ++i3) {
                if (!this.b.get(i3).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.b.toArray();
        }

        @Override
        public boolean add(T t2) {
            ++this.c;
            return this.b.add(t2);
        }

        @Override
        public boolean remove(Object o2) {
            ++this.c;
            return this.b.remove(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.b.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends T> c2) {
            ++this.c;
            return this.b.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c2) {
            ++this.c;
            return this.b.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            ++this.c;
            return this.b.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            ++this.c;
            return this.b.retainAll(c2);
        }

        @Override
        public T get(int index) {
            return this.b.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.c;
            return this.b.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.c;
            this.b.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.c;
            return this.b.remove(index);
        }

        @Override
        public int indexOf(Object o2) {
            return this.b.indexOf(o2);
        }

        @Override
        public ListIterator listIterator() {
            return this.b.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.b.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.b.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.b.add(item);
            ++this.c;
        }

        @Override
        public void clear() {
            this.b.clear();
            ++this.c;
        }

        @Override
        public void insertItem(int index, T item) {
            this.b.add(index, item);
            ++this.c;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n2 = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.b.add(n2++, object);
                }
            } else {
                for (Object e2 : collection) {
                    this.b.add(n2++, e2);
                }
            }
            ++this.c;
        }

        @Override
        public int removeAll(an<T> match) {
            com.aspose.note.system.collections.Generic.List$b.b(match);
            int n2 = 0;
            int n3 = 0;
            for (n2 = 0; n2 < this.b.size() && !match.a(this.b.get(n2)); ++n2) {
            }
            if (n2 == this.b.size()) {
                return 0;
            }
            ++this.c;
            for (n3 = n2 + 1; n3 < this.b.size(); ++n3) {
                if (match.a(this.b.get(n3))) continue;
                this.b.set(n2++, this.b.get(n3));
            }
            if (n3 - n2 > 0) {
                for (int i2 = 0; i2 < n3 - n2; ++i2) {
                    this.b.remove(this.b.size() - 1);
                }
            }
            return n3 - n2;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.remove(index);
            ++this.c;
        }

        @Override
        public void removeRange(int index, int count) {
            this.a(index, count);
            if (count > 0) {
                for (int i2 = 0; i2 < count; ++i2) {
                    this.b.remove(index);
                }
                ++this.c;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.a(index, count);
            int n2 = index;
            for (int i2 = index + count - 1; n2 < i2; ++n2, --i2) {
                T t2 = this.b.get(n2);
                this.b.set(n2, this.b.get(i2));
                this.b.set(i2, t2);
            }
            ++this.c;
        }

        @Override
        public void sort() {
            Collections.sort(this.b, null);
            ++this.c;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.b, comparer);
            ++this.c;
        }

        @Override
        public void sort(r<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.b, new e(this, tComparison));
            ++this.c;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.a(index, count);
            java.util.List<T> list = this.b.subList(index, count);
            Collections.sort(list, comparer);
            for (int i2 = 0; i2 < count; ++i2) {
                this.b.set(index + i2, list.get(i2));
            }
            ++this.c;
        }

        @Override
        public void set_Item(int index, T value) {
            this.b(index);
            if ((long)index == (long)this.b.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.set(index, value);
            ++this.c;
        }

        @Override
        private void a(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t2 : iGenericEnumerable) {
                this.addItem(t2);
            }
        }
    }

    public static class Enumerator<T>
    extends j<Enumerator<T>>
    implements V,
    IGenericEnumerator<T> {
        private List<T> b = new List();
        private int c;
        private int d;
        private T e;

        public Enumerator() {
        }

        Enumerator(List<T> l2) {
            this();
            this.b = l2;
            this.d = l2.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void a() {
            if (this.d != this.b.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.d == this.b.getVersion()) {
                if (this.c < 0) {
                    return false;
                }
                if (this.c < this.b.size()) {
                    this.e = this.b.get_Item(this.c++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.c = this.b.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.a();
            this.c = 0;
        }

        @Override
        public T next() {
            if (this.c < 0 || this.c >= this.b.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.e;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.b = this.b;
            that.c = this.c;
            that.d = this.d;
            that.e = this.e;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return ai.a(enumerator.b, this.b) && enumerator.c == this.c && enumerator.d == this.d && ai.a(enumerator.e, this.e);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (ai.b(null, obj)) {
                return false;
            }
            if (ai.b(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n2 = this.b != null ? this.b.hashCode() : 0;
            n2 = 31 * n2 + this.c;
            n2 = 31 * n2 + this.d;
            n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
            return n2;
        }
    }

    private class c
    extends a<T>
    implements ListIterator<T> {
        c(int n2) {
            super(null);
            this.a = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        @Override
        public T previous() {
            int n2 = this.a - 1;
            if (n2 < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2;
            this.b = n2;
            return objectArray[this.b];
        }

        @Override
        public void set(T e2) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.b, e2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(T e2) {
            try {
                int n2 = this.a;
                List.this.add(n2, e2);
                this.a = n2 + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class a<T>
    implements Iterator<T> {
        int a;
        int b = -1;

        private a() {
        }

        @Override
        public boolean hasNext() {
            return this.a != List.this.c;
        }

        @Override
        public T next() {
            int n2 = this.a;
            if (n2 >= List.this.c) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2 + 1;
            this.b = n2;
            return (T)objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ a(d d2) {
            this();
        }
    }
}

