/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note.fonts;

import com.aspose.note.fonts.IFontsSubsystem;
import com.aspose.note.internal.a.da;
import com.aspose.note.internal.ac.A;
import com.aspose.note.internal.ac.B;
import com.aspose.note.internal.ac.i;
import com.aspose.note.internal.ac.l;
import com.aspose.note.internal.ac.m;
import com.aspose.note.internal.ac.x;
import com.aspose.note.internal.ac.z;
import com.aspose.note.internal.ap.at;
import com.aspose.note.internal.ap.au;
import com.aspose.note.internal.ax.c;
import com.aspose.note.internal.ax.e;
import com.aspose.note.internal.ax.p;
import com.aspose.note.internal.foundation.o;
import com.aspose.note.system.collections.Generic.Dictionary;
import com.aspose.note.system.collections.Generic.KeyNotFoundException;
import com.aspose.note.system.exceptions.ArgumentException;
import com.aspose.note.system.exceptions.ArgumentNullException;
import com.aspose.note.system.exceptions.IO.DirectoryNotFoundException;
import com.aspose.note.system.exceptions.IO.FileNotFoundException;
import com.aspose.note.system.exceptions.IO.InvalidDataException;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class FontsSubsystem
implements IFontsSubsystem {
    private final Dictionary<String, Font> a = new Dictionary(at.d());
    private final Dictionary<String, Font> b = new Dictionary(at.d());
    private final B c = new B();
    private final Dictionary<String, A> d = new Dictionary(at.d());
    private final ReadWriteLock e = new ReentrantReadWriteLock();
    private Map<String, String> f;
    private Font g;

    protected FontsSubsystem(String defaultFont, Map<String, String> fontsSubstitutions) {
        try {
            String string = this.a(defaultFont);
            this.a(string, fontsSubstitutions);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected FontsSubsystem(String defaultFont) {
        this(defaultFont, null);
    }

    protected FontsSubsystem(InputStream defaultFontStream, Map<String, String> fontsSubstitutions) {
        String string = this.a(defaultFontStream);
        this.a(string, fontsSubstitutions);
    }

    protected FontsSubsystem(InputStream defaultFontStream) {
        this(defaultFontStream, null);
    }

    FontsSubsystem(Font defaultFont, Map<String, String> fontsSubstitutions) {
        this.a(fontsSubstitutions);
        this.g = defaultFont;
    }

    FontsSubsystem(Font defaultFont) {
        this(defaultFont, null);
    }

    protected FontsSubsystem() {
        this(FontsSubsystem.getSystemDefaultFont());
    }

    public final Font getDefaultFont() {
        this.e.readLock().lock();
        try {
            Font font = this.g;
            return font;
        }
        finally {
            this.e.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDefaultFont(Font value) {
        this.e.writeLock().lock();
        try {
            if (value != null) {
                Font font = this.findFontFamilyInInternalCollection(value.getName());
                Font font2 = font;
                if (font2 == null) {
                    font2 = value;
                }
                this.g = font2;
            } else {
                this.g = null;
            }
        }
        finally {
            this.e.writeLock().unlock();
        }
    }

    public final void addFontSubstitution(String substituted, String substitution) {
        this.e.writeLock().lock();
        try {
            this.f.put(substituted.toLowerCase(), substitution);
        }
        finally {
            this.e.writeLock().unlock();
        }
    }

    int getSubstitutionCount() {
        return this.f.size();
    }

    public final void addFont(InputStream stream) {
        this.a(stream);
    }

    public final void addFont(String file) throws IOException {
        this.a(file);
    }

    int getFontsCount() {
        return this.a.size();
    }

    public final void loadFontsFromFolder(String folder) throws IOException {
        if (au.b(folder)) {
            if (au.a.equals(folder)) {
                throw new ArgumentException("Empty folder path");
            }
            throw new ArgumentNullException("folder");
        }
        if (!com.aspose.note.internal.ax.c.c(folder)) {
            throw new DirectoryNotFoundException(folder);
        }
        for (String string : com.aspose.note.internal.ax.c.e(folder)) {
            this.addFont(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Font getFontFamily(String fontName) {
        this.e.readLock().lock();
        try {
            var2_2 = this.translateFontName(fontName);
            var3_3 = this.getDefaultFont();
            if (var3_3 != null && au.d(var3_3.getName(), var2_2, (short)3)) {
                var4_4 = var3_3;
                return var4_4;
            }
            var4_5 = this.findFontFamilyInInternalCollection(var2_2);
            if (var4_5 != null) {
                var5_6 = var4_5;
                return var5_6;
            }
            var5_7 = new Font[]{null};
            if (au.b(var2_2) || !this.b.tryGetValue(var2_2, var5_7)) {
                var4_5 = this.fetchFontFamily(var2_2);
                if (!au.b(var2_2)) {
                    this.e.readLock().unlock();
                    this.e.writeLock().lock();
                    try {
                        if (this.b.containsKey(var2_2)) ** GOTO lbl28
                        this.b.addItem(var2_2, (Font)var4_5);
                    }
                    finally {
                        this.e.writeLock().unlock();
                        this.e.readLock().lock();
                    }
                }
            } else {
                var4_5 = var5_7[0];
            }
lbl28:
            // 4 sources

            if (var4_5 != null) {
                var6_9 = this.findFontFamilyInInternalCollection(var4_5.getName());
                if (var6_9 == null) {
                    var6_9 = var4_5;
                }
                var7_11 = var6_9;
                return var7_11;
            }
            var6_10 = var3_3;
            return var6_10;
        }
        finally {
            this.e.readLock().unlock();
        }
    }

    int getRequestCacheSize() {
        return this.b.size();
    }

    protected final String translateFontName(String fontName) {
        if (!au.b(fontName)) {
            String string;
            fontName = fontName.toLowerCase();
            while ((string = this.f.get(fontName)) != null) {
                fontName = string;
            }
        }
        return fontName;
    }

    protected abstract Font fetchFontFamily(String var1);

    protected final Font findFontFamilyInInternalCollection(String fontFamilyName) {
        if (fontFamilyName == null) {
            return null;
        }
        try {
            return this.a.get_Item(fontFamilyName);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(String string) throws IOException {
        Font font = null;
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            font = Font.createFont(0, fileInputStream);
        }
        this.e.writeLock().lock();
        try {
            this.a.addItem(font.getFamily(), font);
            String string2 = this.addTTFontData(new i(string));
            this.e.writeLock().unlock();
            return string2;
        }
        catch (Throwable throwable) {
            try {
                this.e.writeLock().unlock();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (com.aspose.note.internal.ax.e.e(string)) {
                    throw new InvalidDataException(au.a("It seems file '{0}' contains non TrueType font.", new Object[]{string}), fileNotFoundException);
                }
                throw fileNotFoundException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = o.b(p.b(inputStream));
        Font font = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            font = Font.createFont(0, byteArrayInputStream);
        }
        this.e.writeLock().lock();
        try {
            this.a.addItem(font.getFamily(), font);
            String string = this.addTTFontData(new x(byArray));
            this.e.writeLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.e.writeLock().unlock();
                throw throwable;
            }
            catch (Exception exception) {
                throw new InvalidDataException("It seems stream contains non TrueType font.", exception);
            }
        }
    }

    protected static Font getSystemDefaultFont() {
        return da.c().getDefaultFont();
    }

    String addTTFontData(l fontData) {
        m[] mArray = this.c.a(fontData);
        String string = null;
        z[] zArray = new z[mArray.length];
        for (int i2 = 0; i2 < zArray.length; ++i2) {
            z z2 = this.c.a(fontData, mArray[i2].b());
            A a2 = null;
            try {
                a2 = this.d.get_Item(z2.a());
            }
            catch (KeyNotFoundException keyNotFoundException) {
                a2 = new A(z2.a());
                this.d.addItem(z2.a(), a2);
            }
            string = z2.a();
            a2.a(z2);
        }
        return string;
    }

    z getTTFont(String fontName, int fontStyle) {
        if (fontName == null) {
            return null;
        }
        try {
            return this.d.get_Item(fontName).a(fontStyle, false);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            return null;
        }
    }

    private void a(String string, Map<String, String> map) {
        this.a(map);
        this.g = this.findFontFamilyInInternalCollection(string);
        if (this.g == null) {
            throw new IllegalArgumentException("Unable to set provided font as default");
        }
    }

    private void a(Map<String, String> map) {
        this.f = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.f.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
            }
        }
    }
}

