/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import com.aspose.note.HtmlSaveOptions;
import com.aspose.note.ImageSaveOptions;
import com.aspose.note.OneSaveOptions;
import com.aspose.note.PdfSaveOptions;
import com.aspose.note.fonts.FontsSubsystem;
import com.aspose.note.internal.a.ao;
import com.aspose.note.internal.ap.au;
import com.aspose.note.internal.aw.b;
import com.aspose.note.internal.cy.e;

public abstract class SaveOptions {
    private int a;
    private int b;
    private int c;
    private FontsSubsystem d;

    protected SaveOptions(int saveFormat) {
        this.setSaveFormat(saveFormat);
        this.setPageCount(Integer.MAX_VALUE);
    }

    public int getSaveFormat() {
        return this.c;
    }

    protected void setSaveFormat(int value) {
        this.c = value;
    }

    public final FontsSubsystem getFontsSubsystem() {
        return this.d;
    }

    public final void setFontsSubsystem(FontsSubsystem value) {
        this.d = value;
    }

    public final int getPageIndex() {
        return this.a;
    }

    public final void setPageIndex(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("PageIndex MUST BE non-negative");
        }
        this.a = value;
    }

    public final int getPageCount() {
        return this.b;
    }

    public final void setPageCount(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("PageCount MUST BE non-negative");
        }
        this.b = value;
    }

    static SaveOptions fromFormat(int format) {
        switch (format) {
            case 7: {
                return new OneSaveOptions();
            }
            case 6: {
                return new PdfSaveOptions();
            }
            case 8: {
                return new HtmlSaveOptions();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new ImageSaveOptions(format);
            }
        }
        throw ao.e(au.a(com.aspose.note.internal.aw.b.d(), "Unsupported save format: {0}.", e.a((Object)format)));
    }
}

