/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import com.aspose.note.CompositeNode;
import com.aspose.note.DocumentPrintAttributeSet;
import com.aspose.note.DocumentVisitor;
import com.aspose.note.INotebookChildNode;
import com.aspose.note.IncorrectPasswordException;
import com.aspose.note.LoadOptions;
import com.aspose.note.Page;
import com.aspose.note.PageHistory;
import com.aspose.note.PrintOptions;
import com.aspose.note.SaveOptions;
import com.aspose.note.internal.ap.Q;
import com.aspose.note.internal.ap.z;
import com.aspose.note.internal.as.f;
import com.aspose.note.internal.ax.e;
import com.aspose.note.internal.ax.k;
import com.aspose.note.internal.ax.p;
import com.aspose.note.internal.dd.b;
import com.aspose.note.q;
import com.aspose.note.r;
import com.aspose.note.s;
import com.aspose.note.system.collections.Generic.Dictionary;
import com.aspose.note.system.exceptions.ArgumentException;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import javax.print.PrintException;
import javax.print.attribute.AttributeSet;

public class Document
extends CompositeNode<Page>
implements INotebookChildNode {
    private final Dictionary<b, PageHistory> a;
    private q b;
    private boolean c;
    private z d = new z();
    private f e = new f();
    private String f;
    private Q g = new Q();
    private int h;
    private Q i = new Q();
    private boolean j;

    public static boolean isEncrypted(InputStream stream, LoadOptions options, Document[] document) {
        document[0] = null;
        try {
            document[0] = new Document(stream, options);
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            return true;
        }
        return document[0].hasDecryptedContent();
    }

    public static boolean isEncrypted(InputStream stream, String password, Document[] document) {
        LoadOptions loadOptions = new LoadOptions();
        loadOptions.setDocumentPassword(password);
        return Document.isEncrypted(stream, loadOptions, document);
    }

    public static boolean isEncrypted(InputStream stream, Document[] document) {
        return Document.isEncrypted(stream, (LoadOptions)null, document);
    }

    public static boolean isEncrypted(String filePath, LoadOptions options, Document[] document) {
        document[0] = null;
        try {
            document[0] = new Document(filePath, options);
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            return true;
        }
        return document[0].hasDecryptedContent();
    }

    public static boolean isEncrypted(String filePath, Document[] document) {
        return Document.isEncrypted(filePath, (LoadOptions)null, document);
    }

    public static boolean isEncrypted(String filePath, String password, Document[] document) {
        LoadOptions loadOptions = new LoadOptions();
        loadOptions.setDocumentPassword(password);
        return Document.isEncrypted(filePath, loadOptions, document);
    }

    public Document() {
        super(0);
        this.setCreationTimeInternal(z.o());
        this.setGuid(Q.b());
        this.setNotebookManagementEntityGuid(Q.b());
        this.setFileFormat(2);
        this.setColorInternal(com.aspose.note.internal.as.f.aC());
        this.setAutomaticLayoutChangesDetectionEnabled(true);
        this.a = new Dictionary();
    }

    public Document(String filePath) {
        this(filePath, null);
    }

    public Document(String filePath, LoadOptions loadOptions) {
        this();
        this.a(filePath, loadOptions);
    }

    public Document(InputStream inStream) {
        this(inStream, null);
    }

    public Document(InputStream inStream, LoadOptions loadOptions) {
        this(p.b(inStream), loadOptions);
    }

    Document(p inStream, LoadOptions loadOptions) {
        this();
        this.a(inStream, loadOptions);
    }

    public boolean getAutomaticLayoutChangesDetectionEnabled() {
        return this.c;
    }

    public void setAutomaticLayoutChangesDetectionEnabled(boolean value) {
        this.c = value;
    }

    public Date getCreationTime() {
        return z.d(this.getCreationTimeInternal());
    }

    z getCreationTimeInternal() {
        return this.d.H();
    }

    public void setCreationTime(Date value) {
        this.setCreationTimeInternal(z.a(value));
    }

    void setCreationTimeInternal(z value) {
        this.d = value.H();
    }

    @Override
    public Color getColor() {
        return com.aspose.note.internal.as.f.b(this.getColorInternal());
    }

    f getColorInternal() {
        return this.e.cb();
    }

    public void setColor(Color value) {
        this.setColorInternal(com.aspose.note.internal.as.f.a(value));
    }

    void setColorInternal(f value) {
        this.e = value.cb();
    }

    @Override
    public String getDisplayName() {
        return this.f;
    }

    public void setDisplayName(String value) {
        this.f = value;
    }

    @Override
    public UUID getGuid() {
        return Q.a(this.getGuidInternal());
    }

    @Override
    public Q getGuidInternal() {
        return this.g.c();
    }

    void setGuid(Q value) {
        this.g = value.c();
    }

    public int getFileFormat() {
        return this.h;
    }

    void setFileFormat(int value) {
        this.h = value;
    }

    Q getNotebookManagementEntityGuid() {
        return this.i.c();
    }

    void setNotebookManagementEntityGuid(Q value) {
        this.i = value.c();
    }

    final q getDocumentContext() {
        q q2 = this.b;
        if (q2 == null) {
            q2 = q.a();
        }
        return q2;
    }

    final void setDocumentContext(q value) {
        this.b = value;
    }

    final boolean hasDecryptedContent() {
        return this.j;
    }

    final void setDecryptedContent(boolean value) {
        this.j = value;
    }

    @Override
    public void accept(DocumentVisitor visitor) {
        visitor.visitDocumentStart(this);
        super.accept(visitor);
        visitor.visitDocumentEnd(this);
    }

    public PageHistory getPageHistory(Page page) {
        return this.a.get_Item(page.getNodeId());
    }

    public void save(String fileName) throws IOException {
        r.a(this, fileName);
    }

    public void save(OutputStream stream) throws IOException {
        this.saveInternal(stream);
    }

    void saveInternal(OutputStream stream) throws IOException {
        r.a(this, stream);
    }

    public void save(String fileName, int format) throws IOException {
        r.a(this, fileName, SaveOptions.fromFormat(format));
    }

    public void save(OutputStream stream, int format) throws IOException {
        r.a(this, stream, SaveOptions.fromFormat(format));
    }

    public void save(String fileName, SaveOptions options) throws IOException {
        r.a(this, fileName, options);
    }

    public void save(OutputStream stream, SaveOptions options) throws IOException {
        r.a(this, stream, options);
    }

    public void print() throws PrintException {
        this.print(new PrintOptions());
    }

    public void print(String printerName) throws PrintException {
        this.print(new DocumentPrintAttributeSet(printerName));
    }

    public void print(AttributeSet printSettings) throws PrintException {
        PrintOptions printOptions = new PrintOptions();
        printOptions.setPrinterSettings(printSettings);
        this.print(printOptions);
    }

    public void print(PrintOptions options) throws PrintException {
        PrintOptions printOptions = options;
        if (printOptions == null) {
            printOptions = new PrintOptions();
        }
        r.a(this, printOptions);
    }

    public void detectLayoutChanges() {
        this.resetLayout();
    }

    @Override
    void onChildAdded(Page page) {
        if (this.a.containsKey(page.getNodeId())) {
            throw new ArgumentException("The page with the same key is already added.");
        }
        PageHistory pageHistory = new PageHistory(page);
        for (Page page2 : pageHistory) {
            page2.setDocument(this);
        }
        this.a.addItem(page.getNodeId(), pageHistory);
    }

    @Override
    void onChildRemoved(Page page) {
        this.a.removeItemByKey(page.getNodeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, LoadOptions loadOptions) {
        k k2 = com.aspose.note.internal.ax.e.a(string, 3, 1, 1);
        try {
            this.a(k2, loadOptions);
        }
        finally {
            if (k2 != null) {
                k2.dispose();
            }
        }
    }

    private void a(p p2, LoadOptions loadOptions) {
        s.a(p2, this, loadOptions != null ? loadOptions : new LoadOptions());
    }

    @Override
    void checkNodeToBeInserted(Page newChild) {
        if (newChild.getDocument() != null && newChild.getDocument() != this) {
            throw new ArgumentException("Provided Page object belongs to the other Document object. Try to create and insert the copy of this Page object using Page.Clone()");
        }
        super.checkNodeToBeInserted(newChild);
    }
}

