/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import com.aspose.note.CompositeNodeBase;
import com.aspose.note.Document;
import com.aspose.note.DocumentVisitor;
import com.aspose.note.INode;
import com.aspose.note.Node;
import com.aspose.note.internal.ap.aJ;
import com.aspose.note.internal.as.M;
import com.aspose.note.internal.cy.e;
import com.aspose.note.system.collections.Generic.IGenericEnumerable;
import com.aspose.note.system.collections.Generic.IGenericEnumerator;
import com.aspose.note.system.collections.Generic.List;
import com.aspose.note.system.collections.IEnumerable;
import com.aspose.note.system.exceptions.ArgumentException;
import com.aspose.note.system.exceptions.ArgumentNullException;
import java.util.Arrays;

public abstract class CompositeNode<T extends INode>
extends CompositeNodeBase
implements IGenericEnumerable<T> {
    private T a;
    private T b;

    protected CompositeNode(int nodeType) {
        super(nodeType);
    }

    protected CompositeNode(Document document, int nodeType) {
        super(document, nodeType);
    }

    @Override
    public final boolean isComposite() {
        return true;
    }

    public T getFirstChild() {
        return this.a;
    }

    private void a(T t2) {
        this.a = t2;
    }

    public T getLastChild() {
        return this.b;
    }

    private void b(T t2) {
        this.b = t2;
    }

    public java.util.List<T> getChildren() {
        return new List(this);
    }

    Node getInternalFirstChild() {
        return (Node)((Object)e.a(this.getFirstChild(), Node.class));
    }

    Node getInternalLastChild() {
        return (Node)((Object)e.a(this.getLastChild(), Node.class));
    }

    @Override
    public IGenericEnumerator<T> iterator() {
        List<T> list = new List<T>(256);
        for (Object object = this.getFirstChild(); object != null; object = object.getNextSibling()) {
            T t2 = object;
            list.addItem(t2);
        }
        return list.iterator();
    }

    public <T1 extends T> T1 insertChild(int i2, T1 newChild) {
        this.insertChildrenRange(i2, new INode[]{newChild});
        return newChild;
    }

    public final void insertChildrenRange(int i2, Iterable<T> newChildren) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Index must be within the bounds of the document.");
        }
        if (newChildren == null) {
            throw new ArgumentNullException("newChildren");
        }
        for (INode iNode : newChildren) {
            this.checkNodeToBeInserted(iNode);
        }
        Object object = this.getInternalFirstChild();
        for (int i3 = 0; i3 < i2; ++i3) {
            if (object == null) {
                throw new IllegalArgumentException("Index must be within the bounds of the document.");
            }
            object = ((Node)object).getInternalNextSibling();
        }
        if (object == null) {
            for (INode iNode : newChildren) {
                this.appendChildLast(iNode);
            }
        } else {
            INode iNode;
            Node node = ((Node)object).getInternalPreviousSibling();
            T t2 = this.getLastChild();
            ((Node)object).setParent(null);
            if (node != null) {
                iNode = node.getNextSibling();
                node.setNextSibling(null);
                this.b(iNode.getPreviousSibling());
            } else {
                iNode = this.getFirstChild();
                this.b(null);
                this.a(null);
            }
            for (INode iNode2 : newChildren) {
                this.appendChildLast(iNode2);
            }
            if (iNode != null) {
                this.d(iNode);
                this.b(t2);
            }
        }
    }

    public final void insertChildrenRange(int i2, T ... newChildren) {
        this.insertChildrenRange(i2, (Iterable<T>)Arrays.asList(newChildren));
    }

    public <T1 extends T> T1 appendChildFirst(T1 newChild) {
        this.c(newChild);
        this.onChildAdded(newChild);
        return newChild;
    }

    public <T1 extends T> T1 appendChildLast(T1 newChild) {
        this.d(newChild);
        this.onChildAdded(newChild);
        return newChild;
    }

    public <T1 extends T> T1 removeChild(T1 oldChild) {
        if (oldChild == null) {
            throw new ArgumentNullException("oldChild", "The oldChild cannot be a null reference.");
        }
        Node node = (Node)((Object)e.a(oldChild, Node.class));
        if (node == null) {
            throw new ArgumentException("The node's type isn't supported.");
        }
        if (node.getParentNode() != this) {
            throw new ArgumentException("The node belongs to the other node.");
        }
        this.checkDocument(node);
        if (node == this.getInternalLastChild()) {
            this.b(oldChild.getPreviousSibling());
        }
        if (node == this.getInternalFirstChild()) {
            this.a(oldChild.getNextSibling());
        }
        Node node2 = (Node)((Object)e.a(node.getNextSibling(), Node.class));
        Node node3 = (Node)((Object)e.a(node.getPreviousSibling(), Node.class));
        if (node3 != null) {
            node3.setNextSibling(node2);
        }
        if (node2 != null) {
            node2.setPreviousSibling(node3);
        }
        node.setParent(null);
        node.setPreviousSibling(null);
        node.setNextSibling(null);
        this.onChildRemoved(oldChild);
        return oldChild;
    }

    @Override
    public void accept(DocumentVisitor visitor) {
        for (INode iNode : this) {
            iNode.accept(visitor);
        }
    }

    @Override
    List<INode> getChildNodesInternal(int type) {
        List<INode> list = new List<INode>();
        this.a(list, type, (IEnumerable)this);
        return list;
    }

    @Override
    public <T1 extends INode> java.util.List<T1> getChildNodes(Class<T1> typeParameterClass) {
        return List.toJava(this.getChildNodesInternal(typeParameterClass));
    }

    @Override
    <T1 extends INode> List<T1> getChildNodesInternal(Class<T1> typeParameterClass) {
        List list = new List(256);
        this.a(typeParameterClass, list, (IEnumerable)this);
        return list;
    }

    void onChildAdded(T child) {
    }

    void onChildRemoved(T child) {
    }

    @Override
    void resetLayout() {
        super.resetLayout();
        for (Node node : this) {
            node.resetLayout();
        }
    }

    @Override
    float getMinInnerWidth() {
        float f2 = super.getMinInnerWidth();
        for (Node node : this) {
            f2 = aJ.a(f2, node.getMinInnerWidth() + node.getMargins().getLeft() + node.getMargins().getRight());
        }
        return f2;
    }

    @Override
    M calculateInnerSize(M parentInnerSize) {
        M m2 = this.getInitialInnerSize(parentInnerSize.f());
        M m3 = this.maxInnerSize(parentInnerSize.f());
        for (Node node : this) {
            M m4 = node.actualizeSize(m3.f());
            if (node.getAlignment() != 0) {
                m2.a(parentInnerSize.b());
            } else {
                m2.a(aJ.a(m2.b(), m4.b() + node.getRelativePosition().b()));
            }
            m2.b(m2.c() + m4.c());
        }
        return m2;
    }

    protected final void checkDocument(Node node) {
        if (node != null && node.getDocument() != this.getDocument()) {
            throw new ArgumentException("The node belongs to the other document.");
        }
    }

    private void a(List<INode> list, int n2, IEnumerable iEnumerable) {
        for (Node node : iEnumerable) {
            CompositeNodeBase compositeNodeBase;
            if (node.getNodeType() == n2) {
                list.addItem(node);
            }
            if ((compositeNodeBase = (CompositeNodeBase)((Object)e.a(node, CompositeNodeBase.class))) == null) continue;
            list.addRange(compositeNodeBase.getChildNodesInternal(n2));
        }
    }

    private <T1 extends INode> void a(Class<T1> clazz, List<T1> list, IEnumerable iEnumerable) {
        for (Node node : iEnumerable) {
            CompositeNodeBase compositeNodeBase;
            if (e.b((Object)node, clazz)) {
                list.addItem(e.a(node, clazz));
            }
            if ((compositeNodeBase = (CompositeNodeBase)((Object)e.a(node, CompositeNodeBase.class))) == null) continue;
            list.addRange(compositeNodeBase.getChildNodesInternal(clazz));
        }
    }

    void checkNodeToBeInserted(T newChild) {
        if (newChild == null) {
            throw new ArgumentNullException("newChild", "The newChild cannot be a null reference.");
        }
        Node node = (Node)((Object)e.a(newChild, Node.class));
        if (node == null) {
            throw new ArgumentException("The node's type isn't supported.");
        }
        if (node.getParentNode() != null) {
            throw new ArgumentException("The node belongs to the other node.");
        }
        if (node.getDocument() == null) {
            node.setDocument(this.getDocument());
        }
        this.checkDocument(node);
    }

    private void c(T t2) {
        this.checkNodeToBeInserted(t2);
        Node node = (Node)((Object)e.a(t2, Node.class));
        node.setParent(this);
        if (this.getFirstChild() != null) {
            this.getInternalFirstChild().setPreviousSibling(node);
            node.setNextSibling(this.getInternalFirstChild());
        } else {
            this.b(t2);
        }
        this.a(t2);
    }

    private void d(T t2) {
        this.checkNodeToBeInserted(t2);
        Node node = (Node)((Object)e.a(t2, Node.class));
        node.setParent(this);
        if (this.getFirstChild() != null) {
            this.getInternalLastChild().setNextSibling(node);
            node.setPreviousSibling(this.getInternalLastChild());
        } else {
            this.a(t2);
        }
        this.b(t2);
    }
}

