/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.masking;

import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aR.g;
import com.aspose.imaging.internal.jL.a;
import com.aspose.imaging.internal.jL.c;
import com.aspose.imaging.internal.jR.b;
import com.aspose.imaging.internal.jT.e;
import com.aspose.imaging.internal.rj.d;
import com.aspose.imaging.masking.IMaskingAsyncTask;
import com.aspose.imaging.masking.IMaskingSession;
import com.aspose.imaging.masking.options.AutoMaskingGraphCutOptions;
import com.aspose.imaging.masking.options.GraphCutMaskingOptions;
import com.aspose.imaging.masking.options.MaskingOptions;
import com.aspose.imaging.masking.result.MaskingResult;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.system.io.File;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public class ImageMasking {
    private final RasterImage a;

    public ImageMasking(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("sourceImage", "source image is null.");
        }
        this.a = rasterImage;
        String string = d.a(ImageMasking.class).u();
        RasterImage rasterImage2 = rasterImage;
        rasterImage2.b(string);
    }

    public static void applyMask(RasterImage rasterImage, RasterImage rasterImage2, MaskingOptions maskingOptions) {
        if (rasterImage == null) {
            throw new ArgumentNullException("targetImage", "Target image is null.");
        }
        if (rasterImage2 == null) {
            throw new ArgumentNullException("mask", "Image mask is null.");
        }
        if (maskingOptions == null) {
            throw new ArgumentNullException("maskingOptions", "Masking options is null.");
        }
        Rectangle rectangle = rasterImage.getBounds().Clone();
        if (!maskingOptions.getMaskingArea().isEmpty()) {
            rectangle.intersect(maskingOptions.getMaskingArea());
        }
        if (Size.op_Inequality(rasterImage2.getSize(), rectangle.getSize())) {
            throw new ArgumentOutOfRangeException("mask", "Image mask is not the right size.");
        }
        if (Rectangle.op_Inequality(rectangle, rasterImage.getBounds())) {
            rasterImage.crop(rectangle);
        }
        MaskingOptions maskingOptions2 = maskingOptions;
        RasterImage rasterImage3 = rasterImage2;
        RasterImage rasterImage4 = rasterImage;
        int n2 = maskingOptions2.getBackgroundReplacementColor().toArgb();
        Size size = b.a(rasterImage4.getSize(), 4);
        Rectangle rectangle2 = new Rectangle(0, 0, rasterImage4.getWidth(), rasterImage4.getHeight());
        int n3 = com.aspose.imaging.internal.jR.c.a(rasterImage4.getWidth(), size.getWidth());
        int n4 = com.aspose.imaging.internal.jR.c.a(rasterImage4.getHeight(), size.getHeight());
        int n5 = size.getWidth() * size.getHeight();
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                Rectangle rectangle3 = new Rectangle(i2 * size.getWidth(), i3 * size.getHeight(), size.getWidth(), size.getHeight());
                int n6 = n5;
                if (i2 == n3 - 1 || i3 == n4 - 1) {
                    rectangle3.intersect(rectangle2);
                    n6 = rectangle3.getWidth() * rectangle3.getHeight();
                }
                int[] nArray = rasterImage4.loadArgb32Pixels(rectangle3);
                int[] nArray2 = rasterImage3.loadArgb32Pixels(rectangle3);
                boolean bl2 = false;
                for (int i4 = 0; i4 < n6; ++i4) {
                    if ((nArray2[i4] & 0xFFFFFF) != 0) continue;
                    nArray[i4] = n2;
                    bl2 = true;
                }
                if (!bl2) continue;
                rasterImage4.saveArgb32Pixels(rectangle3, nArray);
            }
        }
        GraphCutMaskingOptions graphCutMaskingOptions = (GraphCutMaskingOptions)((Object)d.a(maskingOptions2, GraphCutMaskingOptions.class));
        if (graphCutMaskingOptions != null && graphCutMaskingOptions.getFeatheringRadius() > 0) {
            e.a(rasterImage4, rasterImage4, graphCutMaskingOptions.getFeatheringRadius(), rasterImage4.getBounds(), maskingOptions2.getBackgroundReplacementColor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MaskingResult decompose(MaskingOptions maskingOptions) {
        com.aspose.imaging.internal.kh.d.a((com.aspose.imaging.internal.kh.c)this.a, 4);
        com.aspose.imaging.internal.kh.d.a((com.aspose.imaging.internal.kh.c)this.a, EventType.PreProcessing);
        MaskingOptions maskingOptions2 = maskingOptions;
        Object object = this;
        AutoMaskingGraphCutOptions autoMaskingGraphCutOptions = (AutoMaskingGraphCutOptions)((Object)d.a(maskingOptions2, AutoMaskingGraphCutOptions.class));
        if (autoMaskingGraphCutOptions != null) {
            autoMaskingGraphCutOptions.b(((ImageMasking)object).a);
        }
        a a2 = com.aspose.imaging.internal.jN.c.a(this.a, maskingOptions);
        try {
            com.aspose.imaging.internal.kh.d.a((com.aspose.imaging.internal.kh.c)this.a, EventType.PreProcessing);
            a2.f();
            com.aspose.imaging.internal.kh.d.a((com.aspose.imaging.internal.kh.c)this.a, EventType.Processing);
            boolean bl2 = true;
            object = a2;
            ((a)object).a(new g(), bl2);
            com.aspose.imaging.internal.kh.d.a((com.aspose.imaging.internal.kh.c)this.a, EventType.Finalization);
            MaskingResult maskingResult = a2.c();
            return maskingResult;
        }
        finally {
            a2.close();
        }
    }

    public final IMaskingAsyncTask decomposeAsync(MaskingOptions maskingOptions) {
        return new c(this.a, maskingOptions);
    }

    public final IMaskingSession createSession(MaskingOptions maskingOptions) {
        return new com.aspose.imaging.internal.jL.d(this.a, maskingOptions);
    }

    public final IMaskingSession loadSession(InputStream inputStream) {
        return this.loadSession(Stream.fromJava(inputStream));
    }

    public final IMaskingSession loadSession(Stream stream) {
        return new com.aspose.imaging.internal.jL.d(this.a, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IMaskingSession loadSession(String string) {
        FileStream fileStream = File.openRead(string);
        try {
            IMaskingSession iMaskingSession = this.loadSession(fileStream);
            return iMaskingSession;
        }
        finally {
            fileStream.dispose();
        }
    }

    private void a(MaskingOptions maskingOptions) {
        AutoMaskingGraphCutOptions autoMaskingGraphCutOptions = (AutoMaskingGraphCutOptions)((Object)d.a(maskingOptions, AutoMaskingGraphCutOptions.class));
        if (autoMaskingGraphCutOptions != null) {
            autoMaskingGraphCutOptions.b(this.a);
        }
    }
}

