/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff.filemanagement;

import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.TiffSRational;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aN.cp;
import com.aspose.imaging.internal.lW.a;
import com.aspose.imaging.internal.lY.c;
import com.aspose.imaging.internal.lY.d;
import com.aspose.imaging.internal.mU.l;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.internal.mh.av;
import com.aspose.imaging.internal.mh.bC;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;

public class TiffStreamReader
extends com.aspose.imaging.internal.af.a {
    private static final String a = "count";
    private static final String b = "Total bytes count is negative. ";
    private StreamContainer c;
    private final byte[] d;
    private int e;
    private final long f;
    private boolean g = true;

    public TiffStreamReader(byte[] byArray) {
        this(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public TiffStreamReader(byte[] byArray, int n2) {
        this(byArray, n2, byArray != null ? byArray.length : 0);
    }

    public TiffStreamReader(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("data");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be positive number.");
        }
        if (n2 >= byArray.length && n3 > 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be less than the byte array data length.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length should be positive number.");
        }
        if (n2 + n3 > byArray.length) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length is out of byte array bounds.");
        }
        this.d = byArray;
        this.e = n2;
        this.f = n3;
    }

    public TiffStreamReader(StreamContainer streamContainer) {
        this.c = streamContainer;
        this.d = null;
        this.f = streamContainer.getLength();
    }

    public long getLength() {
        return this.f;
    }

    public boolean getThrowExceptions() {
        return this.g;
    }

    public void setThrowExceptions(boolean bl2) {
        this.g = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBytes(byte[] byArray, int n2, long l2, long l3) {
        if (byArray == null) {
            throw new ArgumentNullException("array");
        }
        long l4 = byArray.length;
        if (l3 + (long)n2 > l4) {
            throw new ArgumentOutOfRangeException(a, "The number of bytes to retrieve exceeds the array bounds.");
        }
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("position", "Incorrect position specified. Must be positive number.");
        }
        long l5 = l2 + (long)this.e;
        long l6 = l2 + l3;
        long l7 = bC.a(0L, l3 - bC.a(0L, l6 - this.f));
        if (this.d != null) {
            System.arraycopy(this.d, (int)l5, byArray, n2, (int)l7);
        } else {
            Object object = this.c.getSyncRoot();
            synchronized (object) {
                long l8 = this.c.getPosition();
                if (l8 != l2) {
                    this.c.seek(l2, 0);
                }
                if ((long)this.c.read(byArray, n2, (int)l7) != l7) {
                    throw new ArgumentOutOfRangeException(a, aV.a(new String[]{"Cannot read ", av.b(l7), " bytes from stream."}));
                }
                this.c.setPosition(l8);
            }
        }
        return l7;
    }

    public byte[] readBytes(long l2, long l3) {
        byte[] byArray = new byte[(int)l3];
        this.readBytes(byArray, 0, l2, l3);
        return byArray;
    }

    public double readDouble(long l2) {
        double[] dArray = this.readDoubleArray(l2, 1L);
        double d2 = 0.0;
        if (dArray != null && dArray.length == 1) {
            d2 = dArray[0];
        }
        return d2;
    }

    public double[] readDoubleArray(long l2, long l3) {
        double[] dArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x8=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                dArray = this.processReadDataDouble(byArray);
            }
        }
        return dArray;
    }

    public float readFloat(long l2) {
        float[] fArray = this.readFloatArray(l2, 1L);
        float f2 = 0.0f;
        if (fArray != null && fArray.length == 1) {
            f2 = fArray[0];
        }
        return f2;
    }

    public float[] readFloatArray(long l2, long l3) {
        float[] fArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x4=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                fArray = this.processReadDataFloat(byArray);
            }
        }
        return fArray;
    }

    public TiffRational readRational(long l2) {
        TiffRational[] tiffRationalArray = this.readRationalArray(l2, 1L);
        TiffRational tiffRational = null;
        if (tiffRationalArray != null && tiffRationalArray.length == 1) {
            tiffRational = tiffRationalArray[0];
        }
        return tiffRational;
    }

    public TiffSRational readSRational(long l2) {
        TiffSRational[] tiffSRationalArray = this.readSRationalArray(l2, 1L);
        TiffSRational tiffSRational = null;
        if (tiffSRationalArray != null && tiffSRationalArray.length == 1) {
            tiffSRational = tiffSRationalArray[0];
        }
        return tiffSRational;
    }

    public TiffRational[] readRationalArray(long l2, long l3) {
        TiffRational[] tiffRationalArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x8=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                long[] lArray = this.processReadDataUInt(byArray);
                tiffRationalArray = new TiffRational[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    tiffRationalArray[n2] = new TiffRational(lArray[n2 * 2], lArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffRationalArray;
    }

    public TiffSRational[] readSRationalArray(long l2, long l3) {
        TiffSRational[] tiffSRationalArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x8=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                int[] nArray = this.processReadDataInt(byArray);
                tiffSRationalArray = new TiffSRational[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    tiffSRationalArray[n2] = new TiffSRational(nArray[n2 * 2], nArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffSRationalArray;
    }

    public byte readSByte(long l2) {
        byte[] byArray = this.readSByteArray(l2, 1L);
        byte by2 = 0;
        if (byArray != null && byArray.length == 1) {
            by2 = byArray[0];
        }
        return by2;
    }

    public byte[] readSByteArray(long l2, long l3) {
        return this.readBytes(l2, l3);
    }

    public int readSInt(long l2) {
        int[] nArray = this.readSIntArray(l2, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readSIntArray(long l2, long l3) {
        int[] nArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x4=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                nArray = this.processReadDataInt(byArray);
            }
        }
        return nArray;
    }

    public short readSShort(long l2) {
        short[] sArray = this.readSShortArray(l2, 1L);
        short s2 = 0;
        if (sArray != null && sArray.length == 1) {
            s2 = sArray[0];
        }
        return s2;
    }

    public short[] readSShortArray(long l2, long l3) {
        short[] sArray = null;
        long l4 = l3 * 2L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x2=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                sArray = this.processReadDataShort(byArray);
            }
        }
        return sArray;
    }

    public long readUInt(long l2) {
        long[] lArray = this.readUIntArray(l2, 1L);
        long l3 = 0L;
        if (lArray != null && lArray.length == 1) {
            l3 = lArray[0];
        }
        return l3;
    }

    public long[] readUIntArray(long l2, long l3) {
        long[] lArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x4=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                lArray = this.processReadDataUInt(byArray);
            }
        }
        return lArray;
    }

    public int readUShort(long l2) {
        int[] nArray = this.readUShortArray(l2, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readUShortArray(long l2, long l3) {
        int[] nArray = null;
        long l4 = l3 * 2L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x2=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                nArray = this.processReadDataUShort(byArray);
            }
        }
        return nArray;
    }

    public final long readLong(long l2) {
        long[] lArray = this.readLongArray(l2, 1L);
        return lArray != null && lArray.length == 1 ? lArray[0] : 0L;
    }

    public final long[] readLongArray(long l2, long l3) {
        long[] lArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x8=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                lArray = this.processReadDataLong(byArray);
            }
        }
        return lArray;
    }

    public final long readULong(long l2) {
        long[] lArray = this.readULongArray(l2, 1L);
        return lArray != null && lArray.length == 1 ? lArray[0] : 0L;
    }

    public final long[] readULongArray(long l2, long l3) {
        long[] lArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.g) {
                throw new ArgumentOutOfRangeException(a, aV.a(b, av.b(l3), "x8=", av.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                lArray = this.processReadDataULong(byArray);
            }
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamContainer toStreamContainer(long l2) {
        StreamContainer streamContainer;
        Stream stream = this.c == null ? null : this.c.a();
        Object object = cp.a(stream);
        synchronized (object) {
            if (this.d != null) {
                int n2 = (int)(this.f - l2);
                MemoryStream memoryStream = new MemoryStream(this.d, this.e + (int)l2, n2);
                streamContainer = new StreamContainer(memoryStream, true);
            } else {
                this.c.seek(l2, 0);
                Stream stream2 = this.c.a();
                streamContainer = new StreamContainer(stream2);
            }
        }
        return streamContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int a(StreamContainer streamContainer) {
        byte[] byArray = new byte[2];
        Object object = streamContainer.getSyncRoot();
        synchronized (object) {
            streamContainer.seek(0L, 0);
            streamContainer.read(byArray);
        }
        return com.aspose.imaging.internal.lY.c.j.b(byArray, 0);
    }

    public final String a(long l2, long l3) {
        byte[] byArray = this.readBytes(l2, l3);
        return l.t().c(byArray);
    }

    public long a(long l2) {
        return this.readUInt(l2) & 0xFFFFFFFFL;
    }

    public long b(long l2) {
        return this.readUShort(l2) & 0xFFFF;
    }

    public long c(long l2) {
        return this.readUInt(l2) & 0xFFFFFFFFL;
    }

    protected double[] processReadDataDouble(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.h(byArray);
    }

    protected float[] processReadDataFloat(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.g(byArray);
    }

    protected int[] processReadDataInt(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.c(byArray);
    }

    protected short[] processReadDataShort(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.a(byArray);
    }

    protected long[] processReadDataUInt(byte[] byArray) {
        if (byArray.length == 0) {
            return com.aspose.imaging.internal.lW.a.d;
        }
        return com.aspose.imaging.internal.lY.d.a.e(byArray);
    }

    protected int[] processReadDataUShort(byte[] byArray) {
        if (byArray.length == 0) {
            return com.aspose.imaging.internal.lW.a.c;
        }
        return com.aspose.imaging.internal.lY.d.a.b(byArray);
    }

    protected long[] processReadDataLong(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.f(byArray);
    }

    protected long[] processReadDataULong(byte[] byArray) {
        return com.aspose.imaging.internal.lY.d.a.f(byArray);
    }
}

