/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.io;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.ObjectDisposedException;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.kN.bB;
import com.aspose.imaging.internal.lC.b;
import com.aspose.imaging.internal.lC.l;
import com.aspose.imaging.internal.lC.z;
import com.aspose.imaging.internal.lc.C;
import com.aspose.imaging.internal.lc.k;
import com.aspose.imaging.internal.lo.c;
import com.aspose.imaging.internal.lo.g;
import com.aspose.imaging.system.SerializableAttribute;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.system.io.i;

@SerializableAttribute
public class StreamReader
extends C {
    private static final int a = 1024;
    private static final int b = 4096;
    private static final int c = 128;
    private byte[] d;
    static byte[] input_buffer_recycle;
    static final Object input_buffer_recycle_lock;
    private char[] e;
    static char[] decoded_buffer_recycle;
    private l f;
    private b g;
    private z h;
    private Stream i;
    private int j;
    private int k;
    private int l;
    private int m;
    private boolean n;
    public static StreamReader Null;
    private static final boolean o = false;
    private boolean p;

    private StreamReader() {
    }

    public StreamReader(Stream stream) {
        this(stream, com.aspose.imaging.internal.lC.l.x(), true, 1024);
    }

    public StreamReader(Stream stream, boolean detectEncodingFromByteOrderMarks) {
        this(stream, com.aspose.imaging.internal.lC.l.x(), detectEncodingFromByteOrderMarks, 1024);
    }

    public StreamReader(Stream stream, l encoding) {
        this(stream, encoding, true, 1024);
    }

    public StreamReader(Stream stream, l encoding, boolean detectEncodingFromByteOrderMarks) {
        this(stream, encoding, detectEncodingFromByteOrderMarks, 1024);
    }

    public StreamReader(Stream stream, l encoding, boolean detectEncodingFromByteOrderMarks, int bufferSize) {
        this.initialize(stream, encoding, detectEncodingFromByteOrderMarks, bufferSize);
    }

    public StreamReader(String path) {
        this(path, com.aspose.imaging.internal.lC.l.x(), true, 4096);
    }

    public StreamReader(String path, boolean detectEncodingFromByteOrderMarks) {
        this(path, com.aspose.imaging.internal.lC.l.x(), detectEncodingFromByteOrderMarks, 4096);
    }

    public StreamReader(String path, l encoding) {
        this(path, encoding, true, 4096);
    }

    public StreamReader(String path, l encoding, boolean detectEncodingFromByteOrderMarks) {
        this(path, encoding, detectEncodingFromByteOrderMarks, 4096);
    }

    public StreamReader(String path, l encoding, boolean detectEncodingFromByteOrderMarks, int bufferSize) {
        if (null == path) {
            throw new ArgumentNullException("path");
        }
        if (aV.e(aV.a, path)) {
            throw new ArgumentException("Empty path not allowed");
        }
        if (null == encoding) {
            throw new ArgumentNullException("encoding");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The minimum size of the buffer must be positive");
        }
        FileStream fileStream = com.aspose.imaging.internal.lc.k.f(path);
        this.initialize(fileStream, encoding, detectEncodingFromByteOrderMarks, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Stream stream, l encoding, boolean detectEncodingFromByteOrderMarks, int bufferSize) {
        Object object;
        if (null == stream) {
            throw new ArgumentNullException("stream");
        }
        if (null == encoding) {
            throw new ArgumentNullException("encoding");
        }
        if (!stream.canRead()) {
            throw new ArgumentException("Cannot read stream");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The minimum size of the buffer must be positive");
        }
        if (bufferSize < 128) {
            bufferSize = 128;
        }
        int n2 = encoding.d(bufferSize) + 1;
        if (bufferSize <= 1024 && input_buffer_recycle != null) {
            object = input_buffer_recycle_lock;
            synchronized (object) {
                if (input_buffer_recycle != null) {
                    this.d = input_buffer_recycle;
                    input_buffer_recycle = null;
                }
                if (decoded_buffer_recycle != null && n2 <= decoded_buffer_recycle.length) {
                    this.e = decoded_buffer_recycle;
                    decoded_buffer_recycle = null;
                }
            }
        }
        if (this.d == null) {
            this.d = new byte[bufferSize];
        } else {
            bB.b(this.d, 0, bufferSize);
        }
        if (this.e == null) {
            this.e = new char[n2];
        } else {
            bB.b(this.e, 0, n2);
        }
        this.i = stream;
        this.l = bufferSize;
        this.f = encoding;
        this.g = encoding.e();
        object = encoding.i();
        this.m = detectEncodingFromByteOrderMarks ? 1 : 0;
        this.m += ((Object)object).length == 0 ? 0 : 2;
        this.j = 0;
        this.k = 0;
    }

    public Stream getBaseStream() {
        return this.i;
    }

    public l getCurrentEncoding() {
        if (this.f == null) {
            throw new RuntimeException();
        }
        return this.f;
    }

    public boolean getEndOfStream() {
        return this.peek() < 0;
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        if (disposing && this.i != null) {
            this.i.close();
        }
        if (this.d != null && this.d.length == 1024 && input_buffer_recycle == null) {
            Object object = input_buffer_recycle_lock;
            synchronized (object) {
                if (input_buffer_recycle == null) {
                    input_buffer_recycle = this.d;
                }
                if (decoded_buffer_recycle == null) {
                    decoded_buffer_recycle = this.e;
                }
            }
        }
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.i = null;
        super.dispose(disposing);
    }

    private int a(int n2) {
        byte[] byArray;
        int n3;
        if ((this.m & 2) == 2 && n2 >= (n3 = (byArray = this.f.i()).length)) {
            int n4;
            for (n4 = 0; n4 < n3 && this.d[n4] == byArray[n4]; ++n4) {
            }
            if (n4 == n3) {
                return n4;
            }
        }
        if ((this.m & 1) == 1) {
            if (n2 < 2) {
                return 0;
            }
            if ((this.d[0] & 0xFF) == 254 && (this.d[1] & 0xFF) == 255) {
                this.f = com.aspose.imaging.internal.lC.l.u();
                return 2;
            }
            if ((this.d[0] & 0xFF) == 255 && (this.d[1] & 0xFF) == 254 && n2 < 4) {
                this.f = com.aspose.imaging.internal.lC.l.A();
                return 2;
            }
            if (n2 < 3) {
                return 0;
            }
            if ((this.d[0] & 0xFF) == 239 && (this.d[1] & 0xFF) == 187 && (this.d[2] & 0xFF) == 191) {
                this.f = com.aspose.imaging.internal.lC.l.x();
                return 3;
            }
            if (n2 < 4) {
                if ((this.d[0] & 0xFF) == 255 && (this.d[1] & 0xFF) == 254 && this.d[2] != 0) {
                    this.f = com.aspose.imaging.internal.lC.l.A();
                    return 2;
                }
                return 0;
            }
            if (this.d[0] == 0 && this.d[1] == 0 && (this.d[2] & 0xFF) == 254 && (this.d[3] & 0xFF) == 255) {
                this.f = com.aspose.imaging.internal.lC.l.C();
                return 4;
            }
            if ((this.d[0] & 0xFF) == 255 && (this.d[1] & 0xFF) == 254) {
                if (this.d[2] == 0 && this.d[3] == 0) {
                    this.f = com.aspose.imaging.internal.lC.l.B();
                    return 4;
                }
                this.f = com.aspose.imaging.internal.lC.l.A();
                return 2;
            }
        }
        return 0;
    }

    public void discardBufferedData() {
        this.c();
        this.j = 0;
        this.k = 0;
        this.n = false;
        this.g = this.f.e();
    }

    private int a() {
        this.k = 0;
        int n2 = 0;
        this.j = 0;
        int n3 = 0;
        do {
            if ((n2 = this.i.read(this.d, 0, this.l)) <= 0) {
                return 0;
            }
            boolean bl2 = this.n = n2 < this.l;
            if (this.m > 0) {
                l l2 = this.f;
                n3 = this.a(n2);
                if (l2 != this.f) {
                    int n4;
                    int n5 = l2.d(this.l) + 1;
                    if (n5 != (n4 = this.f.d(this.l) + 1)) {
                        this.e = new char[n4];
                    }
                    this.g = this.f.e();
                }
                this.m = 0;
                n2 -= n3;
            }
            this.j += this.g.a(this.d, n3, n2, this.e, 0);
            n3 = 0;
        } while (this.j == 0);
        return this.j;
    }

    @Override
    public int peek() {
        this.c();
        if (this.k >= this.j && this.a() == 0) {
            return -1;
        }
        return this.e[this.k];
    }

    boolean dataAvailable() {
        return this.k < this.j;
    }

    @Override
    public int read() {
        this.c();
        if (this.k >= this.j && this.a() == 0) {
            return -1;
        }
        return this.e[this.k++];
    }

    @Override
    public int read(@c @g char[] buffer, int index, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (index > buffer.length - count) {
            throw new ArgumentException("index + count > buffer.Length");
        }
        this.c();
        int n2 = 0;
        while (count > 0) {
            if (this.k >= this.j && this.a() == 0) {
                return n2 > 0 ? n2 : 0;
            }
            int n3 = Math.min(this.j - this.k, count);
            System.arraycopy(this.e, this.k, buffer, index, n3);
            this.k += n3;
            index += n3;
            count -= n3;
            n2 += n3;
            if (!this.n) continue;
            break;
        }
        return n2;
    }

    private int b() {
        while (this.k < this.j) {
            char c2 = this.e[this.k];
            if (c2 == '\n') {
                int n2;
                ++this.k;
                int n3 = n2 = this.p ? this.k - 2 : this.k - 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                this.p = false;
                return n2;
            }
            if (this.p) {
                this.p = false;
                if (this.k == 0) {
                    return -2;
                }
                return this.k - 1;
            }
            this.p = c2 == '\r';
            ++this.k;
        }
        return -1;
    }

    @Override
    public String readLine() {
        this.c();
        if (this.k >= this.j && this.a() == 0) {
            return null;
        }
        int n2 = this.k;
        int n3 = this.b();
        if (n3 < this.j && n3 >= n2) {
            return aV.a(this.e, n2, n3 - n2);
        }
        if (n3 == -2) {
            return this.h.a(0, this.h.c());
        }
        if (this.h == null) {
            this.h = new z();
        } else {
            this.h.b(0);
        }
        do {
            if (this.p) {
                --this.j;
            }
            this.h.a(this.e, n2, this.j - n2);
            if (this.a() == 0) {
                if (this.h.b() > 32768) {
                    z z2 = this.h;
                    this.h = null;
                    return z2.a(0, z2.c());
                }
                return this.h.a(0, this.h.c());
            }
            n2 = this.k;
            n3 = this.b();
            if (n3 >= this.j || n3 < n2) continue;
            this.h.a(this.e, n2, n3 - n2);
            if (this.h.b() > 32768) {
                z z3 = this.h;
                this.h = null;
                return z3.a(0, z3.c());
            }
            return this.h.a(0, this.h.c());
        } while (n3 != -2);
        return this.h.a(0, this.h.c());
    }

    @Override
    public String readToEnd() {
        int n2;
        this.c();
        z z2 = new z();
        int n3 = this.e.length;
        char[] cArray = new char[n3];
        while ((n2 = this.read(cArray, 0, n3)) > 0) {
            z2.a(cArray, 0, n2);
        }
        return z2.toString();
    }

    private void c() {
        if (this.i == null) {
            throw new ObjectDisposedException("StreamReader", "Cannot read from a closed StreamReader");
        }
    }

    /* synthetic */ StreamReader(i x0) {
        this();
    }

    static {
        input_buffer_recycle_lock = new Object();
        Null = new a();
    }

    static final class a
    extends StreamReader {
        a() {
            super((i)null);
        }

        @Override
        public int peek() {
            return -1;
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(@c @g char[] buffer, int index, int count) {
            return 0;
        }

        @Override
        public String readLine() {
            return null;
        }

        @Override
        public String readToEnd() {
            return aV.a;
        }

        @Override
        public Stream getBaseStream() {
            return Stream.Null;
        }

        @Override
        public l getCurrentEncoding() {
            return com.aspose.imaging.internal.lC.l.A();
        }
    }
}

