/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.io;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException;
import com.aspose.imaging.internal.Exceptions.IO.IOException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.Exceptions.ObjectDisposedException;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.pf.f;
import com.aspose.imaging.system.AsyncCallback;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.IAsyncResult;
import com.aspose.imaging.system.io.FileAccess;
import com.aspose.imaging.system.io.FileMode;
import com.aspose.imaging.system.io.Stream;
import java.io.File;

public class FileStream
extends Stream {
    private boolean a = false;
    private boolean b;
    private boolean c;
    private boolean d;
    private f e;
    private final String f;

    public FileStream(String fileName, boolean isWritable, boolean isCreate) {
        this.f = fileName;
        if (isWritable && isCreate) {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
        } else if (!(isWritable || isCreate || new File(fileName).exists())) {
            throw new FileNotFoundException("Can't find read-only file: " + fileName);
        }
        this.e = new f(fileName, isWritable ? "rw" : "r");
        this.c = isWritable;
        this.b = true;
        this.d = true;
    }

    public FileStream(String path, int mode) {
        this(path, mode, mode == 6 ? 2 : 3);
    }

    private FileStream(int bufferSize, String path, int mode, int access) {
        String string;
        if (bufferSize != -2 && bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = bufferSize > 0;
        this.f = path;
        if (path == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (aV.c(path).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (mode < 1 || mode > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (access < 1 || access > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (access == 1) {
            this.c = false;
            this.b = true;
            string = "r";
        } else if (access == 2) {
            this.c = true;
            this.b = true;
            string = "rw";
        } else {
            this.c = true;
            this.b = true;
            string = "rw";
        }
        File file = new File(path);
        if (mode == 6) {
            if (access == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (access == 1) {
                throw new ArgumentException(aV.a("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{Enum.getName(FileMode.class, mode), Enum.getName(FileAccess.class, access)}));
            }
        }
        if ((mode == 2 || mode == 1 || mode == 5) && access == 1) {
            throw new ArgumentException(aV.a("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{Enum.getName(FileMode.class, mode), Enum.getName(FileAccess.class, access)}));
        }
        if (file.exists()) {
            if (mode == 1) {
                throw new IOException("Can't create new file. File '" + path + "' already exist.");
            }
            if (mode == 2 || mode == 5) {
                file.delete();
            }
            this.e = bl2 ? new f(file, string, bufferSize) : new f(file, string);
            if (mode == 6) {
                this.e.a(this.e.i());
            }
        } else {
            if (mode == 3 || mode == 5) {
                throw new FileNotFoundException("Can't find file: " + path + ".", path);
            }
            if (bl2) {
                this.e = new f(file, string, bufferSize);
            } else if (string.equals("r") && mode == 4) {
                string = "rw";
                this.e = new f(file, string);
                this.e.a(true);
            } else {
                this.e = new f(file, string);
            }
        }
        this.d = true;
    }

    public FileStream(String path, int mode, int access) {
        this(-2, path, mode, access);
    }

    public FileStream(String path, int mode, int access, int share) {
        this(path, mode, access);
    }

    public FileStream(String path, int mode, int access, int share, int bufferSize) {
        this(bufferSize, path, mode, access);
    }

    @Override
    public boolean canRead() {
        return this.b;
    }

    @Override
    public boolean canSeek() {
        return this.d;
    }

    @Override
    public boolean canWrite() {
        return this.c;
    }

    @Override
    public long getLength() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.e.i();
    }

    @Override
    public long getPosition() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.e.g();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.e.a(position);
    }

    @Override
    public void flush() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.e.j();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.e.a(offset);
                break;
            }
            case 1: {
                this.e.a(this.e.g() + offset);
                break;
            }
            case 2: {
                this.e.a(this.e.i() + offset);
            }
        }
        return this.e.g();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.e != null && !this.e.e()) {
                this.e.d();
            }
        }
        finally {
            this.e = null;
            this.b = false;
            this.c = false;
            this.d = false;
            super.dispose(disposing);
            this.a = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.e(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.b) {
            int n2 = this.e.b(buffer, offset, count);
            return n2 == -1 ? 0 : n2;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.b) {
            return this.e.l();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.write(value);
    }

    public String getName() {
        return this.f;
    }

    @Override
    public IAsyncResult beginRead(byte[] buffer, int offset, int count, AsyncCallback callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(IAsyncResult asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public IAsyncResult beginWrite(byte[] array, int offset, int numBytes, AsyncCallback userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(IAsyncResult asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

