/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.mR;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class a
implements BufferedImageOp,
RasterOp {
    public static final int a = 1;
    public static final int b = 2;
    public static final int c = 3;
    private int d;
    private AffineTransform e;
    private RenderingHints f;

    public a(AffineTransform affineTransform, RenderingHints renderingHints) {
        this(affineTransform, 1);
        this.f = renderingHints;
        if (renderingHints != null) {
            Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (object != null) {
                if (object == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                    this.d = 2;
                } else if (object == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                    this.d = 3;
                }
            } else {
                object = renderingHints.get(RenderingHints.KEY_RENDERING);
                if (object == RenderingHints.VALUE_RENDER_QUALITY) {
                    this.d = 2;
                }
            }
        }
    }

    public a(AffineTransform affineTransform, int n2) {
        if (Math.abs(affineTransform.getDeterminant()) <= Double.MIN_VALUE) {
            throw new ImagingOpException("Unable to invert transform" + affineTransform);
        }
        this.e = (AffineTransform)affineTransform.clone();
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Unknown interpolation type:" + n2);
        }
        this.d = n2;
    }

    public final int a() {
        return this.d;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        if (this.f == null) {
            Object object = null;
            switch (this.d) {
                case 1: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case 2: {
                    object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case 3: {
                    object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    break;
                }
                default: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                }
            }
            this.f = new RenderingHints(RenderingHints.KEY_INTERPOLATION, object);
        }
        return this.f;
    }

    public final AffineTransform b() {
        return (AffineTransform)this.e.clone();
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.e.transform(srcPt, dstPt);
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        int n2 = src.getWidth();
        int n3 = src.getHeight();
        float[] fArray = new float[]{0.0f, 0.0f, n2, 0.0f, n2, n3, 0.0f, n3};
        this.e.transform(fArray, 0, fArray, 0, 4);
        Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
        float_.add(fArray[2], fArray[3]);
        float_.add(fArray[4], fArray[5]);
        float_.add(fArray[6], fArray[7]);
        return float_;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D rectangle2D = this.getBounds2D(src);
        double d2 = rectangle2D.getX() + rectangle2D.getWidth();
        double d3 = rectangle2D.getY() + rectangle2D.getHeight();
        if (d2 <= 0.0 || d3 <= 0.0) {
            throw new RasterFormatException(String.format("Transformed width (%d) and height (%d) should be greater than 0", d2, d3));
        }
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster((int)d2, (int)d3), destCM.isAlphaPremultiplied(), null);
        }
        ColorModel colorModel = src.getColorModel();
        if (this.d != 1 && colorModel instanceof IndexColorModel) {
            return new BufferedImage((int)d2, (int)d3, 2);
        }
        return new BufferedImage(colorModel, src.getRaster().createCompatibleWritableRaster((int)d2, (int)d3), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle2D rectangle2D = this.getBounds2D(src);
        return src.createCompatibleWritableRaster((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source can't be same as the destination");
        }
        ColorModel colorModel = src.getColorModel();
        BufferedImage bufferedImage = null;
        if (colorModel instanceof IndexColorModel && (this.d != 1 || colorModel.getPixelSize() % 8 != 0)) {
            src = ((IndexColorModel)colorModel).convertToIntDiscrete(src.getRaster(), true);
            colorModel = src.getColorModel();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, colorModel);
        } else if (!colorModel.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
            bufferedImage = dst;
            dst = this.createCompatibleDestImage(src, colorModel);
        }
        if (this.a(src.getRaster(), dst.getRaster()) != 0) {
            throw new ImagingOpException("Unable to transform source");
        }
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)dst, 0, 0, null);
        } else {
            bufferedImage = dst;
        }
        return bufferedImage;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source can't be same as the destination");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Different number of bands in source and destination");
        }
        if (this.a(src, dst) != 0) {
            throw new ImagingOpException("Unable to transform source");
        }
        return dst;
    }

    private int a(Raster raster, WritableRaster writableRaster) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = this.getBounds2D(raster).getBounds().intersection(rectangle3);
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.e.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return -1;
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = rectangle4.x + rectangle2.x;
        int n7 = rectangle4.y + rectangle2.y;
        int n8 = n6 + rectangle4.width;
        int n9 = n7 + rectangle4.height;
        int n10 = (int)(dArray[0] * 256.0);
        int n11 = (int)(dArray[1] * 256.0);
        int n12 = (int)(dArray[2] * 256.0);
        int n13 = (int)(dArray[3] * 256.0);
        int n14 = (int)(dArray[4] * 256.0) + n10 * rectangle4.x + n12 * rectangle4.y + rectangle.x * 256;
        int n15 = (int)(dArray[5] * 256.0) + n11 * rectangle4.x + n13 * rectangle4.y + rectangle.y * 256;
        n12 -= n10 * rectangle4.width;
        n13 -= n11 * rectangle4.width;
        if (raster.getTransferType() == writableRaster.getTransferType()) {
            for (int i2 = n7; i2 < n9; ++i2) {
                for (int i3 = n6; i3 < n8; ++i3) {
                    int n16 = n14 >> 8;
                    int n17 = n15 >> 8;
                    if (n16 >= n2 && n17 >= n3 && n16 < n4 && n17 < n5) {
                        Object object = raster.getDataElements(n16, n17, null);
                        writableRaster.setDataElements(i3, i2, object);
                    }
                    n14 += n10;
                    n15 += n11;
                }
                n14 += n12;
                n15 += n13;
            }
        } else {
            float[] fArray = null;
            for (int i4 = n7; i4 < n9; ++i4) {
                for (int i5 = n6; i5 < n8; ++i5) {
                    int n18 = n14 >> 8;
                    int n19 = n15 >> 8;
                    if (n18 >= n2 && n19 >= n3 && n18 < n4 && n19 < n5) {
                        fArray = raster.getPixel(n18, n19, fArray);
                        writableRaster.setPixel(i5, i4, fArray);
                    }
                    n14 += n10;
                    n15 += n11;
                }
                n14 += n12;
                n15 += n13;
            }
        }
        return 0;
    }
}

