/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.tsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.DLSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIFreeText;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.TimeStampResp;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPException;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPValidationException;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampRequest;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampResponse;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampTokenGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator a;
    private Set b;
    private Set c;
    private Set d;

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set) {
        this(timeStampTokenGenerator, set, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set, Set set2) {
        this(timeStampTokenGenerator, set, set2, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set, Set set2, Set set3) {
        this.a = timeStampTokenGenerator;
        this.b = this.a(set);
        this.c = this.a(set2);
        this.d = this.a(set3);
        this.statusStrings = new ASN1EncodableVector();
    }

    private void a(String string) {
        this.statusStrings.add(new DERUTF8String(string));
    }

    private void a(int n2) {
        this.failInfo |= n2;
    }

    private PKIStatusInfo a() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.status));
        if (this.statusStrings.size() > 0) {
            aSN1EncodableVector.add(PKIFreeText.getInstance(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            a a2 = new a(this.failInfo);
            aSN1EncodableVector.add(a2);
        }
        return PKIStatusInfo.getInstance(new DERSequence(aSN1EncodableVector));
    }

    public TimeStampResponse generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date) throws TSPException {
        try {
            return this.generateGrantedResponse(timeStampRequest, bigInteger, date, "Operation Okay");
        }
        catch (Exception exception) {
            return this.generateRejectedResponse(exception);
        }
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date) throws TSPException {
        return this.generateGrantedResponse(timeStampRequest, bigInteger, date, null);
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date, String string) throws TSPException {
        return this.generateGrantedResponse(timeStampRequest, bigInteger, date, string, null);
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date, String string, Extensions extensions) throws TSPException {
        ContentInfo contentInfo;
        if (date == null) {
            throw new TSPValidationException("The time source is not available.", 512);
        }
        timeStampRequest.validate(this.b, this.c, this.d);
        this.status = 0;
        this.statusStrings = new ASN1EncodableVector();
        if (string != null) {
            this.a(string);
        }
        PKIStatusInfo pKIStatusInfo = this.a();
        try {
            contentInfo = this.a.generate(timeStampRequest, bigInteger, date, extensions).toCMSSignedData().toASN1Structure();
        }
        catch (TSPException tSPException) {
            throw tSPException;
        }
        catch (Exception exception) {
            throw new TSPException("Timestamp token received cannot be converted to ContentInfo", exception);
        }
        try {
            return new TimeStampResponse(new DLSequence(new ASN1Encodable[]{pKIStatusInfo.toASN1Primitive(), contentInfo.toASN1Primitive()}));
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateRejectedResponse(Exception exception) throws TSPException {
        if (exception instanceof TSPValidationException) {
            return this.generateFailResponse(2, ((TSPValidationException)exception).getFailureCode(), exception.getMessage());
        }
        return this.generateFailResponse(2, 0x40000000, exception.getMessage());
    }

    public TimeStampResponse generateFailResponse(int n2, int n3, String string) throws TSPException {
        this.status = n2;
        this.statusStrings = new ASN1EncodableVector();
        this.a(n3);
        if (string != null) {
            this.a(string);
        }
        PKIStatusInfo pKIStatusInfo = this.a();
        TimeStampResp timeStampResp = new TimeStampResp(pKIStatusInfo, null);
        try {
            return new TimeStampResponse(timeStampResp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    private Set a(Set set) {
        if (set == null) {
            return set;
        }
        HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>(set.size());
        for (Object e2 : set) {
            if (e2 instanceof String) {
                hashSet.add(new ASN1ObjectIdentifier((String)e2));
                continue;
            }
            hashSet.add((ASN1ObjectIdentifier)e2);
        }
        return hashSet;
    }

    class a
    extends DERBitString {
        a(int n2) {
            super(com.aspose.imaging.internal.bouncycastle.tsp.TimeStampResponseGenerator$a.getBytes(n2), com.aspose.imaging.internal.bouncycastle.tsp.TimeStampResponseGenerator$a.getPadBits(n2));
        }
    }
}

