/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.imaging.internal.bouncycastle.util.Pack;

public abstract class XMSSAddress {
    private final int a;
    private final long b;
    private final int c;
    private final int d;

    protected XMSSAddress(Builder builder) {
        this.a = builder.b;
        this.b = builder.c;
        this.c = builder.a;
        this.d = builder.d;
    }

    protected byte[] toByteArray() {
        byte[] byArray = new byte[32];
        Pack.intToBigEndian(this.a, byArray, 0);
        Pack.longToBigEndian(this.b, byArray, 4);
        Pack.intToBigEndian(this.c, byArray, 12);
        Pack.intToBigEndian(this.d, byArray, 28);
        return byArray;
    }

    protected final int getLayerAddress() {
        return this.a;
    }

    protected final long getTreeAddress() {
        return this.b;
    }

    public final int getType() {
        return this.c;
    }

    public final int getKeyAndMask() {
        return this.d;
    }

    protected static abstract class Builder<T extends Builder> {
        private final int a;
        private int b = 0;
        private long c = 0L;
        private int d = 0;

        protected Builder(int n2) {
            this.a = n2;
        }

        protected T withLayerAddress(int n2) {
            this.b = n2;
            return this.getThis();
        }

        protected T withTreeAddress(long l2) {
            this.c = l2;
            return this.getThis();
        }

        protected T withKeyAndMask(int n2) {
            this.d = n2;
            return this.getThis();
        }

        protected abstract XMSSAddress build();

        protected abstract T getThis();
    }
}

